/*
 * Decompiled with CFR 0.152.
 */
package com.github.dreamroute.pager.starter.interceptor;

import cn.hutool.core.annotation.AnnotationUtil;
import com.github.dreamroute.pager.starter.anno.Pager;
import com.github.dreamroute.pager.starter.anno.PagerContainer;
import com.github.dreamroute.pager.starter.api.PageRequest;
import com.github.dreamroute.pager.starter.exception.PaggerException;
import com.github.dreamroute.pager.starter.interceptor.PageContainer;
import java.lang.reflect.AnnotatedElement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.select.OrderByElement;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.util.TablesNamesFinder;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.executor.parameter.ParameterHandler;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ParameterMapping;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.apache.ibatis.transaction.Transaction;
import org.springframework.util.CollectionUtils;

@Intercepts(value={@Signature(type=Executor.class, method="query", args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class})})
public class PagerInterceptor
implements Interceptor {
    private ConcurrentHashMap<String, PagerContainer> pagerContainer;
    private static final int SINGLE = 1;
    private static final String COUNT_NAME = "__count__";

    public Object intercept(Invocation invocation) throws Throwable {
        Object[] args = invocation.getArgs();
        MappedStatement ms = (MappedStatement)args[0];
        Object param = args[1];
        Configuration config = ms.getConfiguration();
        this.parsePagerContainer(config);
        PagerContainer pc = this.pagerContainer.get(ms.getId());
        if (pc == null || !(param instanceof PageRequest)) {
            return invocation.proceed();
        }
        BoundSql boundSql = ms.getBoundSql(param);
        String sql = boundSql.getSql();
        this.parseSql(sql, ms.getId());
        Executor executor = (Executor)invocation.getTarget();
        Transaction transaction = executor.getTransaction();
        Connection conn = transaction.getConnection();
        String count = pc.getCount();
        PreparedStatement ps = conn.prepareStatement(count);
        BoundSql countBoundSql = new BoundSql(config, count, boundSql.getParameterMappings(), boundSql.getParameterObject());
        ParameterHandler parameterHandler = config.newParameterHandler(ms, boundSql.getParameterObject(), countBoundSql);
        parameterHandler.setParameters(ps);
        ResultSet rs = ps.executeQuery();
        PageContainer container = new PageContainer();
        while (rs.next()) {
            long totle = rs.getLong(COUNT_NAME);
            container.setTotal(totle);
        }
        ps.close();
        PageRequest pr = (PageRequest)param;
        int pageNum = pr.getPageNum();
        int pageSize = pr.getPageSize();
        container.setPageNum(pageNum);
        container.setPageSize(pr.getPageSize());
        int start = (pageNum - 1) * pageSize;
        pr.setPageNum(start);
        List<ParameterMapping> pmList = this.wrapParameterMapping(config, boundSql, this.pagerContainer.get(ms.getId()).isSingleTable());
        MetaObject moms = config.newMetaObject((Object)ms);
        moms.setValue("sqlSource.sqlSource.sql", (Object)pc.getSql());
        moms.setValue("sqlSource.sqlSource.parameterMappings", pmList);
        if (container.getTotal() != 0L) {
            Object result = invocation.proceed();
            List ls = (List)result;
            container.addAll(ls);
        }
        return container;
    }

    private List<ParameterMapping> wrapParameterMapping(Configuration config, BoundSql boundSql, boolean singleTable) {
        List parameterMappings = boundSql.getParameterMappings();
        ArrayList<ParameterMapping> pmList = new ArrayList<ParameterMapping>(Optional.ofNullable(parameterMappings).orElseGet(ArrayList::new));
        pmList.add(new ParameterMapping.Builder(config, "pageNum", Integer.TYPE).build());
        pmList.add(new ParameterMapping.Builder(config, "pageSize", Integer.TYPE).build());
        if (!singleTable) {
            pmList.addAll(Optional.ofNullable(parameterMappings).orElseGet(ArrayList::new));
        }
        return pmList;
    }

    private void parsePagerContainer(Configuration config) {
        if (this.pagerContainer == null) {
            this.pagerContainer = new ConcurrentHashMap();
            Collection mappers = config.getMapperRegistry().getMappers();
            if (mappers != null && !mappers.isEmpty()) {
                for (Class mapper : mappers) {
                    String mapperName = mapper.getName();
                    Arrays.stream(mapper.getDeclaredMethods()).filter(method -> AnnotationUtil.hasAnnotation((AnnotatedElement)method, Pager.class)).forEach(method -> {
                        String dictinctBy = (String)AnnotationUtil.getAnnotationValue((AnnotatedElement)method, Pager.class, (String)"distinctBy");
                        PagerContainer container = new PagerContainer();
                        container.setDistinctBy(StringUtils.isEmpty((CharSequence)dictinctBy) ? "id" : dictinctBy);
                        this.pagerContainer.put(mapperName + "." + method.getName(), container);
                    });
                }
            }
        }
    }

    private void parseSql(String sql, String id) {
        try {
            PagerContainer container = this.pagerContainer.get(id);
            Select select = (Select)CCJSqlParserUtil.parse((String)sql);
            List tableList = new TablesNamesFinder().getTableList((Statement)select);
            PlainSelect body = (PlainSelect)select.getSelectBody();
            String columns = body.getSelectItems().stream().map(Object::toString).collect(Collectors.joining(","));
            String from = body.getFromItem().toString();
            String where = body.getWhere().toString();
            if (tableList != null && tableList.size() == 1) {
                sql = "SELECT " + columns + " FROM " + from + " WHERE " + where;
                container.setCount("SELECT COUNT (*) __count__ FROM (" + sql + ") t");
                String orderBy = Optional.ofNullable(body.getOrderByElements()).orElseGet(ArrayList::new).stream().map(Objects::toString).collect(Collectors.joining(", "));
                orderBy = StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{orderBy}) ? " ORDER BY " + orderBy : "";
                sql = sql + orderBy + " LIMIT ?, ?";
                container.setSql(sql);
                container.setSingleTable(true);
            } else {
                String joins = body.getJoins().stream().map(Object::toString).collect(Collectors.joining(" "));
                String alias = "";
                String distinctBy = container.getDistinctBy();
                if (distinctBy.indexOf(46) != -1) {
                    alias = distinctBy.split("\\.")[0];
                }
                String orderBy = "";
                String subQueryColumns = "";
                List orderbyList = body.getOrderByElements();
                if (!CollectionUtils.isEmpty((Collection)orderbyList)) {
                    orderBy = " ORDER BY " + orderbyList.stream().map(Object::toString).collect(Collectors.joining(", "));
                    Set orderbyListStr = orderbyList.stream().map(OrderByElement::getExpression).map(Objects::toString).collect(Collectors.toSet());
                    orderbyListStr.add(distinctBy);
                    subQueryColumns = orderbyListStr.stream().collect(Collectors.joining(", "));
                }
                String afterFrom = " FROM " + from + " " + joins + " WHERE " + where;
                String subQuery = "SELECT DISTINCT " + subQueryColumns + afterFrom;
                String noCondition = "SELECT " + columns + " FROM " + from + " " + joins + " ";
                String result = noCondition + " WHERE " + distinctBy + " IN  (SELECT " + distinctBy + " FROM (" + subQuery + orderBy + " LIMIT ?, ?) " + alias + ")";
                if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{where})) {
                    result = result + " AND " + where;
                }
                result = result + orderBy;
                container.setSql(result);
                String count = "SELECT count(DISTINCT " + distinctBy + ") " + COUNT_NAME + afterFrom;
                container.setCount(count);
            }
        }
        catch (Exception e) {
            throw new PaggerException("SQL\u8bed\u53e5\u5f02\u5e38\uff0c\u4f60\u7684sql\u8bed\u53e5\u662f: [" + sql + "]", e);
        }
    }
}

