/*
 * Decompiled with CFR 0.152.
 */
package com.github.dreamroute.pager.starter.api;

import javax.validation.Valid;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;

public final class PageRequest<E> {
    @Min(value=1L)
    @NotNull
    @Max(value=0x7FFFFFFFL)
    private @Min(value=1L) @NotNull @Max(value=0x7FFFFFFFL) int pageNum;
    @Min(value=1L)
    @NotNull
    @Max(value=0x7FFFFFFFL)
    private @Min(value=1L) @NotNull @Max(value=0x7FFFFFFFL) int pageSize;
    @Valid
    private E param;

    private static <E> int $default$pageNum() {
        return 1;
    }

    private static <E> int $default$pageSize() {
        return 10;
    }

    public static <E> PageRequestBuilder<E> builder() {
        return new PageRequestBuilder();
    }

    public int getPageNum() {
        return this.pageNum;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public E getParam() {
        return this.param;
    }

    public void setPageNum(int pageNum) {
        this.pageNum = pageNum;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public void setParam(E param) {
        this.param = param;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PageRequest)) {
            return false;
        }
        PageRequest other = (PageRequest)o;
        if (this.getPageNum() != other.getPageNum()) {
            return false;
        }
        if (this.getPageSize() != other.getPageSize()) {
            return false;
        }
        E this$param = this.getParam();
        E other$param = other.getParam();
        return !(this$param == null ? other$param != null : !this$param.equals(other$param));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getPageNum();
        result = result * 59 + this.getPageSize();
        E $param = this.getParam();
        result = result * 59 + ($param == null ? 43 : $param.hashCode());
        return result;
    }

    public String toString() {
        return "PageRequest(pageNum=" + this.getPageNum() + ", pageSize=" + this.getPageSize() + ", param=" + this.getParam() + ")";
    }

    public PageRequest(int pageNum, int pageSize, E param) {
        this.pageNum = pageNum;
        this.pageSize = pageSize;
        this.param = param;
    }

    public PageRequest() {
        this.pageNum = PageRequest.$default$pageNum();
        this.pageSize = PageRequest.$default$pageSize();
    }

    public static class PageRequestBuilder<E> {
        private boolean pageNum$set;
        private int pageNum$value;
        private boolean pageSize$set;
        private int pageSize$value;
        private E param;

        PageRequestBuilder() {
        }

        public PageRequestBuilder<E> pageNum(int pageNum) {
            this.pageNum$value = pageNum;
            this.pageNum$set = true;
            return this;
        }

        public PageRequestBuilder<E> pageSize(int pageSize) {
            this.pageSize$value = pageSize;
            this.pageSize$set = true;
            return this;
        }

        public PageRequestBuilder<E> param(E param) {
            this.param = param;
            return this;
        }

        public PageRequest<E> build() {
            int pageNum$value = this.pageNum$value;
            if (!this.pageNum$set) {
                pageNum$value = PageRequest.$default$pageNum();
            }
            int pageSize$value = this.pageSize$value;
            if (!this.pageSize$set) {
                pageSize$value = PageRequest.$default$pageSize();
            }
            return new PageRequest<E>(pageNum$value, pageSize$value, this.param);
        }

        public String toString() {
            return "PageRequest.PageRequestBuilder(pageNum$value=" + this.pageNum$value + ", pageSize$value=" + this.pageSize$value + ", param=" + this.param + ")";
        }
    }
}

