/*
 * Decompiled with CFR 0.152.
 */
package com.github.dreamroute.pager.starter.api;

import java.io.Serializable;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;

public class PageRequest
implements Serializable {
    @Min(value=1L)
    @NotNull
    private @Min(value=1L) @NotNull int pageNum = 1;
    @Min(value=1L)
    @NotNull
    @Max(value=0x7FFFFFFFL)
    private @Min(value=1L) @NotNull @Max(value=0x7FFFFFFFL) int pageSize = 10;

    public int getPageNum() {
        return this.pageNum;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageNum(int pageNum) {
        this.pageNum = pageNum;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PageRequest)) {
            return false;
        }
        PageRequest other = (PageRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getPageNum() != other.getPageNum()) {
            return false;
        }
        return this.getPageSize() == other.getPageSize();
    }

    protected boolean canEqual(Object other) {
        return other instanceof PageRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getPageNum();
        result = result * 59 + this.getPageSize();
        return result;
    }

    public String toString() {
        return "PageRequest(pageNum=" + this.getPageNum() + ", pageSize=" + this.getPageSize() + ")";
    }
}

