/*
 * Decompiled with CFR 0.152.
 */
package com.github.dreamroute.pager.starter.interceptor;

import cn.hutool.core.annotation.AnnotationUtil;
import com.github.dreamroute.pager.starter.anno.Pager;
import com.github.dreamroute.pager.starter.anno.PagerContainer;
import com.github.dreamroute.pager.starter.api.PageRequest;
import com.github.dreamroute.pager.starter.exception.PaggerException;
import com.github.dreamroute.pager.starter.interceptor.ProxyUtil;
import com.github.dreamroute.pager.starter.interceptor.ResultWrapper;
import java.lang.reflect.AnnotatedElement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.statement.select.OrderByElement;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.util.TablesNamesFinder;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.builder.StaticSqlSource;
import org.apache.ibatis.cache.CacheKey;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.executor.statement.StatementHandler;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ParameterMapping;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.mapping.SqlSource;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.apache.ibatis.session.SqlSessionFactory;
import org.apache.ibatis.transaction.Transaction;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.util.CollectionUtils;

@Intercepts(value={@Signature(type=Executor.class, method="query", args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class}), @Signature(type=Executor.class, method="query", args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class, CacheKey.class, BoundSql.class})})
public class PagerInterceptor
implements Interceptor,
ApplicationListener<ContextRefreshedEvent> {
    private final ConcurrentHashMap<String, PagerContainer> pagerContainer = new ConcurrentHashMap();
    private static final int SINGLE = 1;
    private static final String COUNT_NAME = "_$count$_";
    private static final String WHERE = " WHERE ";
    private static final String FROM = " FROM ";
    private Configuration config;

    public void onApplicationEvent(ContextRefreshedEvent event) {
        SqlSessionFactory sqlSessionFactory = (SqlSessionFactory)event.getApplicationContext().getBean(SqlSessionFactory.class);
        this.config = sqlSessionFactory.getConfiguration();
        Collection mappers = this.config.getMapperRegistry().getMappers();
        if (mappers != null && !mappers.isEmpty()) {
            for (Class mapper : mappers) {
                String mapperName = mapper.getName();
                Arrays.stream(mapper.getDeclaredMethods()).filter(method -> AnnotationUtil.hasAnnotation((AnnotatedElement)method, Pager.class)).forEach(method -> {
                    PagerContainer container = new PagerContainer();
                    String dictinctBy = (String)AnnotationUtil.getAnnotationValue((AnnotatedElement)method, Pager.class, (String)"distinctBy");
                    if (StringUtils.isNotBlank((CharSequence)dictinctBy)) {
                        container.setDistinctBy(dictinctBy);
                    }
                    this.pagerContainer.put(mapperName + "." + method.getName(), container);
                });
            }
        }
    }

    public Object intercept(Invocation invocation) throws Throwable {
        MappedStatement ms = (MappedStatement)invocation.getArgs()[0];
        Object param = invocation.getArgs()[1];
        PagerContainer pc = this.pagerContainer.get(ms.getId());
        if (pc == null || !(param instanceof PageRequest)) {
            return invocation.proceed();
        }
        if (!pc.isInit()) {
            BoundSql boundSql = ms.getBoundSql(param);
            String beforeSql = boundSql.getSql();
            String afterSql = this.parseSql(beforeSql, ms.getId());
            pc.setAfterSql(afterSql);
            List beforePmList = boundSql.getParameterMappings();
            pc.setOriginPmList(beforePmList);
            List<ParameterMapping> afterPmList = this.parseParameterMappings(this.config, ms.getId(), beforePmList);
            pc.setAfterPmList(afterPmList);
            pc.setInit(true);
        }
        Executor executor = (Executor)ProxyUtil.getOriginObj(invocation.getTarget());
        Transaction transaction = executor.getTransaction();
        BoundSql countBoundSql = new BoundSql(this.config, pc.getCountSql(), pc.getOriginPmList(), param);
        MappedStatement m = new MappedStatement.Builder(this.config, "select.count._inner_id", (SqlSource)new StaticSqlSource(this.config, pc.getCountSql()), SqlCommandType.SELECT).build();
        StatementHandler countHandler = this.config.newStatementHandler(executor, m, param, RowBounds.DEFAULT, null, countBoundSql);
        Statement countStmt = this.prepareStatement(transaction, countHandler);
        ((PreparedStatement)countStmt).execute();
        ResultSet rs = countStmt.getResultSet();
        ResultWrapper container = new ResultWrapper();
        while (rs.next()) {
            long totle = rs.getLong(COUNT_NAME);
            container.setTotal(totle);
        }
        countStmt.close();
        PageRequest pr = (PageRequest)param;
        int pageNum = pr.getPageNum();
        int pageSize = pr.getPageSize();
        container.setPageNum(pageNum);
        container.setPageSize(pageSize);
        int start = (pageNum - 1) * pageSize;
        pr.setPageNum(start);
        if (container.getTotal() != 0L) {
            BoundSql bizBoundSql = new BoundSql(this.config, pc.getAfterSql(), pc.getAfterPmList(), param);
            StatementHandler bizHandler = this.config.newStatementHandler(executor, ms, param, RowBounds.DEFAULT, null, bizBoundSql);
            Statement bizStmt = this.prepareStatement(transaction, bizHandler);
            List data = bizHandler.query(bizStmt, null);
            bizStmt.close();
            container.addAll(data);
        }
        pr.setPageNum(pageNum);
        return container;
    }

    private Statement prepareStatement(Transaction transaction, StatementHandler handler) throws SQLException {
        Statement stmt = handler.prepare(transaction.getConnection(), transaction.getTimeout());
        handler.parameterize(stmt);
        return stmt;
    }

    private List<ParameterMapping> parseParameterMappings(Configuration config, String id, List<ParameterMapping> pmList) {
        ArrayList<ParameterMapping> result = new ArrayList<ParameterMapping>(Optional.ofNullable(pmList).orElseGet(ArrayList::new));
        result.add(new ParameterMapping.Builder(config, "pageNum", Integer.TYPE).build());
        result.add(new ParameterMapping.Builder(config, "pageSize", Integer.TYPE).build());
        if (!this.pagerContainer.get(id).isSingleTable()) {
            result.addAll(Optional.ofNullable(pmList).orElseGet(ArrayList::new));
        }
        return result;
    }

    private String parseSql(String sql, String id) {
        String afterSql;
        Select select;
        PagerContainer container = this.pagerContainer.get(id);
        try {
            select = (Select)CCJSqlParserUtil.parse((String)sql);
        }
        catch (Exception e) {
            throw new PaggerException("SQL\u8bed\u53e5\u5f02\u5e38\uff0c\u4f60\u7684sql\u8bed\u53e5\u662f: [" + sql + "]", e);
        }
        List tableList = new TablesNamesFinder().getTableList((net.sf.jsqlparser.statement.Statement)select);
        PlainSelect body = (PlainSelect)select.getSelectBody();
        String columns = body.getSelectItems().stream().map(Object::toString).collect(Collectors.joining(","));
        String from = body.getFromItem().toString();
        String where = Optional.ofNullable(body.getWhere()).map(Object::toString).orElse("");
        if (tableList != null && tableList.size() == 1) {
            where = StringUtils.isNotBlank((CharSequence)where) ? WHERE + where : "";
            sql = "SELECT " + columns + FROM + from + where;
            container.setCountSql("SELECT COUNT(1) _$count$_ FROM (" + sql + ") _$_t");
            String orderBy = Optional.ofNullable(body.getOrderByElements()).orElseGet(ArrayList::new).stream().map(Objects::toString).collect(Collectors.joining(", "));
            orderBy = StringUtils.isNotBlank((CharSequence)orderBy) ? " ORDER BY " + orderBy : "";
            afterSql = sql + orderBy + " LIMIT ?, ?";
            container.setSingleTable(true);
        } else {
            String joins = body.getJoins().stream().map(Object::toString).collect(Collectors.joining(" "));
            String alias = "";
            String distinctBy = container.getDistinctBy();
            if (StringUtils.isEmpty((CharSequence)distinctBy) || Objects.equals("id", distinctBy)) {
                throw new PaggerException("\u591a\u8868\u67e5\u8be2\u9700\u8981\u8bbe\u7f6e@Pager\u7684\u4e3b\u8868distinctBy\u5c5e\u6027, \u8bbe\u7f6e\u65b9\u5f0f\u53c2\u8003\u63d2\u4ef6\u7684\u6587\u6863distinctBy\u8bbe\u7f6e\u65b9\u6cd5\u3002sql: " + select.toString());
            }
            if (distinctBy.indexOf(46) != -1) {
                alias = distinctBy.split("\\.")[0];
            }
            String orderBy = "";
            String subQueryColumns = "";
            List orderbyList = body.getOrderByElements();
            if (!CollectionUtils.isEmpty((Collection)orderbyList)) {
                orderBy = " ORDER BY " + orderbyList.stream().map(Object::toString).collect(Collectors.joining(", "));
                Set orderbyListStr = orderbyList.stream().map(OrderByElement::getExpression).map(Objects::toString).collect(Collectors.toSet());
                orderbyListStr.add(distinctBy);
                subQueryColumns = String.join((CharSequence)", ", orderbyListStr);
            }
            String afterFrom = FROM + from + " " + joins + WHERE + where;
            String subQuery = "SELECT DISTINCT " + subQueryColumns + afterFrom;
            String noCondition = "SELECT " + columns + FROM + from + " " + joins + " ";
            String result = noCondition + WHERE + distinctBy + " IN  (SELECT " + distinctBy + " FROM (" + subQuery + orderBy + " LIMIT ?, ?) " + alias + ")";
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{where})) {
                result = result + " AND " + where;
            }
            afterSql = result + orderBy;
            String count = "SELECT count(DISTINCT " + distinctBy + ") " + COUNT_NAME + afterFrom;
            container.setCountSql(count);
        }
        return afterSql;
    }
}

