/*
 * Decompiled with CFR 0.152.
 */
package com.github.droidpl.android.jsonviewer;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v7.app.AppCompatActivity;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.widget.Toast;
import com.github.droidpl.android.jsonviewer.R;
import com.github.droidpl.android.jsonviewer.RVJsonAdapter;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class JSONViewerActivity
extends AppCompatActivity
implements RVJsonAdapter.JsonListener {
    private static final String JSON_OBJECT_STATE = "bundle_json_object";
    private static final String JSON_ARRAY_STATE = "bundle_json_array";
    private RecyclerView mRecyclerView;

    public static void startActivity(@NonNull Context context, @Nullable JSONObject jsonObject) {
        Intent intent = new Intent(context, JSONViewerActivity.class);
        Bundle bundle = new Bundle();
        if (jsonObject != null) {
            bundle.putString(JSON_OBJECT_STATE, jsonObject.toString());
        }
        intent.putExtras(bundle);
        context.startActivity(intent);
    }

    public static void startActivity(@NonNull Context context, @Nullable JSONArray jsonArray) {
        Intent intent = new Intent(context, JSONViewerActivity.class);
        Bundle bundle = new Bundle();
        if (jsonArray != null) {
            bundle.putString(JSON_ARRAY_STATE, jsonArray.toString());
        }
        intent.putExtras(bundle);
        context.startActivity(intent);
    }

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.json_viewer_activity);
        this.mRecyclerView = (RecyclerView)this.findViewById(R.id.rv_json);
        this.mRecyclerView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager((Context)this));
        this.mRecyclerView.setHasFixedSize(true);
    }

    protected void onPostCreate(@Nullable Bundle savedInstanceState) {
        super.onPostCreate(savedInstanceState);
        Bundle intentExtras = this.getIntent().getExtras();
        if (intentExtras == null) {
            this.finish();
        } else {
            String jsonObjectString = intentExtras.getString(JSON_OBJECT_STATE);
            String jsonArrayString = intentExtras.getString(JSON_ARRAY_STATE);
            try {
                RVJsonAdapter adapter = jsonObjectString != null ? new RVJsonAdapter((Context)this, new JSONObject(jsonObjectString), (RVJsonAdapter.JsonListener)this) : (jsonArrayString != null ? new RVJsonAdapter((Context)this, new JSONArray(jsonArrayString), (RVJsonAdapter.JsonListener)this) : new RVJsonAdapter((Context)this));
                this.mRecyclerView.setAdapter((RecyclerView.Adapter)adapter);
            }
            catch (JSONException e) {
                Toast.makeText((Context)this, (CharSequence)e.getMessage(), (int)1).show();
                this.finish();
            }
        }
    }

    @Override
    public void openJsonObject(@NonNull JSONObject object) {
        JSONViewerActivity.startActivity((Context)this, object);
    }

    @Override
    public void openJsonArray(@NonNull JSONArray array) {
        JSONViewerActivity.startActivity((Context)this, array);
    }
}

