/*
 * Decompiled with CFR 0.152.
 */
package com.github.droidpl.android.jsonviewer;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import com.github.droidpl.android.jsonviewer.R;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;

public class RVJsonAdapter
extends RecyclerView.Adapter<ViewHolder> {
    private Context mContext;
    private HashMap<String, Object> mMap;
    private JSONArray mJsonArray;
    private JsonListener mListener;

    public RVJsonAdapter(@NonNull Context context, @Nullable JSONObject json, @Nullable JsonListener listener) {
        this.mContext = context;
        if (json != null) {
            this.mMap = new LinkedHashMap<String, Object>(json.length());
            Iterator keys = json.keys();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                this.mMap.put(key, json.opt(key));
            }
        }
        this.mListener = listener;
    }

    public RVJsonAdapter(@NonNull Context context, @Nullable JSONArray array, @Nullable JsonListener listener) {
        this.mContext = context;
        this.mJsonArray = array;
        this.mListener = listener;
    }

    public RVJsonAdapter(@NonNull Context context) {
        this.mContext = context;
    }

    public ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        final ViewHolder viewHolder = new ViewHolder(LayoutInflater.from((Context)this.mContext).inflate(R.layout.json_item_adapter, parent, false));
        viewHolder.itemView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                Object obj;
                if (RVJsonAdapter.this.mListener != null && (obj = RVJsonAdapter.this.getItem(viewHolder.getAdapterPosition())) != null) {
                    if (obj instanceof JSONObject) {
                        RVJsonAdapter.this.mListener.openJsonObject((JSONObject)obj);
                    } else if (obj instanceof JSONArray) {
                        RVJsonAdapter.this.mListener.openJsonArray((JSONArray)obj);
                    }
                }
            }
        });
        return viewHolder;
    }

    public void onBindViewHolder(@NonNull ViewHolder holder, int position) {
        Object obj = this.getItem(position);
        String key = this.getItemKey(position);
        if (obj != null) {
            if (obj instanceof JSONObject) {
                holder.setObject(key, false);
            } else if (obj instanceof JSONArray) {
                holder.setObject(key, true);
            } else {
                holder.setText(key, obj.toString());
            }
        }
    }

    public int getItemCount() {
        if (this.mMap != null) {
            return this.mMap.size();
        }
        if (this.mJsonArray != null) {
            return this.mJsonArray.length();
        }
        return 0;
    }

    @Nullable
    private String getItemKey(int position) {
        if (this.mMap != null) {
            return new ArrayList<Map.Entry<String, Object>>(this.mMap.entrySet()).get(position).getKey();
        }
        if (this.mJsonArray != null) {
            return String.valueOf(position);
        }
        return null;
    }

    @Nullable
    private Object getItem(int position) {
        if (this.mMap != null) {
            return new ArrayList<Map.Entry<String, Object>>(this.mMap.entrySet()).get(position).getValue();
        }
        if (this.mJsonArray != null) {
            return this.mJsonArray.opt(position);
        }
        return null;
    }

    public static class ViewHolder
    extends RecyclerView.ViewHolder {
        private TextView mProperty;
        private TextView mValue;
        private ImageView mImage;

        public ViewHolder(@NonNull View itemView) {
            super(itemView);
            this.mProperty = (TextView)itemView.findViewById(R.id.tv_property);
            this.mValue = (TextView)itemView.findViewById(R.id.tv_value);
            this.mImage = (ImageView)itemView.findViewById(R.id.iv_next);
        }

        public void setText(@Nullable String property, @Nullable String text) {
            this.mImage.setVisibility(8);
            this.mProperty.setText((CharSequence)property);
            this.mValue.setText((CharSequence)text);
        }

        public void setObject(@Nullable String property, boolean isArray) {
            this.mImage.setVisibility(0);
            this.mProperty.setText((CharSequence)property);
            if (isArray) {
                this.mValue.setText((CharSequence)"[...]");
            } else {
                this.mValue.setText((CharSequence)"{...}");
            }
        }
    }

    public static interface JsonListener {
        public void openJsonObject(@NonNull JSONObject var1);

        public void openJsonArray(@NonNull JSONArray var1);
    }
}

