/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import java.io.IOException;
import java.util.ArrayList;
import tcl.lang.AssocData;
import tcl.lang.IdleHandler;
import tcl.lang.Interp;
import tcl.lang.Notifier;
import tcl.lang.Parser;
import tcl.lang.TclException;
import tcl.lang.TclIO;
import tcl.lang.TclObject;
import tcl.lang.TclString;
import tcl.lang.channel.Channel;

class BgErrorMgr
implements AssocData {
    Interp interp;
    TclObject bgerrorCmdObj;
    ArrayList errors;

    BgErrorMgr(Interp interp) {
        this.interp = interp;
        this.bgerrorCmdObj = TclString.newInstance("bgerror");
        this.bgerrorCmdObj.preserve();
        this.errors = new ArrayList();
    }

    void addBgError() {
        BgError bgError = new BgError(this.interp.getNotifier());
        this.interp.addErrorInfo("");
        bgError.errorMsg = this.interp.getResult();
        bgError.errorInfo = null;
        try {
            bgError.errorInfo = this.interp.getVar("errorInfo", null, 1);
        }
        catch (TclException tclException) {
            // empty catch block
        }
        bgError.errorCode = null;
        try {
            bgError.errorCode = this.interp.getVar("errorCode", null, 1);
        }
        catch (TclException tclException) {
            // empty catch block
        }
        bgError.errorMsg.preserve();
        bgError.errorInfo.preserve();
        bgError.errorCode.preserve();
        this.errors.add(bgError);
    }

    @Override
    public void disposeAssocData(Interp interp) {
        for (int i = this.errors.size() - 1; i >= 0; --i) {
            BgError bgError = (BgError)this.errors.get(i);
            this.errors.remove(i);
            bgError.cancel();
            bgError.errorMsg.release();
            bgError.errorMsg = null;
            bgError.errorInfo.release();
            bgError.errorInfo = null;
            bgError.errorCode.release();
            bgError.errorCode = null;
        }
        this.bgerrorCmdObj.release();
        this.bgerrorCmdObj = null;
    }

    class BgError
    extends IdleHandler {
        TclObject errorMsg;
        TclObject errorCode;
        TclObject errorInfo;

        BgError(Notifier notifier) {
            super(notifier);
        }

        @Override
        public void processIdleEvent() {
            int n = BgErrorMgr.this.errors.indexOf(this);
            BgErrorMgr.this.errors.remove(n);
            try {
                BgErrorMgr.this.interp.setVar("errorInfo", null, this.errorInfo, 1);
            }
            catch (TclException tclException) {
                // empty catch block
            }
            try {
                BgErrorMgr.this.interp.setVar("errorCode", null, this.errorCode, 1);
            }
            catch (TclException tclException) {
                // empty catch block
            }
            BgErrorMgr.this.interp.preserve();
            try {
                TclObject[] tclObjectArray = new TclObject[]{BgErrorMgr.this.bgerrorCmdObj, this.errorMsg};
                Parser.evalObjv(BgErrorMgr.this.interp, tclObjectArray, 0, 131072);
            }
            catch (TclException tclException) {
                switch (tclException.getCompletionCode()) {
                    case 1: {
                        try {
                            Channel channel = TclIO.getStdChannel(2);
                            if (BgErrorMgr.this.interp.getResult().toString().equals("\"bgerror\" is an invalid command name or ambiguous abbreviation")) {
                                channel.write(BgErrorMgr.this.interp, this.errorInfo);
                                channel.write(BgErrorMgr.this.interp, "\n");
                            } else {
                                channel.write(BgErrorMgr.this.interp, "bgerror failed to handle background error.\n");
                                channel.write(BgErrorMgr.this.interp, "    Original error: ");
                                channel.write(BgErrorMgr.this.interp, this.errorMsg);
                                channel.write(BgErrorMgr.this.interp, "\n");
                                channel.write(BgErrorMgr.this.interp, "    Error in bgerror: ");
                                channel.write(BgErrorMgr.this.interp, BgErrorMgr.this.interp.getResult());
                                channel.write(BgErrorMgr.this.interp, "\n");
                            }
                            channel.flush(BgErrorMgr.this.interp);
                        }
                        catch (TclException tclException2) {
                        }
                        catch (IOException iOException) {}
                        break;
                    }
                    case 3: {
                        for (int i = BgErrorMgr.this.errors.size() - 1; i >= 0; --i) {
                            BgError bgError = (BgError)BgErrorMgr.this.errors.get(i);
                            BgErrorMgr.this.errors.remove(i);
                            bgError.cancel();
                            bgError.errorMsg.release();
                            bgError.errorMsg = null;
                            bgError.errorInfo.release();
                            bgError.errorInfo = null;
                            bgError.errorCode.release();
                            bgError.errorCode = null;
                        }
                        break;
                    }
                }
            }
            BgErrorMgr.this.interp.release();
            this.errorMsg.release();
            this.errorMsg = null;
            this.errorInfo.release();
            this.errorInfo = null;
            this.errorCode.release();
            this.errorCode = null;
        }
    }
}

