/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import tcl.lang.Interp;
import tcl.lang.TclException;
import tcl.lang.Util;
import tcl.lang.Var;

class Env {
    Env() {
    }

    static void initialize(Interp interp) {
        try {
            interp.setVar("env", "CLASSPATH", Util.tryGetSystemProperty("java.class.path", ""), 1);
        }
        catch (TclException tclException) {
            // empty catch block
        }
        try {
            interp.setVar("env", "HOME", Util.tryGetSystemProperty("user.home", ""), 1);
        }
        catch (TclException tclException) {
            // empty catch block
        }
        try {
            interp.setVar("env", "USER", Util.tryGetSystemProperty("user.name", ""), 1);
        }
        catch (TclException tclException) {
            // empty catch block
        }
        try {
            Properties properties = System.getProperties();
            Enumeration<?> enumeration = properties.propertyNames();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                try {
                    interp.setVar("env", string, properties.getProperty(string), 1);
                }
                catch (TclException tclException) {}
            }
            for (Map.Entry entry : System.getenv().entrySet()) {
                interp.setVar("env", (String)entry.getKey(), (String)entry.getValue(), 1);
            }
        }
        catch (SecurityException securityException) {
        }
        catch (Exception exception) {
            System.out.println("Exception while initializing env array");
            System.out.println(exception);
            System.out.println("");
        }
    }

    public static Map<String, String> getenv(Interp interp) {
        Var[] varArray = null;
        try {
            varArray = Var.lookupVar(interp, "env", null, 1, null, false, false);
        }
        catch (TclException tclException) {
            // empty catch block
        }
        if (varArray == null || varArray[0] == null || !varArray[0].isVarArray()) {
            try {
                return System.getenv();
            }
            catch (SecurityException securityException) {
                return Collections.unmodifiableMap(new HashMap());
            }
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Map<String, Var> map = varArray[0].getArrayMap();
        for (Map.Entry<String, Var> entry : map.entrySet()) {
            String string;
            if (entry.getValue().isVarUndefined() || (string = entry.getValue().getValue().toString()) == null) continue;
            hashMap.put(entry.getKey(), string);
        }
        return Collections.unmodifiableMap(hashMap);
    }
}

