/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import tcl.lang.Interp;
import tcl.lang.TclException;
import tcl.lang.TclRuntimeError;
import tcl.lang.Util;

public final class ExprValue {
    public static final int INT = 0;
    public static final int DOUBLE = 1;
    public static final int STRING = 2;
    private long intValue;
    private double doubleValue;
    private String stringValue;
    private int type;
    private static final boolean validate = false;

    public ExprValue(long l, String string) {
        this.setIntValue(l, string);
    }

    public ExprValue(double d, String string) {
        this.setDoubleValue(d, string);
    }

    public ExprValue(String string) {
        this.setStringValue(string);
    }

    public ExprValue(boolean bl) {
        this.setIntValue(bl);
    }

    public final int getType() {
        return this.type;
    }

    public final boolean isIntType() {
        return this.type == 0;
    }

    public final boolean isDoubleType() {
        return this.type == 1;
    }

    public final boolean isStringType() {
        return this.type == 2;
    }

    public final boolean isIntOrDoubleType() {
        return this.type == 0 || this.type == 1;
    }

    public final long getIntValue() {
        return this.intValue;
    }

    public final double getDoubleValue() {
        return this.doubleValue;
    }

    public final String getStringValue() {
        if (this.type != 2) {
            if (this.type == 0) {
                if (this.stringValue == null) {
                    this.stringValue = Long.toString(this.intValue);
                }
            } else if (this.type == 1 && this.stringValue == null) {
                this.stringValue = Util.printDouble(this.doubleValue);
            }
        }
        return this.stringValue;
    }

    public final boolean getBooleanValue(Interp interp) throws TclException {
        switch (this.type) {
            case 0: {
                return this.intValue != 0L;
            }
            case 1: {
                return this.doubleValue != 0.0;
            }
            case 2: {
                return Util.getBoolean(interp, this.stringValue);
            }
        }
        throw new TclRuntimeError("internal error: expression, unknown");
    }

    public final void setIntValue(long l) {
        this.stringValue = null;
        this.intValue = l;
        this.type = 0;
    }

    public final void setIntValue(long l, String string) {
        this.stringValue = string;
        this.intValue = l;
        this.type = 0;
    }

    public final void setIntValue(boolean bl) {
        this.stringValue = null;
        this.intValue = bl ? 1 : 0;
        this.type = 0;
    }

    public final void setDoubleValue(double d) {
        this.stringValue = null;
        this.doubleValue = d;
        this.type = 1;
    }

    public final void setDoubleValue(double d, String string) {
        this.stringValue = string;
        this.doubleValue = d;
        this.type = 1;
    }

    public final void setStringValue(String string) {
        if (string == null) {
            throw new NullPointerException();
        }
        this.stringValue = string;
        this.type = 2;
    }

    public final void setValue(ExprValue exprValue) {
        this.type = exprValue.type;
        this.intValue = exprValue.intValue;
        this.doubleValue = exprValue.doubleValue;
        this.stringValue = exprValue.stringValue;
    }

    public final void nullStringValue() {
        this.stringValue = null;
    }

    final void toStringType() {
        if (this.type == 2) {
            throw new TclRuntimeError("called toStringType() on STRING type");
        }
        if (this.stringValue == null) {
            this.getStringValue();
        }
        this.type = 2;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(64);
        if (this.type == 2) {
            stringBuffer.append("STRING \"" + this.stringValue + "\"");
        } else if (this.type == 0) {
            String string;
            stringBuffer.append("INT \"" + this.intValue + "\"");
            if (this.stringValue != null && (string = Long.toString(this.intValue)).compareTo(this.stringValue) != 0) {
                stringBuffer.append(" parsed from \"");
                stringBuffer.append(this.stringValue);
                stringBuffer.append("\"");
            }
        } else if (this.type == 1) {
            String string;
            stringBuffer.append("DOUBLE \"" + this.doubleValue + "\"");
            if (this.stringValue != null && (string = Util.printDouble(this.doubleValue)).compareTo(this.stringValue) != 0) {
                stringBuffer.append(" parsed from \"");
                stringBuffer.append(this.stringValue);
                stringBuffer.append("\"");
            }
        }
        return stringBuffer.toString();
    }

    final void optIntMult(ExprValue exprValue) {
        this.stringValue = null;
        this.intValue *= exprValue.intValue;
    }

    final void optDoubleMult(ExprValue exprValue) {
        this.stringValue = null;
        this.doubleValue *= exprValue.doubleValue;
    }

    public final void optIntPlus(ExprValue exprValue) {
        this.stringValue = null;
        this.intValue += exprValue.intValue;
    }

    final void optDoublePlus(ExprValue exprValue) {
        this.stringValue = null;
        this.doubleValue += exprValue.doubleValue;
    }

    final void optIntMinus(ExprValue exprValue) {
        this.stringValue = null;
        this.intValue -= exprValue.intValue;
    }

    final void optDoubleMinus(ExprValue exprValue) {
        this.stringValue = null;
        this.doubleValue -= exprValue.doubleValue;
    }

    final void optIntLess(ExprValue exprValue) {
        this.stringValue = null;
        this.intValue = this.intValue < exprValue.intValue ? 1 : 0;
    }

    final void optDoubleLess(ExprValue exprValue) {
        this.stringValue = null;
        this.intValue = this.doubleValue < exprValue.doubleValue ? 1 : 0;
        this.type = 0;
    }

    final void optIntGreater(ExprValue exprValue) {
        this.stringValue = null;
        this.intValue = this.intValue > exprValue.intValue ? 1 : 0;
    }

    final void optDoubleGreater(ExprValue exprValue) {
        this.stringValue = null;
        this.intValue = this.doubleValue > exprValue.doubleValue ? 1 : 0;
        this.type = 0;
    }

    final void optIntLessEq(ExprValue exprValue) {
        this.stringValue = null;
        this.intValue = this.intValue <= exprValue.intValue ? 1 : 0;
    }

    final void optDoubleLessEq(ExprValue exprValue) {
        this.stringValue = null;
        this.intValue = this.doubleValue <= exprValue.doubleValue ? 1 : 0;
        this.type = 0;
    }

    final void optIntGreaterEq(ExprValue exprValue) {
        this.stringValue = null;
        this.intValue = this.intValue >= exprValue.intValue ? 1 : 0;
    }

    final void optDoubleGreaterEq(ExprValue exprValue) {
        this.stringValue = null;
        this.intValue = this.doubleValue >= exprValue.doubleValue ? 1 : 0;
        this.type = 0;
    }

    final void optIntEq(ExprValue exprValue) {
        this.stringValue = null;
        this.intValue = this.intValue == exprValue.intValue ? 1 : 0;
    }

    final void optDoubleEq(ExprValue exprValue) {
        this.stringValue = null;
        this.intValue = this.doubleValue == exprValue.doubleValue ? 1 : 0;
        this.type = 0;
    }

    final void optIntNotEq(ExprValue exprValue) {
        this.stringValue = null;
        this.intValue = this.intValue != exprValue.intValue ? 1 : 0;
    }

    final void optDoubleNotEq(ExprValue exprValue) {
        this.stringValue = null;
        this.intValue = this.doubleValue != exprValue.doubleValue ? 1 : 0;
        this.type = 0;
    }

    public final void optIntUnaryNot() {
        this.stringValue = null;
        this.intValue = this.intValue == 0L ? 1L : 0L;
    }

    public final void optIntUnaryNotNstr() {
        this.intValue = this.intValue == 0L ? 1L : 0L;
    }
}

