/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.HashMap;
import tcl.lang.Interp;
import tcl.lang.JACL;
import tcl.lang.TclException;
import tcl.lang.TclList;
import tcl.lang.TclObject;
import tcl.lang.TclRuntimeError;
import tcl.lang.TclString;
import tcl.lang.Util;

public class FileUtil {
    public static final int PATH_RELATIVE = 0;
    public static final int PATH_VOLUME_RELATIVE = 1;
    public static final int PATH_ABSOLUTE = 2;
    private static HashMap<String, String> userDirs = null;

    private static int getWinHomePath(String string, boolean bl, StringBuffer stringBuffer) {
        int n;
        for (n = 0; n < string.length() && string.charAt(n) == '/'; ++n) {
        }
        if (n < 2) {
            stringBuffer.setLength(0);
            return 0;
        }
        int n2 = n;
        while (n < string.length() && string.charAt(n) != '/') {
            ++n;
        }
        if (n == n2) {
            stringBuffer.setLength(0);
            return 0;
        }
        stringBuffer.ensureCapacity(stringBuffer.length() + string.length());
        stringBuffer.append("//");
        stringBuffer.append(string.substring(n2, n));
        int n3 = n;
        while (n < string.length()) {
            if (string.charAt(n) != '/') {
                if (n == n3) {
                    stringBuffer.setLength(0);
                    return 0;
                }
                if (bl) {
                    stringBuffer.setLength(0);
                    return n2;
                }
                n2 = n++;
                while (n < string.length() && string.charAt(n) != '/') {
                    ++n;
                }
                stringBuffer.append('/');
                stringBuffer.append(string.substring(n2, n));
                return n;
            }
            ++n;
        }
        stringBuffer.setLength(0);
        return 0;
    }

    private static int beginsWithLetterColon(String string) {
        if (string.length() > 1 && Character.isLetter(string.charAt(0)) && string.charAt(1) == ':') {
            int n;
            for (n = 2; n < string.length() && string.charAt(n) == '/'; ++n) {
            }
            return n;
        }
        return 0;
    }

    private static int getWinAbsPath(String string, StringBuffer stringBuffer) {
        stringBuffer.setLength(0);
        if (string.length() < 1) {
            return 0;
        }
        stringBuffer.ensureCapacity(stringBuffer.length() + string.length());
        int n = FileUtil.beginsWithLetterColon(string);
        if (n > 0) {
            if (n > 2) {
                stringBuffer.append(string.substring(0, 3));
            } else {
                stringBuffer.append(string.substring(0, 2));
            }
            return n;
        }
        int n2 = FileUtil.getWinHomePath(string, false, stringBuffer);
        if (n2 > 0) {
            return n2;
        }
        if (string.charAt(0) == '/') {
            int n3;
            for (n3 = 1; n3 < string.length() && string.charAt(n3) == '/'; ++n3) {
            }
            stringBuffer.append("/");
            return n3;
        }
        return 0;
    }

    private static int getDegenerateUnixPath(String string) {
        int n;
        for (n = 0; n < string.length() && string.charAt(n) == '/'; ++n) {
        }
        if (n == 0) {
            return 0;
        }
        while (n < string.length()) {
            String string2 = string.substring(n);
            if (string2.startsWith("./")) {
                n += 2;
            } else {
                if (!string2.startsWith("../")) break;
                n += 3;
            }
            while (n < string.length() && string.charAt(n) == '/') {
                ++n;
            }
        }
        if (n < string.length() && string.charAt(n) == '.') {
            ++n;
        }
        if (n < string.length() && string.charAt(n) == '.') {
            ++n;
        }
        return n;
    }

    public static int getPathType(String string) {
        if (string.length() < 1) {
            return 0;
        }
        switch (JACL.PLATFORM) {
            case 1: {
                string = string.replace('\\', '/');
                char c = string.charAt(0);
                if (c == '~') {
                    return 2;
                }
                if (c == '/') {
                    StringBuffer stringBuffer = new StringBuffer();
                    if (FileUtil.getWinHomePath(string, true, stringBuffer) > 0) {
                        return 2;
                    }
                    return 1;
                }
                int n = FileUtil.beginsWithLetterColon(string);
                if (n > 0) {
                    if (n > 2) {
                        return 2;
                    }
                    return 1;
                }
                return 0;
            }
            case 2: {
                if (string.charAt(0) == '~') {
                    return 2;
                }
                switch (string.indexOf(58)) {
                    case -1: {
                        if (string.charAt(0) != '/' || FileUtil.getDegenerateUnixPath(string) >= string.length()) break;
                        return 2;
                    }
                    case 0: {
                        return 0;
                    }
                    default: {
                        return 2;
                    }
                }
                return 0;
            }
        }
        char c = string.charAt(0);
        if (c == '/' || c == '~') {
            return 2;
        }
        return 0;
    }

    public static File getNewFileObj(Interp interp, String string) throws TclException {
        string = FileUtil.translateFileName(interp, string);
        switch (FileUtil.getPathType(string)) {
            case 0: {
                return new File(interp.getWorkingDir(), string);
            }
            case 1: {
                String string2 = interp.getWorkingDir().toString();
                int n = FileUtil.beginsWithLetterColon(string2);
                if (n == 0) {
                    throw new TclRuntimeError("interp working directory \"" + string2 + "\" does not start with a drive letter");
                }
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(string2.substring(0, 2));
                stringBuffer.append('\\');
                for (int i = 0; i < string.length(); ++i) {
                    if (string.charAt(i) == '\\') continue;
                    stringBuffer.append(string.substring(i));
                    break;
                }
                string = stringBuffer.toString();
                return new File(string);
            }
            case 2: {
                return new File(string);
            }
        }
        throw new TclRuntimeError("type for fileName \"" + string + "\" not matched in case statement");
    }

    private static void appendComponent(String string, int n, int n2, StringBuffer stringBuffer) {
        while (n < string.length()) {
            char c = string.charAt(n);
            if (c == '/') {
                while (n < n2 && string.charAt(n + 1) == '/') {
                    ++n;
                }
                if (n < n2) {
                    stringBuffer.ensureCapacity(stringBuffer.length() + 1);
                    stringBuffer.append('/');
                }
            } else {
                stringBuffer.ensureCapacity(stringBuffer.length() + 1);
                stringBuffer.append(c);
            }
            ++n;
        }
    }

    public static String joinPath(Interp interp, TclObject[] tclObjectArray, int n, int n2) throws TclException {
        StringBuffer stringBuffer = new StringBuffer();
        switch (JACL.PLATFORM) {
            case 1: {
                for (int i = n; i < n2; ++i) {
                    String string = tclObjectArray[i].toString().replace('\\', '/');
                    int n3 = 0;
                    int n4 = string.length() - 1;
                    if (string.length() == 0) continue;
                    StringBuffer stringBuffer2 = new StringBuffer();
                    n3 = FileUtil.getWinAbsPath(string, stringBuffer2);
                    if (n3 > 0) {
                        stringBuffer = stringBuffer2;
                    } else if (string.charAt(0) == '~') {
                        stringBuffer.setLength(0);
                    } else {
                        char c;
                        if (stringBuffer.length() != 0 && string.regionMatches(n3, "./~", 0, 3)) {
                            n3 = 2;
                        }
                        if (stringBuffer.length() != 0 && (c = stringBuffer.charAt(stringBuffer.length() - 1)) != '/') {
                            stringBuffer.append('/');
                        }
                    }
                    FileUtil.appendComponent(string, n3, n4, stringBuffer);
                    n3 = string.length();
                }
                return stringBuffer.toString();
            }
            case 2: {
                boolean bl = true;
                for (int i = n; i < n2; ++i) {
                    TclObject[] tclObjectArray2 = TclList.getElements(interp, FileUtil.splitPath(interp, tclObjectArray[i].toString()));
                    if (tclObjectArray2.length == 0) continue;
                    int n5 = 0;
                    String string = tclObjectArray2[0].toString();
                    if (string.charAt(0) != ':' && string.indexOf(58) != -1) {
                        stringBuffer.setLength(0);
                        stringBuffer.append(string);
                        bl = false;
                    }
                    for (int j = ++n5; j < tclObjectArray2.length; ++j) {
                        string = tclObjectArray2[j].toString();
                        if (string.equals(":")) {
                            if (stringBuffer.length() != 0) continue;
                            bl = false;
                        } else {
                            int n6 = 111;
                            if (string.length() > 1) {
                                n6 = string.charAt(1);
                            }
                            if (string.charAt(0) == ':') {
                                if (!bl) {
                                    string = string.substring(1);
                                }
                            } else if (bl) {
                                stringBuffer.append(':');
                            }
                            bl = n6 != 58;
                        }
                        stringBuffer.append(string);
                    }
                }
                return stringBuffer.toString();
            }
        }
        for (int i = n; i < n2; ++i) {
            int n7;
            String string = tclObjectArray[i].toString();
            int n8 = string.length() - 1;
            if (string.length() == 0) continue;
            if (string.charAt(n7) == '/') {
                for (n7 = 0; n7 <= n8 && string.charAt(n7) == '/'; ++n7) {
                }
                stringBuffer.setLength(0);
                stringBuffer.append('/');
            } else if (string.charAt(n7) == '~') {
                stringBuffer.setLength(0);
            } else {
                if (stringBuffer.length() != 0 && string.regionMatches(n7, "./~", 0, 3)) {
                    n7 += 2;
                }
                if (stringBuffer.length() != 0 && stringBuffer.charAt(stringBuffer.length() - 1) != '/') {
                    stringBuffer.ensureCapacity(stringBuffer.length() + 1);
                    stringBuffer.append('/');
                }
            }
            FileUtil.appendComponent(string, n7, n8, stringBuffer);
            n7 = string.length();
        }
        return stringBuffer.toString();
    }

    public static TclObject splitPath(Interp interp, String string) throws TclException {
        TclObject tclObject;
        String string2;
        TclObject tclObject2 = TclList.newInstance();
        String string3 = "";
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        String string4 = "./";
        if (string.length() == 0) {
            return tclObject2;
        }
        block0 : switch (JACL.PLATFORM) {
            case 1: {
                string2 = string.replace('\\', '/');
                StringBuffer stringBuffer = new StringBuffer();
                int n = FileUtil.getWinAbsPath(string2, stringBuffer);
                if (n <= 0) break;
                tclObject = TclString.newInstance(stringBuffer.toString());
                TclList.append(interp, tclObject2, tclObject);
                string2 = string2.substring(n);
                bl = true;
                break;
            }
            case 2: {
                string2 = "";
                string4 = ":";
                switch (string.indexOf(58)) {
                    case -1: {
                        if (string.charAt(0) != '/') {
                            string2 = string;
                            bl2 = true;
                            if (string.charAt(0) != '~') break block0;
                            bl4 = true;
                            break;
                        }
                        int n = FileUtil.getDegenerateUnixPath(string);
                        if (n < string.length()) {
                            string2 = string.substring(n);
                            bl2 = true;
                            bl4 = true;
                            break;
                        }
                        TclObject tclObject3 = TclString.newInstance(":" + string);
                        TclList.append(interp, tclObject2, tclObject3);
                        return tclObject2;
                    }
                    case 0: {
                        if (string.length() == 1) {
                            TclObject tclObject4 = TclString.newInstance(":");
                            TclList.append(interp, tclObject2, tclObject4);
                            return tclObject2;
                        }
                        string2 = string.substring(1);
                        bl = true;
                        bl5 = true;
                        bl3 = true;
                        break;
                    }
                    default: {
                        string2 = string;
                        bl4 = true;
                        bl5 = true;
                        bl3 = true;
                        break;
                    }
                }
                break;
            }
            default: {
                if (string.charAt(0) == '/') {
                    tclObject = TclString.newInstance("/");
                    TclList.append(interp, tclObject2, tclObject);
                    string2 = string.substring(1);
                    bl = true;
                    break;
                }
                string2 = string;
            }
        }
        int n = 0;
        while (n != -1) {
            if (bl3) {
                n = string2.indexOf(":");
                if (n == 0) {
                    tclObject = TclString.newInstance("::");
                    TclList.append(interp, tclObject2, tclObject);
                    bl = true;
                    string2 = string2.substring(n + 1);
                    continue;
                }
            } else {
                n = string2.indexOf("/");
                if (n == 0) {
                    string2 = string2.substring(n + 1);
                    continue;
                }
            }
            if (n == -1) {
                if (string2.length() == 0) break;
                string3 = string2;
            } else {
                string3 = string2.substring(0, n);
            }
            if (bl2 && (string3.equals(".") || string3.equals(".."))) {
                string3 = string3.replace('.', ':');
            }
            if (bl) {
                if (string3.charAt(0) == '~') {
                    string3 = string4 + string3;
                } else if (bl5) {
                    if (string2.indexOf(47) == -1) {
                        bl5 = false;
                    } else {
                        string3 = ":" + string3;
                    }
                }
            } else if (bl4) {
                string3 = string3 + ":";
            }
            tclObject = TclString.newInstance(string3);
            TclList.append(interp, tclObject2, tclObject);
            bl = true;
            string2 = string2.substring(n + 1);
        }
        return tclObject2;
    }

    public static String doTildeSubst(Interp interp, String string) throws TclException {
        if (string.length() == 0) {
            String string2;
            try {
                string2 = interp.getVar("env", "HOME", 1).toString();
            }
            catch (Exception exception) {
                throw new TclException(interp, "couldn't find HOME environment variable to expand path");
            }
            return string2;
        }
        if (Util.isUnix()) {
            if (userDirs == null) {
                try {
                    String string3;
                    userDirs = new HashMap();
                    File file = new File("/etc/passwd");
                    BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
                    while ((string3 = bufferedReader.readLine()) != null) {
                        String[] stringArray = string3.split(":");
                        if (stringArray.length < 6 || stringArray[0].length() <= 0 || stringArray[5].length() <= 0) continue;
                        userDirs.put(stringArray[0], stringArray[5]);
                    }
                    bufferedReader.close();
                }
                catch (IOException iOException) {
                    userDirs = null;
                }
            }
            if (userDirs != null && userDirs.containsKey(string)) {
                return userDirs.get(string);
            }
        }
        throw new TclException(interp, "user \"" + string + "\" doesn't exist");
    }

    public static String translateFileName(Interp interp, String string) throws TclException {
        String string2 = "";
        if (string.length() == 0 || string.charAt(0) != '~') {
            TclObject[] tclObjectArray = new TclObject[]{TclString.newInstance(string)};
            string2 = FileUtil.joinPath(interp, tclObjectArray, 0, 1);
        } else {
            TclObject[] tclObjectArray = TclList.getElements(interp, FileUtil.splitPath(interp, string));
            String string3 = tclObjectArray[0].toString().substring(1);
            if (JACL.PLATFORM == 2 && string3.endsWith(":")) {
                string3 = string3.substring(0, string3.length() - 1);
            }
            string3 = FileUtil.doTildeSubst(interp, string3);
            tclObjectArray[0] = TclString.newInstance(string3);
            string2 = FileUtil.joinPath(interp, tclObjectArray, 0, tclObjectArray.length);
        }
        if (JACL.PLATFORM == 1) {
            string2 = string2.replace('/', '\\');
        }
        return string2;
    }

    public static TclObject splitAndTranslate(Interp interp, String string) throws TclException {
        String string2;
        TclObject tclObject = FileUtil.splitPath(interp, string);
        int n = TclList.getLength(interp, tclObject);
        if (n == 1 && (string2 = TclList.index(interp, tclObject, 0).toString()).charAt(0) == '~') {
            String string3 = FileUtil.translateFileName(interp, string2);
            tclObject = FileUtil.splitPath(interp, string3);
        }
        return tclObject;
    }

    public static final String getSeparators(String string) {
        String string2;
        switch (JACL.PLATFORM) {
            case 1: {
                string2 = "/\\:";
                break;
            }
            case 2: {
                if (string != null && string.indexOf(58) != -1) {
                    string2 = ":";
                    break;
                }
                string2 = "/";
                break;
            }
            default: {
                string2 = "/";
            }
        }
        return string2;
    }

    public static final TclObject getNormalizedPath(Interp interp, TclObject tclObject) {
        try {
            File file = FileUtil.getNewFileObj(interp, tclObject.toString());
            String string = file.getName();
            File file2 = file.getParentFile();
            File file3 = ".".equals(string) || "..".equals(string) ? file.getCanonicalFile() : new File(file2.getCanonicalFile(), string);
            return TclString.newInstance(file3);
        }
        catch (TclException tclException) {
            return null;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static File getLinkTarget(File file) {
        try {
            File file2 = file.getAbsoluteFile();
            String string = file2.getName();
            if (".".equals(string) || "..".equals(string)) {
                return null;
            }
            File file3 = file2.getParentFile();
            String string2 = new File(file3.getCanonicalFile(), string).getPath();
            File file4 = new File(string2);
            String string3 = file4.getCanonicalPath();
            if (string2 == null || string3 == null) {
                return null;
            }
            if (string2.equals(string3)) {
                return null;
            }
            return file4;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static boolean isExecutable(File file) {
        try {
            Method method = file.getClass().getMethod("canExecute", new Class[0]);
            Boolean bl = (Boolean)method.invoke((Object)file, new Object[0]);
            return bl;
        }
        catch (Exception exception) {
            boolean bl = false;
            if (file.exists()) {
                String string;
                bl = file.isDirectory();
                if (bl) {
                    return true;
                }
                bl = Util.isWindows() ? (string = file.getName()).endsWith(".exe") || string.endsWith(".com") || string.endsWith(".bat") : true;
                return bl;
            }
            return false;
        }
    }
}

