/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import java.util.Arrays;
import tcl.lang.BackSlashResult;
import tcl.lang.CallFrame;
import tcl.lang.CharPointer;
import tcl.lang.Interp;
import tcl.lang.ParseResult;
import tcl.lang.TclException;
import tcl.lang.TclObject;
import tcl.lang.TclObjectBase;
import tcl.lang.TclParse;
import tcl.lang.TclRuntimeError;
import tcl.lang.TclString;
import tcl.lang.TclToken;
import tcl.lang.WrappedCommand;

public class Parser {
    static final char TYPE_NORMAL = '\u0000';
    static final char TYPE_SPACE = '\u0001';
    static final char TYPE_COMMAND_END = '\u0002';
    static final char TYPE_SUBS = '\u0004';
    static final char TYPE_QUOTE = '\b';
    static final char TYPE_CLOSE_PAREN = '\u0010';
    static final char TYPE_CLOSE_BRACK = ' ';
    static final char TYPE_BRACE = '@';
    static final char TYPE_MAX = '\u007f';
    static char[] typeTable = new char[]{'\u0004', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0001', '\u0002', '\u0001', '\u0001', '\u0001', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0001', '\u0000', '\b', '\u0000', '\u0004', '\u0000', '\u0000', '\u0000', '\u0000', '\u0010', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0002', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0004', '\u0004', ' ', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '@', '\u0000', '@', '\u0000', '\u0000'};
    static final int TCL_TOKEN_WORD = 1;
    static final int TCL_TOKEN_SIMPLE_WORD = 2;
    static final int TCL_TOKEN_TEXT = 4;
    static final int TCL_TOKEN_BS = 8;
    static final int TCL_TOKEN_COMMAND = 16;
    static final int TCL_TOKEN_VARIABLE = 32;
    static final int TCL_TOKEN_SUB_EXPR = 64;
    static final int TCL_TOKEN_OPERATOR = 128;
    static final int TCL_PARSE_SUCCESS = 0;
    static final int TCL_PARSE_QUOTE_EXTRA = 1;
    static final int TCL_PARSE_BRACE_EXTRA = 2;
    static final int TCL_PARSE_MISSING_BRACE = 3;
    static final int TCL_PARSE_MISSING_BRACKET = 4;
    static final int TCL_PARSE_MISSING_PAREN = 5;
    static final int TCL_PARSE_MISSING_QUOTE = 6;
    static final int TCL_PARSE_MISSING_VAR_BRACE = 7;
    static final int TCL_PARSE_SYNTAX = 8;
    static final int TCL_PARSE_BAD_NUMBER = 9;
    public static final int TCL_BRACKET_TERM = 1;
    static final int TCL_ALLOW_EXCEPTIONS = 4;
    static final int DELETED = 1;
    static final int ERR_IN_PROGRESS = 2;
    static final int ERR_ALREADY_LOGGED = 4;
    static final int ERROR_CODE_SET = 8;
    static final int EXPR_INITIALIZED = 16;
    static final int DONT_COMPILE_CMDS_INLINE = 32;
    static final int RAND_SEED_INITIALIZED = 64;
    static final int SAFE_INTERP = 128;
    static final int USE_EVAL_DIRECT = 256;
    private static final int OBJV_CACHE_MAX = 11;
    private static final int[] OBJV_CACHE_SIZES = new int[]{0, 12, 12, 10, 6, 4, 4, 4, 2, 1, 1};

    static TclParse parseCommand(Interp interp, char[] cArray, int n, int n2, String string, int n3, boolean bl) {
        TclParse tclParse;
        char c;
        block45: {
            int n4;
            int n5 = n;
            int n6 = cArray.length - 1;
            if (n2 < 0) {
                n2 = n6 - n;
            }
            if ((n4 = n + n2) > n6) {
                n4 = n6;
            }
            c = cArray[n4];
            cArray[n4] = '\u0000';
            tclParse = new TclParse(interp, cArray, n4, string, n3);
            int n7 = bl ? 34 : 2;
            try {
                int n8;
                BackSlashResult backSlashResult;
                int n9;
                char c2;
                block2: while (true) {
                    c2 = cArray[n];
                    while (c2 <= '\u007f' && typeTable[c2] == '\u0001' || c2 == '\n') {
                        c2 = cArray[++n];
                    }
                    if (c2 == '\\' && (n9 = Parser.eolCharCount(cArray, n + 1, tclParse.endIndex)) > 0) {
                        if (n + 1 + n9 == tclParse.endIndex) {
                            tclParse.incomplete = true;
                        }
                        n += n9 + 1;
                        continue;
                    }
                    if (c2 != '#') break;
                    if (tclParse.commentStart < 0) {
                        tclParse.commentStart = n;
                    }
                    while (true) {
                        c2 = cArray[n];
                        if (n == tclParse.endIndex) {
                            if (bl) {
                                tclParse.incomplete = true;
                            }
                            tclParse.commentSize = n - tclParse.commentStart;
                            continue block2;
                        }
                        if (c2 == '\\') {
                            n9 = Parser.eolCharCount(cArray, n + 1, tclParse.endIndex);
                            if (n9 > 0 && n + n9 + 1 == tclParse.endIndex) {
                                tclParse.incomplete = true;
                            }
                            backSlashResult = Parser.backslash(cArray, n);
                            n = backSlashResult.nextIndex;
                            continue;
                        }
                        if (c2 == '\n') {
                            tclParse.commentSize = ++n - tclParse.commentStart;
                            continue block2;
                        }
                        ++n;
                    }
                    break;
                }
                tclParse.commandStart = n;
                while (true) {
                    int n10 = tclParse.numTokens;
                    TclToken tclToken = tclParse.getToken(n10);
                    tclToken.type = 1;
                    while (true) {
                        n8 = (c2 = cArray[n]) > '\u007f' ? 0 : typeTable[c2];
                        n9 = 0;
                        if (n8 == 1) {
                            ++n;
                            continue;
                        }
                        if (c2 != '\\' || (n9 = Parser.eolCharCount(cArray, n + 1, tclParse.endIndex)) <= 0) break;
                        if (n + n9 + 1 == tclParse.endIndex) {
                            tclParse.incomplete = true;
                        }
                        backSlashResult = Parser.backslash(cArray, n);
                        n = backSlashResult.nextIndex;
                    }
                    if ((n8 & n7) != 0) {
                        tclParse.termIndex = n++;
                        break block45;
                    }
                    if (n == tclParse.endIndex) {
                        if (bl && c != ']') {
                            tclParse.incomplete = true;
                            tclParse.errorType = 4;
                            throw new TclException(interp, "missing close-bracket");
                        }
                        break block45;
                    }
                    tclToken.script_array = cArray;
                    tclToken.script_index = n;
                    ++tclParse.numTokens;
                    ++tclParse.numWords;
                    c2 = cArray[n];
                    if (c2 == '\"') {
                        tclParse = Parser.parseTokens(cArray, ++n, 8, tclParse);
                        if (tclParse.result != 0) {
                            TclException tclException = new TclException(tclParse.result);
                            tclException.errIndex = n;
                            throw tclException;
                        }
                        if (tclParse.string[tclParse.termIndex] != '\"') {
                            tclParse.termIndex = n - 1;
                            tclParse.incomplete = true;
                            tclParse.errorType = 6;
                            throw new TclException(tclParse.interp, "missing \"");
                        }
                        n = tclParse.termIndex + 1;
                    } else if (c2 == '{') {
                        tclToken = tclParse.getToken(tclParse.numTokens);
                        tclToken.type = 4;
                        tclToken.script_array = cArray;
                        tclToken.script_index = ++n;
                        tclToken.numComponents = 0;
                        int n11 = 1;
                        while (true) {
                            c2 = cArray[n];
                            while ((c2 > '\u007f' ? (char)'\u0000' : typeTable[c2]) == '\u0000') {
                                c2 = cArray[++n];
                            }
                            if (cArray[n] == '}') {
                                if (--n11 == 0) break;
                                ++n;
                                continue;
                            }
                            if (cArray[n] == '{') {
                                ++n11;
                                ++n;
                                continue;
                            }
                            if (cArray[n] == '\\') {
                                backSlashResult = Parser.backslash(cArray, n);
                                n9 = Parser.eolCharCount(cArray, n + 1, tclParse.endIndex);
                                if (n9 > 0) {
                                    if (n + n9 + 1 == tclParse.endIndex) {
                                        tclParse.incomplete = true;
                                    }
                                    tclToken.size = n - tclToken.script_index;
                                    if (tclToken.size != 0) {
                                        ++tclParse.numTokens;
                                    }
                                    tclToken = tclParse.getToken(tclParse.numTokens);
                                    tclToken.type = 8;
                                    tclToken.script_array = cArray;
                                    tclToken.script_index = n;
                                    tclToken.size = backSlashResult.nextIndex - n;
                                    tclToken.numComponents = 0;
                                    ++tclParse.numTokens;
                                    n = backSlashResult.nextIndex;
                                    tclToken = tclParse.getToken(tclParse.numTokens);
                                    tclToken.type = 4;
                                    tclToken.script_array = cArray;
                                    tclToken.script_index = n;
                                    tclToken.numComponents = 0;
                                    continue;
                                }
                                n = backSlashResult.nextIndex;
                                continue;
                            }
                            if (n == tclParse.endIndex) {
                                tclParse.termIndex = tclParse.getToken((int)n10).script_index;
                                tclParse.incomplete = true;
                                tclParse.errorType = 3;
                                throw new TclException(interp, "missing close-brace");
                            }
                            ++n;
                        }
                        if (n != tclToken.script_index || tclParse.numTokens == n10 + 1) {
                            tclToken.size = n - tclToken.script_index;
                            ++tclParse.numTokens;
                        }
                        ++n;
                    } else {
                        tclParse = Parser.parseTokens(cArray, n, 1 | n7, tclParse);
                        if (tclParse.result != 0) {
                            TclException tclException = new TclException(tclParse.result);
                            tclException.errIndex = n;
                            throw tclException;
                        }
                        n = tclParse.termIndex;
                    }
                    tclToken = tclParse.getToken(n10);
                    tclToken.size = n - tclToken.script_index;
                    tclToken.numComponents = tclParse.numTokens - (n10 + 1);
                    if (tclToken.numComponents == 1 && tclParse.getToken((int)(n10 + 1)).type == 4) {
                        tclToken.type = 2;
                    }
                    n2 = n4 - n;
                    ParseWhitespaceResult parseWhitespaceResult = Parser.ParseWhiteSpace(cArray, n, n2, tclParse);
                    int n12 = parseWhitespaceResult.numScanned;
                    n8 = parseWhitespaceResult.type;
                    if (n12 <= 0) break;
                    n += n12;
                    n2 -= n12;
                }
                if ((n8 & n7) != 0) {
                    tclParse.termIndex = n++;
                    break block45;
                }
                if (n == tclParse.endIndex) {
                    if (bl && c != ']') {
                        tclParse.incomplete = true;
                        tclParse.errorType = 4;
                        throw new TclException(interp, "missing close-bracket");
                    }
                    break block45;
                }
                tclParse.termIndex = n;
                if (cArray[n - 1] == '\"') {
                    tclParse.errorType = 1;
                    throw new TclException(interp, "extra characters after close-quote");
                }
                tclParse.errorType = 2;
                throw new TclException(interp, "extra characters after close-brace");
            }
            catch (TclException tclException) {
                cArray[n4] = c;
                if (tclParse.commandStart < 0) {
                    tclParse.commandStart = n5;
                }
                tclParse.commandSize = tclParse.termIndex - tclParse.commandStart;
                tclParse.result = 1;
                return tclParse;
            }
        }
        cArray[n4] = c;
        tclParse.commandSize = n - tclParse.commandStart;
        tclParse.result = 0;
        return tclParse;
    }

    static int eolCharCount(char[] cArray, int n, int n2) {
        if (n < n2 && cArray[n] == '\n') {
            return 1;
        }
        if (n < n2 + 1 && cArray[n] == '\r' && cArray[n + 1] == '\n') {
            return 2;
        }
        return 0;
    }

    public static boolean isParseableScript(String string, boolean bl) {
        TclParse tclParse = null;
        CharPointer charPointer = new CharPointer(string);
        int n = string.length();
        int n2 = 0;
        do {
            tclParse = Parser.parseCommand(null, charPointer.array, charPointer.index, n, null, 0, bl);
            n2 = tclParse.errorType;
            charPointer.index = tclParse.commandStart + tclParse.commandSize;
            tclParse.release();
        } while (charPointer.index < n && n2 == 0);
        return n2 == 0;
    }

    static TclParse parseTokens(char[] cArray, int n, int n2, TclParse tclParse) {
        int n3;
        block17: {
            n3 = tclParse.numTokens;
            while (true) {
                char c;
                TclToken tclToken = tclParse.getToken(tclParse.numTokens);
                tclToken.script_array = cArray;
                tclToken.script_index = ++n;
                tclToken.numComponents = 0;
                char c2 = cArray[n];
                char c3 = c = c2 > '\u007f' ? (char)'\u0000' : typeTable[c2];
                if ((c & n2) != 0) break block17;
                if ((c & 4) == 0) {
                    while (((c = (c2 = cArray[++n]) > '\u007f' ? (char)'\u0000' : typeTable[c2]) & (n2 | 4)) == 0) {
                    }
                    tclToken.type = 4;
                    tclToken.size = n - tclToken.script_index;
                    ++tclParse.numTokens;
                    continue;
                }
                if (c2 == '$') {
                    int n4 = tclParse.numTokens;
                    tclParse = Parser.parseVarName(tclParse.interp, cArray, n, tclParse.endIndex - n, tclParse, true);
                    if (tclParse.result != 0) {
                        return tclParse;
                    }
                    n += tclParse.getToken((int)n4).size;
                    continue;
                }
                if (c2 == '[') {
                    block18: {
                        ++n;
                        do {
                            TclParse tclParse2 = Parser.parseCommand(tclParse.interp, cArray, n, tclParse.endIndex - n, tclParse.fileName, tclParse.lineNum, true);
                            if (tclParse2.result != 0) {
                                tclParse.termIndex = tclParse2.termIndex;
                                tclParse.incomplete = tclParse2.incomplete;
                                tclParse.errorType = tclParse2.errorType;
                                tclParse.result = tclParse2.result;
                                return tclParse;
                            }
                            n = tclParse2.commandStart + tclParse2.commandSize;
                            if (cArray[n - 1] == ']' && !tclParse2.incomplete) break block18;
                        } while (n != tclParse.endIndex);
                        if (tclParse.interp != null) {
                            tclParse.interp.setResult("missing close-bracket");
                        }
                        tclParse.termIndex = tclToken.script_index;
                        tclParse.incomplete = true;
                        tclParse.errorType = 4;
                        tclParse.result = 1;
                        return tclParse;
                    }
                    tclToken.type = 16;
                    tclToken.size = n - tclToken.script_index;
                    ++tclParse.numTokens;
                    continue;
                }
                if (c2 == '\\') {
                    int n5 = Parser.eolCharCount(cArray, n + 1, tclParse.endIndex);
                    if (n5 > 0) {
                        if (n + n5 + 1 == tclParse.endIndex) {
                            tclParse.incomplete = true;
                        }
                        if ((n2 & 1) != 0) break block17;
                    }
                    BackSlashResult backSlashResult = Parser.backslash(cArray, n);
                    tclToken.type = 8;
                    tclToken.size = backSlashResult.count;
                    if (tclToken.size == 1) {
                        tclToken.type = 4;
                        ++tclParse.numTokens;
                        continue;
                    }
                    ++tclParse.numTokens;
                    n += tclToken.size;
                    continue;
                }
                if (c2 != '\u0000') break;
                if (n != tclParse.endIndex) {
                    tclToken.type = 4;
                    tclToken.size = 1;
                    ++tclParse.numTokens;
                    ++n;
                    continue;
                }
                break block17;
                break;
            }
            throw new TclRuntimeError("parseTokens encountered unknown character");
        }
        if (tclParse.numTokens == n3) {
            tclToken.type = 4;
            tclToken.size = 0;
            ++tclParse.numTokens;
        }
        tclParse.termIndex = n;
        tclParse.result = 0;
        return tclParse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void evalObjv(Interp interp, TclObject[] tclObjectArray, int n, int n2) throws TclException {
        TclObject[] tclObjectArray2 = null;
        if (tclObjectArray.length == 0) {
            interp.resetResult();
            return;
        }
        interp.ready();
        ++interp.nestLevel;
        CallFrame callFrame = interp.varFrame;
        try {
            WrappedCommand wrappedCommand = interp.getWrappedCommand(tclObjectArray[0].toString());
            if (wrappedCommand == null) {
                tclObjectArray2 = Parser.grabObjv(interp, tclObjectArray.length + 1);
                for (int i = tclObjectArray.length - 1; i >= 0; --i) {
                    tclObjectArray2[i + 1] = tclObjectArray[i];
                }
                tclObjectArray2[0] = TclString.newInstance("::unknown");
                tclObjectArray2[0].preserve();
                wrappedCommand = interp.getWrappedCommand("::unknown");
                if (wrappedCommand == null) {
                    throw new TclException(interp, "invalid command name \"" + tclObjectArray[0].toString() + "\"");
                }
                Parser.evalObjv(interp, tclObjectArray2, n, 0);
                tclObjectArray2[0].release();
                Parser.releaseObjv(interp, tclObjectArray2, tclObjectArray2.length);
                return;
            }
            ++interp.cmdCount;
            if ((n2 & 0x20000) != 0) {
                interp.varFrame = null;
            }
            if (wrappedCommand.mustCallInvoke(interp)) {
                wrappedCommand.invoke(interp, tclObjectArray);
            } else {
                wrappedCommand.cmd.cmdProc(interp, tclObjectArray);
            }
        }
        finally {
            interp.varFrame = callFrame;
            --interp.nestLevel;
        }
    }

    public static void logCommandInfo(Interp interp, char[] cArray, int n, int n2, int n3, TclException tclException) {
        String string;
        int n4;
        String string2 = null;
        if (interp.errAlreadyLogged) {
            return;
        }
        interp.errorLine = 1;
        for (int i = 0; i < n2; ++i) {
            if (cArray[i] != '\n') continue;
            ++interp.errorLine;
        }
        if (n3 < 0) {
            int n5 = cArray.length - 1;
            n3 = n5 - n2;
        }
        if (n3 > 150) {
            n4 = 150;
            string = "...";
        } else {
            n4 = n3;
            string = "";
        }
        string2 = new String(cArray, n2, n4);
        if (!interp.errInProgress) {
            interp.addErrorInfo("\n    while executing\n\"" + string2 + string + "\"");
        } else {
            interp.addErrorInfo("\n    invoked from within\n\"" + string2 + string + "\"");
        }
        interp.errAlreadyLogged = false;
        tclException.errIndex = n2 + n4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static TclObject evalTokens(Interp interp, TclToken[] tclTokenArray, int n, int n2) throws TclException {
        String string = null;
        TclObjectBase tclObjectBase = null;
        while (n2 > 0) {
            TclToken tclToken = tclTokenArray[n];
            TclObjectBase tclObjectBase2 = null;
            switch (tclToken.type) {
                case 4: {
                    string = tclToken.getTokenString();
                    break;
                }
                case 8: {
                    BackSlashResult backSlashResult = Parser.backslash(tclToken.script_array, tclToken.script_index);
                    if (backSlashResult.isWordSep) {
                        string = "\\" + backSlashResult.c;
                        break;
                    }
                    Character c = new Character(backSlashResult.c);
                    string = c.toString();
                    break;
                }
                case 16: {
                    interp.evalFlags |= 1;
                    ++tclToken.script_index;
                    Parser.eval2(interp, tclToken.script_array, tclToken.script_index, tclToken.size - 2, 0);
                    --tclToken.script_index;
                    tclObjectBase2 = interp.getResult();
                    break;
                }
                case 32: {
                    TclObject tclObject;
                    if (tclToken.numComponents == 1) {
                        tclObject = null;
                    } else {
                        tclObject = Parser.evalTokens(interp, tclTokenArray, n + 2, tclToken.numComponents - 1);
                        if (tclObject == null) {
                            return null;
                        }
                    }
                    String string2 = tclTokenArray[n + 1].getTokenString();
                    if (interp.noEval == 0) {
                        if (tclObject != null) {
                            try {
                                tclObjectBase2 = interp.getVar(string2, tclObject.toString(), 0);
                            }
                            finally {
                                tclObject.release();
                            }
                        } else {
                            tclObjectBase2 = interp.getVar(string2, null, 0);
                        }
                    } else {
                        tclObjectBase2 = TclString.newInstance("");
                        ((TclObject)tclObjectBase2).preserve();
                    }
                    n2 -= tclToken.numComponents;
                    n += tclToken.numComponents;
                    break;
                }
                default: {
                    throw new TclRuntimeError("unexpected token type in evalTokens");
                }
            }
            if (tclObjectBase == null) {
                tclObjectBase = tclObjectBase2 != null ? tclObjectBase2 : TclString.newInstance(string);
                ((TclObject)tclObjectBase).preserve();
            } else {
                if (tclObjectBase.isShared()) {
                    ((TclObject)tclObjectBase).release();
                    tclObjectBase = tclObjectBase.duplicate();
                    ((TclObject)tclObjectBase).preserve();
                }
                if (tclObjectBase2 != null) {
                    string = tclObjectBase2.toString();
                }
                TclString.append((TclObject)tclObjectBase, string);
            }
            ++n;
            --n2;
        }
        return tclObjectBase;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void eval2(Interp interp, char[] cArray, int n, int n2, int n3) throws TclException {
        int n4 = 0;
        TclParse tclParse = null;
        int n5 = cArray.length - 1;
        char[] cArray2 = cArray;
        int n6 = n;
        if (n2 < 0) {
            n2 = n5 - n;
        }
        interp.resetResult();
        CallFrame callFrame = interp.varFrame;
        if ((n3 & 0x20000) != 0) {
            interp.varFrame = null;
        }
        int n7 = n2;
        TclObject[] tclObjectArray = Parser.grabObjv(interp, 3);
        boolean bl = (interp.evalFlags & 1) != 0;
        interp.evalFlags &= 0xFFFFFFFE;
        try {
            do {
                tclParse = Parser.parseCommand(interp, cArray2, n6, n7, null, 0, bl);
                if (tclParse.result != 0) {
                    TclException tclException = new TclException(tclParse.result);
                    tclException.errIndex = n6;
                    throw tclException;
                }
                if (tclParse.numWords > 0 && interp.noEval == 0) {
                    try {
                        int n8 = 0;
                        TclToken tclToken = tclParse.getToken(n8);
                        if (tclObjectArray.length != tclParse.numWords) {
                            Parser.releaseObjv(interp, tclObjectArray, tclObjectArray.length);
                            tclObjectArray = Parser.grabObjv(interp, tclParse.numWords);
                        }
                        for (n4 = 0; n4 < tclParse.numWords; ++n4) {
                            TclObject tclObject = Parser.evalTokens(interp, tclParse.tokenList, n8 + 1, tclToken.numComponents);
                            if (tclObject == null) {
                                throw new TclException(1);
                            }
                            tclObjectArray[n4] = tclObject;
                            tclToken = tclParse.getToken(n8 += tclToken.numComponents + 1);
                        }
                        try {
                            Parser.evalObjv(interp, tclObjectArray, n7, 0);
                        }
                        catch (StackOverflowError stackOverflowError) {
                            Parser.infiniteLoopException(interp);
                        }
                    }
                    catch (TclException tclException) {
                        if (tclException.getCompletionCode() == 1 && !interp.errAlreadyLogged) {
                            int n9;
                            int n10 = tclParse.commandSize;
                            char c = cArray[tclParse.commandStart + n10 - 1];
                            char c2 = Parser.charType(c);
                            if ((c2 & (n9 = bl ? 34 : 2)) != 0) {
                                --n10;
                            }
                            interp.varFrame = callFrame;
                            Parser.logCommandInfo(interp, cArray, n, tclParse.commandStart, n10, tclException);
                        }
                        interp.termOffset = tclParse.commandStart + tclParse.commandSize - n;
                        throw tclException;
                    }
                    finally {
                        for (int i = 0; i < n4; ++i) {
                            tclObjectArray[i].release();
                            tclObjectArray[i] = null;
                        }
                        n4 = 0;
                        tclParse.release();
                    }
                }
                int n11 = tclParse.commandStart + tclParse.commandSize;
                n7 -= n11 - n6;
                n6 = n11;
                if (!bl || n6 <= 1 || cArray2[n6 - 1] != ']') continue;
                interp.termOffset = n6 - 1 - n;
                interp.varFrame = callFrame;
                return;
            } while (n7 > 0);
        }
        finally {
            if (tclParse != null) {
                tclParse.release();
            }
            Parser.releaseObjv(interp, tclObjectArray, tclObjectArray.length);
        }
        interp.termOffset = n6 - n;
        interp.varFrame = callFrame;
    }

    static TclParse parseVarName(Interp interp, char[] cArray, int n, int n2, TclParse tclParse, boolean bl) {
        int n3 = n2 >= 0 ? n + n2 : cArray.length - 1;
        if (!bl) {
            tclParse = new TclParse(interp, cArray, n3, null, -1);
        }
        TclToken tclToken = tclParse.getToken(tclParse.numTokens);
        tclToken.type = 32;
        tclToken.script_array = cArray;
        tclToken.script_index = n++;
        int n4 = tclParse.numTokens++;
        if (n >= n3) {
            tclToken.type = 4;
            tclToken.size = 1;
            tclToken.numComponents = 0;
            tclParse.result = 0;
            return tclParse;
        }
        TclToken tclToken2 = tclToken;
        tclToken = tclParse.getToken(tclParse.numTokens);
        if (cArray[n] == '{') {
            tclToken.type = 4;
            tclToken.script_array = cArray;
            tclToken.script_index = ++n;
            tclToken.numComponents = 0;
            while (true) {
                if (n == n3) {
                    if (interp != null) {
                        interp.setResult("missing close-brace for variable name");
                    }
                    tclParse.termIndex = tclToken.script_index - 1;
                    tclParse.incomplete = true;
                    tclParse.errorType = 7;
                    tclParse.result = 1;
                    return tclParse;
                }
                if (cArray[n] == '}') break;
                ++n;
            }
            tclToken.size = n - tclToken.script_index;
            tclToken2.size = n - tclToken2.script_index;
            ++tclParse.numTokens;
            ++n;
        } else {
            tclToken.type = 4;
            tclToken.script_array = cArray;
            tclToken.script_index = n;
            tclToken.numComponents = 0;
            while (n != n3) {
                char c = cArray[n];
                if (Character.isLetterOrDigit(c) || c == '_') {
                    ++n;
                    continue;
                }
                if (c != ':' || n + 1 == n3 || cArray[n + 1] != ':') break;
                n += 2;
                while (n != n3 && cArray[n] == ':') {
                    ++n;
                }
            }
            tclToken.size = n - tclToken.script_index;
            if (tclToken.size == 0) {
                tclToken2.type = 4;
                tclToken2.size = 1;
                tclToken2.numComponents = 0;
                tclParse.result = 0;
                return tclParse;
            }
            ++tclParse.numTokens;
            if (n != n3 && cArray[n] == '(') {
                tclParse = Parser.parseTokens(cArray, ++n, 16, tclParse);
                if (tclParse.result != 0) {
                    return tclParse;
                }
                if (tclParse.termIndex == n3 || tclParse.string[tclParse.termIndex] != ')') {
                    if (interp != null) {
                        interp.setResult("missing )");
                    }
                    tclParse.termIndex = n - 1;
                    tclParse.incomplete = true;
                    tclParse.errorType = 5;
                    tclParse.result = 1;
                    return tclParse;
                }
                n = tclParse.termIndex + 1;
            }
        }
        tclToken2.size = n - tclToken2.script_index;
        tclToken2.numComponents = tclParse.numTokens - (n4 + 1);
        tclParse.result = 0;
        return tclParse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ParseResult parseVar(Interp interp, String string) throws TclException {
        CharPointer charPointer = new CharPointer(string);
        TclParse tclParse = Parser.parseVarName(interp, charPointer.array, charPointer.index, -1, null, false);
        if (tclParse.result != 0) {
            throw new TclException(interp, interp.getResult().toString());
        }
        try {
            if (tclParse.numTokens == 1) {
                ParseResult parseResult = new ParseResult("$", 1);
                return parseResult;
            }
            TclObject tclObject = Parser.evalTokens(interp, tclParse.tokenList, 0, tclParse.numTokens);
            if (!tclObject.isShared()) {
                throw new TclRuntimeError("parseVar got temporary object from evalTokens");
            }
            ParseResult parseResult = new ParseResult(tclObject, tclParse.tokenList[0].size);
            return parseResult;
        }
        finally {
            tclParse.release();
        }
    }

    static boolean commandComplete(String string, int n) {
        TclParse tclParse;
        CharPointer charPointer = new CharPointer(string);
        do {
            tclParse = Parser.parseCommand(null, charPointer.array, charPointer.index, n, null, 0, false);
            charPointer.index = tclParse.commandStart + tclParse.commandSize;
            tclParse.release();
        } while (charPointer.index < n && tclParse.result == 0);
        return !tclParse.incomplete;
    }

    static boolean objCommandComplete(TclObject tclObject) {
        String string = tclObject.toString();
        return Parser.commandComplete(string, string.length());
    }

    static BackSlashResult backslash(char[] cArray, int n) {
        int n2 = cArray.length - n;
        int n3 = cArray.length - 1;
        if (++n == n3) {
            int n4 = 1;
            return new BackSlashResult('\\', n, n4);
        }
        int n5 = 2;
        char c = cArray[n];
        switch (c) {
            case 'a': {
                return new BackSlashResult('\u0007', n + 1, n5);
            }
            case 'b': {
                return new BackSlashResult('\b', n + 1, n5);
            }
            case 'f': {
                return new BackSlashResult('\f', n + 1, n5);
            }
            case 'n': {
                return new BackSlashResult('\n', n + 1, n5);
            }
            case 'r': {
                return new BackSlashResult('\r', n + 1, n5);
            }
            case 't': {
                return new BackSlashResult('\t', n + 1, n5);
            }
            case 'v': {
                return new BackSlashResult('\u000b', n + 1, n5);
            }
            case 'x': {
                ParseHexResult parseHexResult = Parser.ParseHex(cArray, ++n, n2 - 1);
                c = (n5 += parseHexResult.numScanned) == 2 ? (char)'x' : (char)((char)(parseHexResult.result & 0xFF));
                return new BackSlashResult(c, n + parseHexResult.numScanned, n5);
            }
            case 'u': {
                ParseHexResult parseHexResult = Parser.ParseHex(cArray, ++n, n2 > 5 ? 4 : n2 - 1);
                c = (n5 += parseHexResult.numScanned) == 2 ? (char)'u' : (char)((char)parseHexResult.result);
                return new BackSlashResult(c, n + parseHexResult.numScanned, n5);
            }
            case '\n': 
            case '\r': {
                if (c == '\r' && n + 1 < n3 && cArray[n + 1] == '\n') {
                    ++n;
                    ++n5;
                }
                --n5;
                do {
                    c = cArray[++n];
                } while (++n5 < n2 && (c == ' ' || c == 9));
                return new BackSlashResult(' ', n, n5);
            }
            case '\u0000': {
                return new BackSlashResult('\\', n + 1, n5);
            }
        }
        if (c >= '0' && c <= '7') {
            int n6 = c - 48;
            if (++n != n3 && (c = cArray[n]) >= '0' && c <= '7') {
                ++n5;
                n6 = n6 * 8 + (c - 48);
                if (++n != n3 && (c = cArray[n]) >= '0' && c <= '7') {
                    ++n5;
                    n6 = n6 * 8 + (c - 48);
                    ++n;
                }
            }
            return new BackSlashResult((char)(n6 & 0xFF), n, n5);
        }
        return new BackSlashResult(c, n + 1, n5);
    }

    /*
     * Enabled aggressive block sorting
     */
    static TclParse ParseBraces(Interp interp, char[] cArray, int n, int n2, TclParse tclParse, boolean bl) throws TclException {
        String string;
        block25: {
            boolean bl2;
            char c;
            int n3;
            if (n2 == 0 || cArray == null) {
                throw new TclException(interp, "empty script");
            }
            int n4 = cArray.length - 1;
            if (n2 < 0) {
                n2 = n4 - n;
            }
            if ((n3 = n + n2) > n4) {
                n3 = n4;
            }
            if (cArray[n] != '{') {
                throw new TclRuntimeError("expected open brace character at script_index");
            }
            if (!bl) {
                tclParse = new TclParse(interp, cArray, n3, null, -1);
            }
            int n5 = n;
            int n6 = tclParse.numTokens;
            if (tclParse.numTokens == tclParse.tokensAvailable) {
                tclParse.expandTokenArray(tclParse.numTokens + 1);
            }
            TclToken tclToken = tclParse.getToken(n6);
            tclToken.type = 4;
            tclToken.script_array = cArray;
            tclToken.script_index = n5 + 1;
            tclToken.numComponents = 0;
            int n7 = 1;
            block10: while (true) {
                ++n5;
                --n2;
                while (n2 > 0) {
                    char c2;
                    c = cArray[n5];
                    char c3 = c2 = c > '\u007f' ? (char)'\u0000' : typeTable[c];
                    if (c2 != '\u0000') break;
                    ++n5;
                    --n2;
                }
                if (n2 == 0) {
                    bl2 = false;
                    tclParse.errorType = 3;
                    tclParse.termIndex = n;
                    tclParse.incomplete = true;
                    string = "missing close-brace";
                    if (interp != null) break;
                    break block25;
                }
                c = cArray[n5];
                switch (c) {
                    case '{': {
                        ++n7;
                        break;
                    }
                    case '}': {
                        if (--n7 != 0) continue block10;
                        if (n5 != tclToken.script_index || tclParse.numTokens == n6) {
                            tclToken.size = n5 - tclToken.script_index;
                            ++tclParse.numTokens;
                        }
                        tclParse.extra = n5 + 1;
                        return tclParse;
                    }
                    case '\\': {
                        BackSlashResult backSlashResult = Parser.backslash(cArray, n5);
                        int n8 = backSlashResult.count;
                        if (n8 > 1 && cArray[n5 + 1] == '\n') {
                            if (n2 == 2) {
                                tclParse.incomplete = true;
                            }
                            tclToken.size = n5 - tclToken.script_index;
                            if (tclToken.size != 0) {
                                ++tclParse.numTokens;
                            }
                            if (tclParse.numTokens + 1 >= tclParse.tokensAvailable) {
                                tclParse.expandTokenArray(tclParse.numTokens + 1);
                            }
                            tclToken = tclParse.getToken(tclParse.numTokens);
                            tclToken.type = 8;
                            tclToken.script_array = cArray;
                            tclToken.script_index = n5;
                            tclToken.size = n8;
                            tclToken.numComponents = 0;
                            ++tclParse.numTokens;
                            n2 -= n8 - 1;
                            tclToken = tclParse.getToken(tclParse.numTokens);
                            tclToken.type = 4;
                            tclToken.script_array = cArray;
                            tclToken.script_index = (n5 += n8 - 1) + 1;
                            tclToken.numComponents = 0;
                            break;
                        }
                        n5 += n8 - 1;
                        n2 -= n8 - 1;
                        continue block10;
                    }
                }
            }
            block12: while (n5 > n) {
                switch (cArray[n5]) {
                    case '{': {
                        bl2 = true;
                        break;
                    }
                    case '\n': {
                        bl2 = false;
                        break;
                    }
                    case '#': {
                        c = cArray[n5 - 1];
                        if (!bl2 || !Character.isWhitespace(c)) break;
                        string = string + ": possible unbalanced brace in comment";
                        break block12;
                    }
                }
                --n5;
            }
        }
        tclParse.release();
        throw new TclException(interp, string);
    }

    static TclParse ParseQuotedString(Interp interp, char[] cArray, int n, int n2, TclParse tclParse, boolean bl) throws TclException {
        int n3;
        if (n2 == 0 || cArray == null) {
            throw new TclException(interp, "empty script");
        }
        int n4 = cArray.length - 1;
        if (n2 < 0) {
            n2 = n4 - n;
        }
        if ((n3 = n + n2) > n4) {
            n3 = n4;
        }
        if (cArray[n] != '\"') {
            throw new TclRuntimeError("expected quote character at script_index");
        }
        if (!bl) {
            tclParse = new TclParse(interp, cArray, n3, null, -1);
        }
        tclParse = Parser.parseTokens(cArray, n + 1, 8, tclParse);
        if (tclParse.result != 0) {
            tclParse.release();
            throw new TclException(tclParse.result);
        }
        if (cArray[tclParse.termIndex] != '\"') {
            tclParse.release();
            tclParse.errorType = 6;
            tclParse.termIndex = n;
            tclParse.incomplete = true;
            throw new TclException(interp, "missing \"");
        }
        tclParse.extra = tclParse.termIndex + 1;
        return tclParse;
    }

    static ParseWhitespaceResult ParseWhiteSpace(char[] cArray, int n, int n2, TclParse tclParse) {
        int n3;
        int n4;
        block3: {
            n4 = 0;
            n3 = n;
            while (true) {
                char c;
                if (n2 > 0) {
                    c = cArray[n3];
                    int n5 = n4 = c > '\u007f' ? 0 : typeTable[c];
                    if ((n4 & 1) != 0) {
                        --n2;
                        ++n3;
                        continue;
                    }
                }
                if (n2 <= 0 || (n4 & 4) == 0 || (c = cArray[n3]) != '\\' || --n2 == 0 || (c = cArray[n3 + 1]) != '\n') break block3;
                n3 += 2;
                if (--n2 == 0) break;
            }
            tclParse.incomplete = true;
        }
        ParseWhitespaceResult parseWhitespaceResult = new ParseWhitespaceResult();
        parseWhitespaceResult.type = n4;
        parseWhitespaceResult.numScanned = n3 - n;
        return parseWhitespaceResult;
    }

    static ParseHexResult ParseHex(char[] cArray, int n, int n2) {
        char c;
        int n3 = 0;
        int n4 = n;
        while (n2 > 0 && ((c = cArray[n4]) >= '0' && c <= '9' || c >= 'A' && c <= 'F' || c >= 'a' && c <= 'f')) {
            ++n4;
            n3 <<= 4;
            n3 = c >= 'a' ? (n3 |= 10 + c - 97) : (c >= 'A' ? (n3 |= 10 + c - 65) : (n3 |= c - 48));
            --n2;
        }
        ParseHexResult parseHexResult = new ParseHexResult();
        parseHexResult.result = n3;
        parseHexResult.numScanned = n4 - n;
        return parseHexResult;
    }

    static char charType(char c) {
        return c > '\u007f' ? (char)'\u0000' : typeTable[c];
    }

    static void init(Interp interp) {
        TclObject[][][] tclObjectArrayArray = new TclObject[11][][];
        int[] nArray = new int[11];
        for (int i = 0; i < 11; ++i) {
            int n = OBJV_CACHE_SIZES[i];
            tclObjectArrayArray[i] = new TclObject[n][];
            nArray[i] = 0;
            for (int j = 0; j < n; ++j) {
                tclObjectArrayArray[i][j] = new TclObject[i];
            }
        }
        interp.parserObjv = tclObjectArrayArray;
        interp.parserObjvUsed = nArray;
    }

    public static TclObject[] grabObjv(Interp interp, int n) {
        int n2;
        if (n < 11 && (n2 = interp.parserObjvUsed[n]) < OBJV_CACHE_SIZES[n]) {
            int n3 = n;
            interp.parserObjvUsed[n3] = interp.parserObjvUsed[n3] + 1;
            return interp.parserObjv[n][n2];
        }
        return new TclObject[n];
    }

    public static void releaseObjv(Interp interp, TclObject[] tclObjectArray, int n) {
        int n2;
        if (n < 11 && (n2 = interp.parserObjvUsed[n]) > 0) {
            interp.parserObjvUsed[n] = --n2;
            switch (n) {
                case 1: {
                    tclObjectArray[0] = null;
                    break;
                }
                case 2: {
                    tclObjectArray[0] = null;
                    tclObjectArray[1] = null;
                    break;
                }
                case 3: {
                    tclObjectArray[0] = null;
                    tclObjectArray[1] = null;
                    tclObjectArray[2] = null;
                    break;
                }
                case 4: {
                    tclObjectArray[0] = null;
                    tclObjectArray[1] = null;
                    tclObjectArray[2] = null;
                    tclObjectArray[3] = null;
                    break;
                }
                case 5: {
                    tclObjectArray[0] = null;
                    tclObjectArray[1] = null;
                    tclObjectArray[2] = null;
                    tclObjectArray[3] = null;
                    tclObjectArray[4] = null;
                    break;
                }
                default: {
                    Arrays.fill(tclObjectArray, null);
                }
            }
            interp.parserObjv[n][n2] = tclObjectArray;
        }
    }

    static void infiniteLoopException(Interp interp) throws TclException {
        throw new TclException(interp, "too many nested evaluations (infinite loop?)");
    }

    static class ParseHexResult {
        int result;
        int numScanned;

        ParseHexResult() {
        }
    }

    static class ParseWhitespaceResult {
        int numScanned;
        int type;

        ParseWhitespaceResult() {
        }
    }
}

