/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import tcl.lang.FileUtil;
import tcl.lang.Interp;
import tcl.lang.TclException;
import tcl.lang.TclIO;
import tcl.lang.TclObject;
import tcl.lang.TclPosixException;
import tcl.lang.TclString;
import tcl.lang.channel.Channel;
import tcl.lang.channel.TclByteArrayChannel;
import tcl.lang.process.Redirect;
import tcl.lang.process.TclProcess;

public class Pipeline
implements Runnable {
    private ArrayList<TclProcess> processes = new ArrayList();
    private boolean redirectStderrToResult = false;
    private boolean execInBackground = false;
    Interp interp = null;
    Redirect stdinRedirect = null;
    Redirect stdoutRedirect = null;
    Redirect stderrRedirect = null;
    TclException savedException = null;
    private static final Set<String> redirectors;

    public Pipeline(Interp interp, TclObject[] tclObjectArray, int n) throws TclException {
        ArrayList<String> arrayList = new ArrayList<String>();
        File file = interp.getWorkingDir();
        this.interp = interp;
        int n2 = tclObjectArray.length - 1;
        if (tclObjectArray[n2].toString().equals("&")) {
            this.setExecInBackground(true);
            --n2;
        }
        for (int i = n; i <= n2; ++i) {
            Object object;
            int n3;
            int n4;
            String string = tclObjectArray[i].toString();
            if (string.equals("|")) {
                if (arrayList.size() == 0 || i == n2) {
                    throw new TclException(interp, "illegal use of | or |& in command");
                }
                this.addCommand(arrayList, file);
                arrayList = new ArrayList();
                continue;
            }
            if (string.equals("|&")) {
                if (arrayList.size() == 0 || i == n2) {
                    throw new TclException(interp, "illegal use of | or |& in command");
                }
                n4 = this.addCommand(arrayList, file);
                this.processes.get(n4).setStderrRedirect(Redirect.stderrToStdout());
                arrayList = new ArrayList();
                continue;
            }
            n4 = string.length();
            String string2 = null;
            int n5 = n3 = n4 > 4 ? 4 : n4;
            while (n3 >= 1 && !redirectors.contains(string2 = string.substring(0, n3))) {
                string2 = null;
                --n3;
            }
            if (string2 == null) {
                arrayList.add(string);
                continue;
            }
            if ("2>@1".equals(string2)) {
                this.redirectStderrToResult = true;
                continue;
            }
            String string3 = null;
            if (string.length() > string2.length()) {
                string3 = string.substring(string2.length());
            } else {
                if (++i > n2) {
                    throw new TclException(interp, "can't specify \"" + string2 + "\" as last word in command");
                }
                string3 = tclObjectArray[i].toString();
            }
            Redirect redirect = null;
            if (string2.contains("@")) {
                object = TclIO.getChannel(interp, string3);
                if (object == null) {
                    throw new TclException(interp, "could not find channel named \"" + string3 + "\"");
                }
                redirect = new Redirect((Channel)object, false);
            } else if (string2.equals("<<")) {
                object = new TclByteArrayChannel(interp, TclString.newInstance(string3));
                TclIO.registerChannel(interp, (Channel)object);
                redirect = new Redirect((Channel)object, true);
            } else {
                object = FileUtil.getNewFileObj(interp, string3);
                redirect = new Redirect((File)object, string3, string2.contains(">>"));
            }
            if (string2.startsWith("2")) {
                this.stderrRedirect = redirect;
                continue;
            }
            if (string2.contains(">")) {
                this.stdoutRedirect = redirect;
                if (!string2.contains("&")) continue;
                this.stderrRedirect = redirect;
                continue;
            }
            this.stdinRedirect = redirect;
        }
        if (arrayList.size() > 0) {
            this.addCommand(arrayList, file);
        }
    }

    public int addCommand(List<String> list, File file) throws TclException {
        int n;
        String string = list.get(0);
        string = FileUtil.translateFileName(this.interp, string);
        TclProcess tclProcess = TclProcess.newInstance(this.interp);
        tclProcess.setCommand(list);
        if (file != null) {
            tclProcess.setWorkingDir(file);
        }
        if ((n = this.processes.size() - 1) >= 0) {
            TclProcess tclProcess2 = this.processes.get(n);
            tclProcess.setStdinRedirect(new Redirect(tclProcess2));
            tclProcess2.setStdoutRedirect(new Redirect(tclProcess));
        }
        this.processes.add(tclProcess);
        return this.processes.size() - 1;
    }

    public void exec() throws TclException {
        if (this.processes.size() == 0) {
            return;
        }
        if (this.stdinRedirect != null) {
            if (this.stdinRedirect.getType() == Redirect.Type.INHERIT && this.execInBackground && !this.processes.get(0).canInheritFileDescriptors()) {
                this.processes.get(0).setStdinRedirect(null);
            } else {
                this.processes.get(0).setStdinRedirect(this.stdinRedirect);
            }
        }
        if (this.stdoutRedirect != null) {
            this.processes.get(this.processes.size() - 1).setStdoutRedirect(this.stdoutRedirect);
        }
        for (int i = 0; i < this.processes.size(); ++i) {
            TclProcess tclProcess = this.processes.get(i);
            if (tclProcess.getStderrRedirect() == null && this.stderrRedirect != null) {
                tclProcess.setStderrRedirect(this.stderrRedirect);
            }
            try {
                tclProcess.start();
                continue;
            }
            catch (IOException iOException) {
                throw new TclPosixException(this.interp, iOException, true, "couldn't execute \"" + tclProcess.command().get(0) + "\"");
            }
        }
    }

    public void waitForExitAndCleanup(boolean bl) throws TclException {
        for (int i = 0; i < this.processes.size(); ++i) {
            if (bl) {
                this.processes.get(i).destroy();
                continue;
            }
            try {
                this.processes.get(i).waitFor();
                continue;
            }
            catch (InterruptedException interruptedException) {
                this.processes.get(i).destroy();
                continue;
            }
            catch (IOException iOException) {
                throw new TclPosixException(this.interp, iOException, true, "Error");
            }
        }
    }

    public Redirect getStdinRedirect() {
        return this.stdinRedirect;
    }

    public void setStdinRedirect(Redirect redirect) {
        this.stdinRedirect = redirect;
    }

    public Redirect getStdoutRedirect() {
        return this.stdoutRedirect;
    }

    public void setStdoutRedirect(Redirect redirect) {
        this.stdoutRedirect = redirect;
    }

    public Redirect getStderrRedirect() {
        return this.stderrRedirect;
    }

    public void setStderrRedirect(Redirect redirect) {
        this.stderrRedirect = redirect;
    }

    public boolean isExecInBackground() {
        return this.execInBackground;
    }

    public void setExecInBackground(boolean bl) {
        this.execInBackground = bl;
    }

    public boolean isErrorRedirectedToResult() {
        return this.redirectStderrToResult;
    }

    public int[] getProcessIdentifiers() {
        int[] nArray = new int[this.processes.size()];
        for (int i = 0; i < this.processes.size(); ++i) {
            nArray[i] = this.processes.get(i).getPid();
        }
        return nArray;
    }

    public int[] getExitValues() {
        int[] nArray = new int[this.processes.size()];
        for (int i = 0; i < this.processes.size(); ++i) {
            try {
                nArray[i] = this.processes.get(i).exitValue();
                continue;
            }
            catch (Exception exception) {
                nArray[i] = 0;
            }
        }
        return nArray;
    }

    public void throwAnyExceptions() throws TclException {
        if (this.savedException != null) {
            throw this.savedException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this.waitForExitAndCleanup(false);
        }
        catch (TclException tclException) {
            Pipeline pipeline = this;
            synchronized (pipeline) {
                this.savedException = tclException;
            }
        }
    }

    static {
        HashSet<String> hashSet = new HashSet<String>(13);
        hashSet.add("<");
        hashSet.add("<@");
        hashSet.add("<<");
        hashSet.add(">");
        hashSet.add("2>");
        hashSet.add(">&");
        hashSet.add(">>");
        hashSet.add("2>>");
        hashSet.add(">>&");
        hashSet.add(">@");
        hashSet.add("2>@");
        hashSet.add("2>@1");
        hashSet.add(">&@");
        redirectors = Collections.unmodifiableSet(hashSet);
    }
}

