/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import tcl.lang.BinaryMathFunction;
import tcl.lang.ExprValue;
import tcl.lang.Expression;
import tcl.lang.Interp;
import tcl.lang.TclException;

class PowFunction
extends BinaryMathFunction {
    PowFunction() {
    }

    @Override
    void apply(Interp interp, ExprValue[] exprValueArray) throws TclException {
        double d = exprValueArray[0].getDoubleValue();
        double d2 = exprValueArray[1].getDoubleValue();
        if (d < 0.0 && (double)((int)d2) != d2) {
            Expression.DomainError(interp);
        }
        double d3 = Math.pow(d, d2);
        Expression.checkDoubleRange(interp, d3);
        exprValueArray[0].setDoubleValue(d3);
    }
}

