/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import tcl.lang.Interp;
import tcl.lang.TclDouble;
import tcl.lang.TclException;
import tcl.lang.TclInteger;
import tcl.lang.TclList;
import tcl.lang.TclObject;
import tcl.lang.TclObjectBase;
import tcl.lang.TclRuntimeError;
import tcl.lang.Util;

public final class QSort {
    public static final int ASCII = 0;
    public static final int INTEGER = 1;
    public static final int REAL = 2;
    public static final int COMMAND = 3;
    public static final int DICTIONARY = 4;
    private int sortMode;
    private int sortIndex;
    private boolean sortIncreasing;
    private String sortCommand;
    private Interp sortInterp;

    private final void quickSort(TclObject[] tclObjectArray, int n, int n2) throws TclException {
        int n3 = n;
        int n4 = n2;
        if (n2 > n) {
            int n5 = n + n2 >>> 1;
            TclObject tclObject = tclObjectArray[n5];
            while (n3 <= n4) {
                while (n3 < n2 && n3 != n5 && this.compare(tclObjectArray[n3], tclObject) < 0) {
                    ++n3;
                }
                while (n4 > n && n4 != n5 && this.compare(tclObjectArray[n4], tclObject) > 0) {
                    --n4;
                }
                if (n3 > n4) continue;
                QSort.swap(tclObjectArray, n3, n4);
                ++n3;
                --n4;
            }
            if (n < n4) {
                this.quickSort(tclObjectArray, n, n4);
            }
            if (n3 < n2) {
                this.quickSort(tclObjectArray, n3, n2);
            }
        }
    }

    private static final void swap(TclObject[] tclObjectArray, int n, int n2) {
        TclObject tclObject = tclObjectArray[n];
        tclObjectArray[n] = tclObjectArray[n2];
        tclObjectArray[n2] = tclObject;
    }

    final void sort(Interp interp, TclObject[] tclObjectArray, int n, int n2, boolean bl, String string) throws TclException {
        this.sortInterp = interp;
        this.sortMode = n;
        this.sortIndex = n2;
        this.sortIncreasing = bl;
        this.sortCommand = string;
        this.quickSort(tclObjectArray, 0, tclObjectArray.length - 1);
    }

    final int compare(TclObject object, TclObject object2) throws TclException {
        Object object3;
        int n = 0;
        if (this.sortIndex != -1) {
            int n2 = this.sortIndex < -1 ? TclList.getLength(this.sortInterp, (TclObject)object) + (this.sortIndex + 1) : this.sortIndex;
            object3 = TclList.index(this.sortInterp, (TclObject)object, n2);
            if (object3 == null) {
                throw new TclException(this.sortInterp, "element " + n2 + " missing from sublist \"" + object + "\"");
            }
            object = object3;
            n2 = this.sortIndex < -1 ? TclList.getLength(this.sortInterp, (TclObject)object2) + (this.sortIndex + 1) : this.sortIndex;
            object3 = TclList.index(this.sortInterp, (TclObject)object2, n2);
            if (object3 == null) {
                throw new TclException(this.sortInterp, "element " + n2 + " missing from sublist \"" + object2 + "\"");
            }
            object2 = object3;
        }
        switch (this.sortMode) {
            case 0: {
                n = ((TclObjectBase)object).toString().compareTo(((TclObjectBase)object2).toString());
                break;
            }
            case 4: {
                n = this.doDictionary(((TclObjectBase)object).toString(), ((TclObjectBase)object2).toString());
                break;
            }
            case 1: {
                try {
                    long l = TclInteger.getLong(this.sortInterp, (TclObject)object);
                    long l2 = TclInteger.getLong(this.sortInterp, (TclObject)object2);
                    if (l > l2) {
                        n = 1;
                        break;
                    }
                    if (l2 <= l) break;
                    n = -1;
                    break;
                }
                catch (TclException tclException) {
                    this.sortInterp.addErrorInfo("\n    (converting list element from string to integer)");
                    throw tclException;
                }
            }
            case 2: {
                try {
                    double d = TclDouble.get(this.sortInterp, (TclObject)object);
                    double d2 = TclDouble.get(this.sortInterp, (TclObject)object2);
                    if (d > d2) {
                        n = 1;
                        break;
                    }
                    if (!(d2 > d)) break;
                    n = -1;
                    break;
                }
                catch (TclException tclException) {
                    this.sortInterp.addErrorInfo("\n    (converting list element from string to real)");
                    throw tclException;
                }
            }
            case 3: {
                object3 = new StringBuffer(this.sortCommand);
                Util.appendElement(this.sortInterp, (StringBuffer)object3, ((TclObjectBase)object).toString());
                Util.appendElement(this.sortInterp, (StringBuffer)object3, ((TclObjectBase)object2).toString());
                try {
                    this.sortInterp.eval(((StringBuffer)object3).toString(), 0);
                }
                catch (TclException tclException) {
                    this.sortInterp.addErrorInfo("\n    (-compare command)");
                    throw tclException;
                }
                try {
                    n = TclInteger.getInt(this.sortInterp, this.sortInterp.getResult());
                    break;
                }
                catch (TclException tclException) {
                    this.sortInterp.resetResult();
                    TclException tclException2 = new TclException(this.sortInterp, "-compare command returned non-integer result");
                    throw tclException2;
                }
            }
            default: {
                throw new TclRuntimeError("Unknown sortMode " + this.sortMode);
            }
        }
        if (this.sortIncreasing) {
            return n;
        }
        return -n;
    }

    private final int doDictionary(String string, String string2) {
        int n = 0;
        int n2 = 0;
        int n3 = string.length();
        int n4 = string2.length();
        int n5 = 0;
        while (n < n3 && n2 < n4) {
            int n6;
            int n7;
            char c = string.charAt(n);
            char c2 = string2.charAt(n2);
            if (Character.isDigit(c) && Character.isDigit(c2)) {
                long l;
                for (n7 = n + 1; n7 < n3 && Character.isDigit(string.charAt(n7)); ++n7) {
                }
                for (n6 = n2 + 1; n6 < n4 && Character.isDigit(string2.charAt(n6)); ++n6) {
                }
                long l2 = Long.parseLong(string.substring(n, n7));
                if (l2 < (l = Long.parseLong(string2.substring(n2, n6)))) {
                    return -1;
                }
                if (l2 > l) {
                    return 1;
                }
                if (n5 == 0) {
                    if (n7 - n < n6 - n2) {
                        n5 = -1;
                    } else if (n7 - n > n6 - n2) {
                        n5 = 1;
                    }
                }
                n = n7;
                n2 = n6;
                continue;
            }
            n7 = Character.toLowerCase(c);
            if (n7 < (n6 = Character.toLowerCase(c2))) {
                return -1;
            }
            if (n7 > n6) {
                return 1;
            }
            if (n5 == 0) {
                if (c < c2) {
                    n5 = -1;
                }
                if (c > c2) {
                    n5 = 1;
                }
            }
            ++n;
            ++n2;
        }
        if (n == n3 && n2 < n4) {
            return -1;
        }
        if (n < n3 && n2 == n4) {
            return 1;
        }
        return n5;
    }
}

