/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import java.util.LinkedHashMap;
import java.util.Map;
import tcl.lang.FindElemResult;
import tcl.lang.InternalRep;
import tcl.lang.Interp;
import tcl.lang.TclException;
import tcl.lang.TclObject;
import tcl.lang.TclRuntimeError;
import tcl.lang.TclString;
import tcl.lang.Util;

public class TclDict
implements InternalRep {
    private final Map map;
    private final Map keymap;

    private TclDict() {
        this.map = new LinkedHashMap();
        this.keymap = new LinkedHashMap();
    }

    private TclDict(int n) {
        this.map = new LinkedHashMap(n);
        this.keymap = new LinkedHashMap(n);
    }

    @Override
    public void dispose() {
        for (Map.Entry entry : this.map.entrySet()) {
            TclObject tclObject = (TclObject)entry.getKey();
            TclObject tclObject2 = (TclObject)entry.getValue();
            tclObject.release();
            tclObject2.release();
        }
    }

    @Override
    public InternalRep duplicate() {
        int n = this.map.size();
        TclDict tclDict = new TclDict(n);
        for (Map.Entry entry : this.map.entrySet()) {
            TclObject tclObject = (TclObject)entry.getKey();
            TclObject tclObject2 = (TclObject)entry.getValue();
            tclObject.preserve();
            tclObject2.preserve();
            tclDict.map.put(tclObject, tclObject2);
            tclDict.keymap.put(tclObject, tclObject);
        }
        return tclDict;
    }

    public String toString() {
        int n = this.map.size();
        if (n == 0) {
            return "";
        }
        int n2 = n * 8;
        StringBuffer stringBuffer = new StringBuffer(n2 > 64 ? n2 : 64);
        try {
            for (Map.Entry entry : this.map.entrySet()) {
                Object k = entry.getKey();
                Object v = entry.getValue();
                if (k != null) {
                    Util.appendElement(null, stringBuffer, k.toString());
                } else {
                    Util.appendElement(null, stringBuffer, "");
                }
                if (v != null) {
                    Util.appendElement(null, stringBuffer, v.toString());
                    continue;
                }
                Util.appendElement(null, stringBuffer, "");
            }
        }
        catch (TclException tclException) {
            throw new TclRuntimeError("unexpected TclException: " + tclException);
        }
        return stringBuffer.toString();
    }

    public static TclObject newInstance() {
        return new TclObject(new TclDict());
    }

    private static void setDictFromAny(Interp interp, TclObject tclObject) throws TclException {
        TclDict tclDict = new TclDict();
        TclDict.splitDict(interp, tclDict.map, tclDict.keymap, tclObject.toString());
        tclObject.setInternalRep(tclDict);
    }

    private static final void splitDict(Interp interp, Map map, Map map2, String string) throws TclException {
        int n = string.length();
        int n2 = 0;
        FindElemResult findElemResult = new FindElemResult();
        while (n2 < n) {
            TclObject tclObject = null;
            TclObject tclObject2 = null;
            if (!Util.findElement(interp, string, n2, n, findElemResult)) break;
            tclObject = TclString.newInstance(findElemResult.elem);
            n2 = findElemResult.elemEnd;
            if (!Util.findElement(interp, string, n2, n, findElemResult)) {
                throw new TclException(interp, "missing value to go with key");
            }
            tclObject2 = TclString.newInstance(findElemResult.elem);
            tclObject.preserve();
            tclObject2.preserve();
            map.put(tclObject, tclObject2);
            map2.put(tclObject, tclObject);
            n2 = findElemResult.elemEnd;
        }
    }

    public static final TclObject get(Interp interp, TclObject tclObject, TclObject tclObject2) throws TclException {
        if (!(tclObject.getInternalRep() instanceof TclDict)) {
            TclDict.setDictFromAny(interp, tclObject);
        }
        TclDict tclDict = (TclDict)tclObject.getInternalRep();
        return (TclObject)tclDict.map.get(tclObject2);
    }

    public static final void put(Interp interp, TclObject tclObject, TclObject tclObject2, TclObject tclObject3) throws TclException {
        if (tclObject.isShared()) {
            throw new TclRuntimeError("TclDict.put() called with shared object");
        }
        if (!(tclObject.getInternalRep() instanceof TclDict)) {
            TclDict.setDictFromAny(interp, tclObject);
        }
        TclDict tclDict = (TclDict)tclObject.getInternalRep();
        TclObject tclObject4 = (TclObject)tclDict.map.remove(tclObject2);
        tclObject2.preserve();
        tclObject3.preserve();
        if (tclObject4 != null) {
            tclObject4.release();
            TclObject tclObject5 = (TclObject)tclDict.keymap.remove(tclObject2);
            tclObject5.release();
        }
        tclDict.map.put(tclObject2, tclObject3);
        tclDict.keymap.put(tclObject2, tclObject2);
        tclObject.invalidateStringRep();
    }

    public static final void remove(Interp interp, TclObject tclObject, TclObject tclObject2) throws TclException {
        if (tclObject.isShared()) {
            throw new TclRuntimeError("TclDict.remove() called with shared object");
        }
        if (!(tclObject.getInternalRep() instanceof TclDict)) {
            TclDict.setDictFromAny(interp, tclObject);
        }
        tclObject.invalidateStringRep();
        TclDict tclDict = (TclDict)tclObject.getInternalRep();
        TclObject tclObject3 = (TclObject)tclDict.map.remove(tclObject2);
        if (tclObject3 != null) {
            tclObject3.release();
            TclObject tclObject4 = (TclObject)tclDict.keymap.remove(tclObject2);
            tclObject4.release();
        }
    }

    public static final int size(Interp interp, TclObject tclObject) throws TclException {
        if (!(tclObject.getInternalRep() instanceof TclDict)) {
            TclDict.setDictFromAny(interp, tclObject);
        }
        TclDict tclDict = (TclDict)tclObject.getInternalRep();
        return tclDict.map.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final Object foreach(Interp interp, Object object, TclObject tclObject, Visitor visitor) throws TclException {
        TclObject tclObject2;
        TclObject tclObject3;
        if (!(tclObject.getInternalRep() instanceof TclDict)) {
            TclDict.setDictFromAny(interp, tclObject);
        }
        tclObject.preserve();
        TclDict tclDict = (TclDict)tclObject.getInternalRep();
        for (Map.Entry entry : tclDict.map.entrySet()) {
            tclObject3 = (TclObject)entry.getKey();
            tclObject2 = (TclObject)entry.getValue();
            tclObject3.preserve();
            tclObject2.preserve();
        }
        try {
            for (Map.Entry entry : tclDict.map.entrySet()) {
                tclObject3 = (TclObject)entry.getKey();
                tclObject2 = (TclObject)entry.getValue();
                try {
                    object = visitor.visit(interp, object, tclObject3, tclObject2);
                }
                catch (TclException tclException) {
                    if (tclException.getCompletionCode() == 3) {
                        return object;
                    }
                    if (tclException.getCompletionCode() == 4) continue;
                    throw tclException;
                    return object;
                }
            }
        }
        finally {
            for (Map.Entry entry : tclDict.map.entrySet()) {
                tclObject3 = (TclObject)entry.getKey();
                tclObject2 = (TclObject)entry.getValue();
                tclObject3.release();
                tclObject2.release();
            }
            tclObject.release();
        }
    }

    public static final void putKeyList(Interp interp, TclObject tclObject, TclObject[] tclObjectArray, int n, int n2, TclObject tclObject2) throws TclException {
        TclObject tclObject3;
        Object object;
        int n3 = n + n2 - 1;
        TclObject tclObject4 = tclObject;
        if (tclObject.isShared()) {
            throw new TclRuntimeError("TclDict.putKeyList() called with shared object");
        }
        for (int i = n; i < n3; ++i) {
            if (!(tclObject4.getInternalRep() instanceof TclDict)) {
                TclDict.setDictFromAny(interp, tclObject4);
            }
            object = (TclDict)tclObject4.getInternalRep();
            tclObject4.invalidateStringRep();
            tclObject3 = (TclObject)((TclDict)object).map.get(tclObjectArray[i]);
            if (tclObject3 == null) {
                tclObject3 = TclDict.newInstance();
                tclObject3.preserve();
                tclObjectArray[i].preserve();
                ((TclDict)object).map.put(tclObjectArray[i], tclObject3);
                ((TclDict)object).keymap.put(tclObjectArray[i], tclObjectArray[i]);
            } else if (tclObject3.isShared()) {
                tclObject3 = tclObject3.duplicate();
                tclObject3.preserve();
                tclObjectArray[i].preserve();
                ((TclDict)object).map.put(tclObjectArray[i], tclObject3);
                ((TclDict)object).keymap.put(tclObjectArray[i], tclObjectArray[i]);
            }
            tclObject4 = tclObject3;
        }
        if (!(tclObject4.getInternalRep() instanceof TclDict)) {
            TclDict.setDictFromAny(interp, tclObject4);
        }
        TclDict tclDict = (TclDict)tclObject4.getInternalRep();
        object = (TclObject)tclDict.map.remove(tclObjectArray[n3]);
        if (object != null) {
            ((TclObject)object).release();
            tclObject3 = (TclObject)tclDict.keymap.remove(tclObjectArray[n3]);
            tclObject3.release();
        }
        tclObjectArray[n3].preserve();
        tclObject2.preserve();
        tclDict.map.put(tclObjectArray[n3], tclObject2);
        tclDict.keymap.put(tclObjectArray[n3], tclObjectArray[n3]);
        tclObject4.invalidateStringRep();
    }

    public static final void removeKeyList(Interp interp, TclObject tclObject, TclObject[] tclObjectArray, int n, int n2) throws TclException {
        TclObject tclObject2;
        Object object;
        int n3 = n + n2 - 1;
        TclObject tclObject3 = tclObject;
        if (tclObject.isShared()) {
            throw new TclRuntimeError("TclDict.removeKeyList() called with shared object");
        }
        for (int i = n; i < n3; ++i) {
            if (!(tclObject3.getInternalRep() instanceof TclDict)) {
                TclDict.setDictFromAny(interp, tclObject3);
            }
            object = (TclDict)tclObject3.getInternalRep();
            tclObject3.invalidateStringRep();
            tclObject2 = (TclObject)((TclDict)object).map.get(tclObjectArray[i]);
            if (tclObject2 == null) {
                throw new TclException(interp, "key \"" + tclObjectArray[i].toString() + "\" not known in dictionary");
            }
            if (tclObject2.isShared()) {
                tclObject2 = tclObject2.duplicate();
                tclObject2.preserve();
                tclObjectArray[i].preserve();
                ((TclDict)object).map.put(tclObjectArray[i], tclObject2);
                ((TclDict)object).keymap.put(tclObjectArray[i], tclObjectArray[i]);
            }
            tclObject3 = tclObject2;
        }
        if (!(tclObject3.getInternalRep() instanceof TclDict)) {
            TclDict.setDictFromAny(interp, tclObject3);
        }
        TclDict tclDict = (TclDict)tclObject3.getInternalRep();
        object = (TclObject)tclDict.map.remove(tclObjectArray[n3]);
        if (object != null) {
            ((TclObject)object).release();
            tclObject2 = (TclObject)tclDict.keymap.remove(tclObjectArray[n3]);
            tclObject2.release();
        }
        tclObject3.invalidateStringRep();
    }

    public static final void appendToKey(Interp interp, TclObject tclObject, TclObject tclObject2, TclObject[] tclObjectArray, int n, int n2) throws TclException {
        if (tclObject.isShared()) {
            throw new TclRuntimeError("TclDict.append() called with shared object");
        }
        if (!(tclObject.getInternalRep() instanceof TclDict)) {
            TclDict.setDictFromAny(interp, tclObject);
        }
        TclDict tclDict = (TclDict)tclObject.getInternalRep();
        TclObject tclObject3 = (TclObject)tclDict.map.get(tclObject2);
        if (tclObject3 == null) {
            tclObject3 = TclString.newInstance("");
            tclDict.keymap.put(tclObject2, tclObject2);
            tclObject2.preserve();
        } else if (tclObject3.isShared()) {
            tclObject3 = tclObject3.duplicate();
        }
        for (int i = n; i < n2; ++i) {
            TclString.append(tclObject3, tclObjectArray[i].toString());
        }
        tclObject3.preserve();
        tclDict.map.put(tclObject2, tclObject3);
        tclObject.invalidateStringRep();
    }

    public static interface Visitor {
        public Object visit(Interp var1, Object var2, TclObject var3, TclObject var4) throws TclException;
    }
}

