/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import tcl.lang.InternalRep;
import tcl.lang.Interp;
import tcl.lang.TclException;
import tcl.lang.TclInteger;
import tcl.lang.TclObject;
import tcl.lang.TclRuntimeError;
import tcl.lang.Util;

public class TclDouble
implements InternalRep {
    public double value;
    private static final boolean validate = false;

    private TclDouble(double d) {
        this.value = d;
    }

    private TclDouble(Interp interp, String string) throws TclException {
        this.value = Util.getDouble(interp, string);
    }

    @Override
    public InternalRep duplicate() {
        return new TclDouble(this.value);
    }

    @Override
    public void dispose() {
    }

    public static TclObject newInstance(double d) {
        return new TclObject(new TclDouble(d));
    }

    private static void setDoubleFromAny(Interp interp, TclObject tclObject) throws TclException {
        tclObject.setInternalRep(new TclDouble(interp, tclObject.toString()));
    }

    public static double get(Interp interp, TclObject tclObject) throws TclException {
        TclDouble tclDouble;
        if (!tclObject.isDoubleType()) {
            if (Util.isJacl()) {
                TclDouble.setDoubleFromAny(interp, tclObject);
                tclDouble = (TclDouble)tclObject.getInternalRep();
                double d = tclDouble.value;
                if (Util.looksLikeInt(tclObject.toString())) {
                    try {
                        long l = TclInteger.getLong(null, tclObject);
                        return d;
                    }
                    catch (TclException tclException) {
                        throw new TclRuntimeError("looksLikeInt() is true, but TclInteger.get() failed for \"" + tclObject.toString() + "\"");
                    }
                }
            } else {
                TclDouble.setDoubleFromAny(interp, tclObject);
                tclDouble = (TclDouble)tclObject.getInternalRep();
            }
        } else {
            tclDouble = (TclDouble)tclObject.getInternalRep();
        }
        return tclDouble.value;
    }

    public static void set(TclObject tclObject, double d) {
        tclObject.invalidateStringRep();
        if (tclObject.isDoubleType()) {
            TclDouble tclDouble = (TclDouble)tclObject.getInternalRep();
            tclDouble.value = d;
        } else {
            tclObject.setInternalRep(new TclDouble(d));
        }
    }

    public String toString() {
        return Util.printDouble(this.value);
    }

    static void exprSetInternalRep(TclObject tclObject, double d) {
        tclObject.setInternalRep(new TclDouble(d));
    }

    static void setRecycledInternalRep(TclObject tclObject) {
        tclObject.setInternalRep(new TclDouble(0.0));
    }
}

