/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import tcl.lang.Interp;
import tcl.lang.TclException;
import tcl.lang.TclObject;
import tcl.lang.TclRuntimeError;
import tcl.lang.Util;
import tcl.lang.channel.Channel;
import tcl.lang.channel.FileEventScript;
import tcl.lang.channel.StdChannel;

public class TclIO {
    public static final int READ_ALL = 1;
    public static final int READ_LINE = 2;
    public static final int READ_N_BYTES = 3;
    public static final int SEEK_SET = 1;
    public static final int SEEK_CUR = 2;
    public static final int SEEK_END = 3;
    public static final int RDONLY = 1;
    public static final int WRONLY = 2;
    public static final int RDWR = 4;
    public static final int APPEND = 8;
    public static final int CREAT = 16;
    public static final int EXCL = 32;
    public static final int TRUNC = 64;
    public static final int BUFF_FULL = 0;
    public static final int BUFF_LINE = 1;
    public static final int BUFF_NONE = 2;
    public static final int TRANS_AUTO = 0;
    public static final int TRANS_BINARY = 1;
    public static final int TRANS_LF = 2;
    public static final int TRANS_CR = 3;
    public static final int TRANS_CRLF = 4;
    public static int TRANS_PLATFORM = Util.isWindows() ? 4 : (Util.isMac() ? 3 : 2);
    private static StdChannel stdinChan = null;
    private static StdChannel stdoutChan = null;
    private static StdChannel stderrChan = null;

    public static Channel getChannel(Interp interp, String string) {
        HashMap<String, Channel> hashMap = TclIO.getInterpChanTable(interp);
        if (interp.systemEncodingChangesStdoutStderr && ("stdout".equals(string) || "stderr".equals(string))) {
            interp.systemEncodingChangesStdoutStderr = false;
        }
        if (hashMap.containsKey(string)) {
            return hashMap.get(string);
        }
        for (String string2 : new String[]{"stdin", "stdout", "stderr"}) {
            Channel channel = hashMap.get(string2);
            if (channel == null || !channel.getChanName().equals(string)) continue;
            return channel;
        }
        return null;
    }

    public static void getChannelNames(Interp interp, TclObject tclObject) throws TclException {
        Iterator<String> iterator = TclIO.getInterpChanTable(interp).keySet().iterator();
        interp.systemEncodingChangesStdoutStderr = false;
        while (iterator.hasNext()) {
            String string = iterator.next();
            if (tclObject == null) {
                interp.appendElement(string);
                continue;
            }
            if (!Util.stringMatch(string, tclObject.toString())) continue;
            interp.appendElement(string);
        }
    }

    public static void registerChannel(Interp interp, Channel channel) {
        if (interp != null) {
            HashMap<String, Channel> hashMap = TclIO.getInterpChanTable(interp);
            String string = !hashMap.containsKey("stdin") ? "stdin" : (!hashMap.containsKey("stdout") ? "stdout" : (!hashMap.containsKey("stderr") ? "stderr" : channel.getChanName()));
            hashMap.put(string, channel);
            ++channel.refCount;
        }
    }

    public static void flushAllOpenChannels(Interp interp) {
        HashMap<String, Channel> hashMap = TclIO.getInterpChanTable(interp);
        for (Channel channel : hashMap.values()) {
            if (!channel.isWriteOnly() && !channel.isReadWrite()) continue;
            boolean bl = channel.getBlocking();
            if (!bl) {
                channel.setBlocking(true);
            }
            try {
                channel.flush(interp);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (bl) continue;
            channel.setBlocking(false);
        }
    }

    public static void giveChannel(Interp interp, Interp interp2, String string, boolean bl) throws TclException {
        HashMap<String, Channel> hashMap = TclIO.getInterpChanTable(interp);
        HashMap<String, Channel> hashMap2 = TclIO.getInterpChanTable(interp2);
        interp2.systemEncodingChangesStdoutStderr = false;
        Channel channel = hashMap.get(string);
        if (channel != null) {
            hashMap2.put(string, channel);
        } else {
            for (String string2 : new String[]{"stdin", "stdout", "stderr"}) {
                channel = hashMap.get(string2);
                if (channel != null && channel.getChanName().equals(string)) {
                    hashMap2.put(string2, channel);
                    break;
                }
                channel = null;
            }
        }
        if (channel == null) {
            throw new TclException(interp, "can not find channel named \"" + string + "\"");
        }
        ++channel.refCount;
        if (bl) {
            TclIO.unregisterChannel(interp, channel);
        }
    }

    public static void unregisterChannel(Interp interp, Channel channel) {
        HashMap<String, Channel> hashMap = TclIO.getInterpChanTable(interp);
        FileEventScript.dispose(interp, channel, 0);
        FileEventScript.dispose(interp, channel, 1);
        if (hashMap.containsKey(channel.getChanName())) {
            hashMap.remove(channel.getChanName());
        } else {
            for (String string : new String[]{"stdin", "stdout", "stderr"}) {
                Channel channel2 = hashMap.get(string);
                if (channel2 == null || !channel2.getChanName().equals(channel.getChanName())) continue;
                hashMap.remove(string);
                break;
            }
        }
        if (--channel.refCount <= 0) {
            try {
                channel.close();
            }
            catch (IOException iOException) {
                throw new TclRuntimeError("TclIO.unregisterChannel() Error: IOException when closing " + channel.getChanName() + ": " + iOException.getMessage());
            }
        }
    }

    static HashMap<String, Channel> getInterpChanTable(Interp interp) {
        if (interp.interpChanTable == null) {
            interp.interpChanTable = new HashMap();
            Channel channel = TclIO.getStdChannel(0);
            TclIO.registerChannel(interp, channel);
            channel = TclIO.getStdChannel(1);
            TclIO.registerChannel(interp, channel);
            channel = TclIO.getStdChannel(2);
            TclIO.registerChannel(interp, channel);
        }
        return interp.interpChanTable;
    }

    public static Channel getStdChannel(int n) {
        StdChannel stdChannel = null;
        switch (n) {
            case 0: {
                if (stdinChan == null) {
                    stdinChan = new StdChannel(0);
                }
                stdChannel = stdinChan;
                break;
            }
            case 1: {
                if (stdoutChan == null) {
                    stdoutChan = new StdChannel(1);
                }
                stdChannel = stdoutChan;
                break;
            }
            case 2: {
                if (stderrChan == null) {
                    stderrChan = new StdChannel(2);
                }
                stdChannel = stderrChan;
                break;
            }
            default: {
                throw new TclRuntimeError("Invalid type for StdChannel");
            }
        }
        return stdChannel;
    }

    public static String getNextDescriptor(Interp interp, String string) {
        HashMap<String, Channel> hashMap = TclIO.getInterpChanTable(interp);
        int n = string.equals("file") ? 3 : 0;
        while (hashMap.get(string + n) != null) {
            ++n;
        }
        return string + n;
    }

    public static String getTranslationString(int n) {
        switch (n) {
            case 0: {
                return "auto";
            }
            case 3: {
                return "cr";
            }
            case 4: {
                return "crlf";
            }
            case 2: {
                return "lf";
            }
            case 1: {
                return "lf";
            }
        }
        throw new TclRuntimeError("bad translation id");
    }

    public static int getTranslationID(String string) {
        if (string.equals("auto")) {
            return 0;
        }
        if (string.equals("cr")) {
            return 3;
        }
        if (string.equals("crlf")) {
            return 4;
        }
        if (string.equals("lf")) {
            return 2;
        }
        if (string.equals("binary")) {
            return 2;
        }
        if (string.equals("platform")) {
            return TRANS_PLATFORM;
        }
        return -1;
    }

    public static String getBufferingString(int n) {
        switch (n) {
            case 0: {
                return "full";
            }
            case 1: {
                return "line";
            }
            case 2: {
                return "none";
            }
        }
        throw new TclRuntimeError("bad buffering id");
    }

    public static int getBufferingID(String string) {
        if (string.equals("full")) {
            return 0;
        }
        if (string.equals("line")) {
            return 1;
        }
        if (string.equals("none")) {
            return 2;
        }
        return -1;
    }
}

