/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import java.util.Hashtable;
import tcl.lang.InternalRep;
import tcl.lang.TclByteArray;
import tcl.lang.TclDouble;
import tcl.lang.TclInteger;
import tcl.lang.TclList;
import tcl.lang.TclObject;
import tcl.lang.TclRuntimeError;
import tcl.lang.TclString;

abstract class TclObjectBase {
    protected InternalRep internalRep;
    protected int refCount;
    protected String stringRep;
    static final boolean saveObjRecords = false;
    static Hashtable objRecordMap = null;
    static final boolean validate = false;
    protected static final String DEALLOCATED_MSG = "TclObject has been deallocated";
    public long ivalue;

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || object.getClass() != this.getClass()) {
            return false;
        }
        TclObjectBase tclObjectBase = (TclObjectBase)object;
        return this.stringRep == tclObjectBase.stringRep || this.stringRep != null && this.stringRep.equals(tclObjectBase.stringRep);
    }

    public int hashCode() {
        int n = 7;
        n = 31 * n + (null == this.stringRep ? 0 : this.stringRep.hashCode());
        return n;
    }

    public final boolean isIntType() {
        return this.internalRep == TclInteger.dummy;
    }

    public final boolean isStringType() {
        return this.internalRep instanceof TclString;
    }

    public final boolean isDoubleType() {
        return this.internalRep instanceof TclDouble;
    }

    public final boolean isWideIntType() {
        return this.isIntType();
    }

    public final boolean isListType() {
        return this.internalRep instanceof TclList;
    }

    public final boolean isByteArrayType() {
        return this.internalRep instanceof TclByteArray;
    }

    protected TclObjectBase(InternalRep internalRep) {
        this.internalRep = internalRep;
    }

    protected TclObjectBase(TclString tclString, String string) {
        this.internalRep = tclString;
        this.stringRep = string;
    }

    protected TclObjectBase(long l) {
        this.internalRep = TclInteger.dummy;
        this.ivalue = l;
    }

    public final InternalRep getInternalRep() {
        return this.internalRep;
    }

    public void setInternalRep(InternalRep internalRep) {
        if (this.internalRep == null) {
            this.disposedError();
        }
        if (internalRep == null) {
            throw new TclRuntimeError("null InternalRep");
        }
        if (internalRep == this.internalRep) {
            return;
        }
        this.internalRep.dispose();
        this.internalRep = internalRep;
        this.ivalue = 0L;
    }

    public final String toString() {
        if (this.stringRep == null) {
            if (this.internalRep == null) {
                this.disposedError();
            }
            this.stringRep = this.isIntType() ? Long.toString(this.ivalue) : this.internalRep.toString();
        }
        return this.stringRep;
    }

    public final void invalidateStringRep() throws TclRuntimeError {
        if (this.internalRep == null) {
            this.disposedError();
        }
        if (this.refCount > 1) {
            throw new TclRuntimeError("string representation of object \"" + this.toString() + "\" cannot be invalidated: refCount = " + this.refCount);
        }
        this.stringRep = null;
    }

    public final boolean isShared() {
        return this.refCount > 1;
    }

    public final TclObject duplicate() {
        TclObject tclObject;
        if (this.isStringType() && this.stringRep == null) {
            this.stringRep = this.internalRep.toString();
        }
        if (this.isIntType()) {
            tclObject = new TclObject(TclInteger.dummy);
            tclObject.ivalue = this.ivalue;
        } else {
            tclObject = new TclObject(this.internalRep.duplicate());
        }
        if (this.stringRep != null) {
            tclObject.stringRep = this.stringRep;
        }
        return tclObject;
    }

    public final TclObject takeExclusive() throws TclRuntimeError {
        if (this.internalRep == null) {
            this.disposedError();
        }
        if (this.refCount == 1) {
            return (TclObject)this;
        }
        if (this.refCount > 1) {
            TclObject tclObject;
            if (this.isStringType() && this.stringRep == null) {
                this.stringRep = this.internalRep.toString();
            }
            if (this.isIntType()) {
                tclObject = new TclObject(TclInteger.dummy);
                tclObject.ivalue = this.ivalue;
            } else {
                tclObject = new TclObject(this.internalRep.duplicate());
            }
            tclObject.stringRep = this.stringRep;
            tclObject.refCount = 1;
            --this.refCount;
            return tclObject;
        }
        throw new TclRuntimeError("takeExclusive() called on object \"" + this.toString() + "\" with: refCount = 0");
    }

    public final int getRefCount() {
        return this.refCount;
    }

    protected final void disposeObject() {
        if (this.internalRep == null) {
            throw new TclRuntimeError(DEALLOCATED_MSG);
        }
        this.internalRep.dispose();
        this.internalRep = null;
        this.stringRep = null;
        this.refCount = -1;
    }

    protected final void disposedError() {
        throw new TclRuntimeError(DEALLOCATED_MSG);
    }

    static String getObjRecords() {
        return "";
    }

    public final boolean hasNoStringRep() {
        return this.stringRep == null;
    }
}

