/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import tcl.lang.Command;
import tcl.lang.FindElemResult;
import tcl.lang.InternalRep;
import tcl.lang.Interp;
import tcl.lang.ParseExpr;
import tcl.lang.Parser;
import tcl.lang.TclException;
import tcl.lang.TclIndex;
import tcl.lang.TclInteger;
import tcl.lang.TclList;
import tcl.lang.TclNumArgsException;
import tcl.lang.TclObject;
import tcl.lang.TclParse;
import tcl.lang.TclRuntimeError;
import tcl.lang.TclString;
import tcl.lang.TclToken;
import tcl.lang.UTF8CharPointer;
import tcl.lang.Util;

public class TclParser
implements Command {
    private static final String[] options = new String[]{"command", "expr", "varname", "list", "getrange", "getstring", "charindex", "charlength", "countnewline"};
    private static final int PARSE_COMMAND = 0;
    private static final int PARSE_EXPR = 1;
    private static final int PARSE_VARNAME = 2;
    private static final int PARSE_LIST = 3;
    private static final int PARSE_GET_RANGE = 4;
    private static final int PARSE_GET_STR = 5;
    private static final int PARSE_CHAR_INDEX = 6;
    private static final int PARSE_CHAR_LEN = 7;
    private static final int PARSE_COUNT_NWLNE = 8;

    @Override
    public void cmdProc(Interp interp, TclObject[] tclObjectArray) throws TclException {
        UTF8CharPointer uTF8CharPointer;
        if (tclObjectArray.length < 3) {
            throw new TclNumArgsException(interp, 1, tclObjectArray, "option arg ?arg ...?");
        }
        int n = TclIndex.get(interp, tclObjectArray[1], options, "option", 0);
        TclObject tclObject = tclObjectArray[2];
        InternalRep internalRep = tclObject.getInternalRep();
        if (internalRep instanceof UTF8CharPointer) {
            uTF8CharPointer = (UTF8CharPointer)internalRep;
        } else {
            uTF8CharPointer = new UTF8CharPointer(tclObject.toString());
            tclObject.setInternalRep(uTF8CharPointer);
        }
        if (uTF8CharPointer == null) {
            System.out.println(uTF8CharPointer);
        }
        int n2 = uTF8CharPointer.getByteLength();
        switch (n) {
            case 4: {
                int n3;
                int n4;
                if (tclObjectArray.length == 3) {
                    n4 = 0;
                    n3 = n2;
                } else if (tclObjectArray.length == 5) {
                    n4 = TclInteger.getInt(interp, tclObjectArray[3]);
                    n3 = TclInteger.getInt(interp, tclObjectArray[4]);
                    if (n4 < 0) {
                        n4 = 0;
                    } else if (n4 >= n2) {
                        n4 = n2 - 1;
                    }
                    if (n3 < 0) {
                        n3 = 0;
                    } else if (n3 > n2 - n4) {
                        n3 = n2 - n4;
                    }
                } else {
                    throw new TclNumArgsException(interp, 2, tclObjectArray, "string ?index length?");
                }
                interp.setResult(TclParser.ParseMakeRange(uTF8CharPointer, n4, n3));
                return;
            }
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                if (tclObjectArray.length != 4) {
                    throw new TclNumArgsException(interp, 2, tclObjectArray, "string range");
                }
                ParseGetIndexAndLengthResult parseGetIndexAndLengthResult = new ParseGetIndexAndLengthResult();
                TclParser.ParseGetIndexAndLength(interp, tclObjectArray[3], n2, parseGetIndexAndLengthResult);
                int n5 = parseGetIndexAndLengthResult.indexPtr;
                int n6 = parseGetIndexAndLengthResult.lengthPtr;
                switch (n) {
                    case 0: {
                        TclParser.ParseCommand(interp, uTF8CharPointer, n5, n6);
                        return;
                    }
                    case 1: {
                        TclParser.ParseExpr(interp, uTF8CharPointer, n5, n6);
                        return;
                    }
                    case 2: {
                        TclParser.ParseVarName(interp, uTF8CharPointer, n5, n6);
                        return;
                    }
                    case 3: {
                        TclParser.ParseList(interp, uTF8CharPointer, n5, n6);
                        return;
                    }
                    case 5: {
                        TclParser.ParseGetString(interp, uTF8CharPointer, n5, n6);
                        return;
                    }
                    case 6: {
                        TclParser.ParseCharIndex(interp, uTF8CharPointer, n5, n6);
                        return;
                    }
                    case 7: {
                        TclParser.ParseCharLength(interp, uTF8CharPointer, n5, n6);
                        return;
                    }
                }
                break;
            }
            case 8: {
                TclObject tclObject2;
                if (tclObjectArray.length == 5) {
                    tclObject2 = tclObjectArray[4];
                } else if (tclObjectArray.length == 4) {
                    tclObject2 = null;
                } else {
                    throw new TclNumArgsException(interp, 2, tclObjectArray, "string range ?range?");
                }
                TclParser.ParseCountNewline(interp, uTF8CharPointer, n2, tclObjectArray[3], tclObject2);
                return;
            }
        }
        throw new TclException(interp, "unmatched option");
    }

    static void ParseCommand(Interp interp, UTF8CharPointer uTF8CharPointer, int n, int n2) throws TclException {
        int n3 = uTF8CharPointer.getCharIndex(n);
        int n4 = uTF8CharPointer.getCharRange(n, n2);
        TclParse tclParse = Parser.parseCommand(interp, uTF8CharPointer.array, n3, n4, null, -1, false);
        if (tclParse.result != 0) {
            TclParser.ParseSetErrorCode(interp, uTF8CharPointer, tclParse);
        }
        TclObject tclObject = TclList.newInstance();
        if (tclParse.commentStart != -1) {
            TclList.append(interp, tclObject, TclParser.ParseMakeByteRange(uTF8CharPointer, tclParse.commentStart, tclParse.commentSize));
        } else {
            TclList.append(interp, tclObject, TclParser.ParseMakeRange(uTF8CharPointer, uTF8CharPointer.index, 0));
        }
        TclList.append(interp, tclObject, TclParser.ParseMakeByteRange(uTF8CharPointer, tclParse.commandStart, tclParse.commandSize));
        int n5 = tclParse.commandStart + tclParse.commandSize;
        TclList.append(interp, tclObject, TclParser.ParseMakeByteRange(uTF8CharPointer, n5, n4 - (n5 - n3)));
        TclObject tclObject2 = TclList.newInstance();
        ParseMakeTokenListResult parseMakeTokenListResult = new ParseMakeTokenListResult();
        int n6 = 0;
        while (n6 < tclParse.numTokens) {
            n6 = TclParser.ParseMakeTokenList(uTF8CharPointer, tclParse, n6, parseMakeTokenListResult);
            TclObject tclObject3 = parseMakeTokenListResult.newList;
            TclList.append(null, tclObject2, tclObject3);
        }
        TclList.append(interp, tclObject, tclObject2);
        interp.setResult(tclObject);
    }

    static void ParseExpr(Interp interp, UTF8CharPointer uTF8CharPointer, int n, int n2) throws TclException {
        int n3 = uTF8CharPointer.getCharIndex(n);
        int n4 = uTF8CharPointer.getCharRange(n, n2);
        TclParse tclParse = ParseExpr.parseExpr(interp, uTF8CharPointer.array, n3, n4);
        if (tclParse.result != 0) {
            TclParser.ParseSetErrorCode(interp, uTF8CharPointer, tclParse);
        }
        ParseMakeTokenListResult parseMakeTokenListResult = new ParseMakeTokenListResult();
        TclParser.ParseMakeTokenList(uTF8CharPointer, tclParse, 0, parseMakeTokenListResult);
        interp.setResult(parseMakeTokenListResult.newList);
    }

    static void ParseList(Interp interp, UTF8CharPointer uTF8CharPointer, int n, int n2) throws TclException {
        int n3;
        FindElemResult findElemResult = new FindElemResult();
        int n4 = uTF8CharPointer.getCharIndex(n);
        int n5 = n4 - uTF8CharPointer.index;
        TclObject tclObject = TclList.newInstance();
        String string = uTF8CharPointer.getByteRangeAsString(n, n2);
        int n6 = n3 = string.length();
        int n7 = 0;
        while (true) {
            boolean bl;
            int n8 = n7;
            try {
                bl = Util.findElement(interp, string, n7, n3, findElemResult);
            }
            catch (TclException tclException) {
                TclObject tclObject2 = TclList.newInstance();
                TclList.append(interp, tclObject2, TclString.newInstance("PARSE"));
                TclList.append(interp, tclObject2, TclString.newInstance("list"));
                int n9 = uTF8CharPointer.getByteRange(uTF8CharPointer.index, n5 + n7);
                TclList.append(interp, tclObject2, TclInteger.newInstance(n9));
                TclList.append(interp, tclObject2, interp.getResult());
                interp.setErrorCode(tclObject2);
                throw tclException;
            }
            if (!bl) break;
            n7 = findElemResult.elemEnd;
            int n10 = findElemResult.elemStart;
            int n11 = findElemResult.size;
            int n12 = n10 > 0 ? (int)string.charAt(n10 - 1) : 0;
            if (n12 == 123 || n12 == 34) {
                --n10;
                n11 += 2;
            }
            TclList.append(interp, tclObject, TclParser.ParseMakeByteRange(uTF8CharPointer, n5 + n10, n11));
        }
        interp.setResult(tclObject);
    }

    static void ParseVarName(Interp interp, UTF8CharPointer uTF8CharPointer, int n, int n2) throws TclException {
        int n3 = uTF8CharPointer.getCharIndex(n);
        int n4 = uTF8CharPointer.getCharRange(n, n2);
        TclParse tclParse = Parser.parseVarName(interp, uTF8CharPointer.array, n3, n4, null, false);
        if (tclParse.result != 0) {
            TclParser.ParseSetErrorCode(interp, uTF8CharPointer, tclParse);
        }
        ParseMakeTokenListResult parseMakeTokenListResult = new ParseMakeTokenListResult();
        TclParser.ParseMakeTokenList(uTF8CharPointer, tclParse, 0, parseMakeTokenListResult);
        interp.setResult(parseMakeTokenListResult.newList);
    }

    static void ParseSetErrorCode(Interp interp, UTF8CharPointer uTF8CharPointer, TclParse tclParse) throws TclException {
        String string;
        switch (tclParse.errorType) {
            case 1: {
                string = "quoteExtra";
                break;
            }
            case 2: {
                string = "braceExtra";
                break;
            }
            case 3: {
                string = "missingBrace";
                break;
            }
            case 4: {
                string = "missingBracket";
                break;
            }
            case 5: {
                string = "missingParen";
                break;
            }
            case 6: {
                string = "missingQuote";
                break;
            }
            case 7: {
                string = "missingVarBrace";
                break;
            }
            case 8: {
                string = "syntax";
                break;
            }
            case 9: {
                string = "badNumber";
                break;
            }
            default: {
                throw new TclException(interp, "unexpected error type from Tcl_ParseCommand");
            }
        }
        TclObject tclObject = TclList.newInstance();
        TclList.append(interp, tclObject, TclString.newInstance("PARSE"));
        TclList.append(interp, tclObject, TclString.newInstance(string));
        if (tclParse.termIndex > 0) {
            int n = uTF8CharPointer.getByteRange(uTF8CharPointer.index, tclParse.termIndex);
            TclList.append(interp, tclObject, TclInteger.newInstance(n));
        } else {
            TclList.append(interp, tclObject, TclInteger.newInstance(0L));
        }
        TclList.append(interp, tclObject, interp.getResult());
        interp.setErrorCode(tclObject);
        throw new TclException(interp, interp.getResult().toString());
    }

    static int ParseMakeTokenList(UTF8CharPointer uTF8CharPointer, TclParse tclParse, int n, ParseMakeTokenListResult parseMakeTokenListResult) throws TclException {
        String string;
        TclToken tclToken = tclParse.tokenList[n];
        switch (tclToken.type) {
            case 1: {
                string = "word";
                break;
            }
            case 2: {
                string = "simple";
                break;
            }
            case 4: {
                string = "text";
                break;
            }
            case 8: {
                string = "backslash";
                break;
            }
            case 16: {
                string = "command";
                break;
            }
            case 32: {
                string = "variable";
                break;
            }
            case 64: {
                string = "subexpr";
                break;
            }
            case 128: {
                string = "operator";
                break;
            }
            default: {
                string = "unknown";
            }
        }
        TclObject tclObject = TclList.newInstance();
        TclList.append(null, tclObject, TclString.newInstance(string));
        TclList.append(null, tclObject, TclParser.ParseMakeByteRange(uTF8CharPointer, tclToken.script_index, tclToken.size));
        TclObject tclObject2 = TclList.newInstance();
        TclList.append(null, tclObject, tclObject2);
        int n2 = n++;
        ParseMakeTokenListResult parseMakeTokenListResult2 = new ParseMakeTokenListResult();
        while (n <= n2 + tclToken.numComponents) {
            n = TclParser.ParseMakeTokenList(uTF8CharPointer, tclParse, n, parseMakeTokenListResult2);
            TclList.append(null, tclObject2, parseMakeTokenListResult2.newList);
        }
        parseMakeTokenListResult.newList = tclObject;
        return n;
    }

    static TclObject ParseMakeRange(UTF8CharPointer uTF8CharPointer, int n, int n2) throws TclException {
        int n3 = uTF8CharPointer.getByteIndex(uTF8CharPointer.index);
        TclObject tclObject = TclList.newInstance();
        TclList.append(null, tclObject, TclInteger.newInstance(n - n3));
        TclList.append(null, tclObject, TclInteger.newInstance(n2));
        return tclObject;
    }

    static TclObject ParseMakeByteRange(UTF8CharPointer uTF8CharPointer, int n, int n2) throws TclException {
        if (n < 0) {
            throw new TclRuntimeError("char index can't be < 0, was " + n);
        }
        if (n2 < 0) {
            throw new TclRuntimeError("char length can't be < 0, was " + n2);
        }
        int n3 = uTF8CharPointer.getByteIndex(n);
        int n4 = uTF8CharPointer.getByteRange(n, n2);
        return TclParser.ParseMakeRange(uTF8CharPointer, n3, n4);
    }

    static void ParseGetString(Interp interp, UTF8CharPointer uTF8CharPointer, int n, int n2) throws TclException {
        String string = uTF8CharPointer.getByteRangeAsString(n, n2);
        interp.setResult(string);
    }

    static void ParseCharIndex(Interp interp, UTF8CharPointer uTF8CharPointer, int n, int n2) throws TclException {
        int n3 = uTF8CharPointer.getCharIndex(n);
        interp.setResult(n3 - uTF8CharPointer.index);
    }

    static void ParseCharLength(Interp interp, UTF8CharPointer uTF8CharPointer, int n, int n2) throws TclException {
        int n3 = uTF8CharPointer.getCharRange(n, n2);
        interp.setResult(n3);
    }

    static void ParseCountNewline(Interp interp, UTF8CharPointer uTF8CharPointer, int n, TclObject tclObject, TclObject tclObject2) throws TclException {
        int n2;
        int n3;
        int n4;
        int n5 = 0;
        int n6 = TclList.getLength(interp, tclObject);
        ParseGetIndexAndLengthResult parseGetIndexAndLengthResult = new ParseGetIndexAndLengthResult();
        TclParser.ParseGetIndexAndLength(interp, tclObject, n, parseGetIndexAndLengthResult);
        int n7 = parseGetIndexAndLengthResult.indexPtr;
        int n8 = parseGetIndexAndLengthResult.lengthPtr;
        if (tclObject2 != null) {
            n4 = TclList.getLength(interp, tclObject2);
            TclParser.ParseGetIndexAndLength(interp, tclObject2, n, parseGetIndexAndLengthResult);
            n5 = parseGetIndexAndLengthResult.indexPtr;
            int n9 = parseGetIndexAndLengthResult.lengthPtr;
        } else {
            n4 = 0;
        }
        if (n6 == 0 && n4 == 2) {
            n3 = 0;
            n2 = n5;
        } else if (n6 == 2 && n4 == 2) {
            n3 = n7;
            n2 = n5 - n3;
        } else {
            n3 = n7;
            n2 = n8;
        }
        int n10 = n3;
        int n11 = n10 + n2;
        int n12 = 0;
        String string = uTF8CharPointer.getByteRangeAsString(n10, n2);
        int n13 = string.length();
        for (int i = 0; i < n13; ++i) {
            if (string.charAt(i) != '\n') continue;
            ++n12;
        }
        interp.setResult(n12);
    }

    static void ParseGetIndexAndLength(Interp interp, TclObject tclObject, int n, ParseGetIndexAndLengthResult parseGetIndexAndLengthResult) throws TclException {
        int n2 = TclList.getLength(interp, tclObject);
        if (n2 != 0 && n2 != 2) {
            throw new TclException(interp, "invalid range input: incorrect list size");
        }
        if (n2 == 0 && n < 0) {
            throw new TclException(interp, "empty range: no index or length values");
        }
        if (n2 == 0) {
            parseGetIndexAndLengthResult.indexPtr = 0;
            parseGetIndexAndLengthResult.lengthPtr = n;
        } else {
            TclObject tclObject2 = TclList.index(interp, tclObject, 0);
            parseGetIndexAndLengthResult.indexPtr = TclInteger.getInt(interp, tclObject2);
            tclObject2 = TclList.index(interp, tclObject, 1);
            String string = tclObject2.toString();
            int n3 = string.length();
            parseGetIndexAndLengthResult.lengthPtr = string.equals("end") ? n : TclInteger.getInt(interp, tclObject2);
            if (n >= 0) {
                if (parseGetIndexAndLengthResult.indexPtr < 0) {
                    parseGetIndexAndLengthResult.indexPtr = 0;
                }
                if (parseGetIndexAndLengthResult.lengthPtr < 0) {
                    parseGetIndexAndLengthResult.lengthPtr = 0;
                }
                if (parseGetIndexAndLengthResult.indexPtr >= n) {
                    parseGetIndexAndLengthResult.indexPtr = n;
                }
                if (parseGetIndexAndLengthResult.indexPtr + parseGetIndexAndLengthResult.lengthPtr >= n) {
                    parseGetIndexAndLengthResult.lengthPtr = n - parseGetIndexAndLengthResult.indexPtr;
                }
            }
        }
    }

    static class ParseGetIndexAndLengthResult {
        int indexPtr;
        int lengthPtr;

        ParseGetIndexAndLengthResult() {
        }
    }

    static class ParseMakeTokenListResult {
        TclObject newList;

        ParseMakeTokenListResult() {
        }
    }
}

