/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import java.io.UnsupportedEncodingException;
import tcl.lang.CharPointer;
import tcl.lang.InternalRep;
import tcl.lang.TclRuntimeError;
import tcl.lang.cmd.StringCmd;

class UTF8CharPointer
extends CharPointer
implements InternalRep {
    int[] charToByteIndex;
    int[] byteToCharIndex;
    byte[] bytes;
    String orig;

    UTF8CharPointer(String string) {
        super(string);
        this.orig = string;
        this.getByteInfo();
    }

    void getByteInfo() {
        try {
            int n;
            int n2;
            char c;
            boolean bl = true;
            for (int i = 0; i < this.array.length; ++i) {
                c = this.array[i];
                n2 = c == '\u0000' ? 1 : StringCmd.Utf8Count(c);
                if (n2 == 1) continue;
                bl = false;
                break;
            }
            if (bl) {
                this.bytes = null;
                return;
            }
            String string = new String(this.array);
            this.bytes = string.getBytes("UTF8");
            if (string == null) {
                System.out.println("chars is \"" + string + "\" len = " + string.length());
                String string2 = new String(this.bytes, 0, this.bytes.length, "UTF8");
                System.out.println("bytes is \"" + string2 + "\" len = " + this.bytes.length);
            }
            this.charToByteIndex = new int[this.array.length];
            int n3 = 0;
            for (n = 0; n < this.charToByteIndex.length; ++n) {
                this.charToByteIndex[n] = n3;
                c = this.array[n];
                n2 = c == '\u0000' ? 1 : StringCmd.Utf8Count(c);
                n3 += n2;
            }
            int n4 = n3;
            if (this.bytes.length != n4) {
                throw new TclRuntimeError("generated " + this.bytes.length + " but expected to generate " + n4 + " bytes");
            }
            this.byteToCharIndex = new int[this.bytes.length];
            n = 0;
            n3 = 0;
            n2 = 0;
            while (n3 < this.byteToCharIndex.length) {
                if (n3 <= 0 || n2 == 0) {
                    // empty if block
                }
                this.byteToCharIndex[n3] = ++n;
                c = this.array[n];
                if (n2 == 0) {
                    n2 = c == '\u0000' ? 1 : StringCmd.Utf8Count(c);
                }
                ++n3;
                --n2;
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new TclRuntimeError("UTF8 encoding not supported");
        }
    }

    String getByteRangeAsString(int n, int n2) {
        if (this.bytes == null) {
            return this.orig.substring(n, n + n2);
        }
        try {
            return new String(this.bytes, n, n2, "UTF8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new TclRuntimeError("UTF8 encoding not supported");
        }
    }

    int getByteIndex(int n) {
        if (this.bytes == null) {
            return n;
        }
        return this.charToByteIndex[n];
    }

    int getByteRange(int n, int n2) {
        if (this.bytes == null) {
            return n2;
        }
        return this.charToByteIndex[n + n2] - this.charToByteIndex[n];
    }

    int getBytesAtIndex(int n) {
        if (this.bytes == null) {
            return 1;
        }
        return this.charToByteIndex[n + 1] - this.charToByteIndex[n];
    }

    int getByteLength() {
        if (this.bytes == null) {
            return this.orig.length();
        }
        return this.bytes.length - 1;
    }

    int getCharIndex(int n) {
        if (this.bytes == null) {
            return n;
        }
        return this.byteToCharIndex[n];
    }

    int getCharRange(int n, int n2) {
        if (this.bytes == null) {
            return n2;
        }
        return this.byteToCharIndex[n + n2] - this.byteToCharIndex[n];
    }

    @Override
    public String toString() {
        int n;
        if (this.bytes == null) {
            return "1 byte for each character with length " + this.orig.length();
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = this.bytes.length - 1;
        int n3 = this.array.length - 1;
        int n4 = n3;
        if (n2 > n4) {
            n4 = n2;
        }
        stringBuffer.append("index char/byte array: (sizes = " + n3 + " " + n2 + ")\n");
        for (n = 0; n < n4; ++n) {
            String string = "   ";
            String string2 = "   ";
            if (n < n3) {
                string = "'" + this.array[n] + "'";
            }
            if (n < n2) {
                string2 = "'" + (char)this.bytes[n] + "'";
            }
            stringBuffer.append("[" + n + "] = " + string + " " + string2 + "\n");
        }
        stringBuffer.append("\n");
        stringBuffer.append("charToByteIndex array:\n");
        for (n = 0; n < this.charToByteIndex.length - 1; ++n) {
            stringBuffer.append("[" + n + "] = " + this.charToByteIndex[n] + "\n");
        }
        stringBuffer.append("\n");
        stringBuffer.append("byteToCharIndex array:\n");
        for (n = 0; n < this.byteToCharIndex.length - 1; ++n) {
            stringBuffer.append("[" + n + "] = " + this.byteToCharIndex[n] + "\n");
        }
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }

    @Override
    public void dispose() {
    }

    @Override
    public InternalRep duplicate() {
        return this;
    }
}

