/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import java.util.ArrayList;
import java.util.HashMap;
import tcl.lang.Command;
import tcl.lang.CommandTrace;
import tcl.lang.ExecutionTrace;
import tcl.lang.ImportRef;
import tcl.lang.Interp;
import tcl.lang.Namespace;
import tcl.lang.TclException;
import tcl.lang.TclList;
import tcl.lang.TclObject;
import tcl.lang.TclString;

public class WrappedCommand {
    public HashMap<String, WrappedCommand> table;
    public String hashKey;
    public Namespace ns;
    public Command cmd;
    private ArrayList<CommandTrace> commandTraces = null;
    private ArrayList<ExecutionTrace> executionTraces = null;
    private boolean deleteTraceInProgress = false;
    private boolean renameTraceInProgress = false;
    private boolean executionTraceInProgress = false;
    private boolean hasStepTrace = false;
    public boolean deleted;
    ImportRef importRef;
    public int cmdEpoch;

    public boolean hasCommandTraces() {
        return this.commandTraces != null;
    }

    public void removeAllCommandTraces() {
        this.commandTraces = null;
    }

    public void untraceCommand(int n, String string) throws TclException {
        if (this.commandTraces == null) {
            return;
        }
        for (int i = 0; i < this.commandTraces.size(); ++i) {
            CommandTrace commandTrace = this.commandTraces.get(i);
            if (n != commandTrace.getType() || !commandTrace.getCallbackCmd().equals(string)) continue;
            this.commandTraces.remove(i);
            break;
        }
        if (this.commandTraces.size() == 0) {
            this.commandTraces = null;
        }
    }

    public void traceCommand(CommandTrace commandTrace) throws TclException {
        this.untraceCommand(commandTrace.getType(), commandTrace.getCallbackCmd());
        if (this.commandTraces == null) {
            this.commandTraces = new ArrayList();
        }
        this.commandTraces.add(commandTrace);
    }

    public TclObject traceCommandInfo(Interp interp) throws TclException {
        int n;
        if (this.commandTraces == null || this.commandTraces.size() == 0) {
            return TclString.newInstance("");
        }
        TclObject tclObject = TclList.newInstance();
        boolean[] blArray = new boolean[this.commandTraces.size()];
        for (n = 0; n < blArray.length; ++n) {
            blArray[n] = false;
        }
        for (n = 0; n < this.commandTraces.size(); ++n) {
            if (blArray[n]) continue;
            blArray[n] = true;
            TclObject tclObject2 = TclList.newInstance();
            TclList.append(interp, tclObject, tclObject2);
            CommandTrace commandTrace = this.commandTraces.get(n);
            boolean bl = commandTrace.getType() == 0;
            boolean bl2 = commandTrace.getType() == 1;
            for (int i = n + 1; i < this.commandTraces.size(); ++i) {
                CommandTrace commandTrace2;
                if (blArray[i] || !(commandTrace2 = this.commandTraces.get(i)).getCallbackCmd().equals(commandTrace.getCallbackCmd())) continue;
                blArray[i] = true;
                if (commandTrace2.getType() == 0) {
                    bl = true;
                    break;
                }
                bl2 = true;
                break;
            }
            TclObject tclObject3 = TclList.newInstance();
            if (bl2) {
                TclList.append(interp, tclObject3, TclString.newInstance("rename"));
            }
            if (bl) {
                TclList.append(interp, tclObject3, TclString.newInstance("delete"));
            }
            TclList.append(interp, tclObject2, tclObject3);
            TclList.append(interp, tclObject2, TclString.newInstance(commandTrace.getCallbackCmd()));
        }
        return tclObject;
    }

    void callCommandTraces(int n, String string) {
        boolean bl = false;
        switch (n) {
            case 0: {
                bl = this.deleteTraceInProgress;
                this.deleteTraceInProgress = true;
                break;
            }
            case 1: {
                bl = this.renameTraceInProgress;
                this.renameTraceInProgress = true;
            }
        }
        if (this.commandTraces != null && !bl && !this.ns.interp.deleted) {
            Object[] objectArray;
            String string2 = this.ns.fullName + (this.ns.fullName.endsWith("::") ? "" : "::") + this.hashKey;
            for (Object object : objectArray = this.commandTraces.toArray()) {
                ((CommandTrace)object).trace(this.ns.interp, n, string2, n == 0 ? "" : string);
            }
            this.ns.interp.resetResult();
        }
        switch (n) {
            case 0: {
                this.deleteTraceInProgress = false;
                break;
            }
            case 1: {
                this.renameTraceInProgress = false;
            }
        }
    }

    public void traceExecution(ExecutionTrace executionTrace) throws TclException {
        this.untraceExecution(executionTrace.getType(), executionTrace.getCallbackCmd());
        if (this.executionTraces == null) {
            this.executionTraces = new ArrayList();
        }
        this.executionTraces.add(executionTrace);
        if (executionTrace.getType() == 2 || executionTrace.getType() == 3) {
            this.hasStepTrace = true;
        }
    }

    public void untraceExecution(int n, String string) throws TclException {
        if (this.executionTraces == null) {
            return;
        }
        for (int i = 0; i < this.executionTraces.size(); ++i) {
            ExecutionTrace executionTrace = this.executionTraces.get(i);
            if (n != executionTrace.getType() || !executionTrace.getCallbackCmd().equals(string)) continue;
            executionTrace.setDeleted(true);
            this.executionTraces.remove(i);
            break;
        }
        if (this.executionTraces.size() == 0) {
            this.hasStepTrace = false;
            this.executionTraces = null;
        }
        if (this.executionTraces != null && (n == 2 || n == 3)) {
            this.hasStepTrace = false;
            for (ExecutionTrace executionTrace : this.executionTraces) {
                if (executionTrace.getType() != 2 && executionTrace.getType() != 3) continue;
                this.hasStepTrace = true;
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void callExecutionTraces(Interp interp, TclObject[] tclObjectArray, int n, int n2, TclObject tclObject) throws TclException {
        if (this.executionTraces != null && this.executionTraces.size() > 0 && !this.executionTraceInProgress) {
            this.executionTraceInProgress = true;
            TclObject tclObject2 = TclList.newInstance();
            TclList.append(interp, tclObject2, tclObjectArray, 0, tclObjectArray.length);
            ExecutionTrace[] executionTraceArray = new ExecutionTrace[]{};
            executionTraceArray = this.executionTraces.toArray(executionTraceArray);
            try {
                if (n == 0 || n == 2) {
                    for (int i = executionTraceArray.length - 1; i >= 0; --i) {
                        executionTraceArray[i].trace(interp, n, tclObject2.toString(), n2, tclObject);
                    }
                } else {
                    for (int i = 0; i < executionTraceArray.length; ++i) {
                        executionTraceArray[i].trace(interp, n, tclObject2.toString(), n2, tclObject);
                    }
                }
            }
            finally {
                this.executionTraceInProgress = false;
            }
        }
    }

    public TclObject traceExecutionInfo(Interp interp) throws TclException {
        int n;
        if (this.executionTraces == null || this.executionTraces.size() == 0) {
            return TclString.newInstance("");
        }
        TclObject tclObject = TclList.newInstance();
        boolean[] blArray = new boolean[this.executionTraces.size()];
        for (n = 0; n < blArray.length; ++n) {
            blArray[n] = false;
        }
        for (n = 0; n < this.executionTraces.size(); ++n) {
            int n2;
            if (blArray[n]) continue;
            blArray[n] = true;
            TclObject tclObject2 = TclList.newInstance();
            TclList.append(interp, tclObject, tclObject2);
            ExecutionTrace executionTrace = this.executionTraces.get(n);
            boolean[] blArray2 = new boolean[4];
            for (n2 = 0; n2 < 3; ++n2) {
                blArray2[n2] = false;
            }
            blArray2[executionTrace.getType()] = true;
            for (n2 = n + 1; n2 < this.executionTraces.size(); ++n2) {
                ExecutionTrace executionTrace2;
                if (blArray[n2] || !(executionTrace2 = this.executionTraces.get(n2)).getCallbackCmd().equals(executionTrace.getCallbackCmd())) continue;
                blArray[n2] = true;
                blArray2[executionTrace2.getType()] = true;
            }
            TclObject tclObject3 = TclList.newInstance();
            if (blArray2[0]) {
                TclList.append(interp, tclObject3, TclString.newInstance("enter"));
            }
            if (blArray2[2]) {
                TclList.append(interp, tclObject3, TclString.newInstance("enterstep"));
            }
            if (blArray2[1]) {
                TclList.append(interp, tclObject3, TclString.newInstance("leave"));
            }
            if (blArray2[3]) {
                TclList.append(interp, tclObject3, TclString.newInstance("leavestep"));
            }
            TclList.append(interp, tclObject2, tclObject3);
            TclList.append(interp, tclObject2, TclString.newInstance(executionTrace.getCallbackCmd()));
        }
        return tclObject;
    }

    public final boolean mustCallInvoke(Interp interp) {
        return this.executionTraces != null && !this.executionTraceInProgress || interp.hasActiveExecutionStepTraces();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke(Interp interp, TclObject[] tclObjectArray) throws TclException {
        Object object;
        if (!this.mustCallInvoke(interp)) {
            this.cmd.cmdProc(interp, tclObjectArray);
            return;
        }
        TclException tclException = null;
        if (interp.hasActiveExecutionStepTraces()) {
            for (WrappedCommand[] wrappedCommandArray : object = interp.getCopyOfActiveExecutionStepTraces()) {
                wrappedCommandArray.callExecutionTraces(interp, tclObjectArray, 2, 0, null);
            }
        }
        interp.enableExecutionStepTracing(false);
        try {
            this.callExecutionTraces(interp, tclObjectArray, 0, 0, null);
        }
        finally {
            interp.enableExecutionStepTracing(true);
        }
        if (this.deleted) {
            object = Namespace.findCommand(interp, tclObjectArray[0].toString(), this.ns, 0);
            if (object == null) {
                throw new TclException(interp, "invalid command name \"" + tclObjectArray[0] + "\"");
            }
            ((WrappedCommand)object).invoke(interp, tclObjectArray);
            return;
        }
        boolean bl = this.hasStepTrace;
        if (this.hasStepTrace) {
            bl = interp.activateExecutionStepTrace(this);
        }
        try {
            this.cmd.cmdProc(interp, tclObjectArray);
        }
        catch (TclException tclException2) {
            tclException = tclException2;
        }
        if (bl) {
            interp.deactivateExecutionStepTrace(this);
        }
        TclObject tclObject = interp.getResult();
        tclObject.preserve();
        int n = interp.returnCode;
        int n2 = interp.errAlreadyLogged ? 1 : 0;
        try {
            this.callExecutionTraces(interp, tclObjectArray, 1, tclException == null ? 0 : tclException.getCompletionCode(), tclObject);
            if (interp.hasActiveExecutionStepTraces()) {
                WrappedCommand[] wrappedCommandArray;
                for (WrappedCommand wrappedCommand : wrappedCommandArray = interp.getCopyOfActiveExecutionStepTraces()) {
                    wrappedCommand.callExecutionTraces(interp, tclObjectArray, 3, tclException == null ? 0 : tclException.getCompletionCode(), tclObject);
                }
            }
        }
        catch (TclException tclException3) {
            // empty catch block
        }
        interp.errAlreadyLogged = n2;
        interp.returnCode = n;
        interp.setResult(tclObject);
        tclObject.release();
        if (tclException != null) {
            throw tclException;
        }
    }

    void incrEpoch() {
        ++this.cmdEpoch;
        if (this.cmdEpoch == Integer.MIN_VALUE) {
            this.cmdEpoch = 1;
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Wrapper for ");
        if (this.ns != null) {
            stringBuffer.append(this.ns.fullName);
            if (!this.ns.fullName.equals("::")) {
                stringBuffer.append("::");
            }
        }
        if (this.table != null) {
            stringBuffer.append(this.hashKey);
        }
        stringBuffer.append(" -> ");
        stringBuffer.append(this.cmd.getClass().getName());
        stringBuffer.append(" cmdEpoch is ");
        stringBuffer.append(this.cmdEpoch);
        return stringBuffer.toString();
    }
}

