/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang.channel;

import java.net.InetAddress;
import tcl.lang.Interp;
import tcl.lang.TclException;
import tcl.lang.TclInteger;
import tcl.lang.TclList;
import tcl.lang.TclObject;
import tcl.lang.TclString;
import tcl.lang.channel.Channel;

public abstract class AbstractSocketChannel
extends Channel {
    public TclObject getPeerName(Interp interp) throws TclException {
        InetAddress inetAddress = this.getPeerAddress();
        if (inetAddress == null) {
            throw new TclException(interp, "can't get peername: socket is not connected");
        }
        TclObject tclObject = TclList.newInstance();
        TclList.append(interp, tclObject, TclString.newInstance(inetAddress.getHostAddress()));
        TclList.append(interp, tclObject, TclString.newInstance(inetAddress.getHostName()));
        TclList.append(interp, tclObject, TclInteger.newInstance(this.getPeerPort()));
        return tclObject;
    }

    public TclObject getSockName(Interp interp) throws TclException {
        InetAddress inetAddress = this.getLocalAddress();
        if (inetAddress == null) {
            throw new TclException(interp, "can't get localname");
        }
        TclObject tclObject = TclList.newInstance();
        TclList.append(interp, tclObject, TclString.newInstance(inetAddress.getHostAddress()));
        TclList.append(interp, tclObject, TclString.newInstance(inetAddress.getHostName()));
        TclList.append(interp, tclObject, TclInteger.newInstance(this.getLocalPort()));
        return tclObject;
    }

    @Override
    String getChanType() {
        return "tcp";
    }

    @Override
    public void setOutputTranslation(int n) {
        if (n == 0) {
            n = 4;
        }
        super.setOutputTranslation(n);
    }

    public abstract TclObject getError(Interp var1) throws TclException;

    abstract InetAddress getPeerAddress();

    abstract int getPeerPort();

    abstract InetAddress getLocalAddress();

    abstract int getLocalPort();
}

