/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang.channel;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

class EofInputFilter
extends FilterInputStream {
    private byte eofchar;
    private boolean eofSeen = false;
    private boolean sawEofChar = false;
    private int eofCharacterThatWasSeen = 0;

    EofInputFilter(InputStream inputStream) {
        super(inputStream);
        this.eofchar = 0;
    }

    EofInputFilter(InputStream inputStream, byte by) {
        super(inputStream);
        this.eofchar = by;
    }

    void seekReset() {
        this.cancelEof();
        this.sawEofChar = false;
    }

    void cancelEof() {
        this.eofSeen = false;
    }

    void setEofChar(byte by) {
        if (by != this.eofchar) {
            this.cancelEof();
        }
        this.eofchar = by;
    }

    boolean sawEofChar() {
        return this.sawEofChar;
    }

    @Override
    public int available() throws IOException {
        int n = 0;
        try {
            n = this.in.available();
        }
        catch (IOException iOException) {
            n = 0;
        }
        return n + (this.sawEofChar ? 1 : 0);
    }

    @Override
    public int read() throws IOException {
        if (this.eofSeen) {
            return -1;
        }
        if (this.sawEofChar) {
            this.sawEofChar = false;
            return this.eofCharacterThatWasSeen;
        }
        int n = super.read();
        if (n == -1) {
            this.eofSeen = true;
            return -1;
        }
        if (this.eofchar != 0 && n == this.eofchar) {
            this.eofSeen = true;
            this.sawEofChar = true;
            this.eofCharacterThatWasSeen = n;
            return -1;
        }
        return n;
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        int n4;
        if (this.eofSeen) {
            return -1;
        }
        if (this.sawEofChar && n2 > 0) {
            byArray[n] = (byte)(this.eofCharacterThatWasSeen & 0xFF);
            this.sawEofChar = false;
            return 1;
        }
        if (this.eofchar == 0) {
            return super.read(byArray, n, n2);
        }
        for (n4 = 0; n4 < n2 && (n3 = this.read()) != -1; ++n4) {
            byArray[n + n4] = (byte)(n3 & 0xFF);
        }
        return n4;
    }

    @Override
    public void close() throws IOException {
    }
}

