/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang.channel;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.SyncFailedException;
import tcl.lang.FileUtil;
import tcl.lang.Interp;
import tcl.lang.TclException;
import tcl.lang.TclIO;
import tcl.lang.TclPosixException;
import tcl.lang.TclRuntimeError;
import tcl.lang.channel.SeekableChannel;

public class FileChannel
extends SeekableChannel {
    private RandomAccessFile file = null;

    public String open(Interp interp, String string, int n) throws IOException, TclException {
        Object object;
        boolean bl;
        this.mode = n;
        File file = FileUtil.getNewFileObj(interp, string);
        boolean bl2 = bl = (n & 8) != 0 && !file.exists();
        if ((n & 0x10) != 0 && (n & 0x20) != 0 && file.exists()) {
            throw new TclException(interp, "couldn't open \"" + string + "\": file exists");
        }
        if ((n & 0x10) != 0 && !file.exists()) {
            this.file = new RandomAccessFile(file, "rw");
            this.file.close();
        }
        if ((n & 4) != 0) {
            if (!bl) {
                this.checkFileExists(interp, file);
                this.checkReadWritePerm(interp, file, 0);
            }
            if (file.isDirectory()) {
                throw new TclException(interp, "couldn't open \"" + string + "\": illegal operation on a directory");
            }
            this.file = new RandomAccessFile(file, "rw");
        } else if ((n & 1) != 0) {
            this.checkFileExists(interp, file);
            this.checkReadWritePerm(interp, file, -1);
            if (file.isDirectory()) {
                throw new TclException(interp, "couldn't open \"" + string + "\": illegal operation on a directory");
            }
            this.file = new RandomAccessFile(file, "r");
        } else if ((n & 2) != 0) {
            if (!bl) {
                this.checkFileExists(interp, file);
                this.checkReadWritePerm(interp, file, 1);
            }
            if (file.isDirectory()) {
                throw new TclException(interp, "couldn't open \"" + string + "\": illegal operation on a directory");
            }
            if (!bl && !file.canRead()) {
                throw new TclException(interp, "Java IO limitation: Cannot open a file that has only write permissions set.");
            }
            this.file = new RandomAccessFile(file, "rw");
        } else {
            throw new TclRuntimeError("FileChannel.java: invalid mode value");
        }
        if ((n & 8) != 0) {
            this.file.seek(this.file.length());
        }
        if ((n & 0x40) != 0) {
            object = this.file.getChannel();
            ((java.nio.channels.FileChannel)object).truncate(0L);
        }
        object = TclIO.getNextDescriptor(interp, "file");
        this.setChanName((String)object);
        return object;
    }

    @Override
    void implClose() throws IOException {
        if (this.file == null) {
            throw new TclRuntimeError("FileChannel.close(): null file object");
        }
        this.file.close();
        this.file = null;
    }

    @Override
    void sync() throws SyncFailedException, IOException {
        if (this.file != null) {
            this.file.getChannel().force(this.closed);
        }
    }

    @Override
    void implSeek(long l) throws IOException {
        if (this.file == null) {
            throw new TclRuntimeError("FileChannel.seek(): null file object");
        }
        this.file.seek(l);
    }

    @Override
    long implTell() throws IOException {
        if (this.file == null) {
            throw new TclRuntimeError("FileChannel.implTell(): null file object");
        }
        return this.file.getFilePointer();
    }

    @Override
    long getMaxSeek() throws IOException {
        if (this.file == null) {
            throw new TclRuntimeError("FileChannel.getMaxSeek(): null file object");
        }
        return this.file.length();
    }

    private void checkFileExists(Interp interp, File file) throws TclException {
        if (!file.exists()) {
            throw new TclPosixException(interp, 2, true, "couldn't open \"" + file.getName() + "\"");
        }
    }

    private void checkReadWritePerm(Interp interp, File file, int n) throws TclException {
        boolean bl = false;
        if (n <= 0 && !file.canRead()) {
            bl = true;
        }
        if (n >= 0 && !file.canWrite()) {
            bl = true;
        }
        if (bl) {
            throw new TclPosixException(interp, 13, true, "couldn't open \"" + file.getName() + "\"");
        }
    }

    @Override
    String getChanType() {
        return "file";
    }

    @Override
    protected InputStream getInputStream() throws IOException {
        if (this.file == null) {
            throw new IOException("file has not been opened, or has been closed");
        }
        return new FileInputStream(this.file.getFD());
    }

    @Override
    protected OutputStream getOutputStream() throws IOException {
        return new OutputStream(){

            @Override
            public void write(int n) throws IOException {
                if (FileChannel.this.file != null) {
                    FileChannel.this.file.write(n);
                }
            }

            @Override
            public void write(byte[] byArray, int n, int n2) throws IOException {
                if (FileChannel.this.file != null) {
                    FileChannel.this.file.write(byArray, n, n2);
                }
            }
        };
    }
}

