/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang.channel;

import java.io.IOException;
import tcl.lang.Interp;
import tcl.lang.Notifier;
import tcl.lang.TclEvent;
import tcl.lang.TclException;
import tcl.lang.TimerHandler;
import tcl.lang.channel.Channel;
import tcl.lang.channel.FileEventScript;
import tcl.lang.channel.StdChannel;

public class FileEvent
extends TclEvent {
    private static final long FILE_EVENT_DELAY_MS = 30L;
    public static final int READABLE = 0;
    public static final int WRITABLE = 1;
    static boolean stdinUsedForCommandInput = false;
    Interp interp;
    int type;
    Channel channel;

    private FileEvent(Interp interp, Channel channel, int n) {
        this.interp = interp;
        this.channel = channel;
        this.type = n;
    }

    public static void queueFileEvent(Interp interp, Channel channel, int n) {
        Notifier notifier = interp.getNotifier();
        if (notifier != null) {
            FileEvent fileEvent = new FileEvent(interp, channel, n);
            notifier.queueEvent(fileEvent, 0);
        }
    }

    private void requeue() {
        FileEvent.queueFileEvent(this.interp, this.channel, this.type);
    }

    private void requeueLater() {
        new FileEventTimer(30L, this.interp, this.channel, this.type);
    }

    void dispose() {
        FileEventScript.dispose(this.interp, this.channel, this.type);
    }

    @Override
    public int processEvent(int n) {
        FileEventScript fileEventScript = FileEventScript.find(this.interp, this.channel, this.type);
        if (fileEventScript == null) {
            return 1;
        }
        if (this.channel instanceof StdChannel && "stdin".equals(this.channel.getChanName()) && FileEvent.isStdinUsedForCommandInput()) {
            this.requeue();
            return 1;
        }
        if (this.type == 0 && !this.channel.isReadable()) {
            try {
                this.channel.fillInputBuffer();
                this.requeueLater();
            }
            catch (IOException iOException) {
                new TclException(this.interp, iOException.getMessage());
                this.interp.backgroundError();
                this.dispose();
            }
            return 1;
        }
        if (this.type == 1 && !this.channel.isWritable()) {
            this.requeueLater();
            return 1;
        }
        try {
            this.interp.eval(fileEventScript.getScript(), 1);
        }
        catch (TclException tclException) {
            this.interp.backgroundError();
            this.dispose();
            return 1;
        }
        this.requeue();
        return 1;
    }

    public static synchronized boolean isStdinUsedForCommandInput() {
        return stdinUsedForCommandInput;
    }

    public static synchronized boolean setStdinUsedForCommandInput(boolean bl) {
        boolean bl2 = stdinUsedForCommandInput;
        stdinUsedForCommandInput = bl;
        return bl2;
    }

    class FileEventTimer
    extends TimerHandler {
        private Interp interp;
        private Channel channel;
        private int type;

        public FileEventTimer(long l, Interp interp, Channel channel, int n) {
            super(interp.getNotifier(), l);
            this.interp = interp;
            this.channel = channel;
            this.type = n;
        }

        @Override
        public void processTimerEvent() {
            FileEvent.queueFileEvent(this.interp, this.channel, this.type);
        }
    }
}

