/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang.channel;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import tcl.lang.Interp;
import tcl.lang.TclException;
import tcl.lang.TclIO;
import tcl.lang.TclObject;
import tcl.lang.TclPosixException;
import tcl.lang.TclString;
import tcl.lang.channel.AbstractSocketChannel;
import tcl.lang.channel.AcceptThread;
import tcl.lang.channel.SocketConnectionEvent;

public class ServerSocketChannel
extends AbstractSocketChannel {
    private ServerSocket sock;
    private Interp cbInterp;
    private TclObject callback;
    private AcceptThread acceptThread;

    public ServerSocketChannel(Interp interp, String string, int n, TclObject tclObject) throws TclException {
        InetAddress inetAddress = null;
        if (!string.equals("")) {
            try {
                inetAddress = InetAddress.getByName(string);
            }
            catch (UnknownHostException unknownHostException) {
                throw new TclException(interp, "host unkown: " + string);
            }
        }
        this.mode = 16;
        this.callback = tclObject;
        this.callback.preserve();
        this.cbInterp = interp;
        try {
            this.sock = inetAddress == null ? new ServerSocket(n) : new ServerSocket(n, 0, inetAddress);
        }
        catch (IOException iOException) {
            throw new TclException(interp, "couldn't open socket: " + iOException.getMessage().toLowerCase());
        }
        this.acceptThread = new AcceptThread(this.sock, this);
        this.setChanName(TclIO.getNextDescriptor(interp, "sock"));
        this.acceptThread.setDaemon(true);
        this.acceptThread.setName("ServerSocketChannel (" + interp.toString() + "): " + this.getChanName() + " " + string + ":" + n);
        this.acceptThread.start();
    }

    synchronized void addConnection(Socket socket) {
        SocketConnectionEvent socketConnectionEvent = new SocketConnectionEvent(this.cbInterp, this.callback, socket, this.sock);
        this.cbInterp.getNotifier().queueEvent(socketConnectionEvent, 0);
    }

    @Override
    void implClose() throws IOException {
        this.acceptThread.pleaseStop();
        this.sock.close();
        this.callback.release();
    }

    @Override
    public void seek(Interp interp, long l, int n) throws IOException, TclException {
        throw new TclPosixException(interp, 13, true, "error during seek on \"" + this.getChanName() + "\"");
    }

    @Override
    protected InputStream getInputStream() throws IOException {
        throw new RuntimeException("should never be called");
    }

    @Override
    protected OutputStream getOutputStream() throws IOException {
        throw new RuntimeException("should never be called");
    }

    @Override
    public TclObject getError(Interp interp) throws TclException {
        return TclString.newInstance("");
    }

    @Override
    InetAddress getLocalAddress() {
        return this.sock.getInetAddress();
    }

    @Override
    int getLocalPort() {
        return this.sock.getLocalPort();
    }

    @Override
    InetAddress getPeerAddress() {
        return null;
    }

    @Override
    int getPeerPort() {
        return 0;
    }
}

