/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang.channel;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import tcl.lang.ManagedSystemInStream;
import tcl.lang.TclRuntimeError;
import tcl.lang.channel.Channel;

public class StdChannel
extends Channel {
    private int stdType = -1;
    public static final int STDIN = 0;
    public static final int STDOUT = 1;
    public static final int STDERR = 2;
    static InputStream _in = new ManagedSystemInStream();
    static OutputStream _out = System.out;
    static OutputStream _err = System.err;

    @Deprecated
    public static void setIn(InputStream inputStream) {
        _in = inputStream;
    }

    @Deprecated
    public static void setOut(PrintStream printStream) {
        _out = printStream;
    }

    @Deprecated
    public static void setErr(PrintStream printStream) {
        _err = printStream;
    }

    StdChannel() {
    }

    StdChannel(String string) {
        if (string.equals("stdin")) {
            this.open(0);
        } else if (string.equals("stdout")) {
            this.open(1);
        } else if (string.equals("stderr")) {
            this.open(2);
        } else {
            throw new TclRuntimeError("Error: unexpected type for StdChannel");
        }
    }

    public StdChannel(int n) {
        this.open(n);
    }

    String open(int n) {
        switch (n) {
            case 0: {
                this.mode = 1;
                this.setBuffering(1);
                this.setChanName("stdin");
                break;
            }
            case 1: {
                this.mode = 2;
                this.setBuffering(1);
                this.setChanName("stdout");
                break;
            }
            case 2: {
                this.mode = 2;
                this.setBuffering(2);
                this.setChanName("stderr");
                break;
            }
            default: {
                throw new RuntimeException("type does not match one of STDIN, STDOUT, or STDERR");
            }
        }
        this.stdType = n;
        return this.getChanName();
    }

    @Override
    void implClose() throws IOException {
    }

    @Override
    String getChanType() {
        return "tty";
    }

    @Override
    protected InputStream getInputStream() throws IOException {
        if (this.stdType == 0) {
            return _in;
        }
        throw new RuntimeException("Should never be called");
    }

    @Override
    protected OutputStream getOutputStream() throws IOException {
        switch (this.stdType) {
            case 1: {
                return _out;
            }
            case 2: {
                return _err;
            }
        }
        throw new RuntimeException("should never be called");
    }
}

