/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang.cmd;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import tcl.lang.Command;
import tcl.lang.Interp;
import tcl.lang.SearchId;
import tcl.lang.TclException;
import tcl.lang.TclIndex;
import tcl.lang.TclList;
import tcl.lang.TclNumArgsException;
import tcl.lang.TclObject;
import tcl.lang.TclString;
import tcl.lang.TclVarException;
import tcl.lang.Util;
import tcl.lang.Var;

public class ArrayCmd
implements Command {
    static Class procClass = null;
    private static final String[] validCmds = new String[]{"anymore", "donesearch", "exists", "get", "names", "nextelement", "set", "size", "startsearch", "unset"};
    static final int OPT_ANYMORE = 0;
    static final int OPT_DONESEARCH = 1;
    static final int OPT_EXISTS = 2;
    static final int OPT_GET = 3;
    static final int OPT_NAMES = 4;
    static final int OPT_NEXTELEMENT = 5;
    static final int OPT_SET = 6;
    static final int OPT_SIZE = 7;
    static final int OPT_STARTSEARCH = 8;
    static final int OPT_UNSET = 9;

    @Override
    public void cmdProc(Interp interp, TclObject[] tclObjectArray) throws TclException {
        Var var = null;
        Var var2 = null;
        boolean bl = false;
        if (tclObjectArray.length < 3) {
            throw new TclNumArgsException(interp, 1, tclObjectArray, "option arrayName ?arg ...?");
        }
        int n = TclIndex.get(interp, tclObjectArray[1], validCmds, "option", 0);
        String string = tclObjectArray[2].toString();
        Var[] varArray = Var.lookupVar(interp, string, null, 0, null, false, false);
        if (varArray != null) {
            var = varArray[0];
            var2 = varArray[1];
        }
        if (var == null || !var.isVarArray() || var.isVarUndefined()) {
            bl = true;
        }
        if (var != null && var.traces != null && (!var.isVarScalar() || var.isVarUndefined())) {
            String string2 = Var.callTraces(interp, var2, var, string, null, 2563);
            if (string2 != null) {
                throw new TclVarException(interp, string, null, "trace array", string2);
            }
            bl = false;
            varArray = Var.lookupVar(interp, string, null, 0, null, false, false);
            if (varArray != null) {
                var = varArray[0];
                var2 = varArray[1];
            }
            if (var == null || !var.isVarArray() || var.isVarUndefined()) {
                bl = true;
            }
        }
        switch (n) {
            case 0: {
                Iterator iterator;
                if (tclObjectArray.length != 4) {
                    throw new TclNumArgsException(interp, 2, tclObjectArray, "arrayName searchId");
                }
                if (bl) {
                    ArrayCmd.errorNotArray(interp, tclObjectArray[2].toString());
                }
                if (var.sidVec == null) {
                    ArrayCmd.errorIllegalSearchId(interp, tclObjectArray[2].toString(), tclObjectArray[3].toString());
                }
                if ((iterator = var.getSearch(tclObjectArray[3].toString())) == null) {
                    ArrayCmd.errorIllegalSearchId(interp, tclObjectArray[2].toString(), tclObjectArray[3].toString());
                }
                if (iterator.hasNext()) {
                    interp.setResult(true);
                    break;
                }
                interp.setResult(false);
                break;
            }
            case 1: {
                if (tclObjectArray.length != 4) {
                    throw new TclNumArgsException(interp, 2, tclObjectArray, "arrayName searchId");
                }
                if (bl) {
                    ArrayCmd.errorNotArray(interp, tclObjectArray[2].toString());
                }
                boolean bl2 = true;
                if (var.sidVec != null) {
                    bl2 = var.removeSearch(tclObjectArray[3].toString());
                }
                if (var.sidVec != null && bl2) break;
                ArrayCmd.errorIllegalSearchId(interp, tclObjectArray[2].toString(), tclObjectArray[3].toString());
                break;
            }
            case 2: {
                if (tclObjectArray.length != 3) {
                    throw new TclNumArgsException(interp, 2, tclObjectArray, "arrayName");
                }
                interp.setResult(!bl);
                break;
            }
            case 3: {
                if (tclObjectArray.length != 3 && tclObjectArray.length != 4) {
                    throw new TclNumArgsException(interp, 2, tclObjectArray, "arrayName ?pattern?");
                }
                if (bl) {
                    return;
                }
                String string3 = null;
                if (tclObjectArray.length == 4) {
                    string3 = tclObjectArray[3].toString();
                }
                TclObject tclObject = TclList.newInstance();
                String string4 = tclObjectArray[2].toString();
                ArrayList<String> arrayList = new ArrayList<String>();
                for (String string5 : var.getArrayMap().keySet()) {
                    if (string3 != null && !Util.stringMatch(string5, string3)) continue;
                    arrayList.add(string5);
                }
                for (String string5 : arrayList) {
                    Var var3 = var.getArrayMap().get(string5);
                    if (var3 == null || var3.isVarUndefined()) continue;
                    try {
                        String string6 = interp.getVar(string4, string5, 0).toString();
                        TclList.append(interp, tclObject, TclString.newInstance(string5));
                        TclList.append(interp, tclObject, TclString.newInstance(string6));
                    }
                    catch (TclException tclException) {
                        varArray = Var.lookupVar(interp, string, null, 0, null, false, false);
                        if (varArray != null) {
                            var = varArray[0];
                            var2 = varArray[1];
                        }
                        if (var != null && var.isVarArray() && !var.isVarUndefined()) continue;
                        throw tclException;
                    }
                }
                interp.setResult(tclObject);
                break;
            }
            case 4: {
                if (tclObjectArray.length != 3 && tclObjectArray.length != 4) {
                    throw new TclNumArgsException(interp, 2, tclObjectArray, "arrayName ?pattern?");
                }
                if (bl) {
                    return;
                }
                String string7 = null;
                if (tclObjectArray.length == 4) {
                    string7 = tclObjectArray[3].toString();
                }
                Map<String, Var> map = var.getArrayMap();
                TclObject tclObject = TclList.newInstance();
                for (Map.Entry<String, Var> entry : map.entrySet()) {
                    String string8 = entry.getKey();
                    Var var4 = entry.getValue();
                    if (var4.isVarUndefined() || string7 != null && !Util.stringMatch(string8, string7)) continue;
                    TclList.append(interp, tclObject, TclString.newInstance(string8));
                }
                interp.setResult(tclObject);
                break;
            }
            case 5: {
                Iterator iterator;
                if (tclObjectArray.length != 4) {
                    throw new TclNumArgsException(interp, 2, tclObjectArray, "arrayName searchId");
                }
                if (bl) {
                    ArrayCmd.errorNotArray(interp, tclObjectArray[2].toString());
                }
                if (var.sidVec == null) {
                    ArrayCmd.errorIllegalSearchId(interp, tclObjectArray[2].toString(), tclObjectArray[3].toString());
                }
                if ((iterator = var.getSearch(tclObjectArray[3].toString())) == null) {
                    ArrayCmd.errorIllegalSearchId(interp, tclObjectArray[2].toString(), tclObjectArray[3].toString());
                }
                if (!iterator.hasNext()) break;
                Map.Entry entry = (Map.Entry)iterator.next();
                String string9 = (String)entry.getKey();
                Var var5 = (Var)entry.getValue();
                if (!var5.isVarUndefined()) {
                    interp.setResult(string9);
                    break;
                }
                interp.setResult("");
                break;
            }
            case 6: {
                if (tclObjectArray.length != 4) {
                    throw new TclNumArgsException(interp, 2, tclObjectArray, "arrayName list");
                }
                int n2 = TclList.getLength(interp, tclObjectArray[3]);
                if (n2 % 2 != 0) {
                    throw new TclException(interp, "list must have an even number of elements");
                }
                String string10 = tclObjectArray[2].toString();
                if (string10.endsWith(")") && string10.contains("(")) {
                    throw new TclVarException(interp, string10, null, "set", "variable isn't array");
                }
                Var.lookupVar(interp, string10, "", 0, "set", true, false);
                for (int i = 0; i < n2; ++i) {
                    String string11 = TclList.index(interp, tclObjectArray[3], i++).toString();
                    String string12 = TclList.index(interp, tclObjectArray[3], i).toString();
                    interp.setVar(string10, string11, TclString.newInstance(string12), 0);
                }
                break;
            }
            case 7: {
                if (tclObjectArray.length != 3) {
                    throw new TclNumArgsException(interp, 2, tclObjectArray, "arrayName");
                }
                if (bl) {
                    interp.setResult(0L);
                    break;
                }
                Map<String, Var> map = var.getArrayMap();
                int n3 = 0;
                for (Map.Entry<String, Var> entry : map.entrySet()) {
                    String string13 = entry.getKey();
                    Var var6 = entry.getValue();
                    if (var6.isVarUndefined()) continue;
                    ++n3;
                }
                interp.setResult(n3);
                break;
            }
            case 8: {
                if (tclObjectArray.length != 3) {
                    throw new TclNumArgsException(interp, 2, tclObjectArray, "arrayName");
                }
                if (bl) {
                    ArrayCmd.errorNotArray(interp, tclObjectArray[2].toString());
                }
                if (var.sidVec == null) {
                    var.sidVec = new ArrayList();
                }
                int n4 = var.getNextIndex();
                String string14 = "s-" + n4 + "-" + tclObjectArray[2].toString();
                Map<String, Var> map = var.getArrayMap();
                Iterator<Map.Entry<String, Var>> iterator = map.entrySet().iterator();
                var.sidVec.add(new SearchId(iterator, string14, n4));
                interp.setResult(string14);
                break;
            }
            case 9: {
                if (tclObjectArray.length != 3 && tclObjectArray.length != 4) {
                    throw new TclNumArgsException(interp, 2, tclObjectArray, "arrayName ?pattern?");
                }
                if (bl) {
                    return;
                }
                if (tclObjectArray.length == 3) {
                    interp.unsetVar(tclObjectArray[2], 0);
                    break;
                }
                String string15 = tclObjectArray[3].toString();
                Map<String, Var> map = var.getArrayMap();
                Iterator<Map.Entry<String, Var>> iterator = map.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<String, Var> entry = iterator.next();
                    String string16 = entry.getKey();
                    Var var7 = entry.getValue();
                    if (var7.isVarUndefined() || !Util.stringMatch(string16, string15)) continue;
                    interp.unsetVar(string, string16, 0);
                    iterator = map.entrySet().iterator();
                }
                break;
            }
        }
    }

    private static void errorNotArray(Interp interp, String string) throws TclException {
        throw new TclException(interp, "\"" + string + "\" isn't an array");
    }

    static void errorIllegalSearchId(Interp interp, String string, String string2) throws TclException {
        int n = ArrayCmd.validSearchId(string2.toCharArray(), string);
        if (n == 1) {
            throw new TclException(interp, "couldn't find search \"" + string2 + "\"");
        }
        if (n == 0) {
            throw new TclException(interp, "illegal search identifier \"" + string2 + "\"");
        }
        throw new TclException(interp, "search identifier \"" + string2 + "\" isn't for variable \"" + string + "\"");
    }

    private static int validSearchId(char[] cArray, String string) {
        int n;
        if (cArray[0] != 's' || cArray[1] != '-' || cArray[2] < '0' || cArray[2] > '9') {
            return 0;
        }
        for (n = 3; n < cArray.length && cArray[n] != '-'; ++n) {
            if (cArray[n] >= '0' && cArray[n] <= '9') continue;
            return 0;
        }
        if (++n >= cArray.length) {
            return 0;
        }
        if (string.equals(new String(cArray, n, cArray.length - n))) {
            return 1;
        }
        return -1;
    }
}

