/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang.cmd;

import java.text.ParsePosition;
import tcl.lang.Command;
import tcl.lang.Interp;
import tcl.lang.TclByteArray;
import tcl.lang.TclDouble;
import tcl.lang.TclException;
import tcl.lang.TclIndex;
import tcl.lang.TclInteger;
import tcl.lang.TclList;
import tcl.lang.TclNumArgsException;
import tcl.lang.TclObject;
import tcl.lang.TclString;

public class BinaryCmd
implements Command {
    private static final String[] validCmds = new String[]{"format", "scan"};
    private static final int CMD_FORMAT = 0;
    private static final int CMD_SCAN = 1;
    private static final int BINARY_ALL = -1;
    private static final int BINARY_NOCOUNT = -2;
    private static final char FORMAT_END = ' ';

    @Override
    public void cmdProc(Interp interp, TclObject[] tclObjectArray) throws TclException {
        char[] cArray = null;
        int n = 0;
        int n2 = 0;
        if (tclObjectArray.length < 2) {
            throw new TclNumArgsException(interp, 1, tclObjectArray, "option ?arg arg ...?");
        }
        int n3 = TclIndex.get(interp, tclObjectArray[1], validCmds, "option", 0);
        switch (n3) {
            case 0: {
                int n4;
                char c;
                if (tclObjectArray.length < 3) {
                    throw new TclNumArgsException(interp, 2, tclObjectArray, "formatString ?arg arg ...?");
                }
                cArray = tclObjectArray[2].toString().toCharArray();
                int n5 = 3;
                int n6 = 0;
                int n7 = 0;
                ParsePosition parsePosition = new ParsePosition(0);
                block50: while ((c = this.GetFormatSpec(cArray, parsePosition)) != ' ') {
                    int n8 = this.GetFormatCount(cArray, parsePosition);
                    switch (c) {
                        case 'A': 
                        case 'B': 
                        case 'H': 
                        case 'a': 
                        case 'b': 
                        case 'h': {
                            if (n5 >= tclObjectArray.length) {
                                BinaryCmd.missingArg(interp);
                            }
                            if (n8 == -1) {
                                n8 = TclByteArray.getLength(interp, tclObjectArray[n5]);
                            } else if (n8 == -2) {
                                n8 = 1;
                            }
                            ++n5;
                            switch (c) {
                                case 'A': 
                                case 'a': {
                                    n7 += n8;
                                    break;
                                }
                                case 'B': 
                                case 'b': {
                                    n7 += (n8 + 7) / 8;
                                    break;
                                }
                                case 'H': 
                                case 'h': {
                                    n7 += (n8 + 1) / 2;
                                }
                            }
                            continue block50;
                        }
                        case 'I': 
                        case 'S': 
                        case 'W': 
                        case 'c': 
                        case 'd': 
                        case 'f': 
                        case 'i': 
                        case 's': 
                        case 'w': {
                            if (n5 >= tclObjectArray.length) {
                                BinaryCmd.missingArg(interp);
                            }
                            switch (c) {
                                case 'c': {
                                    n2 = 1;
                                    break;
                                }
                                case 'S': 
                                case 's': {
                                    n2 = 2;
                                    break;
                                }
                                case 'I': 
                                case 'i': {
                                    n2 = 4;
                                    break;
                                }
                                case 'W': 
                                case 'w': {
                                    n2 = 8;
                                    break;
                                }
                                case 'f': {
                                    n2 = 4;
                                    break;
                                }
                                case 'd': {
                                    n2 = 8;
                                }
                            }
                            if (n8 == -2) {
                                ++n5;
                                n8 = 1;
                            } else {
                                int n9 = TclList.getLength(interp, tclObjectArray[n5++]);
                                if (n8 == -1) {
                                    n8 = n9;
                                } else if (n8 > n9) {
                                    throw new TclException(interp, "number of elements in list does not match count");
                                }
                            }
                            n7 += n8 * n2;
                            continue block50;
                        }
                        case 'x': {
                            if (n8 == -1) {
                                throw new TclException(interp, "cannot use \"*\" in format string with \"x\"");
                            }
                            if (n8 == -2) {
                                n8 = 1;
                            }
                            n7 += n8;
                            continue block50;
                        }
                        case 'X': {
                            if (n8 == -2) {
                                n8 = 1;
                            }
                            if (n8 > n7 || n8 == -1) {
                                n8 = n7;
                            }
                            if (n7 > n6) {
                                n6 = n7;
                            }
                            n7 -= n8;
                            continue block50;
                        }
                        case '@': {
                            if (n7 > n6) {
                                n6 = n7;
                            }
                            if (n8 == -1) {
                                n7 = n6;
                                continue block50;
                            }
                            if (n8 == -2) {
                                BinaryCmd.alephWithoutCount(interp);
                                continue block50;
                            }
                            n7 = n8;
                            continue block50;
                        }
                    }
                    BinaryCmd.badField(interp, c);
                }
                if (n7 > n6) {
                    n6 = n7;
                }
                if (n6 == 0) {
                    return;
                }
                TclObject tclObject = TclByteArray.newInstance();
                byte[] byArray = TclByteArray.setLength(interp, tclObject, n6);
                interp.setResult(tclObject);
                n5 = 3;
                int n10 = n4 = 0;
                parsePosition.setIndex(0);
                block51: while ((c = this.GetFormatSpec(cArray, parsePosition)) != ' ') {
                    int n11 = this.GetFormatCount(cArray, parsePosition);
                    if (n11 == 0 && c != '@') {
                        if (c == 'x') continue;
                        ++n5;
                        continue;
                    }
                    switch (c) {
                        case 'A': 
                        case 'a': {
                            int n12;
                            int n13 = c == 'a' ? 0 : 32;
                            byte[] byArray2 = TclByteArray.getBytes(interp, tclObjectArray[n5++]);
                            n6 = byArray2.length;
                            if (n11 == -1) {
                                n11 = n6;
                            } else if (n11 == -2) {
                                n11 = 1;
                            }
                            if (n6 >= n11) {
                                System.arraycopy(byArray2, 0, byArray, n4, n11);
                            } else {
                                System.arraycopy(byArray2, 0, byArray, n4, n6);
                                for (n12 = 0; n12 < n11 - n6; ++n12) {
                                    byArray[n4 + n6 + n12] = n13;
                                }
                            }
                            n4 += n11;
                            break;
                        }
                        case 'B': 
                        case 'b': {
                            char[] cArray2 = tclObjectArray[n5++].toString().toCharArray();
                            if (n11 == -1) {
                                n11 = cArray2.length;
                            } else if (n11 == -2) {
                                n11 = 1;
                            }
                            int n14 = n4 + (n11 + 7) / 8;
                            if (n11 > cArray2.length) {
                                n11 = cArray2.length;
                            }
                            if (c == 'B') {
                                for (n7 = 0; n7 < n11; ++n7) {
                                    n <<= 1;
                                    if (cArray2[n7] == '1') {
                                        n |= 1;
                                    } else if (cArray2[n7] != '0') {
                                        BinaryCmd.expectedButGot(interp, "binary", new String(cArray2));
                                    }
                                    if ((n7 + 1) % 8 != 0) continue;
                                    byArray[n4++] = (byte)n;
                                    n = 0;
                                }
                            } else {
                                for (n7 = 0; n7 < n11; ++n7) {
                                    n >>= 1;
                                    if (cArray2[n7] == '1') {
                                        n |= 0x80;
                                    } else if (cArray2[n7] != '0') {
                                        BinaryCmd.expectedButGot(interp, "binary", new String(cArray2));
                                    }
                                    if ((n7 + 1) % 8 != 0) continue;
                                    byArray[n4++] = (byte)n;
                                    n = 0;
                                }
                            }
                            if (n7 % 8 != 0) {
                                n = c == 'B' ? (n <<= 8 - n7 % 8) : (n >>= 8 - n7 % 8);
                                byArray[n4++] = (byte)n;
                            }
                            while (n4 < n14) {
                                byArray[n4++] = 0;
                            }
                            break;
                        }
                        case 'H': 
                        case 'h': {
                            int n12;
                            char[] cArray3 = tclObjectArray[n5++].toString().toCharArray();
                            if (n11 == -1) {
                                n11 = cArray3.length;
                            } else if (n11 == -2) {
                                n11 = 1;
                            }
                            int n15 = n4 + (n11 + 1) / 2;
                            if (n11 > cArray3.length) {
                                n11 = cArray3.length;
                            }
                            if (c == 'H') {
                                for (n7 = 0; n7 < n11; ++n7) {
                                    n <<= 4;
                                    n12 = Character.digit(cArray3[n7], 16);
                                    if (n12 < 0) {
                                        BinaryCmd.expectedButGot(interp, "hexadecimal", new String(cArray3));
                                    }
                                    n |= n12 & 0xF;
                                    if (n7 % 2 == 0) continue;
                                    byArray[n4++] = (byte)n;
                                    n = 0;
                                }
                            } else {
                                for (n7 = 0; n7 < n11; ++n7) {
                                    n >>= 4;
                                    n12 = Character.digit(cArray3[n7], 16);
                                    if (n12 < 0) {
                                        BinaryCmd.expectedButGot(interp, "hexadecimal", new String(cArray3));
                                    }
                                    n |= n12 << 4 & 0xF0;
                                    if (n7 % 2 == 0) continue;
                                    byArray[n4++] = (byte)n;
                                    n = 0;
                                }
                            }
                            if (n7 % 2 != 0) {
                                n = c == 'H' ? (n <<= 4) : (n >>= 4);
                                byArray[n4++] = (byte)n;
                            }
                            while (n4 < n15) {
                                byArray[n4++] = 0;
                            }
                            break;
                        }
                        case 'I': 
                        case 'S': 
                        case 'W': 
                        case 'c': 
                        case 'd': 
                        case 'f': 
                        case 'i': 
                        case 's': 
                        case 'w': {
                            TclObject[] tclObjectArray2;
                            if (n11 == -2) {
                                tclObjectArray2 = new TclObject[]{tclObjectArray[n5++]};
                                n11 = 1;
                            } else {
                                tclObjectArray2 = TclList.getElements(interp, tclObjectArray[n5++]);
                                if (n11 == -1) {
                                    n11 = tclObjectArray2.length;
                                }
                            }
                            for (int i = 0; i < n11; ++i) {
                                n4 = BinaryCmd.FormatNumber(interp, c, tclObjectArray2[i], byArray, n4);
                            }
                            continue block51;
                        }
                        case 'x': {
                            int n13;
                            if (n11 == -2) {
                                n11 = 1;
                            }
                            for (n13 = 0; n13 < n11; ++n13) {
                                byArray[n4++] = 0;
                            }
                            continue block51;
                        }
                        case 'X': {
                            if (n4 > n10) {
                                n10 = n4;
                            }
                            if (n11 == -2) {
                                n11 = 1;
                            }
                            if (n11 == -1 || n11 > n4) {
                                n4 = 0;
                                break;
                            }
                            n4 -= n11;
                            break;
                        }
                        case '@': {
                            if (n4 > n10) {
                                n10 = n4;
                            }
                            n4 = n11 == -1 ? n10 : n11;
                        }
                    }
                }
                break;
            }
            case 1: {
                char c;
                if (tclObjectArray.length < 4) {
                    throw new TclNumArgsException(interp, 2, tclObjectArray, "value formatString ?varName varName ...?");
                }
                byte[] byArray = TclByteArray.getBytes(interp, tclObjectArray[2]);
                int n16 = byArray.length;
                cArray = tclObjectArray[3].toString().toCharArray();
                int n17 = 4;
                boolean bl = false;
                int n18 = 0;
                ParsePosition parsePosition = new ParsePosition(0);
                while ((c = this.GetFormatSpec(cArray, parsePosition)) != ' ') {
                    int n19 = this.GetFormatCount(cArray, parsePosition);
                    switch (c) {
                        case 'A': 
                        case 'a': {
                            if (n17 >= tclObjectArray.length) {
                                BinaryCmd.missingArg(interp);
                            }
                            if (n19 == -1) {
                                n19 = n16 - n18;
                            } else {
                                if (n19 == -2) {
                                    n19 = 1;
                                }
                                if (n19 > n16 - n18) break;
                            }
                            if (c == 'A') {
                                for (n2 = n19; n2 > 0 && (byArray[n18 + n2 - 1] == 0 || byArray[n18 + n2 - 1] == 32); --n2) {
                                }
                            }
                            interp.setVar(tclObjectArray[n17++], TclByteArray.newInstance(byArray, n18, n2), 0);
                            n18 += n19;
                            break;
                        }
                        case 'B': 
                        case 'b': {
                            int n20;
                            if (n17 >= tclObjectArray.length) {
                                BinaryCmd.missingArg(interp);
                            }
                            if (n19 == -1) {
                                n19 = (n16 - n18) * 8;
                            } else {
                                if (n19 == -2) {
                                    n19 = 1;
                                }
                                if (n19 > (n16 - n18) * 8) break;
                            }
                            Object object = new StringBuffer(n19);
                            int n21 = n18;
                            if (c == 'b') {
                                for (n20 = 0; n20 < n19; ++n20) {
                                    n = n20 % 8 != 0 ? (n >>= 1) : byArray[n21++];
                                    ((StringBuffer)object).append((n & 1) != 0 ? (char)'1' : '0');
                                }
                            } else {
                                for (n20 = 0; n20 < n19; ++n20) {
                                    n = n20 % 8 != 0 ? (n <<= 1) : byArray[n21++];
                                    ((StringBuffer)object).append((n & 0x80) != 0 ? (char)'1' : '0');
                                }
                            }
                            interp.setVar(tclObjectArray[n17++], TclString.newInstance(((StringBuffer)object).toString()), 0);
                            n18 += (n19 + 7) / 8;
                            break;
                        }
                        case 'H': 
                        case 'h': {
                            int n20;
                            if (n17 >= tclObjectArray.length) {
                                BinaryCmd.missingArg(interp);
                            }
                            if (n19 == -1) {
                                n19 = (n16 - n18) * 2;
                            } else {
                                if (n19 == -2) {
                                    n19 = 1;
                                }
                                if (n19 > (n16 - n18) * 2) break;
                            }
                            Object object = new StringBuffer(n19);
                            int n21 = n18;
                            if (c == 'h') {
                                for (n20 = 0; n20 < n19; ++n20) {
                                    n = n20 % 2 != 0 ? (n >>= 4) : byArray[n21++];
                                    ((StringBuffer)object).append(Character.forDigit(n & 0xF, 16));
                                }
                            } else {
                                for (n20 = 0; n20 < n19; ++n20) {
                                    n = n20 % 2 != 0 ? (n <<= 4) : byArray[n21++];
                                    ((StringBuffer)object).append(Character.forDigit(n >> 4 & 0xF, 16));
                                }
                            }
                            interp.setVar(tclObjectArray[n17++], TclString.newInstance(((StringBuffer)object).toString()), 0);
                            n18 += (n19 + 1) / 2;
                            break;
                        }
                        case 'I': 
                        case 'S': 
                        case 'W': 
                        case 'c': 
                        case 'd': 
                        case 'f': 
                        case 'i': 
                        case 's': 
                        case 'w': {
                            int n20;
                            int n21;
                            Object object;
                            if (n17 >= tclObjectArray.length) {
                                BinaryCmd.missingArg(interp);
                            }
                            switch (c) {
                                case 'c': {
                                    n2 = 1;
                                    break;
                                }
                                case 'S': 
                                case 's': {
                                    n2 = 2;
                                    break;
                                }
                                case 'I': 
                                case 'i': {
                                    n2 = 4;
                                    break;
                                }
                                case 'f': {
                                    n2 = 4;
                                    break;
                                }
                                case 'd': {
                                    n2 = 8;
                                    break;
                                }
                                case 'W': 
                                case 'w': {
                                    n2 = 8;
                                }
                            }
                            if (n19 == -2) {
                                if (n16 - n18 < n2) break;
                                object = BinaryCmd.ScanNumber(byArray, n18, c);
                                n18 += n2;
                            } else {
                                if (n19 == -1) {
                                    n19 = (n16 - n18) / n2;
                                }
                                if (n16 - n18 < n19 * n2) break;
                                object = TclList.newInstance();
                                n21 = n18;
                                for (n20 = 0; n20 < n19; ++n20) {
                                    TclList.append(null, (TclObject)object, BinaryCmd.ScanNumber(byArray, n21, c));
                                    n21 += n2;
                                }
                                n18 += n19 * n2;
                            }
                            interp.setVar(tclObjectArray[n17++], (TclObject)object, 0);
                            break;
                        }
                        case 'x': {
                            if (n19 == -2) {
                                n19 = 1;
                            }
                            if (n19 == -1 || n19 > n16 - n18) {
                                n18 = n16;
                                break;
                            }
                            n18 += n19;
                            break;
                        }
                        case 'X': {
                            if (n19 == -2) {
                                n19 = 1;
                            }
                            if (n19 == -1 || n19 > n18) {
                                n18 = 0;
                                break;
                            }
                            n18 -= n19;
                            break;
                        }
                        case '@': {
                            if (n19 == -2) {
                                BinaryCmd.alephWithoutCount(interp);
                            }
                            if (n19 == -1 || n19 > n16) {
                                n18 = n16;
                                break;
                            }
                            n18 = n19;
                            break;
                        }
                        default: {
                            BinaryCmd.badField(interp, c);
                        }
                    }
                }
                interp.setResult(n17 - 4);
            }
        }
    }

    private char GetFormatSpec(char[] cArray, ParsePosition parsePosition) {
        int n;
        for (n = parsePosition.getIndex(); n < cArray.length && cArray[n] == ' '; ++n) {
        }
        if (n >= cArray.length) {
            parsePosition.setIndex(n);
            return ' ';
        }
        parsePosition.setIndex(n + 1);
        return cArray[n++];
    }

    private int GetFormatCount(char[] cArray, ParsePosition parsePosition) {
        int n = parsePosition.getIndex();
        if (n < cArray.length && cArray[n] == '*') {
            parsePosition.setIndex(n + 1);
            return -1;
        }
        if (n < cArray.length && Character.isDigit(cArray[n])) {
            int n2 = 1;
            while (n + n2 < cArray.length && Character.isDigit(cArray[n + n2])) {
                ++n2;
            }
            parsePosition.setIndex(n + n2);
            return Integer.parseInt(new String(cArray, n, n2));
        }
        return -2;
    }

    static int FormatNumber(Interp interp, char c, TclObject tclObject, byte[] byArray, int n) throws TclException {
        if (c == 'd') {
            double d = TclDouble.get(interp, tclObject);
            long l = Double.doubleToLongBits(d);
            for (int i = 7; i >= 0; --i) {
                byArray[n++] = (byte)(l >> i * 8);
            }
        } else if (c == 'f') {
            double d = TclDouble.get(interp, tclObject);
            float f = d == Double.POSITIVE_INFINITY ? Float.POSITIVE_INFINITY : (d == Double.NEGATIVE_INFINITY ? Float.NEGATIVE_INFINITY : (Math.abs(d) > 3.4028234663852886E38 ? (d >= 0.0 ? Float.MAX_VALUE : -3.4028235E38f) : (Math.abs(d) < (double)1.4E-45f ? (d >= 0.0 ? 0.0f : -0.0f) : (float)d)));
            int n2 = Float.floatToIntBits(f);
            for (int i = 3; i >= 0; --i) {
                byArray[n++] = (byte)(n2 >> i * 8);
            }
        } else {
            long l = TclInteger.getLong(interp, tclObject);
            switch (c) {
                case 'c': {
                    byArray[n++] = (byte)l;
                    break;
                }
                case 's': {
                    byArray[n++] = (byte)l;
                    byArray[n++] = (byte)(l >> 8);
                    break;
                }
                case 'S': {
                    byArray[n++] = (byte)(l >> 8);
                    byArray[n++] = (byte)l;
                    break;
                }
                case 'i': {
                    byArray[n++] = (byte)l;
                    byArray[n++] = (byte)(l >> 8);
                    byArray[n++] = (byte)(l >> 16);
                    byArray[n++] = (byte)(l >> 24);
                    break;
                }
                case 'I': {
                    byArray[n++] = (byte)(l >> 24);
                    byArray[n++] = (byte)(l >> 16);
                    byArray[n++] = (byte)(l >> 8);
                    byArray[n++] = (byte)l;
                    break;
                }
                case 'w': {
                    byArray[n++] = (byte)l;
                    byArray[n++] = (byte)(l >> 8);
                    byArray[n++] = (byte)(l >> 16);
                    byArray[n++] = (byte)(l >> 24);
                    byArray[n++] = (byte)(l >> 32);
                    byArray[n++] = (byte)(l >> 40);
                    byArray[n++] = (byte)(l >> 48);
                    byArray[n++] = (byte)(l >> 56);
                    break;
                }
                case 'W': {
                    byArray[n++] = (byte)(l >> 56);
                    byArray[n++] = (byte)(l >> 48);
                    byArray[n++] = (byte)(l >> 40);
                    byArray[n++] = (byte)(l >> 32);
                    byArray[n++] = (byte)(l >> 24);
                    byArray[n++] = (byte)(l >> 16);
                    byArray[n++] = (byte)(l >> 8);
                    byArray[n++] = (byte)l;
                }
            }
        }
        return n;
    }

    private static TclObject ScanNumber(byte[] byArray, int n, int n2) {
        switch (n2) {
            case 99: {
                return TclInteger.newInstance(byArray[n]);
            }
            case 115: {
                short s = (short)((byArray[n] & 0xFF) + ((byArray[n + 1] & 0xFF) << 8));
                return TclInteger.newInstance(s);
            }
            case 83: {
                short s = (short)((byArray[n + 1] & 0xFF) + ((byArray[n] & 0xFF) << 8));
                return TclInteger.newInstance(s);
            }
            case 105: {
                int n3 = (byArray[n] & 0xFF) + ((byArray[n + 1] & 0xFF) << 8) + ((byArray[n + 2] & 0xFF) << 16) + ((byArray[n + 3] & 0xFF) << 24);
                return TclInteger.newInstance(n3);
            }
            case 73: {
                int n4 = (byArray[n + 3] & 0xFF) + ((byArray[n + 2] & 0xFF) << 8) + ((byArray[n + 1] & 0xFF) << 16) + ((byArray[n] & 0xFF) << 24);
                return TclInteger.newInstance(n4);
            }
            case 119: {
                long l = ((long)byArray[n] & 0xFFL) + (((long)byArray[n + 1] & 0xFFL) << 8) + (((long)byArray[n + 2] & 0xFFL) << 16) + (((long)byArray[n + 3] & 0xFFL) << 24) + (((long)byArray[n + 4] & 0xFFL) << 32) + (((long)byArray[n + 5] & 0xFFL) << 40) + (((long)byArray[n + 6] & 0xFFL) << 48) + (((long)byArray[n + 7] & 0xFFL) << 56);
                return TclInteger.newInstance(l);
            }
            case 87: {
                long l = ((long)byArray[n + 7] & 0xFFL) + (((long)byArray[n + 6] & 0xFFL) << 8) + (((long)byArray[n + 5] & 0xFFL) << 16) + (((long)byArray[n + 4] & 0xFFL) << 24) + (((long)byArray[n + 3] & 0xFFL) << 32) + (((long)byArray[n + 2] & 0xFFL) << 40) + (((long)byArray[n + 1] & 0xFFL) << 48) + (((long)byArray[n] & 0xFFL) << 56);
                return TclInteger.newInstance(l);
            }
            case 102: {
                int n5 = (byArray[n + 3] & 0xFF) + ((byArray[n + 2] & 0xFF) << 8) + ((byArray[n + 1] & 0xFF) << 16) + ((byArray[n] & 0xFF) << 24);
                return TclDouble.newInstance(Float.intBitsToFloat(n5));
            }
            case 100: {
                long l = ((long)byArray[n + 7] & 0xFFL) + ((long)(byArray[n + 6] & 0xFF) << 8) + ((long)(byArray[n + 5] & 0xFF) << 16) + ((long)(byArray[n + 4] & 0xFF) << 24) + ((long)(byArray[n + 3] & 0xFF) << 32) + ((long)(byArray[n + 2] & 0xFF) << 40) + ((long)(byArray[n + 1] & 0xFF) << 48) + ((long)(byArray[n] & 0xFF) << 56);
                return TclDouble.newInstance(Double.longBitsToDouble(l));
            }
        }
        return null;
    }

    private static void missingArg(Interp interp) throws TclException {
        throw new TclException(interp, "not enough arguments for all format specifiers");
    }

    private static void badField(Interp interp, char c) throws TclException {
        throw new TclException(interp, "bad field specifier \"" + c + "\"");
    }

    private static void alephWithoutCount(Interp interp) throws TclException {
        throw new TclException(interp, "missing count for \"@\" field specifier");
    }

    private static void expectedButGot(Interp interp, String string, String string2) throws TclException {
        throw new TclException(interp, "expected " + string + " string but got \"" + string2 + "\" instead");
    }
}

