/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang.cmd;

import tcl.lang.Command;
import tcl.lang.Interp;
import tcl.lang.Pipeline;
import tcl.lang.TclException;
import tcl.lang.TclIO;
import tcl.lang.TclNumArgsException;
import tcl.lang.TclObject;
import tcl.lang.TclString;
import tcl.lang.channel.Channel;
import tcl.lang.channel.PipelineChannel;

public class CloseCmd
implements Command {
    @Override
    public void cmdProc(Interp interp, TclObject[] tclObjectArray) throws TclException {
        if (tclObjectArray.length != 2) {
            throw new TclNumArgsException(interp, 1, tclObjectArray, "channelId");
        }
        Channel channel = TclIO.getChannel(interp, tclObjectArray[1].toString());
        if (channel == null) {
            throw new TclException(interp, "can not find channel named \"" + tclObjectArray[1].toString() + "\"");
        }
        TclIO.unregisterChannel(interp, channel);
        if (channel.getBlocking() && channel instanceof PipelineChannel) {
            Pipeline pipeline = ((PipelineChannel)channel).getPipeline();
            int[] nArray = pipeline.getProcessIdentifiers();
            int[] nArray2 = pipeline.getExitValues();
            boolean bl = false;
            for (int i = 0; i < nArray2.length; ++i) {
                if (nArray2[i] == 0) continue;
                bl = true;
                interp.setErrorCode(TclString.newInstance("CHILDSTATUS " + nArray[i] + " " + nArray2[i]));
            }
            String string = ((PipelineChannel)channel).getStderrOutput();
            if (string.length() > 0) {
                bl = true;
                if (string.endsWith("\n")) {
                    string = string.substring(0, string.length() - 1);
                }
            } else if (bl) {
                string = "child process exited abnormally";
            }
            if (bl) {
                throw new TclException(interp, string);
            }
            pipeline.throwAnyExceptions();
        }
    }
}

