/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang.cmd;

import java.util.LinkedList;
import tcl.lang.Command;
import tcl.lang.Interp;
import tcl.lang.TclBoolean;
import tcl.lang.TclDict;
import tcl.lang.TclException;
import tcl.lang.TclIndex;
import tcl.lang.TclInteger;
import tcl.lang.TclList;
import tcl.lang.TclNumArgsException;
import tcl.lang.TclObject;
import tcl.lang.TclRuntimeError;
import tcl.lang.Util;

public class DictCmd
implements Command {
    private static final String[] options = new String[]{"append", "create", "exists", "filter", "for", "get", "incr", "info", "keys", "lappend", "merge", "remove", "replace", "set", "size", "unset", "update", "values", "with"};
    private static final Command[] subcommands = new Command[]{new AppendCmd(), new CreateCmd(), new ExistsCmd(), new FilterCmd(), new ForCmd(), new GetCmd(), new IncrCmd(), new InfoCmd(), new KeysCmd(), new LappendCmd(), new MergeCmd(), new RemoveCmd(), new ReplaceCmd(), new SetCmd(), new SizeCmd(), new UnsetCmd(), new UpdateCmd(), new ValuesCmd(), new WithCmd()};

    @Override
    public void cmdProc(Interp interp, TclObject[] tclObjectArray) throws TclException {
        if (tclObjectArray.length < 2) {
            throw new TclNumArgsException(interp, 1, tclObjectArray, "subcommand ?arg ...?");
        }
        int n = TclIndex.get(interp, tclObjectArray[1], options, "subcommand", 0);
        subcommands[n].cmdProc(interp, tclObjectArray);
    }

    private static final class WithCmd
    implements Command {
        private WithCmd() {
        }

        @Override
        public void cmdProc(Interp interp, TclObject[] tclObjectArray) throws TclException {
            TclObject tclObject;
            if (tclObjectArray.length < 4) {
                throw new TclNumArgsException(interp, 2, tclObjectArray, "dictVar ?key ...? script");
            }
            TclObject tclObject2 = interp.getVar(tclObjectArray[2], 0);
            TclObject tclObject3 = tclObjectArray[tclObjectArray.length - 1];
            TclObject tclObject4 = tclObject2;
            for (int i = 3; i < tclObjectArray.length - 1; ++i) {
                if ((tclObject4 = TclDict.get(interp, tclObject4, tclObjectArray[i])) != null) continue;
                throw new TclException(interp, "key \"" + tclObjectArray[i].toString() + "\" not known in dictionary");
            }
            tclObject2.preserve();
            final LinkedList linkedList = new LinkedList();
            TclDict.foreach(interp, null, tclObject4, new TclDict.Visitor(){

                @Override
                public Object visit(Interp interp, Object object, TclObject tclObject, TclObject tclObject2) throws TclException {
                    interp.setVar(tclObject, tclObject2, 0);
                    linkedList.add(tclObject);
                    return null;
                }
            });
            try {
                interp.eval(tclObject3, 0);
            }
            catch (TclException tclException) {
                if (tclException.getCompletionCode() == 1) {
                    interp.addErrorInfo("\n    (body of \"dict with\")");
                }
                throw tclException;
            }
            try {
                interp.getVar(tclObjectArray[2], 0);
            }
            catch (TclException tclException) {
                interp.resetResult();
                return;
            }
            TclObject tclObject5 = TclDict.newInstance();
            for (TclObject tclObject6 : linkedList) {
                tclObject = null;
                try {
                    tclObject = interp.getVar(tclObject6, 0);
                }
                catch (TclException tclException) {
                    tclObject = null;
                }
                if (tclObject == null) continue;
                TclDict.put(interp, tclObject5, tclObject6, tclObject);
            }
            if (tclObjectArray.length == 4) {
                tclObject2 = tclObject5;
            } else {
                if (tclObject2.isShared()) {
                    tclObject2 = tclObject2.duplicate();
                    tclObject2.preserve();
                }
                tclObject4 = tclObject2;
                for (int i = 3; i < tclObjectArray.length - 2; ++i) {
                    tclObject = TclDict.get(interp, tclObject4, tclObjectArray[i]);
                    if (tclObject == null) {
                        interp.resetResult();
                        return;
                    }
                    if (tclObject.isShared()) {
                        tclObject = tclObject.duplicate();
                        tclObject.preserve();
                        TclDict.put(interp, tclObject4, tclObjectArray[i], tclObject);
                    }
                    tclObject4 = tclObject;
                }
                TclDict.put(interp, tclObject4, tclObjectArray[tclObjectArray.length - 2], tclObject5);
            }
            interp.setResult(interp.setVar(tclObjectArray[2], tclObject2, 0));
        }
    }

    private static final class ValuesCmd
    implements Command {
        private ValuesCmd() {
        }

        @Override
        public void cmdProc(Interp interp, TclObject[] tclObjectArray) throws TclException {
            if (tclObjectArray.length < 3 || tclObjectArray.length > 4) {
                throw new TclNumArgsException(interp, 2, tclObjectArray, "dictionary ?pattern?");
            }
            TclObject tclObject = tclObjectArray[2];
            final String string = tclObjectArray.length == 4 ? tclObjectArray[3].toString() : null;
            final TclObject tclObject2 = TclList.newInstance();
            TclDict.foreach(interp, null, tclObject, new TclDict.Visitor(){

                @Override
                public Object visit(Interp interp, Object object, TclObject tclObject, TclObject tclObject22) throws TclException {
                    if (string == null || Util.stringMatch(tclObject22.toString(), string)) {
                        TclList.append(interp, tclObject2, tclObject22);
                    }
                    return null;
                }
            });
            interp.setResult(tclObject2);
        }
    }

    private static final class UpdateCmd
    implements Command {
        private UpdateCmd() {
        }

        @Override
        public void cmdProc(Interp interp, TclObject[] tclObjectArray) throws TclException {
            if (tclObjectArray.length < 5 || tclObjectArray.length % 2 != 0) {
                throw new TclNumArgsException(interp, 2, tclObjectArray, "varName key varName ?key varName ...? script");
            }
            TclObject tclObject = null;
            try {
                tclObject = interp.getVar(tclObjectArray[2], 0);
            }
            catch (TclException tclException) {
                tclObject = TclDict.newInstance();
                tclObject.preserve();
            }
            for (int i = 3; i < tclObjectArray.length - 1; i += 2) {
                TclObject tclObject2 = TclDict.get(interp, tclObject, tclObjectArray[i]);
                if (tclObject2 != null) {
                    interp.setVar(tclObjectArray[i + 1], tclObject2, 0);
                    continue;
                }
                try {
                    interp.unsetVar(tclObjectArray[i + 1], 0);
                    continue;
                }
                catch (TclException tclException) {
                    // empty catch block
                }
            }
            TclObject tclObject3 = tclObjectArray[tclObjectArray.length - 1];
            try {
                interp.eval(tclObject3, 0);
            }
            catch (TclException tclException) {
                if (tclException.getCompletionCode() == 1) {
                    interp.addErrorInfo("\n    (body of \"dict update\")");
                }
                throw tclException;
            }
            finally {
                try {
                    interp.getVar(tclObjectArray[2], 0);
                }
                catch (TclException tclException) {
                    interp.resetResult();
                    return;
                }
                if (tclObject.isShared()) {
                    tclObject = tclObject.duplicate();
                }
                for (int i = 3; i < tclObjectArray.length - 1; i += 2) {
                    TclObject tclObject4 = null;
                    try {
                        tclObject4 = interp.getVar(tclObjectArray[i + 1], 0);
                    }
                    catch (TclException tclException) {
                        tclObject4 = null;
                    }
                    if (tclObject4 != null) {
                        TclDict.put(interp, tclObject, tclObjectArray[i], tclObject4);
                        continue;
                    }
                    TclDict.remove(interp, tclObject, tclObjectArray[i]);
                }
                interp.setResult(interp.setVar(tclObjectArray[2], tclObject, 0));
            }
        }
    }

    private static final class UnsetCmd
    implements Command {
        private UnsetCmd() {
        }

        @Override
        public void cmdProc(Interp interp, TclObject[] tclObjectArray) throws TclException {
            if (tclObjectArray.length < 4) {
                throw new TclNumArgsException(interp, 2, tclObjectArray, "varName key ?key ...?");
            }
            TclObject tclObject = null;
            try {
                tclObject = interp.getVar(tclObjectArray[2], 0);
            }
            catch (TclException tclException) {
                tclObject = TclDict.newInstance();
                tclObject.preserve();
            }
            if (tclObject.isShared()) {
                tclObject = tclObject.duplicate();
            }
            TclDict.removeKeyList(interp, tclObject, tclObjectArray, 3, tclObjectArray.length - 3);
            tclObject.invalidateStringRep();
            interp.setResult(interp.setVar(tclObjectArray[2], tclObject, 0));
        }
    }

    private static final class SizeCmd
    implements Command {
        private SizeCmd() {
        }

        @Override
        public void cmdProc(Interp interp, TclObject[] tclObjectArray) throws TclException {
            if (tclObjectArray.length != 3) {
                throw new TclNumArgsException(interp, 2, tclObjectArray, "dictionary");
            }
            interp.setResult(TclDict.size(interp, tclObjectArray[2]));
        }
    }

    private static final class SetCmd
    implements Command {
        private SetCmd() {
        }

        @Override
        public void cmdProc(Interp interp, TclObject[] tclObjectArray) throws TclException {
            if (tclObjectArray.length < 5) {
                throw new TclNumArgsException(interp, 2, tclObjectArray, "varName key ?key ...? value");
            }
            TclObject tclObject = null;
            try {
                tclObject = interp.getVar(tclObjectArray[2], 0);
            }
            catch (TclException tclException) {
                tclObject = TclDict.newInstance();
                tclObject.preserve();
            }
            if (tclObject.isShared()) {
                tclObject = tclObject.duplicate();
            }
            TclObject tclObject2 = tclObjectArray[tclObjectArray.length - 1];
            TclDict.putKeyList(interp, tclObject, tclObjectArray, 3, tclObjectArray.length - 4, tclObject2);
            tclObject.invalidateStringRep();
            interp.setResult(interp.setVar(tclObjectArray[2], tclObject, 0));
        }
    }

    private static final class ReplaceCmd
    implements Command {
        private ReplaceCmd() {
        }

        @Override
        public void cmdProc(Interp interp, TclObject[] tclObjectArray) throws TclException {
            if (tclObjectArray.length < 3 || tclObjectArray.length % 2 != 1) {
                throw new TclNumArgsException(interp, 2, tclObjectArray, "dictionary ?key value ...?");
            }
            TclObject tclObject = tclObjectArray[2];
            if (tclObject.isShared()) {
                tclObject = tclObject.duplicate();
            }
            for (int i = 3; i < tclObjectArray.length; i += 2) {
                TclDict.put(interp, tclObject, tclObjectArray[i], tclObjectArray[i + 1]);
            }
            interp.setResult(tclObject);
        }
    }

    private static final class RemoveCmd
    implements Command {
        private RemoveCmd() {
        }

        @Override
        public void cmdProc(Interp interp, TclObject[] tclObjectArray) throws TclException {
            if (tclObjectArray.length < 3) {
                throw new TclNumArgsException(interp, 2, tclObjectArray, "dictionary ?key ...?");
            }
            TclObject tclObject = tclObjectArray[2];
            if (tclObject.isShared()) {
                tclObject = tclObject.duplicate();
            }
            for (int i = 3; i < tclObjectArray.length; ++i) {
                TclDict.remove(interp, tclObject, tclObjectArray[i]);
            }
            interp.setResult(tclObject);
        }
    }

    private static final class MergeCmd
    implements Command {
        private MergeCmd() {
        }

        @Override
        public void cmdProc(Interp interp, TclObject[] tclObjectArray) throws TclException {
            final TclObject tclObject = TclDict.newInstance();
            for (int i = 2; i < tclObjectArray.length; ++i) {
                TclDict.foreach(interp, null, tclObjectArray[i], new TclDict.Visitor(){

                    @Override
                    public Object visit(Interp interp, Object object, TclObject tclObject3, TclObject tclObject2) throws TclException {
                        TclDict.put(interp, tclObject, tclObject3, tclObject2);
                        return null;
                    }
                });
            }
            interp.setResult(tclObject);
        }
    }

    private static final class LappendCmd
    implements Command {
        private LappendCmd() {
        }

        @Override
        public void cmdProc(Interp interp, TclObject[] tclObjectArray) throws TclException {
            TclObject tclObject;
            TclObject tclObject2;
            if (tclObjectArray.length < 4) {
                throw new TclNumArgsException(interp, 2, tclObjectArray, "varName key ?value ...?");
            }
            TclObject tclObject3 = null;
            try {
                tclObject3 = interp.getVar(tclObjectArray[2], 0);
            }
            catch (TclException tclException) {
                tclObject3 = TclDict.newInstance();
                tclObject3.preserve();
            }
            if (tclObjectArray.length == 4) {
                interp.setResult(tclObject3);
                return;
            }
            if (tclObject3.isShared()) {
                tclObject3 = tclObject3.duplicate();
            }
            if ((tclObject2 = TclDict.get(interp, tclObject3, tclObject = tclObjectArray[3])) == null) {
                tclObject2 = TclList.newInstance();
                tclObject2.preserve();
            } else if (tclObject2.isShared()) {
                tclObject2 = tclObject2.duplicate();
                tclObject2.preserve();
            }
            for (int i = 4; i < tclObjectArray.length; ++i) {
                TclList.append(interp, tclObject2, tclObjectArray[i]);
            }
            TclDict.put(interp, tclObject3, tclObject, tclObject2);
            tclObject3.invalidateStringRep();
            interp.setResult(interp.setVar(tclObjectArray[2], tclObject3, 0));
        }
    }

    private static final class KeysCmd
    implements Command {
        private KeysCmd() {
        }

        @Override
        public void cmdProc(Interp interp, TclObject[] tclObjectArray) throws TclException {
            if (tclObjectArray.length < 3 || tclObjectArray.length > 4) {
                throw new TclNumArgsException(interp, 2, tclObjectArray, "dictionary ?pattern?");
            }
            TclObject tclObject = tclObjectArray[2];
            final String string = tclObjectArray.length == 4 ? tclObjectArray[3].toString() : null;
            final TclObject tclObject2 = TclList.newInstance();
            TclDict.foreach(interp, null, tclObject, new TclDict.Visitor(){

                @Override
                public Object visit(Interp interp, Object object, TclObject tclObject, TclObject tclObject22) throws TclException {
                    if (string == null || Util.stringMatch(tclObject.toString(), string)) {
                        TclList.append(interp, tclObject2, tclObject);
                    }
                    return null;
                }
            });
            interp.setResult(tclObject2);
        }
    }

    private static final class InfoCmd
    implements Command {
        private InfoCmd() {
        }

        @Override
        public void cmdProc(Interp interp, TclObject[] tclObjectArray) throws TclException {
            if (tclObjectArray.length != 3) {
                throw new TclNumArgsException(interp, 2, tclObjectArray, "dictionary");
            }
            final StringBuffer stringBuffer = new StringBuffer();
            int n = TclDict.size(interp, tclObjectArray[2]);
            stringBuffer.append("" + n + " entries in table\n");
            stringBuffer.append("Entries (and ref-counts):\n");
            TclDict.foreach(interp, null, tclObjectArray[2], new TclDict.Visitor(){

                @Override
                public Object visit(Interp interp, Object object, TclObject tclObject, TclObject tclObject2) throws TclException {
                    stringBuffer.append(tclObject.toString() + "(" + tclObject.getRefCount() + ") = " + tclObject2.toString() + "(" + tclObject2.getRefCount() + ")\n");
                    return null;
                }
            });
            interp.setResult(stringBuffer.toString());
        }
    }

    private static final class IncrCmd
    implements Command {
        private IncrCmd() {
        }

        @Override
        public void cmdProc(Interp interp, TclObject[] tclObjectArray) throws TclException {
            TclObject tclObject;
            if (tclObjectArray.length < 4 || tclObjectArray.length > 5) {
                throw new TclNumArgsException(interp, 2, tclObjectArray, "varName key ?increment?");
            }
            TclObject tclObject2 = null;
            try {
                tclObject2 = interp.getVar(tclObjectArray[2], 0);
            }
            catch (TclException tclException) {
                tclObject2 = TclDict.newInstance();
                tclObject2.preserve();
            }
            TclObject tclObject3 = tclObjectArray[3];
            int n = 1;
            if (tclObjectArray.length == 5) {
                n = TclInteger.get(interp, tclObjectArray[4]);
            }
            if (tclObject2.isShared()) {
                tclObject2 = tclObject2.duplicate();
            }
            if ((tclObject = TclDict.get(interp, tclObject2, tclObject3)) == null) {
                tclObject = TclInteger.newInstance(0L);
            }
            if (tclObject.isShared()) {
                tclObject = tclObject.duplicate();
            }
            TclInteger.incr(interp, tclObject, n);
            TclDict.put(interp, tclObject2, tclObject3, tclObject);
            interp.setResult(interp.setVar(tclObjectArray[2], tclObject2, 0));
        }
    }

    private static final class GetCmd
    implements Command {
        private GetCmd() {
        }

        @Override
        public void cmdProc(Interp interp, TclObject[] tclObjectArray) throws TclException {
            if (tclObjectArray.length < 3) {
                throw new TclNumArgsException(interp, 2, tclObjectArray, "dictionary ?key key ...?");
            }
            TclObject tclObject = tclObjectArray[2];
            if (tclObjectArray.length == 3) {
                interp.setResult(tclObject);
                return;
            }
            for (int i = 3; i < tclObjectArray.length; ++i) {
                if ((tclObject = TclDict.get(interp, tclObject, tclObjectArray[i])) != null) continue;
                throw new TclException(interp, "key \"" + tclObjectArray[i].toString() + "\" not known in dictionary");
            }
            interp.setResult(tclObject);
        }
    }

    private static final class ForCmd
    implements Command {
        private ForCmd() {
        }

        @Override
        public void cmdProc(Interp interp, TclObject[] tclObjectArray) throws TclException {
            if (tclObjectArray.length != 5) {
                throw new TclNumArgsException(interp, 2, tclObjectArray, "{keyVar valueVar} dictionary script");
            }
            final TclObject[] tclObjectArray2 = TclList.getElements(interp, tclObjectArray[2]);
            TclObject tclObject = tclObjectArray[3];
            final TclObject tclObject2 = tclObjectArray[4];
            if (tclObjectArray2.length != 2) {
                throw new TclException(interp, "must have exactly two variable names");
            }
            TclDict.foreach(interp, null, tclObject, new TclDict.Visitor(){

                @Override
                public Object visit(Interp interp, Object object, TclObject tclObject, TclObject tclObject22) throws TclException {
                    interp.setVar(tclObjectArray2[0], tclObject, 0);
                    interp.setVar(tclObjectArray2[1], tclObject22, 0);
                    try {
                        interp.eval(tclObject2, 0);
                    }
                    catch (TclException tclException) {
                        if (tclException.getCompletionCode() == 1) {
                            interp.addErrorInfo("\n    (\"dict for\" body line " + interp.errorLine + ")");
                        }
                        throw tclException;
                    }
                    return null;
                }
            });
        }
    }

    private static final class FilterCmd
    implements Command {
        private static final String[] filterTypes = new String[]{"key", "script", "value"};
        private static final int FILTER_KEY = 0;
        private static final int FILTER_SCRIPT = 1;
        private static final int FILTER_VALUE = 2;

        private FilterCmd() {
        }

        @Override
        public void cmdProc(Interp interp, TclObject[] tclObjectArray) throws TclException {
            if (tclObjectArray.length < 4) {
                throw new TclNumArgsException(interp, 2, tclObjectArray, "dictionary filterType ...");
            }
            int n = TclIndex.get(interp, tclObjectArray[3], filterTypes, "filterType", 0);
            switch (n) {
                case 0: {
                    if (tclObjectArray.length != 5) {
                        throw new TclNumArgsException(interp, 2, tclObjectArray, "dictionary key globPattern");
                    }
                    this.filterKey(interp, tclObjectArray);
                    break;
                }
                case 1: {
                    if (tclObjectArray.length != 6) {
                        throw new TclNumArgsException(interp, 2, tclObjectArray, "dictionary script {keyVar valueVar} filterScript");
                    }
                    this.filterScript(interp, tclObjectArray);
                    break;
                }
                case 2: {
                    if (tclObjectArray.length != 5) {
                        throw new TclNumArgsException(interp, 2, tclObjectArray, "dictionary value globPattern");
                    }
                    this.filterValue(interp, tclObjectArray);
                    break;
                }
                default: {
                    throw new TclRuntimeError("unexpected index");
                }
            }
        }

        private void filterKey(Interp interp, TclObject[] tclObjectArray) throws TclException {
            TclObject tclObject = tclObjectArray[2];
            final TclObject tclObject2 = TclDict.newInstance();
            final String string = tclObjectArray[4].toString();
            TclDict.foreach(interp, null, tclObject, new TclDict.Visitor(){

                @Override
                public Object visit(Interp interp, Object object, TclObject tclObject, TclObject tclObject22) throws TclException {
                    if (Util.stringMatch(tclObject.toString(), string)) {
                        TclDict.put(interp, tclObject2, tclObject, tclObject22);
                    }
                    return null;
                }
            });
            interp.setResult(tclObject2);
        }

        private void filterScript(Interp interp, TclObject[] tclObjectArray) throws TclException {
            TclObject tclObject = tclObjectArray[2];
            final TclObject tclObject2 = TclDict.newInstance();
            final TclObject[] tclObjectArray2 = TclList.getElements(interp, tclObjectArray[4]);
            final TclObject tclObject3 = tclObjectArray[5];
            if (tclObjectArray2.length != 2) {
                throw new TclException(interp, "must have exactly two variable names");
            }
            TclDict.foreach(interp, null, tclObject, new TclDict.Visitor(){

                @Override
                public Object visit(Interp interp, Object object, TclObject tclObject, TclObject tclObject22) throws TclException {
                    interp.setVar(tclObjectArray2[0], tclObject, 0);
                    interp.setVar(tclObjectArray2[1], tclObject22, 0);
                    try {
                        interp.eval(tclObject3, 0);
                    }
                    catch (TclException tclException) {
                        if (tclException.getCompletionCode() == 1) {
                            interp.addErrorInfo("\n    (\"dict filter\" script line " + interp.errorLine + ")");
                        }
                        throw tclException;
                    }
                    if (TclBoolean.get(interp, interp.getResult())) {
                        TclDict.put(interp, tclObject2, tclObject, tclObject22);
                    }
                    return null;
                }
            });
            interp.setResult(tclObject2);
        }

        private void filterValue(Interp interp, TclObject[] tclObjectArray) throws TclException {
            TclObject tclObject = tclObjectArray[2];
            final TclObject tclObject2 = TclDict.newInstance();
            final String string = tclObjectArray[4].toString();
            TclDict.foreach(interp, null, tclObject, new TclDict.Visitor(){

                @Override
                public Object visit(Interp interp, Object object, TclObject tclObject, TclObject tclObject22) throws TclException {
                    if (Util.stringMatch(tclObject22.toString(), string)) {
                        TclDict.put(interp, tclObject2, tclObject, tclObject22);
                    }
                    return null;
                }
            });
            interp.setResult(tclObject2);
        }
    }

    private static final class ExistsCmd
    implements Command {
        private ExistsCmd() {
        }

        @Override
        public void cmdProc(Interp interp, TclObject[] tclObjectArray) throws TclException {
            if (tclObjectArray.length < 4) {
                throw new TclNumArgsException(interp, 2, tclObjectArray, "dictionary key ?key ...?");
            }
            TclObject tclObject = tclObjectArray[2];
            for (int i = 3; i < tclObjectArray.length; ++i) {
                if ((tclObject = TclDict.get(interp, tclObject, tclObjectArray[i])) != null) continue;
                interp.setResult(TclBoolean.newInstance(false));
                return;
            }
            interp.setResult(TclBoolean.newInstance(true));
        }
    }

    private static final class CreateCmd
    implements Command {
        private CreateCmd() {
        }

        @Override
        public void cmdProc(Interp interp, TclObject[] tclObjectArray) throws TclException {
            if (tclObjectArray.length % 2 != 0) {
                throw new TclNumArgsException(interp, 2, tclObjectArray, "?key value ...?");
            }
            TclObject tclObject = TclDict.newInstance();
            if (tclObjectArray.length > 2) {
                for (int i = 2; i < tclObjectArray.length; i += 2) {
                    TclDict.put(interp, tclObject, tclObjectArray[i], tclObjectArray[i + 1]);
                }
            }
            interp.setResult(tclObject);
        }
    }

    private static final class AppendCmd
    implements Command {
        private AppendCmd() {
        }

        @Override
        public void cmdProc(Interp interp, TclObject[] tclObjectArray) throws TclException {
            if (tclObjectArray.length < 4) {
                throw new TclNumArgsException(interp, 2, tclObjectArray, "varName key ?value ...?");
            }
            TclObject tclObject = null;
            try {
                tclObject = interp.getVar(tclObjectArray[2], 0);
            }
            catch (TclException tclException) {
                tclObject = TclDict.newInstance();
                tclObject.preserve();
            }
            if (tclObjectArray.length == 4) {
                interp.setResult(tclObject);
                return;
            }
            if (tclObject.isShared()) {
                tclObject = tclObject.duplicate();
                tclObject.preserve();
            }
            TclObject tclObject2 = tclObjectArray[3];
            TclDict.appendToKey(interp, tclObject, tclObject2, tclObjectArray, 4, tclObjectArray.length);
            interp.setResult(interp.setVar(tclObjectArray[2], tclObject, 0));
        }
    }
}

