/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang.cmd;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.Hashtable;
import tcl.lang.Command;
import tcl.lang.Interp;
import tcl.lang.TclByteArray;
import tcl.lang.TclException;
import tcl.lang.TclIO;
import tcl.lang.TclIndex;
import tcl.lang.TclList;
import tcl.lang.TclNumArgsException;
import tcl.lang.TclObject;
import tcl.lang.TclRuntimeError;
import tcl.lang.TclString;
import tcl.lang.channel.Channel;

public class EncodingCmd
implements Command {
    public static String systemTclEncoding;
    public static String systemJavaEncoding;
    static Hashtable<String, EncodingMap> encodeHash;
    static EncodingMap[] encodings;
    private static final char[] symbolEncoding0x40to0x7A;
    private static final char[] symbolEncoding0xA0to0xFF;
    private static final String[] validCmds;
    static final int OPT_CONVERTFROM = 0;
    static final int OPT_CONVERTTO = 1;
    static final int OPT_NAMES = 2;
    static final int OPT_SYSTEM = 3;

    @Override
    public void cmdProc(Interp interp, TclObject[] tclObjectArray) throws TclException {
        if (tclObjectArray.length < 2) {
            throw new TclNumArgsException(interp, 1, tclObjectArray, "option ?arg ...?");
        }
        int n = TclIndex.get(interp, tclObjectArray[1], validCmds, "option", 0);
        switch (n) {
            case 0: 
            case 1: {
                TclObject tclObject;
                String string;
                if (tclObjectArray.length == 3) {
                    string = systemTclEncoding;
                    tclObject = tclObjectArray[2];
                } else if (tclObjectArray.length == 4) {
                    string = tclObjectArray[2].toString();
                    tclObject = tclObjectArray[3];
                } else {
                    throw new TclNumArgsException(interp, 2, tclObjectArray, "?encoding? data");
                }
                String string2 = EncodingCmd.getJavaName(string);
                if (string2 == null) {
                    throw new TclException(interp, "unknown encoding \"" + string + "\"");
                }
                try {
                    if (n == 0) {
                        if (string.equals("identity")) {
                            TclByteArray.getLength(interp, tclObject);
                            interp.setResult(tclObject);
                            break;
                        }
                        if (string.equals("symbol")) {
                            char[] cArray = new char[TclByteArray.getLength(interp, tclObject)];
                            EncodingCmd.decodeSymbol(TclByteArray.getBytes(interp, tclObject), cArray, 0, cArray.length);
                            interp.setResult(new String(cArray));
                            break;
                        }
                        interp.setResult(TclByteArray.decodeToString(interp, tclObject, string));
                        break;
                    }
                    if (string.equals("identity")) {
                        if (tclObject.isByteArrayType()) {
                            interp.setResult(tclObject);
                            break;
                        }
                        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(tclObject.toString().length() * 3);
                        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
                        dataOutputStream.writeUTF(tclObject.toString());
                        byte[] byArray = byteArrayOutputStream.toByteArray();
                        interp.setResult(TclByteArray.newInstance(byArray, 2, byArray.length - 2));
                        break;
                    }
                    if (string.equals("symbol")) {
                        byte[] byArray = EncodingCmd.encodeSymbol(tclObject.toString().toCharArray(), 0, tclObject.toString().length());
                        interp.setResult(TclByteArray.newInstance(byArray, 0, byArray.length));
                        break;
                    }
                    TclObject tclObject2 = TclByteArray.newInstance(tclObject.toString().getBytes(string2));
                    interp.setResult(tclObject2);
                    break;
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    throw new TclException(interp, "Encoding.cmdProc() error: unsupported java encoding \"" + string2 + "\"");
                }
                catch (IOException iOException) {
                    throw new TclException(interp, iOException.getMessage());
                }
            }
            case 2: {
                if (tclObjectArray.length > 2) {
                    throw new TclNumArgsException(interp, 2, tclObjectArray, null);
                }
                TclObject tclObject = TclList.newInstance();
                for (int i = 0; i < encodings.length; ++i) {
                    EncodingMap encodingMap = encodings[i];
                    if (!EncodingCmd.isSupported(encodingMap.javaName)) continue;
                    TclList.append(interp, tclObject, TclString.newInstance(encodingMap.tclName));
                }
                interp.setResult(tclObject);
                break;
            }
            case 3: {
                if (tclObjectArray.length > 3) {
                    throw new TclNumArgsException(interp, 2, tclObjectArray, "?encoding?");
                }
                if (tclObjectArray.length == 2) {
                    interp.setResult(systemTclEncoding);
                    break;
                }
                String string = tclObjectArray[2].toString();
                String string3 = EncodingCmd.getJavaName(string);
                if (string3 == null) {
                    throw new TclException(interp, "unknown encoding \"" + string + "\"");
                }
                if (!EncodingCmd.isSupported(string3)) {
                    throw new TclException(interp, "Encoding.cmdProc() error: unsupported java encoding \"" + string3 + "\"");
                }
                systemTclEncoding = string;
                systemJavaEncoding = string3;
                if (!interp.systemEncodingChangesStdoutStderr) break;
                Channel channel = TclIO.getChannel(interp, "stdout");
                if (channel != null) {
                    channel.setEncoding(systemJavaEncoding);
                }
                if ((channel = TclIO.getChannel(interp, "stderr")) != null) {
                    channel.setEncoding(systemJavaEncoding);
                }
                interp.systemEncodingChangesStdoutStderr = true;
                break;
            }
            default: {
                throw new TclRuntimeError("Encoding.cmdProc() error: incorrect index returned from TclIndex.get()");
            }
        }
    }

    public static int getBytesPerChar(String string) {
        String string2 = "java," + string;
        EncodingMap encodingMap = encodeHash.get(string2);
        if (encodingMap == null) {
            throw new RuntimeException("Invalid encoding \"" + string + "\"");
        }
        return encodingMap.bytesPerChar;
    }

    public static String getJavaName(String string) {
        String string2 = "tcl," + string;
        EncodingMap encodingMap = encodeHash.get(string2);
        if (encodingMap == null) {
            return null;
        }
        return encodingMap.javaName;
    }

    static String getTclName(String string) {
        String string2 = "java," + string;
        EncodingMap encodingMap = encodeHash.get(string2);
        if (encodingMap == null) {
            return null;
        }
        return encodingMap.tclName;
    }

    static boolean isSupported(String string) {
        Charset charset;
        String string2 = "java," + string;
        EncodingMap encodingMap = encodeHash.get(string2);
        if (encodingMap == null) {
            return false;
        }
        try {
            charset = Charset.forName(string);
        }
        catch (IllegalCharsetNameException illegalCharsetNameException) {
            throw new TclRuntimeError("illegal charset name \"" + string + "\"");
        }
        catch (UnsupportedCharsetException unsupportedCharsetException) {
            return false;
        }
        return charset.canEncode();
    }

    public static void decodeSymbol(byte[] byArray, char[] cArray, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            int n3 = byArray[i] & 0xFF;
            cArray[i + n] = n3 < 64 ? (char)n3 : (n3 < 123 ? symbolEncoding0x40to0x7A[n3 - 64] : (n3 < 160 ? (char)n3 : symbolEncoding0xA0to0xFF[n3 - 160]));
        }
    }

    public static byte[] encodeSymbol(char[] cArray, int n, int n2) {
        byte[] byArray = new byte[n2];
        for (int i = n; i < n + n2; ++i) {
            int n3;
            if (cArray[i] <= '\u00ff') {
                byArray[i - n] = (byte)(cArray[i] & 0xFF);
                continue;
            }
            boolean bl = true;
            for (n3 = 0; bl && n3 < symbolEncoding0x40to0x7A.length; ++n3) {
                if (cArray[i] != symbolEncoding0x40to0x7A[n3]) continue;
                bl = false;
                byArray[i - n] = (byte)(n3 + 64);
            }
            for (n3 = 0; bl && n3 < symbolEncoding0xA0to0xFF.length; ++n3) {
                if (cArray[i] != symbolEncoding0xA0to0xFF[n3]) continue;
                bl = false;
                byArray[i - n] = (byte)(n3 + 160);
            }
            if (!bl) continue;
            byArray[i - n] = 63;
        }
        return byArray;
    }

    static {
        Object object;
        Object object2;
        Object object3;
        systemTclEncoding = null;
        systemJavaEncoding = null;
        encodings = new EncodingMap[]{new EncodingMap("identity", "UTF8", 1), new EncodingMap("symbol", "ASCII", 1), new EncodingMap("utf-8", "UTF8", 1), new EncodingMap("utf-16", "UTF16", 2), new EncodingMap("unicode", "ISO-10646-UCS-2", 2), new EncodingMap("ascii", "ASCII", 1), new EncodingMap("big5", "Big5", 0), new EncodingMap("cp1250", "Cp1250", 1), new EncodingMap("cp1251", "Cp1251", 1), new EncodingMap("ansi-1251", "Cp1251", 1), new EncodingMap("cp1252", "Cp1252", 1), new EncodingMap("cp1253", "Cp1253", 1), new EncodingMap("cp1254", "Cp1254", 1), new EncodingMap("cp1255", "Cp1255", 1), new EncodingMap("cp1256", "Cp1256", 1), new EncodingMap("cp1257", "Cp1257", 1), new EncodingMap("cp1258", "Cp1258", 1), new EncodingMap("cp437", "Cp437", 1), new EncodingMap("cp737", "Cp737", 1), new EncodingMap("cp775", "Cp775", 1), new EncodingMap("cp850", "Cp850", 1), new EncodingMap("cp852", "Cp852", 1), new EncodingMap("cp855", "Cp855", 1), new EncodingMap("cp857", "Cp857", 1), new EncodingMap("cp860", "Cp860", 1), new EncodingMap("cp861", "Cp861", 1), new EncodingMap("cp862", "Cp862", 1), new EncodingMap("cp863", "Cp863", 1), new EncodingMap("cp864", "Cp864", 1), new EncodingMap("cp865", "Cp865", 1), new EncodingMap("cp866", "Cp866", 1), new EncodingMap("cp869", "Cp869", 1), new EncodingMap("cp874", "Cp874", 1), new EncodingMap("cp932", "Cp943", 0), new EncodingMap("cp936", "Cp936", 0), new EncodingMap("cp949", "Cp949", 0), new EncodingMap("cp950", "Cp950", 0), new EncodingMap("euc-cn", "EUC_cn", 0), new EncodingMap("euc-jp", "EUC_jp", 0), new EncodingMap("euc-kr", "EUC_kr", 0), new EncodingMap("iso2022", "ISO-2022-JP-2", -1), new EncodingMap("iso2022-jp", "ISO-2022-JP-2", -1), new EncodingMap("iso2022-kr", "ISO2022KR", -1), new EncodingMap("iso8859-1", "ISO-8859-1", 1), new EncodingMap("ansi_x3.4-1968", "ISO-8859-1", 1), new EncodingMap("iso8859-2", "ISO-8859-2", 1), new EncodingMap("iso8859-3", "ISO-8859-3", 1), new EncodingMap("iso8859-4", "ISO-8859-4", 1), new EncodingMap("iso8859-5", "ISO-8859-5", 1), new EncodingMap("iso8859-6", "ISO-8859-6", 1), new EncodingMap("iso8859-7", "ISO-8859-7", 1), new EncodingMap("iso8859-8", "ISO-8859-8", 1), new EncodingMap("iso8859-9", "ISO-8859-9", 1), new EncodingMap("iso8859-10", "ISO-8859-10", 1), new EncodingMap("iso8859-11", "ISO-8859-11", 1), new EncodingMap("iso8859-12", "ISO-8859-12", 1), new EncodingMap("iso8859-13", "ISO-8859-13", 1), new EncodingMap("iso8859-14", "ISO-8859-14", 1), new EncodingMap("iso8859-15", "ISO-8859-15", 1), new EncodingMap("jis0201", "JIS0201", 1), new EncodingMap("jis0208", "JIS0208", 2), new EncodingMap("jis0212", "JIS0212", 2), new EncodingMap("koi8-r", "KOI8_r", 1), new EncodingMap("macCentEuro", "MacCentEuro", 1), new EncodingMap("macCroatian", "MacCroatian", 1), new EncodingMap("macCyrillic", "MacCyrillic", 1), new EncodingMap("macDingbats", "MacDingbats", 1), new EncodingMap("macGreek", "MacGreek", 1), new EncodingMap("macIceland", "MacIceland", 1), new EncodingMap("macJapan", "MacJapan", 0), new EncodingMap("macRoman", "MacRoman", 1), new EncodingMap("macRomania", "MacRomania", 1), new EncodingMap("macSymbol", "MacSymbol", 1), new EncodingMap("macThai", "MacThai", 1), new EncodingMap("macTurkish", "MacTurkish", 1), new EncodingMap("macUkraine", "MacUkraine", 1), new EncodingMap("shiftjis", "Shift_JIS", 0)};
        encodeHash = new Hashtable();
        for (int i = 0; i < encodings.length; ++i) {
            object3 = encodings[i];
            object2 = "tcl," + ((EncodingMap)object3).tclName;
            object = "java," + ((EncodingMap)object3).javaName;
            encodeHash.put((String)object2, (EncodingMap)object3);
            encodeHash.put((String)object, (EncodingMap)object3);
        }
        Charset charset = Charset.defaultCharset();
        object3 = charset.aliases();
        object2 = new ArrayList(object3.size() + 1);
        ((ArrayList)object2).add(charset.name());
        ((ArrayList)object2).addAll(object3);
        object = ((ArrayList)object2).iterator();
        String string = null;
        while (object.hasNext()) {
            string = (String)object.next();
            String string2 = "java," + string;
            EncodingMap encodingMap = encodeHash.get(string2);
            if (encodingMap == null) {
                string = null;
                continue;
            }
            systemTclEncoding = encodingMap.tclName;
            systemJavaEncoding = encodingMap.javaName;
            break;
        }
        if (string == null || string.length() == 0) {
            systemTclEncoding = "iso8859-1";
            systemJavaEncoding = "ISO-8859-1";
        }
        symbolEncoding0x40to0x7A = new char[]{'\u2245', '\u0391', '\u0392', '\u03a7', '\u0394', '\u0395', '\u03a6', '\u0393', '\u0397', '\u0399', '\u03d1', '\u039a', '\u039b', '\u039c', '\u039d', '\u039f', '\u03a0', '\u0398', '\u03a1', '\u03a3', '\u03a4', '\u03a5', '\u03c2', '\u03a9', '\u039e', '\u03a8', '\u0396', '[', '\u2234', ']', '\u22a5', '_', '\uf8e5', '\u03b1', '\u03b2', '\u03c7', '\u03b4', '\u03b5', '\u03c6', '\u03b3', '\u03b7', '\u03b9', '\u03d5', '\u03ba', '\u03bb', '\u03bc', '\u03bd', '\u03bf', '\u03c0', '\u03b8', '\u03c1', '\u03c3', '\u03c4', '\u03c5', '\u03d6', '\u03c9', '\u03be', '\u03c8', '\u03b6'};
        symbolEncoding0xA0to0xFF = new char[]{'\u0000', '\u03d2', '\u2032', '\u2264', '\u2044', '\u221e', '\u0192', '\u2663', '\u2666', '\u2665', '\u2660', '\u2194', '\u2190', '\u2191', '\u2192', '\u2193', '\u00b0', '\u00b1', '\u2033', '\u2265', '\u00d7', '\u221d', '\u2202', '\u2022', '\u00f7', '\u2260', '\u2261', '\u2248', '\u2026', '\uf8e6', '\uf8e7', '\u21b5', '\u2135', '\u2111', '\u211c', '\u2118', '\u2297', '\u2295', '\u2205', '\u2229', '\u222a', '\u2283', '\u2287', '\u2284', '\u2282', '\u2286', '\u2208', '\u2209', '\u2220', '\u2207', '\u00ae', '\u00a9', '\u2122', '\u220f', '\u221a', '\u22c5', '\u00ac', '\u2227', '\u2228', '\u21d4', '\u21d0', '\u21d1', '\u21d2', '\u21d3', '\u22c4', '\u2329', '\uf8e8', '\uf8e9', '\uf8ea', '\u2211', '\uf8eb', '\uf8ec', '\uf8ed', '\uf8ee', '\uf8ef', '\uf8f0', '\uf8f1', '\uf8f2', '\uf8f3', '\uf8f4', '\uf8ff', '\u232a', '\u222b', '\u2320', '\uf8f5', '\u2321', '\uf8f6', '\uf8f7', '\uf8f8', '\uf8f9', '\uf8fa', '\uf8fb', '\uf8fc', '\uf8fd', '\uf8fe', '\u0000'};
        validCmds = new String[]{"convertfrom", "convertto", "names", "system"};
    }

    static class EncodingMap {
        String tclName;
        String javaName;
        int bytesPerChar;

        public EncodingMap(String string, String string2, int n) {
            this.tclName = string;
            this.javaName = string2;
            this.bytesPerChar = n;
        }
    }
}

