/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang.cmd;

import java.io.IOException;
import tcl.lang.Command;
import tcl.lang.Interp;
import tcl.lang.TclException;
import tcl.lang.TclIO;
import tcl.lang.TclNumArgsException;
import tcl.lang.TclObject;
import tcl.lang.TclPosixException;
import tcl.lang.TclRuntimeError;
import tcl.lang.TclString;
import tcl.lang.channel.Channel;

public class GetsCmd
implements Command {
    @Override
    public void cmdProc(Interp interp, TclObject[] tclObjectArray) throws TclException {
        Channel channel;
        boolean bl = false;
        String string = "";
        if (tclObjectArray.length < 2 || tclObjectArray.length > 3) {
            throw new TclNumArgsException(interp, 1, tclObjectArray, "channelId ?varName?");
        }
        if (tclObjectArray.length == 3) {
            bl = true;
            string = tclObjectArray[2].toString();
        }
        if ((channel = TclIO.getChannel(interp, tclObjectArray[1].toString())) == null) {
            throw new TclException(interp, "can not find channel named \"" + tclObjectArray[1].toString() + "\"");
        }
        try {
            TclObject tclObject = TclString.newInstance(new StringBuffer(64));
            int n = channel.read(interp, tclObject, 2, 0);
            if (n < 0) {
                if (!channel.eof() && !channel.isBlocked(interp)) {
                    throw new TclPosixException(interp, 5, true, "error reading \"" + tclObjectArray[1].toString() + "\"");
                }
                n = -1;
            }
            if (bl) {
                interp.setVar(string, tclObject, 0);
                interp.setResult(n);
            } else {
                interp.setResult(tclObject);
            }
        }
        catch (IOException iOException) {
            throw new TclRuntimeError("GetsCmd.cmdProc() Error: IOException when getting " + channel.getChanName() + ": " + iOException.getMessage());
        }
    }
}

