/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang.cmd;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import tcl.lang.CallFrame;
import tcl.lang.Command;
import tcl.lang.Expression;
import tcl.lang.Interp;
import tcl.lang.MathFunction;
import tcl.lang.Namespace;
import tcl.lang.Procedure;
import tcl.lang.TclException;
import tcl.lang.TclIndex;
import tcl.lang.TclInteger;
import tcl.lang.TclList;
import tcl.lang.TclNumArgsException;
import tcl.lang.TclObject;
import tcl.lang.TclString;
import tcl.lang.Util;
import tcl.lang.Var;
import tcl.lang.WrappedCommand;
import tcl.lang.cmd.InterpCmd;
import tcl.lang.cmd.NamespaceCmd;

public class InfoCmd
implements Command {
    private static final String[] validCmds = new String[]{"args", "body", "cmdcount", "commands", "complete", "default", "exists", "functions", "globals", "hostname", "level", "library", "loaded", "locals", "nameofexecutable", "patchlevel", "procs", "script", "sharedlibextension", "tclversion", "vars"};
    static final int OPT_ARGS = 0;
    static final int OPT_BODY = 1;
    static final int OPT_CMDCOUNT = 2;
    static final int OPT_COMMANDS = 3;
    static final int OPT_COMPLETE = 4;
    static final int OPT_DEFAULT = 5;
    static final int OPT_EXISTS = 6;
    static final int OPT_FUNCTIONS = 7;
    static final int OPT_GLOBALS = 8;
    static final int OPT_HOSTNAME = 9;
    static final int OPT_LEVEL = 10;
    static final int OPT_LIBRARY = 11;
    static final int OPT_LOADED = 12;
    static final int OPT_LOCALS = 13;
    static final int OPT_NAMEOFEXECUTABLE = 14;
    static final int OPT_PATCHLEVEL = 15;
    static final int OPT_PROCS = 16;
    static final int OPT_SCRIPT = 17;
    static final int OPT_SHAREDLIBEXTENSION = 18;
    static final int OPT_TCLVERSION = 19;
    static final int OPT_VARS = 20;

    @Override
    public void cmdProc(Interp interp, TclObject[] tclObjectArray) throws TclException {
        if (tclObjectArray.length < 2) {
            throw new TclNumArgsException(interp, 1, tclObjectArray, "option ?arg arg ...?");
        }
        int n = TclIndex.get(interp, tclObjectArray[1], validCmds, "option", 0);
        switch (n) {
            case 0: {
                InfoCmd.InfoArgsCmd(interp, tclObjectArray);
                break;
            }
            case 1: {
                InfoCmd.InfoBodyCmd(interp, tclObjectArray);
                break;
            }
            case 2: {
                InfoCmd.InfoCmdCountCmd(interp, tclObjectArray);
                break;
            }
            case 3: {
                InfoCmd.InfoCommandsCmd(interp, tclObjectArray);
                break;
            }
            case 4: {
                InfoCmd.InfoCompleteCmd(interp, tclObjectArray);
                break;
            }
            case 5: {
                InfoCmd.InfoDefaultCmd(interp, tclObjectArray);
                break;
            }
            case 6: {
                InfoCmd.InfoExistsCmd(interp, tclObjectArray);
                break;
            }
            case 7: {
                this.InfoFunctionsCmd(interp, tclObjectArray);
                break;
            }
            case 8: {
                InfoCmd.InfoGlobalsCmd(interp, tclObjectArray);
                break;
            }
            case 9: {
                InfoCmd.InfoHostnameCmd(interp, tclObjectArray);
                break;
            }
            case 10: {
                InfoCmd.InfoLevelCmd(interp, tclObjectArray);
                break;
            }
            case 11: {
                InfoCmd.InfoLibraryCmd(interp, tclObjectArray);
                break;
            }
            case 12: {
                InfoCmd.InfoLoadedCmd(interp, tclObjectArray);
                break;
            }
            case 13: {
                InfoCmd.InfoLocalsCmd(interp, tclObjectArray);
                break;
            }
            case 14: {
                InfoCmd.InfoNameOfExecutableCmd(interp, tclObjectArray);
                break;
            }
            case 15: {
                InfoCmd.InfoPatchLevelCmd(interp, tclObjectArray);
                break;
            }
            case 16: {
                InfoCmd.InfoProcsCmd(interp, tclObjectArray);
                break;
            }
            case 17: {
                InfoCmd.InfoScriptCmd(interp, tclObjectArray);
                break;
            }
            case 18: {
                InfoCmd.InfoSharedlibCmd(interp, tclObjectArray);
                break;
            }
            case 19: {
                InfoCmd.InfoTclVersionCmd(interp, tclObjectArray);
                break;
            }
            case 20: {
                InfoCmd.InfoVarsCmd(interp, tclObjectArray);
            }
        }
    }

    private static void InfoArgsCmd(Interp interp, TclObject[] tclObjectArray) throws TclException {
        if (tclObjectArray.length != 3) {
            throw new TclNumArgsException(interp, 2, tclObjectArray, "procname");
        }
        String string = tclObjectArray[2].toString();
        Procedure procedure = Procedure.findProc(interp, string);
        if (procedure == null) {
            throw new TclException(interp, "\"" + string + "\" isn't a procedure");
        }
        TclObject tclObject = TclList.newInstance();
        for (int i = 0; i < procedure.argList.length; ++i) {
            TclObject tclObject2 = TclString.newInstance(procedure.argList[i][0]);
            TclList.append(interp, tclObject, tclObject2);
        }
        interp.setResult(tclObject);
    }

    private static void InfoBodyCmd(Interp interp, TclObject[] tclObjectArray) throws TclException {
        if (tclObjectArray.length != 3) {
            throw new TclNumArgsException(interp, 2, tclObjectArray, "procname");
        }
        String string = tclObjectArray[2].toString();
        Procedure procedure = Procedure.findProc(interp, string);
        if (procedure == null) {
            throw new TclException(interp, "\"" + string + "\" isn't a procedure");
        }
        interp.setResult(procedure.body.toString());
    }

    private static void InfoCmdCountCmd(Interp interp, TclObject[] tclObjectArray) throws TclException {
        if (tclObjectArray.length != 2) {
            throw new TclNumArgsException(interp, 2, tclObjectArray, null);
        }
        interp.setResult(interp.cmdCount);
    }

    private static void InfoCommandsCmd(Interp interp, TclObject[] tclObjectArray) throws TclException {
        Namespace namespace;
        String string;
        Namespace namespace2 = Namespace.getGlobalNamespace(interp);
        Namespace namespace3 = Namespace.getCurrentNamespace(interp);
        boolean bl = false;
        if (tclObjectArray.length == 2) {
            string = null;
            namespace = namespace3;
            bl = false;
        } else if (tclObjectArray.length == 3) {
            String string2 = tclObjectArray[2].toString();
            Iterator<Map.Entry<String, WrappedCommand>> iterator = interp.getnfqnResult;
            Namespace.getNamespaceForQualName(interp, string2, null, 0, (Namespace.GetNamespaceForQualNameResult)((Object)iterator));
            namespace = ((Namespace.GetNamespaceForQualNameResult)((Object)iterator)).ns;
            string = ((Namespace.GetNamespaceForQualNameResult)((Object)iterator)).simpleName;
            if (namespace != null) {
                bl = string.compareTo(string2) != 0;
            }
        } else {
            throw new TclNumArgsException(interp, 2, tclObjectArray, "?pattern?");
        }
        TclObject tclObject = TclList.newInstance();
        if (namespace != null) {
            String string3;
            for (Map.Entry<String, WrappedCommand> entry : namespace.cmdTable.entrySet()) {
                TclObject tclObject2;
                string3 = (String)entry.getKey();
                if (string != null && !Util.stringMatch(string3, string)) continue;
                if (bl) {
                    WrappedCommand wrappedCommand = (WrappedCommand)entry.getValue();
                    tclObject2 = TclString.newInstance(interp.getCommandFullName(wrappedCommand));
                } else {
                    tclObject2 = TclString.newInstance(string3);
                }
                TclList.append(interp, tclObject, tclObject2);
            }
            if (namespace != namespace2 && !bl) {
                for (Map.Entry<String, WrappedCommand> entry : namespace2.cmdTable.entrySet()) {
                    string3 = entry.getKey();
                    if (string != null && !Util.stringMatch(string3, string) || namespace.cmdTable.get(string3) != null) continue;
                    TclList.append(interp, tclObject, TclString.newInstance(string3));
                }
            }
        }
        interp.setResult(tclObject);
    }

    private static void InfoCompleteCmd(Interp interp, TclObject[] tclObjectArray) throws TclException {
        if (tclObjectArray.length != 3) {
            throw new TclNumArgsException(interp, 2, tclObjectArray, "command");
        }
        interp.setResult(Interp.commandComplete(tclObjectArray[2].toString()));
    }

    private static void InfoDefaultCmd(Interp interp, TclObject[] tclObjectArray) throws TclException {
        if (tclObjectArray.length != 5) {
            throw new TclNumArgsException(interp, 2, tclObjectArray, "procname arg varname");
        }
        String string = tclObjectArray[2].toString();
        String string2 = tclObjectArray[3].toString();
        Procedure procedure = Procedure.findProc(interp, string);
        if (procedure == null) {
            throw new TclException(interp, "\"" + string + "\" isn't a procedure");
        }
        for (int i = 0; i < procedure.argList.length; ++i) {
            if (!string2.equals(procedure.argList[i][0].toString())) continue;
            String string3 = tclObjectArray[4].toString();
            try {
                if (procedure.argList[i][1] != null) {
                    interp.setVar(string3, procedure.argList[i][1], 0);
                    interp.setResult(1L);
                } else {
                    interp.setVar(string3, "", 0);
                    interp.setResult(0L);
                }
            }
            catch (TclException tclException) {
                throw new TclException(interp, "couldn't store default value in variable \"" + string3 + "\"");
            }
            return;
        }
        throw new TclException(interp, "procedure \"" + string + "\" doesn't have an argument \"" + string2 + "\"");
    }

    private static void InfoExistsCmd(Interp interp, TclObject[] tclObjectArray) throws TclException {
        Var var = null;
        if (tclObjectArray.length != 3) {
            throw new TclNumArgsException(interp, 2, tclObjectArray, "varName");
        }
        String string = tclObjectArray[2].toString();
        Var[] varArray = Var.lookupVar(interp, string, null, 0, "access", false, false);
        if (varArray != null) {
            var = varArray[0];
        }
        if (var != null && !var.isVarUndefined()) {
            interp.setResult(true);
        } else {
            interp.setResult(false);
        }
    }

    private void InfoFunctionsCmd(Interp interp, TclObject[] tclObjectArray) throws TclException {
        String string;
        Expression expression = new Expression();
        if (tclObjectArray.length == 2) {
            string = null;
        } else if (tclObjectArray.length == 3) {
            string = tclObjectArray[2].toString();
        } else {
            throw new TclNumArgsException(interp, 2, tclObjectArray, "?pattern?");
        }
        TclObject tclObject = TclList.newInstance();
        Set<Map.Entry<String, MathFunction>> set = expression.mathFuncTable.entrySet();
        for (Map.Entry<String, MathFunction> entry : set) {
            String string2 = entry.getKey();
            if (string != null && !Util.stringMatch(string2, string)) continue;
            TclList.append(interp, tclObject, TclString.newInstance(string2));
        }
        interp.setResult(tclObject);
    }

    private static void InfoGlobalsCmd(Interp interp, TclObject[] tclObjectArray) throws TclException {
        String string;
        Namespace namespace = Namespace.getGlobalNamespace(interp);
        if (tclObjectArray.length == 2) {
            string = null;
        } else if (tclObjectArray.length == 3) {
            string = NamespaceCmd.tail(tclObjectArray[2].toString());
        } else {
            throw new TclNumArgsException(interp, 2, tclObjectArray, "?pattern?");
        }
        TclObject tclObject = TclList.newInstance();
        for (Map.Entry<String, Var> entry : namespace.varTable.entrySet()) {
            String string2 = entry.getKey();
            Var var = entry.getValue();
            if (var.isVarUndefined() || string != null && !Util.stringMatch(string2, string)) continue;
            TclList.append(interp, tclObject, TclString.newInstance(string2));
        }
        interp.setResult(tclObject);
    }

    private static void InfoHostnameCmd(Interp interp, TclObject[] tclObjectArray) throws TclException {
        String string = null;
        if (tclObjectArray.length != 2) {
            throw new TclNumArgsException(interp, 2, tclObjectArray, null);
        }
        try {
            string = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        if (string != null) {
            interp.setResult(string);
            return;
        }
        interp.setResult("unable to determine name of host");
    }

    private static void InfoLevelCmd(Interp interp, TclObject[] tclObjectArray) throws TclException {
        if (tclObjectArray.length == 2) {
            if (interp.varFrame == null) {
                interp.setResult(0L);
            } else {
                interp.setResult(interp.varFrame.level);
            }
            return;
        }
        if (tclObjectArray.length == 3) {
            int n = TclInteger.getInt(interp, tclObjectArray[2]);
            if (n <= 0) {
                if (interp.varFrame == null) {
                    throw new TclException(interp, "bad level \"" + tclObjectArray[2].toString() + "\"");
                }
                n += interp.varFrame.level;
            }
            CallFrame callFrame = interp.varFrame;
            while (callFrame != null && callFrame.level != n) {
                callFrame = callFrame.callerVar;
            }
            if (callFrame == null || callFrame.objv == null) {
                throw new TclException(interp, "bad level \"" + tclObjectArray[2].toString() + "\"");
            }
            TclObject tclObject = TclList.newInstance();
            for (int i = 0; i < callFrame.objv.length; ++i) {
                TclList.append(interp, tclObject, TclString.newInstance(callFrame.objv[i]));
            }
            interp.setResult(tclObject);
            return;
        }
        throw new TclNumArgsException(interp, 2, tclObjectArray, "?number?");
    }

    private static void InfoLibraryCmd(Interp interp, TclObject[] tclObjectArray) throws TclException {
        if (tclObjectArray.length != 2) {
            throw new TclNumArgsException(interp, 2, tclObjectArray, null);
        }
        try {
            interp.setResult(interp.getVar("tcl_library", 1));
            return;
        }
        catch (TclException tclException) {
            throw new TclException(interp, "no library has been specified for Tcl");
        }
    }

    private static void InfoLoadedCmd(Interp interp, TclObject[] tclObjectArray) throws TclException {
        Interp interp2;
        if (tclObjectArray.length != 2 && tclObjectArray.length != 3) {
            throw new TclNumArgsException(interp, 2, tclObjectArray, "?interp?");
        }
        if (tclObjectArray.length == 3 && (interp2 = InterpCmd.getInterp(interp, tclObjectArray[2])) == null) {
            throw new TclException(interp, "could not find interpreter \"" + tclObjectArray[2].toString() + "\"");
        }
        interp.setResult(TclString.newInstance(""));
    }

    private static void InfoLocalsCmd(Interp interp, TclObject[] tclObjectArray) throws TclException {
        String string;
        if (tclObjectArray.length == 2) {
            string = null;
        } else if (tclObjectArray.length == 3) {
            string = tclObjectArray[2].toString();
        } else {
            throw new TclNumArgsException(interp, 2, tclObjectArray, "?pattern?");
        }
        if (interp.varFrame == null || !interp.varFrame.isProcCallFrame) {
            return;
        }
        TclObject tclObject = TclList.newInstance();
        Var.AppendLocals(interp, tclObject, string, false);
        interp.setResult(tclObject);
    }

    private static void InfoNameOfExecutableCmd(Interp interp, TclObject[] tclObjectArray) throws TclException {
        if (tclObjectArray.length != 2) {
            throw new TclNumArgsException(interp, 2, tclObjectArray, null);
        }
        String string = interp.getNameOfExecutable();
        boolean bl = false;
        File file = null;
        if (string == null) {
            bl = true;
        } else {
            file = new File(string);
            if (!file.exists()) {
                bl = true;
            }
        }
        if (bl) {
            Object object;
            String string2;
            boolean bl2 = Util.isWindows();
            String string3 = bl2 ? "\r\n" : "\n";
            String string4 = bl2 ? ".bat" : ".sh";
            try {
                file = File.createTempFile("jtcl", string4);
                string = file.getCanonicalPath();
            }
            catch (IOException iOException) {
                throw new TclException(interp, "Could not create temp file for [info nameofexecutable]");
            }
            String string5 = "java";
            String string6 = System.getProperty("java.home");
            if (string6 != null) {
                string2 = bl2 ? ".exe" : "";
                object = new File(new File(new File(string6), "bin"), "java" + string2);
                if (((File)object).exists()) {
                    string5 = ((File)object).getPath();
                } else {
                    object = new File(new File(new File(new File(string6), "jre"), "sh"), "java");
                    if (((File)object).exists()) {
                        string5 = ((File)object).getPath();
                    }
                }
            }
            string2 = bl2 ? "@echo off" + string3 : "#!" + string3 + "exec ";
            string2 = string2 + "\"" + string5 + "\"";
            object = System.getProperty("java.class.path");
            if (object != null) {
                string2 = string2 + " -classpath \"" + (String)object + "\" ";
            }
            string2 = string2 + interp.getShellClassName();
            string2 = string2 + (bl2 ? " %*" : " ${1+\"$@\"}") + string3;
            FileWriter fileWriter = null;
            try {
                fileWriter = new FileWriter(file);
                fileWriter.write(string2);
                fileWriter.close();
            }
            catch (Exception exception) {
                throw new TclException(interp, "Could not write temp file [info nameofexecutable]");
            }
            file.deleteOnExit();
            if (!bl2) {
                try {
                    Process process = Runtime.getRuntime().exec("chmod +x " + file.getPath());
                    process.waitFor();
                    process.destroy();
                }
                catch (Exception exception) {
                    throw new TclException(interp, "Couldn't set executable file as executable [name of executable]");
                }
            }
            interp.setNameOfExecutable(string);
        }
        interp.setResult(string);
    }

    private static void InfoPatchLevelCmd(Interp interp, TclObject[] tclObjectArray) throws TclException {
        if (tclObjectArray.length != 2) {
            throw new TclNumArgsException(interp, 2, tclObjectArray, null);
        }
        interp.setResult(interp.getVar("tcl_patchLevel", 1));
    }

    private static void InfoProcsCmd(Interp interp, TclObject[] tclObjectArray) throws TclException {
        String string;
        Namespace namespace = Namespace.getCurrentNamespace(interp);
        String string2 = null;
        if (tclObjectArray.length == 2) {
            string = null;
        } else if (tclObjectArray.length == 3) {
            string = tclObjectArray[2].toString();
            int n = string.lastIndexOf("::");
            if (n >= 0) {
                string2 = string.substring(0, n + 2);
                namespace = Namespace.findNamespace(interp, string2, null, 0);
                string = string.substring(n + 2);
            }
        } else {
            throw new TclNumArgsException(interp, 2, tclObjectArray, "?pattern?");
        }
        TclObject tclObject = TclList.newInstance();
        if (namespace != null) {
            for (Map.Entry<String, WrappedCommand> entry : namespace.cmdTable.entrySet()) {
                String string3 = entry.getKey();
                WrappedCommand wrappedCommand = entry.getValue();
                WrappedCommand wrappedCommand2 = Namespace.getOriginalCommand(wrappedCommand);
                if (!Procedure.isProc(wrappedCommand) && (wrappedCommand2 == null || !Procedure.isProc(wrappedCommand2)) || string != null && !Util.stringMatch(string3, string)) continue;
                String string4 = (string2 == null ? "" : namespace.toString() + "::") + string3;
                if (string4.startsWith("::::")) {
                    string4 = string4.substring(2);
                }
                TclList.append(interp, tclObject, TclString.newInstance(string4));
            }
        }
        interp.setResult(tclObject);
    }

    private static void InfoScriptCmd(Interp interp, TclObject[] tclObjectArray) throws TclException {
        if (tclObjectArray.length == 3) {
            interp.scriptFile = tclObjectArray[2].toString();
        } else if (tclObjectArray.length != 2) {
            throw new TclNumArgsException(interp, 2, tclObjectArray, "?filename?");
        }
        interp.setResult(interp.scriptFile);
    }

    private static void InfoSharedlibCmd(Interp interp, TclObject[] tclObjectArray) throws TclException {
        if (tclObjectArray.length != 2) {
            throw new TclNumArgsException(interp, 2, tclObjectArray, null);
        }
        interp.setResult(".jar");
    }

    private static void InfoTclVersionCmd(Interp interp, TclObject[] tclObjectArray) throws TclException {
        if (tclObjectArray.length != 2) {
            throw new TclNumArgsException(interp, 2, tclObjectArray, null);
        }
        interp.setResult(interp.getVar("tcl_version", 1));
    }

    private static void InfoVarsCmd(Interp interp, TclObject[] tclObjectArray) throws TclException {
        Namespace namespace;
        String string;
        Namespace namespace2 = Namespace.getGlobalNamespace(interp);
        Namespace namespace3 = Namespace.getCurrentNamespace(interp);
        boolean bl = false;
        if (tclObjectArray.length == 2) {
            string = null;
            namespace = namespace3;
            bl = false;
        } else if (tclObjectArray.length == 3) {
            String string2 = tclObjectArray[2].toString();
            Iterator<Map.Entry<String, Var>> iterator = interp.getnfqnResult;
            Namespace.getNamespaceForQualName(interp, string2, null, 0, (Namespace.GetNamespaceForQualNameResult)((Object)iterator));
            namespace = ((Namespace.GetNamespaceForQualNameResult)((Object)iterator)).ns;
            string = ((Namespace.GetNamespaceForQualNameResult)((Object)iterator)).simpleName;
            if (namespace != null) {
                bl = string.compareTo(string2) != 0;
            }
        } else {
            throw new TclNumArgsException(interp, 2, tclObjectArray, "?pattern?");
        }
        if (namespace == null) {
            return;
        }
        TclObject tclObject = TclList.newInstance();
        if (interp.varFrame == null || !interp.varFrame.isProcCallFrame || bl) {
            Var var;
            String string3;
            for (Map.Entry<String, Var> entry : namespace.varTable.entrySet()) {
                string3 = (String)entry.getKey();
                var = (Var)entry.getValue();
                if (var.isVarUndefined() && !var.isVarNamespace() || string != null && !Util.stringMatch(string3, string)) continue;
                TclObject tclObject2 = bl ? TclString.newInstance(Var.getVariableFullName(interp, var)) : TclString.newInstance(string3);
                TclList.append(interp, tclObject, tclObject2);
            }
            if (namespace != namespace2 && !bl) {
                for (Map.Entry<String, Var> entry : namespace2.varTable.entrySet()) {
                    string3 = entry.getKey();
                    var = entry.getValue();
                    if (var.isVarUndefined() && !var.isVarNamespace() || string != null && !Util.stringMatch(string3, string) || namespace.varTable.get(string3) != null) continue;
                    TclList.append(interp, tclObject, TclString.newInstance(string3));
                }
            }
        } else {
            Var.AppendLocals(interp, tclObject, string, true);
        }
        interp.setResult(tclObject);
    }
}

