/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang.cmd;

import java.util.Map;
import tcl.lang.AssocData;
import tcl.lang.CommandWithDispose;
import tcl.lang.Interp;
import tcl.lang.Namespace;
import tcl.lang.TclException;
import tcl.lang.TclIO;
import tcl.lang.TclIndex;
import tcl.lang.TclInteger;
import tcl.lang.TclList;
import tcl.lang.TclNumArgsException;
import tcl.lang.TclObject;
import tcl.lang.TclRuntimeError;
import tcl.lang.TclString;
import tcl.lang.WrappedCommand;
import tcl.lang.channel.Channel;
import tcl.lang.cmd.InterpAliasCmd;
import tcl.lang.cmd.InterpCmd;

public class InterpSlaveCmd
implements CommandWithDispose,
AssocData {
    private static final String[] options = new String[]{"alias", "aliases", "eval", "expose", "hide", "hidden", "issafe", "invokehidden", "marktrusted", "recursionlimit"};
    private static final int OPT_ALIAS = 0;
    private static final int OPT_ALIASES = 1;
    private static final int OPT_EVAL = 2;
    private static final int OPT_EXPOSE = 3;
    private static final int OPT_HIDE = 4;
    private static final int OPT_HIDDEN = 5;
    private static final int OPT_ISSAFE = 6;
    private static final int OPT_INVOKEHIDDEN = 7;
    private static final int OPT_MARKTRUSTED = 8;
    private static final int OPT_RECURSIONLMT = 9;
    private static final String[] hiddenOptions = new String[]{"-global", "--"};
    private static final int OPT_HIDDEN_GLOBAL = 0;
    private static final int OPT_HIDDEN_LAST = 1;
    Interp masterInterp;
    String path;
    Interp slaveInterp;
    WrappedCommand interpCmd;
    static final boolean debug = false;

    @Override
    public void cmdProc(Interp interp, TclObject[] tclObjectArray) throws TclException {
        if (tclObjectArray.length < 2) {
            throw new TclNumArgsException(interp, 1, tclObjectArray, "cmd ?arg ...?");
        }
        int n = TclIndex.get(interp, tclObjectArray[1], options, "option", 0);
        switch (n) {
            case 0: {
                if (tclObjectArray.length == 3) {
                    InterpAliasCmd.describe(interp, this.slaveInterp, tclObjectArray[2]);
                    return;
                }
                if (tclObjectArray.length == 4 && "".equals(tclObjectArray[3].toString())) {
                    InterpAliasCmd.delete(interp, this.slaveInterp, tclObjectArray[2]);
                    return;
                }
                if (tclObjectArray.length >= 4) {
                    InterpAliasCmd.create(interp, this.slaveInterp, interp, tclObjectArray[2], tclObjectArray[3], 4, tclObjectArray);
                    return;
                }
                throw new TclNumArgsException(interp, 2, tclObjectArray, "aliasName ?targetName? ?args..?");
            }
            case 1: {
                if (tclObjectArray.length != 2) {
                    throw new TclNumArgsException(interp, 2, tclObjectArray, null);
                }
                InterpAliasCmd.list(interp, this.slaveInterp);
                break;
            }
            case 2: {
                if (tclObjectArray.length < 3) {
                    throw new TclNumArgsException(interp, 2, tclObjectArray, "arg ?arg ...?");
                }
                InterpSlaveCmd.eval(interp, this.slaveInterp, 2, tclObjectArray);
                break;
            }
            case 3: {
                if (tclObjectArray.length < 3 || tclObjectArray.length > 4) {
                    throw new TclNumArgsException(interp, 2, tclObjectArray, "hiddenCmdName ?cmdName?");
                }
                InterpSlaveCmd.expose(interp, this.slaveInterp, 2, tclObjectArray);
                break;
            }
            case 4: {
                if (tclObjectArray.length < 3 || tclObjectArray.length > 4) {
                    throw new TclNumArgsException(interp, 2, tclObjectArray, "cmdName ?hiddenCmdName?");
                }
                InterpSlaveCmd.hide(interp, this.slaveInterp, 2, tclObjectArray);
                break;
            }
            case 5: {
                if (tclObjectArray.length != 2) {
                    throw new TclNumArgsException(interp, 2, tclObjectArray, null);
                }
                InterpSlaveCmd.hidden(interp, this.slaveInterp);
                break;
            }
            case 6: {
                if (tclObjectArray.length != 2) {
                    throw new TclNumArgsException(interp, 2, tclObjectArray, null);
                }
                interp.setResult(this.slaveInterp.isSafe);
                break;
            }
            case 7: {
                int n2;
                boolean bl = false;
                for (n2 = 2; n2 < tclObjectArray.length && tclObjectArray[n2].toString().charAt(0) == '-'; ++n2) {
                    int n3 = TclIndex.get(interp, tclObjectArray[n2], hiddenOptions, "option", 0);
                    if (n3 != 0) {
                        ++n2;
                        break;
                    }
                    bl = true;
                }
                if (tclObjectArray.length - n2 < 1) {
                    throw new TclNumArgsException(interp, 2, tclObjectArray, "?-global? ?--? cmd ?arg ..?");
                }
                InterpSlaveCmd.invokeHidden(interp, this.slaveInterp, bl, n2, tclObjectArray);
                break;
            }
            case 8: {
                if (tclObjectArray.length != 2) {
                    throw new TclNumArgsException(interp, 2, tclObjectArray, null);
                }
                InterpSlaveCmd.markTrusted(interp, this.slaveInterp);
                break;
            }
            case 9: {
                if (tclObjectArray.length != 2 && tclObjectArray.length != 3) {
                    throw new TclNumArgsException(interp, 2, tclObjectArray, "?newlimit?");
                }
                InterpSlaveCmd.recursionLimit(interp, this.slaveInterp, tclObjectArray.length - 2, tclObjectArray);
            }
        }
    }

    @Override
    public void disposeCmd() {
        this.masterInterp.slaveTable.remove(this.path);
        this.interpCmd = null;
        if (this.slaveInterp != null) {
            this.slaveInterp.dispose();
        }
    }

    @Override
    public void disposeAssocData(Interp interp) {
        if (!interp.slaveTable.isEmpty()) {
            throw new TclRuntimeError("disposeAssocData: commands still exist");
        }
        interp.slaveTable = null;
        Object object = interp.targetTable.entrySet().iterator();
        while (object.hasNext()) {
            Map.Entry entry = object.next();
            WrappedCommand wrappedCommand = (WrappedCommand)entry.getKey();
            Interp interp2 = (Interp)entry.getValue();
            interp2.deleteCommandFromToken(wrappedCommand);
        }
        interp.targetTable = null;
        if (interp.interpChanTable != null) {
            while ((object = (Channel)Namespace.FirstHashEntry(interp.interpChanTable)) != null) {
                TclIO.unregisterChannel(interp, (Channel)object);
            }
        }
        if (interp.slave.interpCmd != null) {
            interp.slave.slaveInterp = null;
            interp.slave.masterInterp.deleteCommandFromToken(interp.slave.interpCmd);
        }
        if (!interp.aliasTable.isEmpty()) {
            throw new TclRuntimeError("disposeAssocData: aliases still exist");
        }
        interp.aliasTable = null;
    }

    static Interp create(Interp interp, TclObject tclObject, boolean bl) throws TclException {
        Object object;
        String string;
        Interp interp2;
        TclObject[] tclObjectArray = TclList.getElements(interp, tclObject);
        if (tclObjectArray.length < 2) {
            interp2 = interp;
            string = tclObject.toString();
        } else {
            object = TclList.newInstance();
            TclList.insert(interp, (TclObject)object, 0, tclObjectArray, 0, tclObjectArray.length - 2);
            interp2 = InterpCmd.getInterp(interp, (TclObject)object);
            string = tclObjectArray[tclObjectArray.length - 1].toString();
        }
        if (!bl) {
            bl = interp2.isSafe;
        }
        if (interp2.slaveTable.containsKey(string)) {
            throw new TclException(interp, "interpreter named \"" + string + "\" already exists, cannot create");
        }
        object = new Interp();
        InterpSlaveCmd interpSlaveCmd = new InterpSlaveCmd();
        ((Interp)object).setMaxNestingDepth(interp2.getMaxNestingDepth());
        ((Interp)object).slave = interpSlaveCmd;
        ((Interp)object).setAssocData("InterpSlaveCmd", interpSlaveCmd);
        ((Interp)object).setWorkingDir(interp.getWorkingDir().getPath());
        interpSlaveCmd.masterInterp = interp2;
        interpSlaveCmd.path = string;
        interpSlaveCmd.slaveInterp = object;
        interp2.createCommand(string, ((Interp)object).slave);
        ((Interp)object).slave.interpCmd = Namespace.findCommand(interp2, string, null, 0);
        interp2.slaveTable.put(string, ((Interp)object).slave);
        ((Interp)object).setVar("tcl_interactive", "0", 1);
        if (bl) {
            try {
                InterpSlaveCmd.makeSafe((Interp)object);
            }
            catch (TclException tclException) {
                tclException.printStackTrace();
            }
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void eval(Interp interp, Interp interp2, int n, TclObject[] tclObjectArray) throws TclException {
        interp2.preserve();
        try {
            int n2;
            interp2.allowExceptions();
            try {
                if (n + 1 == tclObjectArray.length) {
                    interp2.eval(tclObjectArray[n], 0);
                } else {
                    TclObject tclObject = TclList.newInstance();
                    for (int i = n; i < tclObjectArray.length; ++i) {
                        TclList.append(interp, tclObject, tclObjectArray[i]);
                    }
                    tclObject.preserve();
                    interp2.eval(tclObject, 0);
                    tclObject.release();
                }
                n2 = interp2.returnCode;
            }
            catch (TclException tclException) {
                n2 = tclException.getCompletionCode();
            }
            interp.transferResult(interp2, n2);
        }
        finally {
            interp2.release();
        }
    }

    static void expose(Interp interp, Interp interp2, int n, TclObject[] tclObjectArray) throws TclException {
        if (interp.isSafe) {
            throw new TclException(interp, "permission denied: safe interpreter cannot expose commands");
        }
        int n2 = tclObjectArray.length - n == 1 ? n : n + 1;
        try {
            interp2.exposeCommand(tclObjectArray[n].toString(), tclObjectArray[n2].toString());
        }
        catch (TclException tclException) {
            interp.transferResult(interp2, tclException.getCompletionCode());
            throw tclException;
        }
    }

    static void hide(Interp interp, Interp interp2, int n, TclObject[] tclObjectArray) throws TclException {
        if (interp.isSafe) {
            throw new TclException(interp, "permission denied: safe interpreter cannot hide commands");
        }
        int n2 = tclObjectArray.length - n == 1 ? n : n + 1;
        try {
            interp2.hideCommand(tclObjectArray[n].toString(), tclObjectArray[n2].toString());
        }
        catch (TclException tclException) {
            interp.transferResult(interp2, tclException.getCompletionCode());
            throw tclException;
        }
    }

    static void hidden(Interp interp, Interp interp2) throws TclException {
        if (interp2.hiddenCmdTable == null) {
            return;
        }
        TclObject tclObject = TclList.newInstance();
        for (Map.Entry entry : interp2.hiddenCmdTable.entrySet()) {
            String string = (String)entry.getKey();
            TclList.append(interp, tclObject, TclString.newInstance(string));
        }
        interp.setResult(tclObject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void invokeHidden(Interp interp, Interp interp2, boolean bl, int n, TclObject[] tclObjectArray) throws TclException {
        if (interp.isSafe) {
            throw new TclException(interp, "not allowed to invoke hidden commands from safe interpreter");
        }
        interp2.preserve();
        try {
            int n2;
            interp2.allowExceptions();
            TclObject[] tclObjectArray2 = new TclObject[tclObjectArray.length - n];
            for (int i = 0; i < tclObjectArray.length - n; ++i) {
                tclObjectArray2[i] = tclObjectArray[i + n];
            }
            try {
                if (bl) {
                    interp2.invokeGlobal(tclObjectArray2, 1);
                } else {
                    interp2.invoke(tclObjectArray2, 1);
                }
                n2 = interp2.returnCode;
            }
            catch (TclException tclException) {
                n2 = tclException.getCompletionCode();
            }
            interp.transferResult(interp2, n2);
        }
        finally {
            interp2.release();
        }
    }

    static void markTrusted(Interp interp, Interp interp2) throws TclException {
        if (interp.isSafe) {
            throw new TclException(interp, "permission denied: safe interpreter cannot mark trusted");
        }
        interp2.isSafe = false;
    }

    static void recursionLimit(Interp interp, Interp interp2, int n, TclObject[] tclObjectArray) throws TclException {
        if (n != 0) {
            if (interp.isSafe) {
                throw new TclException(interp, "permission denied: safe interpreters cannot change recursion limit");
            }
            int n2 = TclInteger.getInt(interp, tclObjectArray[tclObjectArray.length - 1]);
            if (n2 <= 0) {
                throw new TclException(interp, "recursion limit must be > 0");
            }
            interp2.setMaxNestingDepth(n2);
            if (interp == interp2 && interp.nestLevel > n2) {
                throw new TclException(interp, "falling back due to new recursion limit");
            }
            interp.setResult(tclObjectArray[tclObjectArray.length - 1]);
        } else {
            int n3 = interp2.setMaxNestingDepth(0);
            interp.setResult(TclInteger.newInstance(n3));
        }
    }

    private static void makeSafe(Interp interp) throws TclException {
        interp.hideUnsafeCommands();
        interp.isSafe = true;
        try {
            interp.unsetVar("env", 1);
        }
        catch (TclException tclException) {
            // empty catch block
        }
        try {
            interp.unsetVar("tcl_platform", "os", 1);
        }
        catch (TclException tclException) {
            // empty catch block
        }
        try {
            interp.unsetVar("tcl_platform", "osVersion", 1);
        }
        catch (TclException tclException) {
            // empty catch block
        }
        try {
            interp.unsetVar("tcl_platform", "machine", 1);
        }
        catch (TclException tclException) {
            // empty catch block
        }
        try {
            interp.unsetVar("tcl_platform", "user", 1);
        }
        catch (TclException tclException) {
            // empty catch block
        }
        try {
            interp.unsetVar("tclDefaultLibrary", 1);
        }
        catch (TclException tclException) {
            // empty catch block
        }
        try {
            interp.unsetVar("tcl_library", 1);
        }
        catch (TclException tclException) {
            // empty catch block
        }
        try {
            interp.unsetVar("tcl_pkgPath", 1);
        }
        catch (TclException tclException) {
            // empty catch block
        }
        Channel channel = TclIO.getStdChannel(0);
        if (channel != null) {
            TclIO.unregisterChannel(interp, channel);
        }
        if ((channel = TclIO.getStdChannel(1)) != null) {
            TclIO.unregisterChannel(interp, channel);
        }
        if ((channel = TclIO.getStdChannel(2)) != null) {
            TclIO.unregisterChannel(interp, channel);
        }
    }

    static Interp getSlave(Interp interp, TclObject tclObject) throws TclException {
        int n = TclList.getLength(interp, tclObject);
        Interp interp2 = interp;
        for (int i = 0; i < n; ++i) {
            TclObject tclObject2 = TclList.index(interp, tclObject, i);
            InterpSlaveCmd interpSlaveCmd = (InterpSlaveCmd)interp2.slaveTable.get(tclObject2.toString());
            if (interpSlaveCmd == null) {
                interp2 = null;
                break;
            }
            interp2 = interpSlaveCmd.slaveInterp;
            if (interp2 == null) break;
        }
        if (interp2 == null) {
            throw new TclException(interp, "could not find interpreter \"" + tclObject + "\"");
        }
        return interp2;
    }
}

