/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang.cmd;

import tcl.lang.Command;
import tcl.lang.Interp;
import tcl.lang.TclException;
import tcl.lang.TclList;
import tcl.lang.TclNumArgsException;
import tcl.lang.TclObject;
import tcl.lang.TclRuntimeError;
import tcl.lang.Util;

public class LindexCmd
implements Command {
    @Override
    public void cmdProc(Interp interp, TclObject[] tclObjectArray) throws TclException {
        if (tclObjectArray.length < 2) {
            throw new TclNumArgsException(interp, 1, tclObjectArray, "list ?index...?");
        }
        TclObject tclObject = tclObjectArray.length == 3 ? LindexCmd.TclLindexList(interp, tclObjectArray[1], tclObjectArray, 2) : LindexCmd.TclLindexFlat(interp, tclObjectArray[1], tclObjectArray.length - 2, tclObjectArray, 2);
        if (tclObject == null) {
            throw new TclRuntimeError("unexpected null result");
        }
        interp.setResult(tclObject);
        tclObject.release();
    }

    public static TclObject TclLindexList(Interp interp, TclObject tclObject, TclObject[] tclObjectArray, int n) throws TclException {
        int n2;
        TclObject tclObject2 = tclObjectArray[n];
        boolean bl = tclObject2.isListType();
        boolean bl2 = false;
        if (!bl) {
            try {
                n2 = Util.getIntForIndex(null, tclObject2, 0);
                bl2 = true;
            }
            catch (TclException tclException) {
                // empty catch block
            }
        }
        if (!bl && bl2) {
            return LindexCmd.TclLindexFlat(interp, tclObject, 1, tclObjectArray, n);
        }
        TclObject[] tclObjectArray2 = null;
        try {
            tclObjectArray2 = TclList.getElements(null, tclObject2);
        }
        catch (TclException tclException) {
            // empty catch block
        }
        if (tclObjectArray2 == null) {
            return LindexCmd.TclLindexFlat(interp, tclObject, 1, tclObjectArray, n);
        }
        tclObject.preserve();
        for (int i = 0; i < tclObjectArray2.length; ++i) {
            int n3;
            try {
                n3 = TclList.getLength(interp, tclObject);
            }
            catch (TclException tclException) {
                tclObject.release();
                throw tclException;
            }
            try {
                n2 = Util.getIntForIndex(interp, tclObjectArray2[i], n3 - 1);
            }
            catch (TclException tclException) {
                tclObject.release();
                throw tclException;
            }
            if (n2 < 0 || n2 >= n3) {
                tclObject.release();
                tclObject = interp.checkCommonString(null);
                tclObject.preserve();
                return tclObject;
            }
            TclObject tclObject3 = tclObject;
            tclObject = TclList.index(interp, tclObject3, n2);
            tclObject.preserve();
            tclObject3.release();
        }
        return tclObject;
    }

    static TclObject TclLindexFlat(Interp interp, TclObject tclObject, int n, TclObject[] tclObjectArray, int n2) throws TclException {
        tclObject.preserve();
        int n3 = n2 + n;
        for (int i = n2; i < n3; ++i) {
            int n4;
            int n5;
            try {
                n5 = TclList.getLength(interp, tclObject);
            }
            catch (TclException tclException) {
                tclObject.release();
                throw tclException;
            }
            try {
                n4 = Util.getIntForIndex(interp, tclObjectArray[i], n5 - 1);
            }
            catch (TclException tclException) {
                tclObject.release();
                throw tclException;
            }
            if (n4 < 0 || n4 >= n5) {
                tclObject.release();
                tclObject = interp.checkCommonString(null);
                tclObject.preserve();
                return tclObject;
            }
            try {
                n5 = TclList.getLength(interp, tclObject);
            }
            catch (TclException tclException) {
                tclObject.release();
                throw tclException;
            }
            TclObject tclObject2 = tclObject;
            tclObject = TclList.index(interp, tclObject2, n4);
            tclObject.preserve();
            tclObject2.release();
        }
        return tclObject;
    }
}

