/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang.cmd;

import java.util.ArrayList;
import tcl.lang.Command;
import tcl.lang.Interp;
import tcl.lang.TclException;
import tcl.lang.TclList;
import tcl.lang.TclNumArgsException;
import tcl.lang.TclObject;
import tcl.lang.TclString;
import tcl.lang.Util;
import tcl.lang.Var;

public class LsetCmd
implements Command {
    @Override
    public void cmdProc(Interp interp, TclObject[] tclObjectArray) throws TclException {
        TclObject tclObject;
        if (tclObjectArray.length < 3) {
            throw new TclNumArgsException(interp, 1, tclObjectArray, "listVar index ?index...? value");
        }
        TclObject tclObject2 = Var.getVar(interp, tclObjectArray[1].toString(), null, 512);
        if (tclObject2 == null) {
            throw new TclException(interp, "Cannot find variable name " + tclObjectArray[1].toString());
        }
        if (tclObjectArray.length == 4) {
            tclObject = LsetCmd.list(interp, tclObject2, tclObjectArray[2], tclObjectArray[3]);
        } else {
            TclObject[] tclObjectArray2 = new TclObject[tclObjectArray.length - 3];
            if (tclObjectArray.length > 4) {
                for (int i = 0; i < tclObjectArray.length - 3; ++i) {
                    tclObjectArray2[i] = tclObjectArray[i + 2];
                }
            }
            tclObject = LsetCmd.flat(interp, tclObject2, tclObjectArray.length - 3, tclObjectArray2, tclObjectArray[tclObjectArray.length - 1]);
        }
        if (tclObject == null) {
            throw new TclException(interp, "Substitution has failed!");
        }
        tclObject2 = Var.setVar(interp, tclObjectArray[1].toString(), null, tclObject, 512);
        tclObject.release();
        if (tclObject2 == null) {
            throw new TclException(interp, "Cannot update variable");
        }
        interp.setResult(tclObject2);
    }

    private static final TclObject flat(Interp interp, TclObject tclObject, int n, TclObject[] tclObjectArray, TclObject tclObject2) throws TclException {
        boolean bl;
        boolean bl2 = false;
        int n2 = 0;
        ArrayList<TclObject> arrayList = new ArrayList<TclObject>();
        if (n == 0) {
            tclObject2.preserve();
            return tclObject2;
        }
        if (tclObject.isShared()) {
            bl = true;
            tclObject = tclObject.duplicate();
            tclObject.preserve();
        } else {
            bl = false;
        }
        TclObject tclObject3 = tclObject;
        int n3 = 0;
        while (true) {
            int n4;
            ArrayList arrayList2;
            try {
                arrayList2 = TclList.getElementsList(interp, tclObject);
                n4 = arrayList2.size();
            }
            catch (TclException tclException) {
                break;
            }
            n2 = Util.getIntForIndex(interp, tclObjectArray[n3], n4 - 1);
            if (n2 < 0 || n2 >= n4) {
                interp.setResult(TclString.newInstance("list index out of range"));
                throw new TclException(interp, "list index out of range");
            }
            if (n3 >= n - 1) {
                bl2 = false;
                break;
            }
            TclObject tclObject4 = (TclObject)arrayList2.get(n2);
            if (tclObject4.isShared()) {
                tclObject4 = tclObject4.duplicate();
                try {
                    TclList.setElement(interp, tclObject, n2, tclObject4);
                }
                catch (TclException tclException) {
                    break;
                }
            }
            arrayList.add(tclObject);
            tclObject = tclObject4;
            ++n3;
        }
        if (!bl2) {
            try {
                TclList.lsetElement(interp, tclObject, n2, tclObject2);
                n3 = arrayList.size();
                for (int i = 0; i < n3; ++i) {
                    TclObject tclObject5 = (TclObject)arrayList.get(i);
                    tclObject5.invalidateStringRep();
                }
                tclObject.invalidateStringRep();
                if (!bl) {
                    tclObject3.preserve();
                }
                return tclObject3;
            }
            catch (TclException tclException) {
                if (bl) {
                    tclObject3.release();
                }
                throw tclException;
            }
        }
        if (bl) {
            tclObject3.release();
        }
        return null;
    }

    private static final TclObject list(Interp interp, TclObject tclObject, TclObject tclObject2, TclObject tclObject3) throws TclException {
        boolean bl;
        int n;
        TclObject[] tclObjectArray;
        ArrayList<TclObject> arrayList;
        boolean bl2;
        int n2;
        block27: {
            n2 = 0;
            bl2 = false;
            arrayList = new ArrayList<TclObject>();
            if (!tclObject2.isListType()) {
                try {
                    n2 = Util.getIntForIndex(null, tclObject2, 0);
                    return LsetCmd.flat(interp, tclObject, 1, TclList.getElements(interp, tclObject2), tclObject3);
                }
                catch (TclException tclException) {
                    try {
                        tclObjectArray = TclList.getElements(null, tclObject2);
                        n = tclObjectArray.length;
                        break block27;
                    }
                    catch (TclException tclException2) {
                        interp.setResult(TclString.newInstance(tclException.getMessage()));
                        throw tclException;
                    }
                }
            }
            try {
                tclObjectArray = TclList.getElements(null, tclObject2);
                n = tclObjectArray.length;
            }
            catch (TclException tclException) {
                return LsetCmd.flat(interp, tclObject, 1, TclList.getElements(interp, tclObject2), tclObject3);
            }
        }
        if (n == 0) {
            tclObject3.preserve();
            return tclObject3;
        }
        if (tclObject.isShared()) {
            bl = true;
            tclObject = tclObject.duplicate();
            tclObject.preserve();
        } else {
            bl = false;
        }
        TclObject tclObject4 = tclObject;
        int n3 = 0;
        while (true) {
            int n4;
            ArrayList arrayList2;
            try {
                arrayList2 = TclList.getElementsList(interp, tclObject);
                n4 = arrayList2.size();
            }
            catch (TclException tclException) {
                break;
            }
            try {
                tclObjectArray = TclList.getElements(interp, tclObject2);
                n = tclObjectArray.length;
            }
            catch (TclException tclException) {
                break;
            }
            n2 = Util.getIntForIndex(interp, tclObjectArray[n3], n4 - 1);
            if (n2 < 0 || n2 >= n4) {
                interp.setResult(TclString.newInstance("list index out of range"));
                throw new TclException(interp, "list index out of range");
            }
            if (n3 >= n - 1) {
                bl2 = false;
                break;
            }
            TclObject tclObject5 = (TclObject)arrayList2.get(n2);
            if (tclObject5.isShared()) {
                tclObject5 = tclObject5.duplicate();
                try {
                    TclList.setElement(interp, tclObject, n2, tclObject5);
                }
                catch (TclException tclException) {
                    break;
                }
            }
            arrayList.add(tclObject);
            tclObject = tclObject5;
            ++n3;
        }
        if (!bl2) {
            try {
                TclList.lsetElement(interp, tclObject, n2, tclObject3);
                n3 = arrayList.size();
                for (int i = 0; i < n3; ++i) {
                    TclObject tclObject6 = (TclObject)arrayList.get(i);
                    tclObject6.invalidateStringRep();
                }
                tclObject.invalidateStringRep();
                if (!bl) {
                    tclObject4.preserve();
                }
                return tclObject4;
            }
            catch (TclException tclException) {
                if (bl) {
                    tclObject4.release();
                }
                throw tclException;
            }
        }
        if (bl) {
            tclObject4.release();
        }
        return null;
    }
}

