/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang.cmd;

import java.util.regex.PatternSyntaxException;
import tcl.lang.Command;
import tcl.lang.Interp;
import tcl.lang.Regex;
import tcl.lang.TclException;
import tcl.lang.TclIndex;
import tcl.lang.TclInteger;
import tcl.lang.TclList;
import tcl.lang.TclNumArgsException;
import tcl.lang.TclObject;
import tcl.lang.TclObjectBase;
import tcl.lang.TclString;
import tcl.lang.cmd.RegsubCmd;

public class RegexpCmd
implements Command {
    private static final String[] validOpts = new String[]{"-all", "-about", "-indices", "-inline", "-expanded", "-line", "-linestop", "-lineanchor", "-nocase", "-start", "--"};
    private static final String[] validOptsWithXFlags = new String[]{"-all", "-about", "-indices", "-inline", "-expanded", "-line", "-linestop", "-lineanchor", "-nocase", "-start", "--", "-xflags"};
    private static final int OPT_ALL = 0;
    private static final int OPT_ABOUT = 1;
    private static final int OPT_INDICES = 2;
    private static final int OPT_INLINE = 3;
    private static final int OPT_EXPANDED = 4;
    private static final int OPT_LINE = 5;
    private static final int OPT_LINESTOP = 6;
    private static final int OPT_LINEANCHOR = 7;
    private static final int OPT_NOCASE = 8;
    private static final int OPT_START = 9;
    private static final int OPT_LAST = 10;
    private static final int OPT_XFLAGS = 11;
    private boolean allowXFlags = false;

    public static void init(Interp interp) {
        interp.createCommand("regexp", new RegexpCmd());
        interp.createCommand("regsub", new RegsubCmd());
    }

    public void setAllowXFlags(boolean bl) {
        this.allowXFlags = bl;
    }

    protected TclObject getAboutCompileError(Interp interp) throws TclException {
        TclObject tclObject = TclList.newInstance();
        TclList.append(interp, tclObject, TclString.newInstance("0"));
        TclList.append(interp, tclObject, TclString.newInstance("COMPILE_ERROR"));
        return tclObject;
    }

    @Override
    public void cmdProc(Interp interp, TclObject[] tclObjectArray) throws TclException {
        int n;
        Object object;
        int n2;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        String string = null;
        int n6 = 0;
        block19: for (n2 = 1; n2 < tclObjectArray.length && !bl4 && ((TclObjectBase)(object = tclObjectArray[n2])).toString().length() != 0 && ((TclObjectBase)object).toString().charAt(0) == '-'; ++n2) {
            int n7 = TclIndex.get(interp, (TclObject)object, this.allowXFlags ? validOptsWithXFlags : validOpts, "switch", 0);
            switch (n7) {
                case 1: {
                    bl3 = true;
                    continue block19;
                }
                case 4: {
                    n6 |= 0x20;
                    continue block19;
                }
                case 2: {
                    bl = true;
                    continue block19;
                }
                case 6: {
                    n6 |= 0x40;
                    continue block19;
                }
                case 7: {
                    n6 |= 0x80;
                    continue block19;
                }
                case 5: {
                    n6 |= 0x40;
                    n6 |= 0x80;
                    continue block19;
                }
                case 8: {
                    n6 |= 8;
                    continue block19;
                }
                case 0: {
                    n3 = 1;
                    continue block19;
                }
                case 3: {
                    bl2 = true;
                    continue block19;
                }
                case 9: {
                    if (++n2 >= tclObjectArray.length || (n4 = TclInteger.getInt(interp, tclObjectArray[n2])) >= 0) continue block19;
                    n4 = 0;
                    continue block19;
                }
                case 10: {
                    bl4 = true;
                    continue block19;
                }
                case 11: {
                    if (++n2 >= tclObjectArray.length) continue block19;
                    string = tclObjectArray[n2].toString();
                    bl4 = true;
                }
            }
        }
        if (tclObjectArray.length - n2 < 2 - (bl3 ? 1 : 0)) {
            throw new TclNumArgsException(interp, 1, tclObjectArray, "?switches? exp string ?matchVar? ?subMatchVar subMatchVar ...?");
        }
        if (bl2 && tclObjectArray.length - n2 - 2 != 0) {
            throw new TclException(interp, "regexp match variables not allowed when using -inline");
        }
        object = tclObjectArray[n2++].toString();
        String string2 = bl3 ? "" : tclObjectArray[n2++].toString();
        Regex regex = null;
        TclObject tclObject = TclInteger.newInstance(0L);
        try {
            regex = string == null ? new Regex((String)object, string2, n4, n6) : new Regex((String)object, string2, n4, n6, string);
        }
        catch (PatternSyntaxException patternSyntaxException) {
            interp.setErrorCode(TclString.newInstance("REGEXP COMPILE_ERROR {" + Regex.getPatternSyntaxMessage(patternSyntaxException) + "}"));
            throw new TclException(interp, Regex.getPatternSyntaxMessage(patternSyntaxException));
        }
        catch (Exception exception) {
            interp.setErrorCode(TclString.newInstance("REGEXP COMPILE_ERROR {" + exception.getMessage() + "}"));
            throw new TclException(interp, exception.getMessage());
        }
        if (bl3) {
            interp.setResult(regex.getInfo(interp));
            return;
        }
        do {
            boolean bl5;
            if (!(bl5 = regex.match())) {
                if (n3 <= 1) {
                    if (bl2) {
                        interp.resetResult();
                    } else {
                        interp.setResult(0L);
                    }
                    return;
                }
                break;
            }
            int n8 = regex.groupCount();
            int n9 = 0;
            n5 = bl2 ? n8 + 1 : tclObjectArray.length - n2;
            for (n = 0; n < n5; ++n) {
                TclObject tclObject2;
                int n10;
                int n11;
                if (bl) {
                    if (n9 <= n8) {
                        n11 = regex.start(n9);
                        n10 = regex.end(n9);
                        ++n9;
                        if (n10 >= regex.getOffset()) {
                            --n10;
                        }
                    } else {
                        n11 = -1;
                        n10 = -1;
                    }
                    tclObject2 = TclList.newInstance();
                    TclList.append(interp, tclObject2, TclInteger.newInstance(n11));
                    TclList.append(interp, tclObject2, TclInteger.newInstance(n10));
                } else if (n9 <= n8) {
                    n11 = regex.start(n9);
                    if (n11 == -1) {
                        tclObject2 = TclList.newInstance();
                    } else {
                        n10 = regex.end(n9);
                        String string3 = string2.substring(n11, n10);
                        tclObject2 = TclString.newInstance(string3);
                    }
                    ++n9;
                } else {
                    tclObject2 = TclList.newInstance();
                }
                if (bl2) {
                    interp.appendElement(tclObject2.toString());
                    continue;
                }
                String string4 = tclObjectArray[n2 + n].toString();
                try {
                    interp.setVar(string4, tclObject2, 0);
                    continue;
                }
                catch (TclException tclException) {
                    throw new TclException(interp, "couldn't set variable \"" + string4 + "\"");
                }
            }
            if (n3 == 0) break;
            ++n3;
            n = regex.end();
            if (regex.start() != regex.end()) continue;
            ++n;
        } while (n < string2.length());
        if (!bl2) {
            interp.setResult(n3 != 0 ? (long)(n3 - 1) : 1L);
        }
    }
}

