/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang.cmd;

import java.io.IOException;
import tcl.lang.Command;
import tcl.lang.Interp;
import tcl.lang.TclException;
import tcl.lang.TclIO;
import tcl.lang.TclIndex;
import tcl.lang.TclObject;
import tcl.lang.TclString;
import tcl.lang.Util;
import tcl.lang.channel.ServerSocketChannel;
import tcl.lang.channel.SocketChannel;

public class SocketCmd
implements Command {
    private static final String[] validCmds = new String[]{"-async", "-myaddr", "-myport", "-server"};
    static final int OPT_ASYNC = 0;
    static final int OPT_MYADDR = 1;
    static final int OPT_MYPORT = 2;
    static final int OPT_SERVER = 3;

    @Override
    public void cmdProc(Interp interp, TclObject[] tclObjectArray) throws TclException {
        int n;
        boolean bl = false;
        boolean bl2 = false;
        String string = "";
        String string2 = "";
        String string3 = "";
        int n2 = 0;
        int n3 = 0;
        block8: for (n = 1; n < tclObjectArray.length && tclObjectArray[n].toString().length() > 0 && tclObjectArray[n].toString().charAt(0) == '-'; ++n) {
            int n4 = TclIndex.get(interp, tclObjectArray[n], validCmds, "option", 0);
            switch (n4) {
                case 0: {
                    if (bl) {
                        throw new TclException(interp, "cannot set -async option for server sockets");
                    }
                    bl2 = true;
                    continue block8;
                }
                case 1: {
                    if (++n >= tclObjectArray.length) {
                        throw new TclException(interp, "no argument given for -myaddr option");
                    }
                    string = tclObjectArray[n].toString();
                    continue block8;
                }
                case 2: {
                    if (++n >= tclObjectArray.length) {
                        throw new TclException(interp, "no argument given for -myport option");
                    }
                    n2 = SocketCmd.getPort(interp, tclObjectArray[n]);
                    continue block8;
                }
                case 3: {
                    if (bl2) {
                        throw new TclException(interp, "cannot set -async option for server sockets");
                    }
                    bl = true;
                    if (++n >= tclObjectArray.length) {
                        throw new TclException(interp, "no argument given for -server option");
                    }
                    string2 = tclObjectArray[n].toString();
                    continue block8;
                }
                default: {
                    throw new TclException(interp, "bad option \"" + tclObjectArray[n] + "\", must be -async, -myaddr, -myport, or -server");
                }
            }
        }
        if (bl) {
            string3 = string;
            if (n2 != 0) {
                throw new TclException(interp, "Option -myport is not valid for servers");
            }
        } else if (n + 1 < tclObjectArray.length) {
            string3 = tclObjectArray[n].toString();
            ++n;
        } else {
            SocketCmd.errorWrongNumArgs(interp, tclObjectArray[0].toString());
        }
        if (n == tclObjectArray.length - 1) {
            n3 = SocketCmd.getPort(interp, tclObjectArray[n]);
        } else {
            SocketCmd.errorWrongNumArgs(interp, tclObjectArray[0].toString());
        }
        if (bl) {
            TclObject tclObject = TclString.newInstance(string2);
            ServerSocketChannel serverSocketChannel = new ServerSocketChannel(interp, string, n3, tclObject);
            TclIO.registerChannel(interp, serverSocketChannel);
            interp.setResult(serverSocketChannel.getChanName());
        } else {
            try {
                SocketChannel socketChannel = new SocketChannel(interp, 4, string, n2, bl2, string3, n3);
                TclIO.registerChannel(interp, socketChannel);
                interp.setResult(socketChannel.getChanName());
            }
            catch (IOException iOException) {
                throw new TclException(interp, "couldn't open socket: " + iOException.getMessage().toLowerCase());
            }
        }
    }

    private static void errorWrongNumArgs(Interp interp, String string) throws TclException {
        throw new TclException(interp, "wrong # args: should be either:\n" + string + " ?-myaddr addr? ?-myport myport? ?-async? host port\n" + string + " -server command ?-myaddr addr? port");
    }

    private static int getPort(Interp interp, TclObject tclObject) throws TclException {
        long l = Util.getInt(interp, tclObject.toString());
        if (l > 65535L) {
            throw new TclException(interp, "couldn't open socket: port number too high");
        }
        return (int)l;
    }
}

