/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang.cmd;

import tcl.lang.Command;
import tcl.lang.Expression;
import tcl.lang.Interp;
import tcl.lang.StrtodResult;
import tcl.lang.StrtoulResult;
import tcl.lang.TclByteArray;
import tcl.lang.TclException;
import tcl.lang.TclIndex;
import tcl.lang.TclInteger;
import tcl.lang.TclList;
import tcl.lang.TclNumArgsException;
import tcl.lang.TclObject;
import tcl.lang.TclObjectBase;
import tcl.lang.TclRuntimeError;
import tcl.lang.TclString;
import tcl.lang.Util;

public class StringCmd
implements Command {
    private static final String[] options = new String[]{"bytelength", "compare", "equal", "first", "index", "is", "last", "length", "map", "match", "range", "repeat", "replace", "tolower", "toupper", "totitle", "trim", "trimleft", "trimright", "wordend", "wordstart"};
    private static final int STR_BYTELENGTH = 0;
    private static final int STR_COMPARE = 1;
    private static final int STR_EQUAL = 2;
    private static final int STR_FIRST = 3;
    private static final int STR_INDEX = 4;
    private static final int STR_IS = 5;
    private static final int STR_LAST = 6;
    private static final int STR_LENGTH = 7;
    private static final int STR_MAP = 8;
    private static final int STR_MATCH = 9;
    private static final int STR_RANGE = 10;
    private static final int STR_REPEAT = 11;
    private static final int STR_REPLACE = 12;
    private static final int STR_TOLOWER = 13;
    private static final int STR_TOUPPER = 14;
    private static final int STR_TOTITLE = 15;
    private static final int STR_TRIM = 16;
    private static final int STR_TRIMLEFT = 17;
    private static final int STR_TRIMRIGHT = 18;
    private static final int STR_WORDEND = 19;
    private static final int STR_WORDSTART = 20;
    private static final String[] isOptions = new String[]{"alnum", "alpha", "ascii", "control", "boolean", "digit", "double", "false", "graph", "integer", "lower", "print", "punct", "space", "true", "upper", "wideinteger", "wordchar", "xdigit"};
    private static final int STR_IS_ALNUM = 0;
    private static final int STR_IS_ALPHA = 1;
    private static final int STR_IS_ASCII = 2;
    private static final int STR_IS_CONTROL = 3;
    private static final int STR_IS_BOOL = 4;
    private static final int STR_IS_DIGIT = 5;
    private static final int STR_IS_DOUBLE = 6;
    private static final int STR_IS_FALSE = 7;
    private static final int STR_IS_GRAPH = 8;
    private static final int STR_IS_INT = 9;
    private static final int STR_IS_LOWER = 10;
    private static final int STR_IS_PRINT = 11;
    private static final int STR_IS_PUNCT = 12;
    private static final int STR_IS_SPACE = 13;
    private static final int STR_IS_TRUE = 14;
    private static final int STR_IS_UPPER = 15;
    private static final int STR_IS_WIDEINTEGER = 16;
    private static final int STR_IS_WORD = 17;
    private static final int STR_IS_XDIGIT = 18;
    private static final int ALPHA_BITS = 62;
    private static final int PUNCT_BITS = 0x1F00000;
    private static final int PRINT_BITS = 535855102;
    private static final int WORD_BITS = 8389182;

    @Override
    public void cmdProc(Interp interp, TclObject[] tclObjectArray) throws TclException {
        if (tclObjectArray.length < 2) {
            throw new TclNumArgsException(interp, 1, tclObjectArray, "option arg ?arg ...?");
        }
        int n = TclIndex.get(interp, tclObjectArray[1], options, "option", 0);
        switch (n) {
            case 1: 
            case 2: {
                int n2;
                int n3;
                int n4;
                int n5;
                String string;
                if (tclObjectArray.length < 4 || tclObjectArray.length > 7) {
                    throw new TclNumArgsException(interp, 2, tclObjectArray, "?-nocase? ?-length int? string1 string2");
                }
                boolean bl = false;
                int n6 = -1;
                for (int i = 2; i < tclObjectArray.length - 2; ++i) {
                    string = tclObjectArray[i].toString();
                    n5 = string.length();
                    if (n5 > 1 && "-nocase".startsWith(string)) {
                        bl = true;
                        continue;
                    }
                    if (n5 > 1 && "-length".startsWith(string)) {
                        if (i + 1 >= tclObjectArray.length - 2) {
                            throw new TclNumArgsException(interp, 2, tclObjectArray, "?-nocase? ?-length int? string1 string2");
                        }
                        n6 = TclInteger.getInt(interp, tclObjectArray[++i]);
                        continue;
                    }
                    throw new TclException(interp, "bad option \"" + string + "\": must be -nocase or -length");
                }
                String string2 = tclObjectArray[tclObjectArray.length - 2].toString();
                string = tclObjectArray[tclObjectArray.length - 1].toString();
                n5 = string2.length();
                int n7 = n4 = n5 < (n3 = string.length()) ? n5 : n3;
                if (n6 == 0) {
                    n2 = 0;
                } else if (bl || n6 > 0 && n6 <= n4) {
                    if (n6 > 0 && n6 < n4) {
                        n4 = n6;
                    } else if (n6 < 0) {
                        int n8 = n6 = n5 > n3 ? n5 : n3;
                    }
                    if (bl) {
                        string2 = string2.toLowerCase();
                        string = string.toLowerCase();
                    }
                    if ((n2 = string2.substring(0, n4).compareTo(string.substring(0, n4))) == 0 && n6 > n4) {
                        n2 = n5 - n3;
                    }
                } else {
                    n2 = string2.substring(0, n4).compareTo(string.substring(0, n4));
                    if (n2 == 0) {
                        n2 = n5 - n3;
                    }
                }
                if (n == 2) {
                    interp.setResult(n2 == 0);
                    break;
                }
                interp.setResult(n2 > 0 ? 1 : (n2 < 0 ? -1 : 0));
                break;
            }
            case 3: {
                if (tclObjectArray.length < 4 || tclObjectArray.length > 5) {
                    throw new TclNumArgsException(interp, 2, tclObjectArray, "subString string ?startIndex?");
                }
                String string = tclObjectArray[2].toString();
                String string3 = tclObjectArray[3].toString();
                int n9 = string.length();
                int n10 = string3.length();
                int n11 = 0;
                if (tclObjectArray.length == 5 && (n11 = Util.getIntForIndex(interp, tclObjectArray[4], n10 - 1)) >= n10) {
                    interp.setResult(-1L);
                    break;
                }
                if (n9 == 0) {
                    interp.setResult(-1L);
                    break;
                }
                if (n9 == 1) {
                    char c = string.charAt(0);
                    int n12 = string3.indexOf(c, n11);
                    interp.setResult(n12);
                    break;
                }
                int n13 = string3.indexOf(string, n11);
                interp.setResult(n13);
                break;
            }
            case 4: {
                if (tclObjectArray.length != 4) {
                    throw new TclNumArgsException(interp, 2, tclObjectArray, "string charIndex");
                }
                String string = tclObjectArray[2].toString();
                int n14 = string.length();
                int n15 = Util.getIntForIndex(interp, tclObjectArray[3], n14 - 1);
                if (n15 < 0 || n15 >= n14) break;
                TclObject tclObject = interp.checkCommonCharacter(string.charAt(n15));
                if (tclObject == null) {
                    tclObject = TclString.newInstance(string.substring(n15, n15 + 1));
                }
                interp.setResult(tclObject);
                break;
            }
            case 5: {
                int n16;
                if (tclObjectArray.length < 4 || tclObjectArray.length > 7) {
                    throw new TclNumArgsException(interp, 2, tclObjectArray, "class ?-strict? ?-failindex var? str");
                }
                n = TclIndex.get(interp, tclObjectArray[2], isOptions, "class", 0);
                boolean bl = false;
                TclObjectBase tclObjectBase = null;
                if (tclObjectArray.length != 4) {
                    for (n16 = 3; n16 < tclObjectArray.length - 1; ++n16) {
                        String string = tclObjectArray[n16].toString();
                        int n17 = string.length();
                        if (n17 > 1 && "-strict".startsWith(string)) {
                            bl = true;
                            continue;
                        }
                        if (n17 > 1 && "-failindex".startsWith(string)) {
                            if (n16 + 1 >= tclObjectArray.length - 1) {
                                throw new TclNumArgsException(interp, 3, tclObjectArray, "?-strict? ?-failindex var? str");
                            }
                            tclObjectBase = tclObjectArray[++n16];
                            continue;
                        }
                        throw new TclException(interp, "bad option \"" + string + "\": must be -strict or -failindex");
                    }
                }
                n16 = 1;
                int n18 = 0;
                TclObject tclObject = tclObjectArray[tclObjectArray.length - 1];
                String string = tclObject.toString();
                int n19 = string.length();
                if (n19 == 0) {
                    if (bl) {
                        n16 = 0;
                    }
                    interp.setResult(n16 != 0);
                    return;
                }
                block21 : switch (n) {
                    case 4: 
                    case 7: 
                    case 14: {
                        try {
                            boolean bl2 = Util.getBoolean(null, string);
                            if ((n != 14 || bl2) && (n != 7 || !bl2)) break;
                            n16 = 0;
                        }
                        catch (TclException tclException) {
                            n16 = 0;
                        }
                        break;
                    }
                    case 6: {
                        Object object;
                        if (tclObject.isDoubleType() || tclObject.isIntType()) break;
                        if (Expression.looksLikeInt(string, n19, 0, false)) {
                            object = interp.strtoulResult;
                            Util.strtoul(string, 0, 0, (StrtoulResult)object);
                            if (((StrtoulResult)object).index == n19) {
                                if (((StrtoulResult)object).errno != -2) break;
                                n16 = 0;
                                n18 = -1;
                                break;
                            }
                        }
                        object = interp.strtodResult;
                        Util.strtod(string, 0, -1, (StrtodResult)object);
                        if (((StrtodResult)object).errno == -4) {
                            n16 = 0;
                            n18 = -1;
                            break;
                        }
                        if (((StrtodResult)object).index == 0) {
                            n16 = 0;
                            n18 = 0;
                            break;
                        }
                        n18 = ((StrtodResult)object).index;
                        for (int i = ((StrtodResult)object).index; i < n19; ++i) {
                            if (Character.isWhitespace(string.charAt(i))) continue;
                            n16 = 0;
                            break block21;
                        }
                        break;
                    }
                    case 9: {
                        if (tclObject.isIntType()) {
                            if (TclInteger.isWithinIntRange(interp, tclObject)) break;
                            n18 = -1;
                            n16 = 0;
                            break;
                        }
                        StrtoulResult strtoulResult = interp.strtoulResult;
                        Util.strtoul(string, 0, 0, strtoulResult);
                        if (strtoulResult.errno == -2 || strtoulResult.value > Integer.MAX_VALUE || strtoulResult.value < Integer.MIN_VALUE) {
                            n16 = 0;
                            n18 = -1;
                            break;
                        }
                        if (strtoulResult.index == 0) {
                            n16 = 0;
                            n18 = 0;
                            break;
                        }
                        n18 = strtoulResult.index;
                        for (int i = strtoulResult.index; i < n19; ++i) {
                            if (Character.isWhitespace(string.charAt(i))) continue;
                            n16 = 0;
                            break block21;
                        }
                        break;
                    }
                    case 16: {
                        if (tclObject.isIntType()) {
                            if (TclInteger.isWithinLongRange(interp, tclObject)) break;
                            n18 = -1;
                            n16 = 0;
                            break;
                        }
                        StrtoulResult strtoulResult = interp.strtoulResult;
                        Util.strtoul(string, 0, 0, strtoulResult);
                        if (strtoulResult.errno == -2) {
                            n16 = 0;
                            n18 = -1;
                            break;
                        }
                        if (strtoulResult.index == 0) {
                            n16 = 0;
                            n18 = 0;
                            break;
                        }
                        n18 = strtoulResult.index;
                        for (int i = strtoulResult.index; i < n19; ++i) {
                            if (Character.isWhitespace(string.charAt(i))) continue;
                            n16 = 0;
                            break block21;
                        }
                        break;
                    }
                    default: {
                        for (n18 = 0; n18 < n19; ++n18) {
                            char c = string.charAt(n18);
                            switch (n) {
                                case 2: {
                                    n16 = c < '\u0080' ? 1 : 0;
                                    break;
                                }
                                case 0: {
                                    n16 = Character.isLetterOrDigit(c);
                                    break;
                                }
                                case 1: {
                                    n16 = Character.isLetter(c);
                                    break;
                                }
                                case 5: {
                                    n16 = Character.isDigit(c);
                                    break;
                                }
                                case 8: {
                                    n16 = (1 << Character.getType(c) & 0x1FF07FFE) != 0 && c != ' ' ? 1 : 0;
                                    break;
                                }
                                case 11: {
                                    n16 = (1 << Character.getType(c) & 0x1FF07FFE) != 0 ? 1 : 0;
                                    break;
                                }
                                case 12: {
                                    n16 = (1 << Character.getType(c) & 0x1F00000) != 0 ? 1 : 0;
                                    break;
                                }
                                case 15: {
                                    n16 = Character.isUpperCase(c);
                                    break;
                                }
                                case 13: {
                                    n16 = Character.isWhitespace(c);
                                    break;
                                }
                                case 3: {
                                    n16 = Character.isISOControl(c);
                                    break;
                                }
                                case 10: {
                                    n16 = Character.isLowerCase(c);
                                    break;
                                }
                                case 17: {
                                    n16 = (1 << Character.getType(c) & 0x80023E) != 0 ? 1 : 0;
                                    break;
                                }
                                case 18: {
                                    n16 = Character.digit(c, 16) >= 0 ? 1 : 0;
                                    break;
                                }
                                default: {
                                    throw new TclRuntimeError("unimplemented");
                                }
                            }
                            if (n16 == 0) break block21;
                        }
                    }
                }
                if (n16 == 0 && tclObjectBase != null) {
                    interp.setVar(tclObjectBase.toString(), (String)null, n18, 0);
                }
                interp.setResult(n16 != 0);
                break;
            }
            case 6: {
                if (tclObjectArray.length < 4 || tclObjectArray.length > 5) {
                    throw new TclNumArgsException(interp, 2, tclObjectArray, "subString string ?startIndex?");
                }
                String string = tclObjectArray[2].toString();
                String string4 = tclObjectArray[3].toString();
                int n20 = string.length();
                int n21 = string4.length();
                int n22 = 0;
                if (tclObjectArray.length == 5) {
                    n22 = Util.getIntForIndex(interp, tclObjectArray[4], n21 - 1);
                    if (n22 < 0) {
                        interp.setResult(-1L);
                        break;
                    }
                    if (n22 < n21) {
                        string4 = string4.substring(0, n22 + 1);
                    }
                }
                if (n20 == 0) {
                    interp.setResult(-1L);
                    break;
                }
                if (n20 == 1) {
                    char c = string.charAt(0);
                    int n23 = string4.lastIndexOf(c);
                    interp.setResult(n23);
                    break;
                }
                int n24 = string4.lastIndexOf(string);
                interp.setResult(n24);
                break;
            }
            case 0: {
                if (tclObjectArray.length != 3) {
                    throw new TclNumArgsException(interp, 2, tclObjectArray, "string");
                }
                if (tclObjectArray[2].isByteArrayType()) {
                    interp.setResult(TclByteArray.getLength(interp, tclObjectArray[2]));
                    break;
                }
                interp.setResult(StringCmd.Utf8Count(tclObjectArray[2].toString()));
                break;
            }
            case 7: {
                if (tclObjectArray.length != 3) {
                    throw new TclNumArgsException(interp, 2, tclObjectArray, "string");
                }
                if (tclObjectArray[2].isByteArrayType()) {
                    interp.setResult(TclByteArray.getLength(interp, tclObjectArray[2]));
                    break;
                }
                interp.setResult(tclObjectArray[2].toString().length());
                break;
            }
            case 8: {
                int n25;
                String[] stringArray;
                TclObject[] tclObjectArray2;
                if (tclObjectArray.length < 4 || tclObjectArray.length > 5) {
                    throw new TclNumArgsException(interp, 2, tclObjectArray, "?-nocase? charMap string");
                }
                boolean bl = false;
                if (tclObjectArray.length == 5) {
                    tclObjectArray2 = tclObjectArray[2].toString();
                    int n26 = tclObjectArray2.length();
                    if (n26 > 1 && "-nocase".startsWith((String)tclObjectArray2)) {
                        bl = true;
                    } else {
                        throw new TclException(interp, "bad option \"" + (String)tclObjectArray2 + "\": must be -nocase");
                    }
                }
                if ((tclObjectArray2 = TclList.getElements(interp, tclObjectArray[tclObjectArray.length - 2])).length == 0) {
                    interp.setResult(tclObjectArray[tclObjectArray.length - 1]);
                } else if (tclObjectArray2.length % 2 != 0) {
                    throw new TclException(interp, "char map list unbalanced");
                }
                String string = tclObjectArray[tclObjectArray.length - 1].toString();
                String string5 = bl ? string.toLowerCase() : string;
                int n27 = string.length();
                if (n27 == 0) break;
                String[] stringArray2 = new String[tclObjectArray2.length];
                int[] nArray = new int[tclObjectArray2.length];
                for (int i = 0; i < tclObjectArray2.length; ++i) {
                    stringArray2[i] = tclObjectArray2[i].toString();
                    nArray[i] = stringArray2[i].length();
                }
                if (bl) {
                    stringArray = new String[stringArray2.length];
                    for (int i = 0; i < stringArray2.length; ++i) {
                        stringArray[i] = stringArray2[i].toLowerCase();
                    }
                } else {
                    stringArray = stringArray2;
                }
                TclObject tclObject = TclString.newInstance("");
                int n28 = 0;
                block51: for (n25 = 0; n25 < n27; ++n25) {
                    for (n = 0; n < stringArray2.length; n += 2) {
                        String string6 = stringArray2[n];
                        int n29 = nArray[n];
                        if (n29 <= 0 || !string5.substring(n25).startsWith(stringArray[n])) continue;
                        if (n28 != n25) {
                            TclString.append(tclObject, string.substring(n28, n25));
                            n28 = n25 + n29;
                        } else {
                            n28 += n29;
                        }
                        n25 = n28 - 1;
                        TclString.append(tclObject, stringArray2[n + 1]);
                        continue block51;
                    }
                }
                if (n28 != n25) {
                    TclString.append(tclObject, string.substring(n28, n25));
                }
                interp.setResult(tclObject);
                break;
            }
            case 9: {
                String string;
                String string7;
                if (tclObjectArray.length < 4 || tclObjectArray.length > 5) {
                    throw new TclNumArgsException(interp, 2, tclObjectArray, "?-nocase? pattern string");
                }
                if (tclObjectArray.length == 5) {
                    String string8 = tclObjectArray[2].toString();
                    if (string8.length() <= 1 || !"-nocase".startsWith(string8)) {
                        throw new TclException(interp, "bad option \"" + string8 + "\": must be -nocase");
                    }
                    string7 = tclObjectArray[4].toString().toLowerCase();
                    string = tclObjectArray[3].toString().toLowerCase();
                } else {
                    string7 = tclObjectArray[3].toString();
                    string = tclObjectArray[2].toString();
                }
                interp.setResult(Util.stringMatch(string7, string));
                break;
            }
            case 10: {
                int n30;
                int n31;
                if (tclObjectArray.length != 5) {
                    throw new TclNumArgsException(interp, 2, tclObjectArray, "string first last");
                }
                String string = null;
                if (tclObjectArray[2].isByteArrayType()) {
                    n31 = TclByteArray.getLength(interp, tclObjectArray[2]);
                } else {
                    string = tclObjectArray[2].toString();
                    n31 = string.length();
                }
                int n32 = Util.getIntForIndex(interp, tclObjectArray[3], n31 - 1);
                if (n32 < 0) {
                    n32 = 0;
                }
                if ((n30 = Util.getIntForIndex(interp, tclObjectArray[4], n31 - 1)) >= n31) {
                    n30 = n31 - 1;
                }
                if (n32 > n30) {
                    interp.resetResult();
                    break;
                }
                if (string == null) {
                    byte[] byArray = TclByteArray.getBytes(interp, tclObjectArray[2]);
                    TclObject tclObject = TclByteArray.newInstance(byArray, n32, n30 + 1 - n32);
                    interp.setResult(tclObject);
                    break;
                }
                interp.setResult(string.substring(n32, n30 + 1));
                break;
            }
            case 11: {
                if (tclObjectArray.length != 4) {
                    throw new TclNumArgsException(interp, 2, tclObjectArray, "string count");
                }
                int n33 = TclInteger.getInt(interp, tclObjectArray[3]);
                String string = tclObjectArray[2].toString();
                if (string.length() <= 0) break;
                TclObject tclObject = TclString.newInstance("");
                for (n = 0; n < n33; ++n) {
                    TclString.append(tclObject, string);
                }
                interp.setResult(tclObject);
                break;
            }
            case 12: {
                if (tclObjectArray.length < 5 || tclObjectArray.length > 6) {
                    throw new TclNumArgsException(interp, 2, tclObjectArray, "string first last ?string?");
                }
                String string = tclObjectArray[2].toString();
                int n34 = string.length() - 1;
                int n35 = Util.getIntForIndex(interp, tclObjectArray[3], n34);
                int n36 = Util.getIntForIndex(interp, tclObjectArray[4], n34);
                if (n36 < n35 || n35 > n34 || n36 < 0) {
                    interp.setResult(tclObjectArray[2]);
                    break;
                }
                if (n35 < 0) {
                    n35 = 0;
                }
                String string9 = string.substring(n35);
                int n37 = (n36 > n34 ? n34 : n36) - n35 + 1;
                String string10 = n37 <= 0 ? string9 : (n37 >= string9.length() ? "" : string9.substring(n37));
                TclObject tclObject = TclString.newInstance(string.substring(0, n35));
                if (tclObjectArray.length == 6) {
                    TclString.append(tclObject, tclObjectArray[5]);
                }
                if (n36 < n34) {
                    TclString.append(tclObject, string10);
                }
                interp.setResult(tclObject);
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                if (tclObjectArray.length < 3 || tclObjectArray.length > 5) {
                    throw new TclNumArgsException(interp, 2, tclObjectArray, "string ?first? ?last?");
                }
                String string = tclObjectArray[2].toString();
                if (tclObjectArray.length == 3) {
                    if (n == 13) {
                        interp.setResult(string.toLowerCase());
                        break;
                    }
                    if (n == 14) {
                        interp.setResult(string.toUpperCase());
                        break;
                    }
                    interp.setResult(Util.toTitle(string));
                    break;
                }
                int n38 = string.length() - 1;
                int n39 = Util.getIntForIndex(interp, tclObjectArray[3], n38);
                if (n39 < 0) {
                    n39 = 0;
                }
                int n40 = n39;
                if (tclObjectArray.length == 5) {
                    n40 = Util.getIntForIndex(interp, tclObjectArray[4], n38);
                }
                if (n40 >= n38) {
                    n40 = n38;
                }
                if (n40 < n39) {
                    interp.setResult(tclObjectArray[2]);
                    break;
                }
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(string.substring(0, n39));
                String string11 = n40 + 1 > n38 ? string.substring(n39) : string.substring(n39, n40 + 1);
                if (n == 13) {
                    stringBuffer.append(string11.toLowerCase());
                } else if (n == 14) {
                    stringBuffer.append(string11.toUpperCase());
                } else {
                    stringBuffer.append(Util.toTitle(string11));
                }
                if (n40 + 1 <= n38) {
                    stringBuffer.append(string.substring(n40 + 1));
                }
                interp.setResult(stringBuffer.toString());
                break;
            }
            case 16: {
                if (tclObjectArray.length == 3) {
                    interp.setResult(tclObjectArray[2].toString().trim());
                    break;
                }
                if (tclObjectArray.length == 4) {
                    String string = Util.TrimLeft(tclObjectArray[2].toString(), tclObjectArray[3].toString());
                    interp.setResult(Util.TrimRight(string, tclObjectArray[3].toString()));
                    break;
                }
                throw new TclNumArgsException(interp, 2, tclObjectArray, "string ?chars?");
            }
            case 17: {
                if (tclObjectArray.length == 3) {
                    interp.setResult(Util.TrimLeft(tclObjectArray[2].toString()));
                    break;
                }
                if (tclObjectArray.length == 4) {
                    interp.setResult(Util.TrimLeft(tclObjectArray[2].toString(), tclObjectArray[3].toString()));
                    break;
                }
                throw new TclNumArgsException(interp, 2, tclObjectArray, "string ?chars?");
            }
            case 18: {
                if (tclObjectArray.length == 3) {
                    interp.setResult(Util.TrimRight(tclObjectArray[2].toString()));
                    break;
                }
                if (tclObjectArray.length == 4) {
                    interp.setResult(Util.TrimRight(tclObjectArray[2].toString(), tclObjectArray[3].toString()));
                    break;
                }
                throw new TclNumArgsException(interp, 2, tclObjectArray, "string ?chars?");
            }
            case 19: {
                char c;
                int n41;
                if (tclObjectArray.length != 4) {
                    throw new TclNumArgsException(interp, 2, tclObjectArray, "string index");
                }
                String string = tclObjectArray[2].toString();
                char[] cArray = string.toCharArray();
                int n42 = string.length();
                n = Util.getIntForIndex(interp, tclObjectArray[3], n42 - 1);
                if (n < 0) {
                    n = 0;
                }
                if (n >= n42) {
                    interp.setResult(n42);
                    return;
                }
                for (n41 = n; n41 < n42 && (1 << Character.getType(c = cArray[n41]) & 0x80023E) != 0; ++n41) {
                }
                if (n41 == n) {
                    n41 = n + 1;
                }
                interp.setResult(n41);
                break;
            }
            case 20: {
                char c;
                int n43;
                if (tclObjectArray.length != 4) {
                    throw new TclNumArgsException(interp, 2, tclObjectArray, "string index");
                }
                String string = tclObjectArray[2].toString();
                char[] cArray = string.toCharArray();
                int n44 = string.length();
                n = Util.getIntForIndex(interp, tclObjectArray[3], n44 - 1);
                if (n > n44) {
                    n = n44 - 1;
                }
                if (n < 0) {
                    interp.setResult(0L);
                    return;
                }
                for (n43 = n; n43 >= 0 && (1 << Character.getType(c = cArray[n43]) & 0x80023E) != 0; --n43) {
                }
                if (n43 != n) {
                    ++n43;
                }
                interp.setResult(n43);
                break;
            }
        }
    }

    public static final int Utf8Count(String string) {
        int n = 0;
        int n2 = string.length();
        int n3 = 0;
        while (n < n2) {
            char c;
            if ((c = string.charAt(n++)) > '\u0000' && c < '\u0080') {
                ++n3;
                continue;
            }
            if (c <= '\u07ff') {
                n3 += 2;
                continue;
            }
            if (c > '\uffff') continue;
            n3 += 3;
        }
        return n3;
    }

    public static final int Utf8Count(char c) {
        if (c > '\u0000' && c < '\u0080') {
            return 1;
        }
        if (c <= '\u07ff') {
            return 2;
        }
        return 3;
    }
}

