/*
 * Decompiled with CFR 0.152.
 */
package tcl.pkg.fleet;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import tcl.lang.Interp;
import tcl.lang.TclException;
import tcl.lang.TclList;
import tcl.lang.TclObject;
import tcl.lang.TclString;
import tcl.pkg.fleet.FleetCmd;
import tcl.pkg.fleet.Message;

public class FleetMember
implements Runnable {
    public static final int STATUS_OK = 0;
    public static final int STATUS_ERROR = 1;
    private static boolean debug = false;
    private boolean terminated = false;
    private Thread thread = null;
    private BlockingQueue queue = new LinkedBlockingQueue();
    private Interp interp = null;
    private final FleetCmd fleet;
    private final String name;
    private long processingTime = 0L;
    private long waitingTime = 0L;

    FleetMember(FleetCmd fleetCmd, String string) {
        this.name = string;
        this.fleet = fleetCmd;
        this.thread = new Thread(this);
        this.thread.setDaemon(true);
        this.thread.setName(string + " service");
        if (debug) {
            System.out.println("thread create");
        }
        this.thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void execCommand(Message message) {
        if (debug) {
            System.out.println("execCommand ");
        }
        ExecEvent execEvent = new ExecEvent(message);
        this.queue.add(execEvent);
        FleetMember fleetMember = this;
        synchronized (fleetMember) {
            if (debug) {
                System.out.println("notify in execCommand");
            }
            this.notify();
        }
    }

    public int forget() {
        int n = this.queue.size();
        this.queue.clear();
        return n;
    }

    public int messageCount() {
        int n = this.queue.size();
        return n;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public void run() {
        if (debug) {
            System.out.println("thread start");
        }
        try {
            while (true) {
                long l = System.nanoTime();
                ExecEvent execEvent = (ExecEvent)this.queue.take();
                if (execEvent.callback != null) {
                    this.waitingTime += System.nanoTime() - l;
                    this.processEvent(execEvent);
                    continue;
                }
                break;
            }
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        this.terminated = true;
        if (this.interp != null) {
            if (debug) {
                System.out.println("Invoking interp.dispose()");
            }
            this.interp.dispose();
            this.interp = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processEvent(ExecEvent execEvent) {
        if (debug) {
            System.out.println("PROCESS QUEUE EVENT: " + execEvent);
        }
        try {
            if (this.interp == null) {
                if (debug) {
                    System.out.println("Interp() and init");
                }
                this.interp = new Interp();
            }
            this.evalScript(execEvent.callback);
        }
        catch (TclException tclException) {
            TclObject[] tclObjectArray = new StringBuffer(128);
            tclObjectArray.append("TclException: ");
            try {
                TclObject tclObject = this.interp.getVar("errorInfo", null, 1);
                tclObjectArray.append(tclObject.toString());
            }
            catch (TclException tclException2) {
                tclObjectArray.append(tclException.getMessage());
            }
            if (debug) {
                System.out.println(tclObjectArray.toString());
            }
            execEvent.callback.completed(1, this.fleet, this, TclString.newInstance(tclObjectArray.toString()));
        }
        finally {
            try {
                TclObject[] tclObjectArray;
                for (TclObject tclObject : tclObjectArray = TclList.getElements(this.interp, execEvent.callback.messageList)) {
                    tclObject.release();
                }
            }
            catch (TclException tclException) {}
        }
    }

    public double getProcessingTime() {
        return (double)this.processingTime / 1.0E9;
    }

    public double getWaitingTime() {
        return (double)this.waitingTime / 1.0E9;
    }

    private void evalScript(Message message) throws TclException {
        if (debug) {
            System.out.println("evalCmd ");
        }
        long l = System.nanoTime();
        this.interp.eval(message.messageList, 131072);
        TclObject tclObject = this.interp.getResult().duplicate();
        tclObject.preserve();
        this.processingTime += System.nanoTime() - l;
        message.completed(0, this.fleet, this, tclObject);
    }

    protected void finalize() throws Throwable {
        if (debug) {
            System.out.println("TclThread finalized");
        }
        super.finalize();
    }

    private static class ExecEvent {
        final Message callback;

        ExecEvent(Message message) {
            this.callback = message;
        }
    }

    public static interface MessageResult {
        public void completed(int var1, FleetCmd var2, FleetMember var3, TclObject var4);
    }
}

