/*
 * Decompiled with CFR 0.152.
 */
package tcl.pkg.itcl;

import java.util.HashMap;
import java.util.Map;
import tcl.lang.CallFrame;
import tcl.lang.Command;
import tcl.lang.CommandWithDispose;
import tcl.lang.Interp;
import tcl.lang.Namespace;
import tcl.lang.TclException;
import tcl.lang.TclInteger;
import tcl.lang.TclList;
import tcl.lang.TclNumArgsException;
import tcl.lang.TclObject;
import tcl.lang.TclRuntimeError;
import tcl.lang.TclString;
import tcl.lang.Var;
import tcl.lang.WrappedCommand;
import tcl.pkg.itcl.BiCmds;
import tcl.pkg.itcl.Class;
import tcl.pkg.itcl.Ensemble;
import tcl.pkg.itcl.Itcl;
import tcl.pkg.itcl.ItclAccess;
import tcl.pkg.itcl.ItclClass;
import tcl.pkg.itcl.ItclInt;
import tcl.pkg.itcl.ItclObject;
import tcl.pkg.itcl.ItclObjectInfo;
import tcl.pkg.itcl.ItclVarLookup;
import tcl.pkg.itcl.Itcl_Stack;
import tcl.pkg.itcl.Methods;
import tcl.pkg.itcl.Migrate;
import tcl.pkg.itcl.Objects;
import tcl.pkg.itcl.Parse;
import tcl.pkg.itcl.Util;

class Cmds {
    static String initScript = "namespace eval ::itcl { source resource:/tcl/pkg/itcl/library/itcl.tcl }";
    static String safeInitScript = "proc ::itcl::local {class name args} {\n    set ptr [uplevel [list $class $name] $args]\n    uplevel [list set itcl-local-$ptr $ptr]\n    set cmd [uplevel namespace which -command $ptr]\n    uplevel [list trace variable itcl-local-$ptr u \"::itcl::delete object $cmd; list\"]\n    return $ptr\n}";
    static int itclCompatFlags = -1;

    Cmds() {
    }

    static void Initialize(Interp interp) throws TclException {
        String string = "8.0";
        interp.pkgRequire("Tcl", string, false);
        if (interp.getCommand("::itcl::class") != null) {
            throw new TclException(interp, "already installed: [incr Tcl]");
        }
        itclCompatFlags = 0;
        Ensemble.EnsembleInit(interp);
        ItclObjectInfo itclObjectInfo = new ItclObjectInfo();
        itclObjectInfo.interp = interp;
        itclObjectInfo.objects = new HashMap();
        itclObjectInfo.transparentFrames = new Itcl_Stack();
        Util.InitStack(itclObjectInfo.transparentFrames);
        itclObjectInfo.contextFrames = new HashMap();
        itclObjectInfo.protection = 4;
        itclObjectInfo.cdefnStack = new Itcl_Stack();
        Util.InitStack(itclObjectInfo.cdefnStack);
        interp.setAssocData(ItclInt.INTERP_DATA, itclObjectInfo);
        interp.createCommand("::itcl::class", new Parse.ClassCmd(itclObjectInfo));
        Util.PreserveData(itclObjectInfo);
        interp.createCommand("::itcl::body", new Methods.BodyCmd());
        interp.createCommand("::itcl::configbody", new Methods.ConfigBodyCmd());
        Ensemble.CreateEnsemble(interp, "::itcl::find");
        Ensemble.AddEnsemblePart(interp, "::itcl::find", "classes", "?pattern?", (Command)new FindClassesCmd(itclObjectInfo));
        Util.PreserveData(itclObjectInfo);
        Ensemble.AddEnsemblePart(interp, "::itcl::find", "objects", "?-class className? ?-isa className? ?pattern?", (Command)new FindObjectsCmd(itclObjectInfo));
        Util.PreserveData(itclObjectInfo);
        Ensemble.CreateEnsemble(interp, "::itcl::delete");
        Ensemble.AddEnsemblePart(interp, "::itcl::delete", "class", "name ?name...?", (Command)new DelClassCmd(itclObjectInfo));
        Util.PreserveData(itclObjectInfo);
        Ensemble.AddEnsemblePart(interp, "::itcl::delete", "object", "name ?name...?", (Command)new DelObjectCmd(itclObjectInfo));
        Util.PreserveData(itclObjectInfo);
        Ensemble.CreateEnsemble(interp, "::itcl::is");
        Ensemble.AddEnsemblePart(interp, "::itcl::is", "class", "name", (Command)new IsClassCmd(itclObjectInfo));
        Util.PreserveData(itclObjectInfo);
        Ensemble.AddEnsemblePart(interp, "::itcl::is", "object", "?-class classname? name", (Command)new IsObjectCmd(itclObjectInfo));
        Util.PreserveData(itclObjectInfo);
        interp.createCommand("::itcl::code", new CodeCmd());
        interp.createCommand("::itcl::scope", new ScopeCmd());
        Ensemble.CreateEnsemble(interp, "::itcl::import::stub");
        Ensemble.AddEnsemblePart(interp, "::itcl::import::stub", "create", "name", (Command)new StubCreateCmd());
        Ensemble.AddEnsemblePart(interp, "::itcl::import::stub", "exists", "name", (Command)new StubExistsCmd());
        Objects.ScopedVarResolverImpl scopedVarResolverImpl = new Objects.ScopedVarResolverImpl();
        interp.addInterpResolver("itcl", scopedVarResolverImpl);
        Parse.ParseInit(interp, itclObjectInfo);
        BiCmds.BiInit(interp);
        Namespace namespace = Namespace.findNamespace(interp, "::itcl", null, 512);
        if (namespace == null) {
            throw new TclException(interp, interp.getResult().toString());
        }
        Namespace.exportList(interp, namespace, "body", true);
        Namespace.exportList(interp, namespace, "class", false);
        Namespace.exportList(interp, namespace, "code", false);
        Namespace.exportList(interp, namespace, "configbody", false);
        Namespace.exportList(interp, namespace, "delete", false);
        Namespace.exportList(interp, namespace, "delete_helper", false);
        Namespace.exportList(interp, namespace, "ensemble", false);
        Namespace.exportList(interp, namespace, "find", false);
        Namespace.exportList(interp, namespace, "local", false);
        Namespace.exportList(interp, namespace, "scope", false);
        interp.setVar("::itcl::patchLevel", TclString.newInstance(Itcl.PATCH_LEVEL), 2);
        interp.setVar("::itcl::version", TclString.newInstance(Itcl.VERSION), 2);
    }

    static void Init(Interp interp) throws TclException {
        Cmds.Initialize(interp);
        interp.eval(initScript);
    }

    static void SafeInit(Interp interp) throws TclException {
        Cmds.Initialize(interp);
        interp.eval(safeInitScript);
    }

    static void DelObjectInfo(ItclObjectInfo itclObjectInfo) {
        ItclObject itclObject;
        while ((itclObject = (ItclObject)ItclAccess.FirstHashEntry(itclObjectInfo.objects)) != null) {
            itclObjectInfo.interp.deleteCommandFromToken(itclObject.w_accessCmd);
        }
        itclObjectInfo.objects.clear();
        itclObjectInfo.objects = null;
        for (Map.Entry entry : itclObjectInfo.contextFrames.entrySet()) {
            itclObject = (ItclObject)entry.getValue();
            Util.ReleaseData(itclObject);
        }
        itclObjectInfo.contextFrames.clear();
        itclObjectInfo.contextFrames = null;
        Util.DeleteStack(itclObjectInfo.transparentFrames);
        itclObjectInfo.transparentFrames = null;
        Util.DeleteStack(itclObjectInfo.cdefnStack);
        itclObjectInfo.cdefnStack = null;
    }

    static boolean IsStub(WrappedCommand wrappedCommand) {
        return wrappedCommand.cmd instanceof HandleStubCmd;
    }

    static void ItclDeleteStub(Object object) {
    }

    public static class IsClassCmd
    implements CommandWithDispose {
        ItclObjectInfo info;

        IsClassCmd(ItclObjectInfo itclObjectInfo) {
            this.info = itclObjectInfo;
        }

        @Override
        public void disposeCmd() {
            Util.ReleaseData(this.info);
        }

        @Override
        public void cmdProc(Interp interp, TclObject[] tclObjectArray) throws TclException {
            ItclClass itclClass = null;
            Namespace namespace = null;
            if (tclObjectArray.length != 2) {
                throw new TclNumArgsException(interp, 1, tclObjectArray, "commandname");
            }
            String string = tclObjectArray[1].toString();
            Util.DecodeScopedCommandResult decodeScopedCommandResult = Util.DecodeScopedCommand(interp, string);
            namespace = decodeScopedCommandResult.rNS;
            String string2 = decodeScopedCommandResult.rCmd;
            itclClass = Class.FindClass(interp, string2, false);
            if (itclClass != null) {
                interp.setResult(true);
            } else {
                interp.setResult(false);
            }
        }
    }

    public static class IsObjectCmd
    implements CommandWithDispose {
        ItclObjectInfo info;

        IsObjectCmd(ItclObjectInfo itclObjectInfo) {
            this.info = itclObjectInfo;
        }

        @Override
        public void disposeCmd() {
            Util.ReleaseData(this.info);
        }

        @Override
        public void cmdProc(Interp interp, TclObject[] tclObjectArray) throws TclException {
            ItclObject itclObject;
            boolean bl = false;
            int n = 0;
            String string = null;
            Namespace namespace = null;
            ItclClass itclClass = null;
            if (tclObjectArray.length != 2 && tclObjectArray.length != 4) {
                throw new TclNumArgsException(interp, 1, tclObjectArray, "?-class classname? commandname");
            }
            for (n = 1; n < tclObjectArray.length; ++n) {
                String string2 = tclObjectArray[n].toString();
                if (string2.equals("-class")) {
                    String string3 = tclObjectArray[n + 1].toString();
                    itclClass = Class.FindClass(interp, string3, false);
                    if (itclClass == null) {
                        throw new TclException(interp, interp.getResult().toString());
                    }
                    ++n;
                    bl = true;
                    continue;
                }
                string = tclObjectArray[n].toString();
            }
            if (string == null) {
                throw new TclRuntimeError("name not assigned in objc loop");
            }
            Util.DecodeScopedCommandResult decodeScopedCommandResult = Util.DecodeScopedCommand(interp, string);
            String string4 = decodeScopedCommandResult.rCmd;
            namespace = decodeScopedCommandResult.rNS;
            WrappedCommand wrappedCommand = Namespace.findCommand(interp, string4, namespace, 0);
            if (wrappedCommand == null || !Objects.IsObject(wrappedCommand)) {
                interp.setResult(false);
                return;
            }
            if (bl && !Objects.ObjectIsa(itclObject = Objects.GetContextFromObject(wrappedCommand), itclClass)) {
                interp.setResult(false);
                return;
            }
            interp.setResult(true);
        }
    }

    public static class HandleStubCmd
    implements CommandWithDispose {
        WrappedCommand wcmd;

        @Override
        public void cmdProc(Interp interp, TclObject[] tclObjectArray) throws TclException {
            String string = interp.getCommandFullName(this.wcmd);
            interp.eval("::auto_load \"" + string + "\"");
            TclObject tclObject = interp.getResult();
            boolean bl = false;
            int n = 0;
            try {
                n = TclInteger.getInt(interp, tclObject);
            }
            catch (TclException tclException) {
                bl = true;
            }
            if (bl || n != 1) {
                interp.resetResult();
                throw new TclException(interp, "can't autoload \"" + string + "\"");
            }
            TclObject tclObject2 = Util.CreateArgs(interp, string, tclObjectArray, 1);
            TclObject[] tclObjectArray2 = TclList.getElements(interp, tclObject2);
            interp.resetResult();
            Util.EvalArgs(interp, tclObjectArray2);
        }

        @Override
        public void disposeCmd() {
            Cmds.ItclDeleteStub(null);
        }
    }

    public static class StubExistsCmd
    implements Command {
        @Override
        public void cmdProc(Interp interp, TclObject[] tclObjectArray) throws TclException {
            if (tclObjectArray.length != 2) {
                throw new TclNumArgsException(interp, 1, tclObjectArray, "name");
            }
            String string = tclObjectArray[1].toString();
            WrappedCommand wrappedCommand = Namespace.findCommand(interp, string, null, 0);
            if (wrappedCommand != null && Cmds.IsStub(wrappedCommand)) {
                interp.setResult(true);
            } else {
                interp.setResult(false);
            }
        }
    }

    public static class StubCreateCmd
    implements Command {
        @Override
        public void cmdProc(Interp interp, TclObject[] tclObjectArray) throws TclException {
            WrappedCommand wrappedCommand;
            if (tclObjectArray.length != 2) {
                throw new TclNumArgsException(interp, 1, tclObjectArray, "name");
            }
            String string = tclObjectArray[1].toString();
            interp.createCommand(string, new HandleStubCmd());
            ((HandleStubCmd)wrappedCommand.cmd).wcmd = wrappedCommand = Namespace.findCommand(interp, string, null, 2);
        }
    }

    static class CodeCmd
    implements Command {
        CodeCmd() {
        }

        @Override
        public void cmdProc(Interp interp, TclObject[] tclObjectArray) throws TclException {
            String string;
            int n;
            Namespace namespace = Namespace.getCurrentNamespace(interp);
            for (n = 1; n < tclObjectArray.length && (string = tclObjectArray[n].toString()).length() >= 2 && string.charAt(0) == '-'; ++n) {
                if (string.equals("-namespace")) {
                    if (tclObjectArray.length == 2) {
                        throw new TclNumArgsException(interp, 1, tclObjectArray, "?-namespace name? command ?arg arg...?");
                    }
                    string = tclObjectArray[n + 1].toString();
                    namespace = Namespace.findNamespace(interp, string, null, 512);
                    if (namespace == null) {
                        throw new TclException(interp, interp.getResult().toString());
                    }
                    ++n;
                    continue;
                }
                if (string.equals("--")) {
                    ++n;
                    break;
                }
                throw new TclException(interp, "bad option \"" + string + "\": should be -namespace or --");
            }
            if (tclObjectArray.length < 2) {
                throw new TclNumArgsException(interp, 1, tclObjectArray, "?-namespace name? command ?arg arg...?");
            }
            TclObject tclObject = TclList.newInstance();
            TclList.append(interp, tclObject, TclString.newInstance("namespace"));
            TclList.append(interp, tclObject, TclString.newInstance("inscope"));
            TclObject tclObject2 = namespace == Namespace.getGlobalNamespace(interp) ? TclString.newInstance("::") : TclString.newInstance(namespace.fullName);
            TclList.append(interp, tclObject, tclObject2);
            if (tclObjectArray.length - n == 1) {
                tclObject2 = tclObjectArray[n];
            } else {
                tclObject2 = TclList.newInstance();
                for (int i = n; i < tclObjectArray.length; ++i) {
                    TclList.append(interp, tclObject2, tclObjectArray[i]);
                }
            }
            TclList.append(interp, tclObject, tclObject2);
            interp.setResult(tclObject);
        }
    }

    public static class ScopeCmd
    implements Command {
        @Override
        public void cmdProc(Interp interp, TclObject[] tclObjectArray) throws TclException {
            Namespace namespace = Namespace.getCurrentNamespace(interp);
            String string = null;
            if (tclObjectArray.length != 2) {
                throw new TclNumArgsException(interp, 1, tclObjectArray, "varname");
            }
            String string2 = tclObjectArray[1].toString();
            if (string2.startsWith("::")) {
                interp.setResult(tclObjectArray[1]);
                return;
            }
            int n = -1;
            int n2 = -1;
            for (int i = 0; i < string2.length(); ++i) {
                if (string2.charAt(i) == '(') {
                    n2 = i;
                    continue;
                }
                if (string2.charAt(i) != ')' || n2 == -1) continue;
                n = i;
                break;
            }
            if (n2 != -1 && n != -1) {
                string = string2.substring(n2, n + 1);
                string2 = string2.substring(0, n2);
            }
            if (Class.IsClassNamespace(namespace)) {
                ItclClass itclClass = Class.GetClassFromNamespace(namespace);
                ItclVarLookup itclVarLookup = (ItclVarLookup)itclClass.resolveVars.get(string2);
                if (itclVarLookup == null) {
                    throw new TclException(interp, "variable \"" + string2 + "\" not found in class \"" + itclClass.fullname + "\"");
                }
                if ((itclVarLookup.vdefn.member.flags & ItclInt.COMMON) != 0) {
                    StringBuffer stringBuffer = new StringBuffer(64);
                    stringBuffer.append(itclVarLookup.vdefn.member.fullname);
                    if (string != null) {
                        stringBuffer.append(string);
                        string = null;
                    }
                    interp.setResult(stringBuffer.toString());
                    return;
                }
                CallFrame callFrame = Migrate.GetCallFrame(interp, 0);
                ItclObjectInfo itclObjectInfo = itclClass.info;
                ItclObject itclObject = (ItclObject)itclObjectInfo.contextFrames.get(callFrame);
                if (itclObject == null) {
                    throw new TclException(interp, "can't scope variable \"" + string2 + "\": missing object context\"");
                }
                TclObject tclObject = TclList.newInstance();
                TclList.append(interp, tclObject, TclString.newInstance("@itcl"));
                TclList.append(interp, tclObject, TclString.newInstance(interp.getCommandFullName(itclObject.w_accessCmd)));
                StringBuffer stringBuffer = new StringBuffer(64);
                stringBuffer.append(itclVarLookup.vdefn.member.fullname);
                if (string != null) {
                    stringBuffer.append(string);
                    string = null;
                }
                TclList.append(interp, tclObject, TclString.newInstance(stringBuffer.toString()));
                interp.setResult(tclObject);
            } else {
                StringBuffer stringBuffer = new StringBuffer(64);
                Var var = Namespace.findNamespaceVar(interp, string2, namespace, 2);
                if (var == null) {
                    throw new TclException(interp, "variable \"" + string2 + "\" not found in namespace \"" + namespace.fullName + "\"");
                }
                String string3 = Var.getVariableFullName(interp, var);
                stringBuffer.append(string3);
                if (string != null) {
                    stringBuffer.append(string);
                    string = null;
                }
                interp.setResult(stringBuffer.toString());
            }
        }
    }

    static class DelObjectCmd
    implements CommandWithDispose {
        ItclObjectInfo info;

        DelObjectCmd(ItclObjectInfo itclObjectInfo) {
            this.info = itclObjectInfo;
        }

        @Override
        public void disposeCmd() {
            Util.ReleaseData(this.info);
        }

        @Override
        public void cmdProc(Interp interp, TclObject[] tclObjectArray) throws TclException {
            for (int i = 1; i < tclObjectArray.length; ++i) {
                String string = tclObjectArray[i].toString();
                ItclObject itclObject = Objects.FindObject(interp, string);
                if (itclObject == null) {
                    throw new TclException(interp, "object \"" + string + "\" not found");
                }
                Objects.DeleteObject(interp, itclObject);
            }
        }
    }

    static class DelClassCmd
    implements CommandWithDispose {
        ItclObjectInfo info;

        DelClassCmd(ItclObjectInfo itclObjectInfo) {
            this.info = itclObjectInfo;
        }

        @Override
        public void disposeCmd() {
            Util.ReleaseData(this.info);
        }

        @Override
        public void cmdProc(Interp interp, TclObject[] tclObjectArray) throws TclException {
            ItclClass itclClass;
            String string;
            int n;
            for (n = 1; n < tclObjectArray.length; ++n) {
                string = tclObjectArray[n].toString();
                itclClass = Class.FindClass(interp, string, true);
                if (itclClass != null) continue;
                throw new TclException(interp, interp.getResult().toString());
            }
            for (n = 1; n < tclObjectArray.length; ++n) {
                string = tclObjectArray[n].toString();
                itclClass = Class.FindClass(interp, string, false);
                if (itclClass == null) continue;
                interp.resetResult();
                Class.DeleteClass(interp, itclClass);
            }
            interp.resetResult();
        }
    }

    public static class ProtectionCmd
    implements Command {
        @Override
        public void cmdProc(Interp interp, TclObject[] tclObjectArray) throws TclException {
            throw new TclRuntimeError("unused function");
        }
    }

    public static class FindObjectsCmd
    implements CommandWithDispose {
        ItclObjectInfo info;

        FindObjectsCmd(ItclObjectInfo itclObjectInfo) {
            this.info = itclObjectInfo;
        }

        @Override
        public void disposeCmd() {
            Util.ReleaseData(this.info);
        }

        @Override
        public void cmdProc(Interp interp, TclObject[] tclObjectArray) throws TclException {
            Namespace namespace = Namespace.getCurrentNamespace(interp);
            Namespace namespace2 = Namespace.getGlobalNamespace(interp);
            boolean bl = false;
            String string = null;
            ItclClass itclClass = null;
            ItclClass itclClass2 = null;
            String string2 = null;
            String string3 = null;
            String string4 = null;
            TclObject tclObject = TclList.newInstance();
            int n = 0;
            while (++n < tclObjectArray.length) {
                string3 = tclObjectArray[n].toString();
                if (string3.length() == 0 || string3.charAt(0) != '-') {
                    if (string != null) break;
                    string = string3;
                    bl = string.indexOf("::") != -1;
                    continue;
                }
                if (n + 1 < tclObjectArray.length && string3.equals("-class")) {
                    string2 = tclObjectArray[n + 1].toString();
                    itclClass = Class.FindClass(interp, string2, true);
                    if (itclClass == null) {
                        throw new TclException(interp, interp.getResult().toString());
                    }
                    ++n;
                    continue;
                }
                if (n + 1 < tclObjectArray.length && string3.equals("-isa")) {
                    string2 = tclObjectArray[n + 1].toString();
                    itclClass2 = Class.FindClass(interp, string2, true);
                    if (itclClass2 == null) {
                        throw new TclException(interp, interp.getResult().toString());
                    }
                    ++n;
                    continue;
                }
                if (n != tclObjectArray.length - 1 || string != null) break;
                string = string3;
                bl = string.indexOf("::") != -1;
            }
            if (n < tclObjectArray.length) {
                throw new TclNumArgsException(interp, 1, tclObjectArray, "?-class className? ?-isa className? ?pattern?");
            }
            Itcl_Stack itcl_Stack = new Itcl_Stack();
            Util.InitStack(itcl_Stack);
            Util.PushStack(namespace2, itcl_Stack);
            Util.PushStack(namespace, itcl_Stack);
            HashMap<WrappedCommand, String> hashMap = new HashMap<WrappedCommand, String>();
            boolean bl2 = false;
            while (Util.GetStackSize(itcl_Stack) > 0) {
                Object object;
                Namespace namespace3 = (Namespace)Util.PopStack(itcl_Stack);
                if (namespace3 == namespace && bl2) continue;
                for (Map.Entry<String, WrappedCommand> entry : namespace3.cmdTable.entrySet()) {
                    TclObject tclObject2;
                    object = entry.getKey();
                    WrappedCommand wrappedCommand = entry.getValue();
                    if (!Objects.IsObject(wrappedCommand)) continue;
                    WrappedCommand wrappedCommand2 = Namespace.getOriginalCommand(wrappedCommand);
                    if (wrappedCommand2 != null) {
                        wrappedCommand = wrappedCommand2;
                    }
                    ItclObject itclObject = Objects.GetContextFromObject(wrappedCommand);
                    if (bl || namespace3 != namespace || wrappedCommand2 != null) {
                        string4 = interp.getCommandFullName(wrappedCommand);
                        tclObject2 = TclString.newInstance(string4);
                    } else {
                        string4 = interp.getCommandName(wrappedCommand);
                        tclObject2 = TclString.newInstance(string4);
                    }
                    boolean bl3 = hashMap.put(wrappedCommand, "") == null;
                    boolean bl4 = false;
                    if (bl3 && (string == null || tcl.lang.Util.stringMatch(string4, string)) && (itclClass == null || itclObject.classDefn == itclClass)) {
                        if (itclClass2 == null) {
                            bl4 = true;
                        } else if (itclObject.classDefn.heritage.get(itclClass2) != null) {
                            bl4 = true;
                        }
                    }
                    if (!bl4) continue;
                    TclList.append(interp, tclObject, tclObject2);
                }
                bl2 = true;
                for (Map.Entry<String, Object> entry : namespace3.childTable.entrySet()) {
                    object = (Namespace)entry.getValue();
                    Util.PushStack(object, itcl_Stack);
                }
            }
            hashMap.clear();
            Util.DeleteStack(itcl_Stack);
            interp.setResult(tclObject);
        }
    }

    public static class FindClassesCmd
    implements CommandWithDispose {
        ItclObjectInfo info;

        FindClassesCmd(ItclObjectInfo itclObjectInfo) {
            this.info = itclObjectInfo;
        }

        @Override
        public void disposeCmd() {
            Util.ReleaseData(this.info);
        }

        @Override
        public void cmdProc(Interp interp, TclObject[] tclObjectArray) throws TclException {
            String string;
            Namespace namespace = Namespace.getCurrentNamespace(interp);
            Namespace namespace2 = Namespace.getGlobalNamespace(interp);
            boolean bl = false;
            if (tclObjectArray.length > 2) {
                throw new TclNumArgsException(interp, 1, tclObjectArray, "?pattern?");
            }
            if (tclObjectArray.length == 2) {
                string = tclObjectArray[1].toString();
                bl = string.indexOf("::") != -1;
            } else {
                string = null;
            }
            Itcl_Stack itcl_Stack = new Itcl_Stack();
            Util.InitStack(itcl_Stack);
            Util.PushStack(namespace2, itcl_Stack);
            Util.PushStack(namespace, itcl_Stack);
            HashMap<WrappedCommand, String> hashMap = new HashMap<WrappedCommand, String>();
            TclObject tclObject = TclList.newInstance();
            boolean bl2 = false;
            while (Util.GetStackSize(itcl_Stack) > 0) {
                String string2;
                Namespace namespace3 = (Namespace)Util.PopStack(itcl_Stack);
                if (namespace3 == namespace && bl2) continue;
                for (Map.Entry<String, WrappedCommand> entry : namespace3.cmdTable.entrySet()) {
                    boolean bl3;
                    TclObject tclObject2;
                    String string3;
                    string2 = entry.getKey();
                    WrappedCommand wrappedCommand = entry.getValue();
                    if (!Class.IsClass(wrappedCommand)) continue;
                    WrappedCommand wrappedCommand2 = Namespace.getOriginalCommand(wrappedCommand);
                    if (bl || namespace3 != namespace || wrappedCommand2 != null) {
                        string3 = interp.getCommandFullName(wrappedCommand);
                        tclObject2 = TclString.newInstance(string3);
                    } else {
                        string3 = interp.getCommandName(wrappedCommand);
                        tclObject2 = TclString.newInstance(string3);
                    }
                    if (wrappedCommand2 != null) {
                        wrappedCommand = wrappedCommand2;
                    }
                    if (!(bl3 = hashMap.put(wrappedCommand, "") == null) || string != null && !tcl.lang.Util.stringMatch(string3, string)) continue;
                    TclList.append(interp, tclObject, tclObject2);
                }
                bl2 = true;
                for (Map.Entry<String, Object> entry : namespace3.childTable.entrySet()) {
                    string2 = entry.getKey();
                    Namespace namespace4 = (Namespace)entry.getValue();
                    Util.PushStack(namespace4, itcl_Stack);
                }
            }
            hashMap.clear();
            Util.DeleteStack(itcl_Stack);
            interp.setResult(tclObject);
        }
    }
}

