/*
 * Decompiled with CFR 0.152.
 */
package tcl.pkg.itcl;

import tcl.lang.Command;
import tcl.lang.CommandWithDispose;
import tcl.lang.InternalRep;
import tcl.lang.Interp;
import tcl.lang.Namespace;
import tcl.lang.Procedure;
import tcl.lang.TclException;
import tcl.lang.TclList;
import tcl.lang.TclObject;
import tcl.lang.TclString;
import tcl.lang.WrappedCommand;
import tcl.pkg.itcl.EnsembleParser;
import tcl.pkg.itcl.EnsemblePart;
import tcl.pkg.itcl.ItclAccess;
import tcl.pkg.itcl.ItclEnsInvoc;
import tcl.pkg.itcl.Itcl_InterpState;
import tcl.pkg.itcl.Itcl_List;
import tcl.pkg.itcl.Itcl_ListElem;
import tcl.pkg.itcl.Util;

class Ensemble {
    Interp interp;
    EnsemblePart[] parts;
    int numParts;
    int maxParts;
    WrappedCommand wcmd;
    EnsemblePart parent;

    Ensemble() {
    }

    static String[] SplitEnsemble(Interp interp, String string) throws TclException {
        TclObject tclObject = TclString.newInstance(string);
        TclObject[] tclObjectArray = TclList.getElements(interp, tclObject);
        String[] stringArray = new String[tclObjectArray.length];
        for (int i = 0; i < tclObjectArray.length; ++i) {
            stringArray[i] = tclObjectArray[i].toString();
        }
        return stringArray;
    }

    static String MergeEnsemble(Interp interp, String[] stringArray, int n) throws TclException {
        TclObject tclObject = TclList.newInstance();
        for (int i = 0; i < n; ++i) {
            TclList.append(interp, tclObject, TclString.newInstance(stringArray[i]));
        }
        return tclObject.toString();
    }

    static void EnsembleInit(Interp interp) {
        interp.createCommand("::itcl::ensemble", new EnsembleCmd(null));
    }

    static void CreateEnsemble(Interp interp, String string) throws TclException {
        Object object;
        Ensemble ensemble = null;
        String[] stringArray = null;
        try {
            stringArray = Ensemble.SplitEnsemble(interp, string);
        }
        catch (TclException tclException) {
            Ensemble.CreateEnsembleFailed(interp, string, tclException);
        }
        if (stringArray.length < 1) {
            object = new TclException(interp, "invalid ensemble name \"" + string + "\"");
            Ensemble.CreateEnsembleFailed(interp, string, (TclException)object);
        }
        ensemble = null;
        if (stringArray.length > 1) {
            try {
                ensemble = Ensemble.FindEnsemble(interp, stringArray, stringArray.length - 1);
            }
            catch (TclException tclException) {
                Ensemble.CreateEnsembleFailed(interp, string, tclException);
            }
            if (ensemble == null) {
                object = Ensemble.MergeEnsemble(interp, stringArray, stringArray.length - 1);
                TclException tclException = new TclException(interp, "invalid ensemble name \"" + (String)object + "\"");
                Ensemble.CreateEnsembleFailed(interp, string, tclException);
            }
        }
        try {
            Ensemble.CreateEnsemble(interp, ensemble, stringArray[stringArray.length - 1]);
        }
        catch (TclException tclException) {
            Ensemble.CreateEnsembleFailed(interp, string, tclException);
        }
    }

    static void CreateEnsembleFailed(Interp interp, String string, TclException tclException) throws TclException {
        StringBuffer stringBuffer = new StringBuffer(64);
        stringBuffer.append("\n    (while creating ensemble \"");
        stringBuffer.append(string);
        stringBuffer.append("\")");
        interp.addErrorInfo(stringBuffer.toString());
        throw tclException;
    }

    static void AddEnsemblePart(Interp interp, String string, String string2, String string3, Command command) throws TclException {
        String[] stringArray = null;
        Ensemble ensemble = null;
        try {
            stringArray = Ensemble.SplitEnsemble(interp, string);
        }
        catch (TclException tclException) {
            Ensemble.AddEnsemblePartFailed(interp, string, tclException);
        }
        try {
            ensemble = Ensemble.FindEnsemble(interp, stringArray, stringArray.length);
        }
        catch (TclException tclException) {
            Ensemble.AddEnsemblePartFailed(interp, string, tclException);
        }
        if (ensemble == null) {
            String string4 = Ensemble.MergeEnsemble(interp, stringArray, stringArray.length);
            TclException tclException = new TclException(interp, "invalid ensemble name \"" + string4 + "\"");
            Ensemble.AddEnsemblePartFailed(interp, string, tclException);
        }
        try {
            EnsemblePart ensemblePart = Ensemble.AddEnsemblePart(interp, ensemble, string2, string3, command);
        }
        catch (TclException tclException) {
            Ensemble.AddEnsemblePartFailed(interp, string, tclException);
        }
    }

    static void AddEnsemblePartFailed(Interp interp, String string, TclException tclException) throws TclException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\n    (while adding to ensemble \"");
        stringBuffer.append(string);
        stringBuffer.append("\")");
        interp.addErrorInfo(stringBuffer.toString());
        throw tclException;
    }

    static boolean GetEnsembleUsage(Interp interp, String string, StringBuffer stringBuffer) {
        Ensemble ensemble;
        String[] stringArray = null;
        Itcl_InterpState itcl_InterpState = Util.SaveInterpState(interp, 0);
        try {
            stringArray = Ensemble.SplitEnsemble(interp, string);
        }
        catch (TclException tclException) {
            Util.RestoreInterpState(interp, itcl_InterpState);
            return false;
        }
        try {
            ensemble = Ensemble.FindEnsemble(interp, stringArray, stringArray.length);
        }
        catch (TclException tclException) {
            Util.RestoreInterpState(interp, itcl_InterpState);
            return false;
        }
        if (ensemble == null) {
            Util.RestoreInterpState(interp, itcl_InterpState);
            return false;
        }
        Ensemble.GetEnsembleUsage(ensemble, stringBuffer);
        Util.DiscardInterpState(itcl_InterpState);
        return true;
    }

    static boolean GetEnsembleUsageForObj(Interp interp, TclObject tclObject, StringBuffer stringBuffer) {
        Command command;
        TclObject tclObject2 = null;
        tclObject2 = tclObject;
        while (tclObject2 != null && tclObject2.getInternalRep() instanceof ItclEnsInvoc) {
            ItclEnsInvoc itclEnsInvoc = (ItclEnsInvoc)tclObject2.getInternalRep();
            tclObject2 = itclEnsInvoc.chainObj;
        }
        if (tclObject2 != null && (command = interp.getCommand(tclObject2.toString())) != null && command instanceof HandleEnsemble) {
            Ensemble ensemble = ((HandleEnsemble)command).ensData;
            Ensemble.GetEnsembleUsage(ensemble, stringBuffer);
            return true;
        }
        return false;
    }

    static void GetEnsembleUsage(Ensemble ensemble, StringBuffer stringBuffer) {
        String string = "  ";
        boolean bl = false;
        for (int i = 0; i < ensemble.numParts; ++i) {
            EnsemblePart ensemblePart = ensemble.parts[i];
            if (ensemblePart.name.equals("@error")) {
                bl = true;
                continue;
            }
            stringBuffer.append(string);
            Ensemble.GetEnsemblePartUsage(ensemblePart, stringBuffer);
            string = "\n  ";
        }
        if (bl) {
            stringBuffer.append("\n...and others described on the man page");
        }
    }

    static void GetEnsemblePartUsage(EnsemblePart ensemblePart, StringBuffer stringBuffer) {
        Itcl_List itcl_List = new Itcl_List();
        Util.InitList(itcl_List);
        EnsemblePart ensemblePart2 = ensemblePart;
        while (ensemblePart2 != null) {
            Util.InsertList(itcl_List, ensemblePart2);
            ensemblePart2 = ensemblePart2.ensemble.parent;
        }
        WrappedCommand wrappedCommand = ensemblePart.ensemble.wcmd;
        String string = ensemblePart.ensemble.interp.getCommandName(wrappedCommand);
        Util.AppendElement(stringBuffer, string);
        Itcl_ListElem itcl_ListElem = Util.FirstListElem(itcl_List);
        while (itcl_ListElem != null) {
            ensemblePart2 = (EnsemblePart)Util.GetListValue(itcl_ListElem);
            Util.AppendElement(stringBuffer, ensemblePart2.name);
            itcl_ListElem = Util.NextListElem(itcl_ListElem);
        }
        Util.DeleteList(itcl_List);
        if (ensemblePart.usage != null && ensemblePart.usage.length() > 0) {
            stringBuffer.append(" ");
            stringBuffer.append(ensemblePart.usage);
        } else if (ensemblePart.cmd != null && ensemblePart.cmd instanceof HandleEnsemble) {
            stringBuffer.append(" option ?arg arg ...?");
        }
    }

    static void CreateEnsemble(Interp interp, Ensemble ensemble, String string) throws TclException {
        EnsemblePart ensemblePart;
        Ensemble ensemble2 = new Ensemble();
        ensemble2.interp = interp;
        ensemble2.numParts = 0;
        ensemble2.maxParts = 10;
        ensemble2.parts = new EnsemblePart[ensemble2.maxParts];
        ensemble2.wcmd = null;
        ensemble2.parent = null;
        if (ensemble == null) {
            WrappedCommand wrappedCommand;
            interp.createCommand(string, new HandleEnsemble(ensemble2));
            ensemble2.wcmd = wrappedCommand = Namespace.findCommand(interp, string, null, 2);
            return;
        }
        try {
            ensemblePart = Ensemble.CreateEnsemblePart(interp, ensemble, string);
        }
        catch (TclException tclException) {
            Ensemble.DeleteEnsemble(ensemble2);
            throw tclException;
        }
        ensemble2.wcmd = ensemble.wcmd;
        ensemble2.parent = ensemblePart;
        ensemblePart.cmd = new HandleEnsemble(ensemble2);
    }

    static EnsemblePart AddEnsemblePart(Interp interp, Ensemble ensemble, String string, String string2, Command command) throws TclException {
        EnsemblePart ensemblePart = Ensemble.CreateEnsemblePart(interp, ensemble, string);
        if (string2 != null) {
            ensemblePart.usage = string2;
        }
        WrappedCommand wrappedCommand = new WrappedCommand();
        wrappedCommand.ns = ensemble.wcmd.ns;
        wrappedCommand.cmd = command;
        ensemblePart.cmd = command;
        ensemblePart.wcmd = wrappedCommand;
        return ensemblePart;
    }

    static void DeleteEnsemble(Ensemble ensemble) {
        while (ensemble.numParts > 0) {
            Ensemble.DeleteEnsemblePart(ensemble.parts[0]);
        }
        ensemble.parts = null;
    }

    static Ensemble FindEnsemble(Interp interp, String[] stringArray, int n) throws TclException {
        if (n < 1) {
            return null;
        }
        WrappedCommand wrappedCommand = Namespace.findCommand(interp, stringArray[0], null, 512);
        if (wrappedCommand == null || !(wrappedCommand.cmd instanceof HandleEnsemble)) {
            throw new TclException(interp, "command \"" + stringArray[0] + "\" is not an ensemble");
        }
        Ensemble ensemble = ((HandleEnsemble)wrappedCommand.cmd).ensData;
        for (int i = 1; i < n; ++i) {
            Command command;
            EnsemblePart ensemblePart = Ensemble.FindEnsemblePart(interp, ensemble, stringArray[i]);
            if (ensemblePart == null) {
                String string = Ensemble.MergeEnsemble(interp, stringArray, i);
                TclException tclException = new TclException(interp, "invalid ensemble name \"" + string + "\"");
            }
            if ((command = ensemblePart.cmd) == null || !(command instanceof HandleEnsemble)) {
                throw new TclException(interp, "part \"" + stringArray[i] + "\" is not an ensemble");
            }
            ensemble = ((HandleEnsemble)command).ensData;
        }
        return ensemble;
    }

    static EnsemblePart CreateEnsemblePart(Interp interp, Ensemble ensemble, String string) throws TclException {
        int n;
        FindEnsemblePartIndexResult findEnsemblePartIndexResult = Ensemble.FindEnsemblePartIndex(ensemble, string);
        if (findEnsemblePartIndexResult.status) {
            throw new TclException(interp, "part \"" + string + "\" already exists in ensemble");
        }
        int n2 = findEnsemblePartIndexResult.pos;
        if (ensemble.numParts >= ensemble.maxParts) {
            EnsemblePart[] ensemblePartArray = new EnsemblePart[ensemble.maxParts * 2];
            for (n = 0; n < ensemble.maxParts; ++n) {
                ensemblePartArray[n] = ensemble.parts[n];
            }
            ensemble.parts = null;
            ensemble.parts = ensemblePartArray;
            ensemble.maxParts = ensemblePartArray.length;
        }
        for (n = ensemble.numParts; n > n2; --n) {
            ensemble.parts[n] = ensemble.parts[n - 1];
        }
        ++ensemble.numParts;
        EnsemblePart ensemblePart = new EnsemblePart();
        ensemblePart.name = string;
        ensemblePart.cmd = null;
        ensemblePart.usage = null;
        ensemblePart.ensemble = ensemble;
        ensemble.parts[n2] = ensemblePart;
        Ensemble.ComputeMinChars(ensemble, n2);
        Ensemble.ComputeMinChars(ensemble, n2 - 1);
        Ensemble.ComputeMinChars(ensemble, n2 + 1);
        return ensemblePart;
    }

    static void DeleteEnsemblePart(EnsemblePart ensemblePart) {
        Command command = ensemblePart.cmd;
        if (command instanceof CommandWithDispose) {
            ((CommandWithDispose)command).disposeCmd();
        }
        ensemblePart.cmd = null;
        FindEnsemblePartIndexResult findEnsemblePartIndexResult = Ensemble.FindEnsemblePartIndex(ensemblePart.ensemble, ensemblePart.name);
        if (findEnsemblePartIndexResult.status) {
            int n = findEnsemblePartIndexResult.pos;
            Ensemble ensemble = ensemblePart.ensemble;
            for (int i = n; i < ensemble.numParts - 1; ++i) {
                ensemble.parts[i] = ensemble.parts[i + 1];
            }
            --ensemble.numParts;
        }
        if (ensemblePart.usage != null) {
            ensemblePart.usage = null;
        }
        ensemblePart.name = null;
    }

    static EnsemblePart FindEnsemblePart(Interp interp, Ensemble ensemble, String string) throws TclException {
        int n = 0;
        EnsemblePart ensemblePart = null;
        int n2 = 0;
        int n3 = ensemble.numParts - 1;
        int n4 = string.length();
        while (n3 >= n2) {
            int n5;
            n = n2 + n3 >>> 1;
            if (string.charAt(0) == ensemble.parts[n].name.charAt(0)) {
                n5 = string.substring(0, n4).compareTo(ensemble.parts[n].name);
                if (n5 == 0) {
                    break;
                }
            } else {
                n5 = string.charAt(0) < ensemble.parts[n].name.charAt(0) ? -1 : 1;
            }
            if (n5 > 0) {
                n2 = n + 1;
                continue;
            }
            n3 = n - 1;
        }
        if (n3 < n2) {
            return ensemblePart;
        }
        if (n4 < ensemble.parts[n].minChars) {
            while (n > 0) {
                if (string.substring(0, n4).compareTo(ensemble.parts[--n].name) == 0) continue;
                ++n;
                break;
            }
        }
        if (n4 < ensemble.parts[n].minChars) {
            StringBuffer stringBuffer = new StringBuffer(64);
            stringBuffer.append("ambiguous option \"" + string + "\": should be one of...");
            for (int i = n; i < ensemble.numParts && string.substring(0, n4).compareTo(ensemble.parts[i].name) == 0; ++i) {
                stringBuffer.append("\n  ");
                Ensemble.GetEnsemblePartUsage(ensemble.parts[i], stringBuffer);
            }
            throw new TclException(interp, stringBuffer.toString());
        }
        ensemblePart = ensemble.parts[n];
        return ensemblePart;
    }

    static FindEnsemblePartIndexResult FindEnsemblePartIndex(Ensemble ensemble, String string) {
        int n = 0;
        int n2 = 0;
        int n3 = ensemble.numParts - 1;
        while (n3 >= n2) {
            int n4;
            n = n2 + n3 >>> 1;
            if (string.charAt(0) == ensemble.parts[n].name.charAt(0)) {
                n4 = string.compareTo(ensemble.parts[n].name);
                if (n4 == 0) {
                    break;
                }
            } else {
                n4 = string.charAt(0) < ensemble.parts[n].name.charAt(0) ? -1 : 1;
            }
            if (n4 > 0) {
                n2 = n + 1;
                continue;
            }
            n3 = n - 1;
        }
        FindEnsemblePartIndexResult findEnsemblePartIndexResult = new FindEnsemblePartIndexResult();
        if (n3 >= n2) {
            findEnsemblePartIndexResult.status = true;
            findEnsemblePartIndexResult.pos = n;
            return findEnsemblePartIndexResult;
        }
        findEnsemblePartIndexResult.status = false;
        findEnsemblePartIndexResult.pos = n2;
        return findEnsemblePartIndexResult;
    }

    static void ComputeMinChars(Ensemble ensemble, int n) {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        String string;
        int n7;
        String string2;
        if (n < 0 || n >= ensemble.numParts) {
            return;
        }
        ensemble.parts[n].minChars = 1;
        if (n - 1 >= 0) {
            string2 = ensemble.parts[n].name;
            n7 = 0;
            string = ensemble.parts[n - 1].name;
            n6 = 0;
            n5 = string2.length();
            n4 = string.length();
            n3 = 1;
            while (n7 < n5 && n6 < n4 && string2.charAt(n7) == string.charAt(n6)) {
                ++n7;
                ++n6;
                ++n3;
            }
            if (n3 > ensemble.parts[n].minChars) {
                ensemble.parts[n].minChars = n3;
            }
        }
        if (n + 1 < ensemble.numParts) {
            string2 = ensemble.parts[n].name;
            n7 = 0;
            string = ensemble.parts[n + 1].name;
            n6 = 0;
            n5 = string2.length();
            n4 = string.length();
            n3 = 1;
            while (n7 < n5 && n6 < n4 && string2.charAt(n7) == string.charAt(n6)) {
                ++n7;
                ++n6;
                ++n3;
            }
            if (n3 > ensemble.parts[n].minChars) {
                ensemble.parts[n].minChars = n3;
            }
        }
        if (ensemble.parts[n].minChars > (n2 = ensemble.parts[n].name.length())) {
            ensemble.parts[n].minChars = n2;
        }
    }

    static EnsembleParser GetEnsembleParser(Interp interp) {
        WrappedCommand wrappedCommand;
        Namespace namespace;
        EnsembleParser ensembleParser = (EnsembleParser)interp.getAssocData("itcl_ensembleParser");
        if (ensembleParser != null) {
            return ensembleParser;
        }
        ensembleParser = new EnsembleParser();
        ensembleParser.master = interp;
        ensembleParser.parser = new Interp();
        ensembleParser.ensData = null;
        Namespace namespace2 = Namespace.getGlobalNamespace(ensembleParser.parser);
        while ((namespace = (Namespace)ItclAccess.FirstHashEntry(namespace2.childTable)) != null) {
            Namespace.deleteNamespace(namespace);
        }
        while ((wrappedCommand = (WrappedCommand)ItclAccess.FirstHashEntry(namespace2.cmdTable)) != null) {
            ensembleParser.parser.deleteCommandFromToken(wrappedCommand);
        }
        ensembleParser.parser.createCommand("part", new EnsPartCmd(ensembleParser));
        ensembleParser.parser.createCommand("option", new EnsPartCmd(ensembleParser));
        ensembleParser.parser.createCommand("ensemble", new EnsembleCmd(ensembleParser));
        interp.setAssocData("itcl_ensembleParser", ensembleParser);
        return ensembleParser;
    }

    static void DeleteEnsParser(EnsembleParser ensembleParser, Interp interp) {
        ensembleParser.parser.dispose();
    }

    static void EnsembleErrorCmd(Ensemble ensemble, Interp interp, TclObject[] tclObjectArray, int n) throws TclException {
        StringBuffer stringBuffer = new StringBuffer(64);
        String string = tclObjectArray[n].toString();
        stringBuffer.append("bad option \"");
        stringBuffer.append(string);
        stringBuffer.append("\": should be one of...\n");
        Ensemble.GetEnsembleUsage(ensemble, stringBuffer);
        throw new TclException(interp, stringBuffer.toString());
    }

    static void FreeEnsInvocInternalRep(ItclEnsInvoc itclEnsInvoc) {
        TclObject tclObject = itclEnsInvoc.chainObj;
        if (tclObject != null) {
            tclObject.release();
        }
    }

    static InternalRep DupEnsInvocInternalRep(ItclEnsInvoc itclEnsInvoc) {
        ItclEnsInvoc itclEnsInvoc2 = new ItclEnsInvoc();
        itclEnsInvoc2.ensPart = itclEnsInvoc.ensPart;
        itclEnsInvoc2.chainObj = itclEnsInvoc.chainObj;
        if (itclEnsInvoc2.chainObj != null) {
            itclEnsInvoc2.chainObj.preserve();
        }
        return itclEnsInvoc2;
    }

    static void SetEnsInvocFromAny(Interp interp, TclObject tclObject) throws TclException {
    }

    static String UpdateStringOfEnsInvoc(ItclEnsInvoc itclEnsInvoc) {
        EnsemblePart ensemblePart = itclEnsInvoc.ensPart;
        TclObject tclObject = itclEnsInvoc.chainObj;
        StringBuffer stringBuffer = new StringBuffer(64);
        if (tclObject != null) {
            String string = tclObject.toString();
            stringBuffer.append(string);
        }
        if (ensemblePart != null) {
            Util.AppendElement(stringBuffer, ensemblePart.name);
        }
        return stringBuffer.toString();
    }

    static class EnsPartCmd
    implements Command {
        EnsembleParser ensParser;

        EnsPartCmd(EnsembleParser ensembleParser) {
            this.ensParser = ensembleParser;
        }

        @Override
        public void cmdProc(Interp interp, TclObject[] tclObjectArray) throws TclException {
            EnsembleParser ensembleParser = this.ensParser;
            Ensemble ensemble = ensembleParser.ensData;
            if (tclObjectArray.length != 4) {
                throw new TclException(interp, "wrong # args: should be \"" + tclObjectArray[0].toString() + " name args body\"");
            }
            String string = tclObjectArray[1].toString();
            WrappedCommand wrappedCommand = ensemble.wcmd;
            Procedure procedure = ItclAccess.newProcedure(interp, wrappedCommand.ns, string, tclObjectArray[2], tclObjectArray[3], "unknown", 0);
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = false;
            boolean bl2 = false;
            TclObject[][] tclObjectArray2 = ItclAccess.getArgList(procedure);
            for (int i = 0; i < tclObjectArray2.length; ++i) {
                TclObject tclObject = tclObjectArray2[i][0];
                TclObject tclObject2 = tclObjectArray2[i][1];
                bl = false;
                if (tclObject.toString().equals("args")) {
                    bl = true;
                    continue;
                }
                if (tclObject2 != null) {
                    if (bl2) {
                        stringBuffer.append(" ");
                    }
                    stringBuffer.append("?");
                    stringBuffer.append(tclObject);
                    stringBuffer.append("?");
                    bl2 = true;
                    continue;
                }
                if (bl2) {
                    stringBuffer.append(" ");
                }
                stringBuffer.append(tclObject);
                bl2 = true;
            }
            if (bl) {
                if (bl2) {
                    stringBuffer.append(" ");
                }
                stringBuffer.append("?arg arg ...?");
            }
            String string2 = stringBuffer.toString();
            EnsemblePart ensemblePart = Ensemble.AddEnsemblePart(interp, ensemble, string, string2, (Command)procedure);
            ItclAccess.setWrappedCommand(procedure, ensemblePart.wcmd);
        }
    }

    static class EnsembleCmd
    implements Command {
        EnsembleParser ensParser;

        EnsembleCmd(EnsembleParser ensembleParser) {
            this.ensParser = ensembleParser;
        }

        @Override
        public void cmdProc(Interp interp, TclObject[] tclObjectArray) throws TclException {
            TclObject tclObject;
            Command command;
            if (tclObjectArray.length < 2) {
                StringBuffer stringBuffer = new StringBuffer(64);
                stringBuffer.append("wrong # args: should be \"");
                stringBuffer.append(tclObjectArray[0].toString());
                stringBuffer.append(" name ?command arg arg...?\"");
                throw new TclException(interp, stringBuffer.toString());
            }
            EnsembleParser ensembleParser = this.ensParser != null ? this.ensParser : Ensemble.GetEnsembleParser(interp);
            Ensemble ensemble = ensembleParser.ensData;
            String string = tclObjectArray[1].toString();
            if (ensemble != null) {
                EnsemblePart ensemblePart;
                try {
                    ensemblePart = Ensemble.FindEnsemblePart(interp, ensemble, string);
                }
                catch (TclException tclException) {
                    ensemblePart = null;
                }
                if (ensemblePart == null) {
                    Ensemble.CreateEnsemble(interp, ensemble, string);
                    try {
                        ensemblePart = Ensemble.FindEnsemblePart(interp, ensemble, string);
                    }
                    catch (TclException tclException) {
                        ensemblePart = null;
                    }
                    Util.Assert(ensemblePart != null, "Itcl_EnsembleCmd: can't create ensemble");
                }
                if ((command = ensemblePart.cmd) == null || !(command instanceof HandleEnsemble)) {
                    throw new TclException(interp, "part \"" + tclObjectArray[1].toString() + "\" is not an ensemble");
                }
                ensemble = ((HandleEnsemble)command).ensData;
            } else {
                WrappedCommand wrappedCommand;
                try {
                    wrappedCommand = Namespace.findCommand(interp, string, null, 0);
                }
                catch (TclException tclException) {
                    wrappedCommand = null;
                }
                if (wrappedCommand == null) {
                    Ensemble.CreateEnsemble(interp, null, string);
                    wrappedCommand = Namespace.findCommand(interp, string, null, 0);
                }
                if ((command = wrappedCommand == null ? null : wrappedCommand.cmd) == null || !(command instanceof HandleEnsemble)) {
                    throw new TclException(interp, "command \"" + tclObjectArray[1].toString() + "\" is not an ensemble");
                }
                ensemble = ((HandleEnsemble)command).ensData;
            }
            TclException tclException = null;
            Ensemble ensemble2 = ensembleParser.ensData;
            ensembleParser.ensData = ensemble;
            if (tclObjectArray.length == 3) {
                try {
                    ensembleParser.parser.eval(tclObjectArray[2].toString());
                }
                catch (TclException tclException2) {
                    tclException = tclException2;
                }
            } else if (tclObjectArray.length > 3) {
                tclObject = TclList.newInstance();
                for (int i = 2; i < tclObjectArray.length; ++i) {
                    TclList.append(interp, tclObject, tclObjectArray[i]);
                }
                try {
                    ensembleParser.parser.eval(tclObject.toString());
                }
                catch (TclException tclException3) {
                    tclException = tclException3;
                }
            }
            if (tclException != null) {
                tclObject = ensembleParser.parser.getVar("::errorInfo", 1);
                if (tclObject != null) {
                    interp.addErrorInfo(tclObject.toString());
                }
                if (tclObjectArray.length == 3) {
                    String string2 = "\n    (\"ensemble\" body line " + ensembleParser.parser.getErrorLine() + ")";
                    interp.addErrorInfo(string2);
                }
                ensembleParser.ensData = ensemble2;
                throw new TclException(interp, ensembleParser.parser.getResult().toString());
            }
            ensembleParser.ensData = ensemble2;
            interp.setResult(ensembleParser.parser.getResult().toString());
        }
    }

    static class HandleEnsemble
    implements CommandWithDispose {
        Ensemble ensData;

        HandleEnsemble(Ensemble ensemble) {
            this.ensData = ensemble;
        }

        @Override
        public void disposeCmd() {
            Ensemble.DeleteEnsemble(this.ensData);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void cmdProc(Interp interp, TclObject[] tclObjectArray) throws TclException {
            if (tclObjectArray.length < 2) {
                StringBuffer stringBuffer = new StringBuffer(64);
                stringBuffer.append("wrong # args: should be one of...\n");
                Ensemble.GetEnsembleUsage(this.ensData, stringBuffer);
                throw new TclException(interp, stringBuffer.toString());
            }
            String string = tclObjectArray[1].toString();
            int n = string.length();
            EnsemblePart ensemblePart = Ensemble.FindEnsemblePart(interp, this.ensData, string);
            if (ensemblePart == null && (ensemblePart = Ensemble.FindEnsemblePart(interp, this.ensData, "@error")) != null) {
                Command command = ensemblePart.cmd;
                if (ensemblePart.wcmd.mustCallInvoke(interp)) {
                    ensemblePart.wcmd.invoke(interp, tclObjectArray);
                } else {
                    command.cmdProc(interp, tclObjectArray);
                }
                return;
            }
            if (ensemblePart == null) {
                Ensemble.EnsembleErrorCmd(this.ensData, interp, tclObjectArray, 1);
            }
            TclObject tclObject = ItclEnsInvoc.newInstance();
            ItclEnsInvoc itclEnsInvoc = (ItclEnsInvoc)tclObject.getInternalRep();
            itclEnsInvoc.ensPart = ensemblePart;
            itclEnsInvoc.chainObj = tclObjectArray[0];
            tclObjectArray[1].preserve();
            tclObjectArray[0].preserve();
            TclObject tclObject2 = TclList.newInstance();
            TclList.append(interp, tclObject2, tclObject);
            for (int i = 2; i < tclObjectArray.length; ++i) {
                TclList.append(interp, tclObject2, tclObjectArray[i]);
            }
            tclObject2.preserve();
            try {
                TclObject[] tclObjectArray2 = TclList.getElements(interp, tclObject2);
                Command command = ensemblePart.cmd;
                if (ensemblePart.wcmd.mustCallInvoke(interp)) {
                    ensemblePart.wcmd.invoke(interp, tclObjectArray2);
                } else {
                    command.cmdProc(interp, tclObjectArray2);
                }
            }
            finally {
                tclObject2.release();
            }
        }
    }

    static class FindEnsemblePartIndexResult {
        boolean status;
        int pos;

        FindEnsemblePartIndexResult() {
        }
    }
}

