/*
 * Decompiled with CFR 0.152.
 */
package tcl.pkg.java;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import tcl.lang.Interp;
import tcl.lang.PackageNameException;
import tcl.lang.TclBoolean;
import tcl.lang.TclClassLoader;
import tcl.lang.TclDouble;
import tcl.lang.TclException;
import tcl.lang.TclInteger;
import tcl.lang.TclObject;
import tcl.lang.TclRuntimeError;
import tcl.lang.TclString;
import tcl.pkg.java.ClassRep;
import tcl.pkg.java.FieldSig;
import tcl.pkg.java.FuncSig;
import tcl.pkg.java.JavaImportCmd;
import tcl.pkg.java.JavaInfoCmd;
import tcl.pkg.java.PropertySig;
import tcl.pkg.java.ReflectException;
import tcl.pkg.java.ReflectObject;
import tcl.pkg.java.reflect.PkgInvoker;

public class JavaInvoke {
    private static Object[] EMPTY_ARGS = new Object[0];

    static TclObject newInstance(Interp interp, TclObject tclObject, TclObject[] tclObjectArray, int n, int n2) throws TclException {
        Object object;
        if (n2 == 1) {
            object = tclObject.toString();
            if (((String)object).equals("Boolean") || ((String)object).equals("java.lang.Boolean")) {
                tclObject = TclString.newInstance("java.lang.Boolean boolean");
            } else if (((String)object).equals("Integer") || ((String)object).equals("java.lang.Integer")) {
                tclObject = TclString.newInstance("java.lang.Integer int");
            } else if (((String)object).equals("Byte") || ((String)object).equals("java.lang.Byte")) {
                tclObject = TclString.newInstance("java.lang.Byte byte");
            } else if (((String)object).equals("Short") || ((String)object).equals("java.lang.Short")) {
                tclObject = TclString.newInstance("java.lang.Short short");
            } else if (((String)object).equals("Character") || ((String)object).equals("java.lang.Character")) {
                tclObject = TclString.newInstance("java.lang.Character char");
            } else if (((String)object).equals("Long") || ((String)object).equals("java.lang.Long")) {
                tclObject = TclString.newInstance("java.lang.Long long");
            } else if (((String)object).equals("Float") || ((String)object).equals("java.lang.Float")) {
                tclObject = TclString.newInstance("java.lang.Float float");
            } else if (((String)object).equals("Double") || ((String)object).equals("java.lang.Double")) {
                tclObject = TclString.newInstance("java.lang.Double double");
            }
        }
        object = FuncSig.get(interp, null, tclObject, tclObjectArray, n, n2, false);
        Object object2 = JavaInvoke.call(interp, ((FuncSig)object).pkgInvoker, tclObject, ((FuncSig)object).func, null, tclObjectArray, n, n2);
        return ReflectObject.newInstance(interp, ((FuncSig)object).targetCls, object2);
    }

    static TclObject callMethod(Interp interp, TclObject tclObject, TclObject tclObject2, TclObject[] tclObjectArray, int n, int n2, boolean bl) throws TclException {
        Object object = ReflectObject.get(interp, tclObject);
        Class clazz = ReflectObject.getClass(interp, tclObject);
        FuncSig funcSig = FuncSig.get(interp, clazz, tclObject2, tclObjectArray, n, n2, false);
        Method method = (Method)funcSig.func;
        Class<?> clazz2 = method.getReturnType();
        if (!PkgInvoker.isAccessible(clazz2)) {
            throw new TclException(interp, "Return type \"" + JavaInfoCmd.getNameFromClass(clazz2) + "\" is not accessible");
        }
        Object object2 = JavaInvoke.call(interp, funcSig.pkgInvoker, tclObject2, method, object, tclObjectArray, n, n2);
        if (clazz2 == Void.TYPE) {
            return null;
        }
        return JavaInvoke.wrap(interp, clazz2, object2, bl);
    }

    static TclObject callStaticMethod(Interp interp, TclObject tclObject, TclObject tclObject2, TclObject[] tclObjectArray, int n, int n2, boolean bl) throws TclException {
        Class clazz = ClassRep.get(interp, tclObject);
        FuncSig funcSig = FuncSig.get(interp, clazz, tclObject2, tclObjectArray, n, n2, true);
        Method method = (Method)funcSig.func;
        Class<?> clazz2 = method.getReturnType();
        if (!PkgInvoker.isAccessible(clazz2)) {
            throw new TclException(interp, "Return type \"" + JavaInfoCmd.getNameFromClass(clazz2) + "\" is not accessible");
        }
        Object object = JavaInvoke.call(interp, funcSig.pkgInvoker, tclObject2, method, null, tclObjectArray, n, n2);
        if (clazz2 == Void.TYPE) {
            return null;
        }
        return JavaInvoke.wrap(interp, method.getReturnType(), object, bl);
    }

    static Object call(Interp interp, PkgInvoker pkgInvoker, TclObject tclObject, Object object, Object object2, TclObject[] tclObjectArray, int n, int n2) throws TclException {
        Object[] objectArray;
        Class<?>[] classArray;
        Constructor constructor = null;
        Method method = null;
        boolean bl = object instanceof Constructor;
        if (bl) {
            constructor = (Constructor)object;
            classArray = constructor.getParameterTypes();
        } else {
            method = (Method)object;
            classArray = method.getParameterTypes();
        }
        if (n2 != classArray.length) {
            throw new TclException(interp, "wrong # args for calling " + (bl ? "constructor" : "method") + " \"" + tclObject + "\"");
        }
        if (n2 == 0) {
            objectArray = EMPTY_ARGS;
        } else {
            objectArray = new Object[n2];
            for (int i = 0; i < n2; ++i) {
                objectArray[i] = JavaInvoke.convertTclObject(interp, classArray[i], tclObjectArray[i + n]);
            }
        }
        try {
            Object object3 = bl ? pkgInvoker.invokeConstructor(constructor, objectArray) : pkgInvoker.invokeMethod(method, object2, objectArray);
            return object3;
        }
        catch (InstantiationException instantiationException) {
            throw new TclRuntimeError("unexpected abstract class: " + instantiationException.getMessage());
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new TclRuntimeError("unexpected inaccessible ctor or method: " + illegalAccessException.getMessage());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new TclRuntimeError("unexpected IllegalArgumentException: " + illegalArgumentException.getMessage());
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            if (throwable instanceof TclException) {
                interp.setResult(throwable.getMessage());
                throw (TclException)throwable;
            }
            throw new ReflectException(interp, throwable);
        }
    }

    static final TclObject getField(Interp interp, TclObject tclObject, TclObject tclObject2, boolean bl) throws TclException {
        return JavaInvoke.getsetField(interp, tclObject, tclObject2, null, bl, true);
    }

    static final void setField(Interp interp, TclObject tclObject, TclObject tclObject2, TclObject tclObject3) throws TclException {
        JavaInvoke.getsetField(interp, tclObject, tclObject2, tclObject3, false, false);
    }

    static TclObject getsetField(Interp interp, TclObject tclObject, TclObject tclObject2, TclObject tclObject3, boolean bl, boolean bl2) throws TclException {
        boolean bl3;
        Object object;
        Class clazz;
        block14: {
            clazz = null;
            object = null;
            bl3 = false;
            try {
                object = ReflectObject.get(interp, tclObject);
            }
            catch (TclException tclException) {
                try {
                    clazz = ClassRep.get(interp, tclObject);
                }
                catch (TclException tclException2) {
                    throw new TclException(interp, "unknown class or object \"" + tclObject + "\"");
                }
                bl3 = true;
                if (PkgInvoker.isAccessible(clazz)) break block14;
                JavaInvoke.notAccessibleError(interp, clazz);
            }
        }
        if (!bl3) {
            if (object == null) {
                throw new TclException(interp, "can't access fields in a null object reference");
            }
            clazz = ReflectObject.getClass(interp, tclObject);
        }
        if (bl3 && bl2 && tclObject2.toString().equals("class")) {
            return JavaInvoke.wrap(interp, Class.class, clazz, false);
        }
        FieldSig fieldSig = FieldSig.get(interp, tclObject2, clazz);
        Field field = fieldSig.field;
        if (bl3 && !Modifier.isStatic(field.getModifiers())) {
            throw new TclException(interp, "can't access an instance field without an object");
        }
        Class<?> clazz2 = field.getType();
        if (!PkgInvoker.isAccessible(field.getType())) {
            throw new TclException(interp, "Field type \"" + JavaInfoCmd.getNameFromClass(clazz2) + "\" is not accessible");
        }
        if (!bl2 && Modifier.isFinal(field.getModifiers())) {
            throw new TclException(interp, "can't set final field \"" + tclObject2 + "\"");
        }
        try {
            if (bl2) {
                return JavaInvoke.wrap(interp, clazz2, fieldSig.pkgInvoker.getField(field, object), bl);
            }
            Object object2 = JavaInvoke.convertTclObject(interp, clazz2, tclObject3);
            fieldSig.pkgInvoker.setField(field, object, object2);
            return null;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new TclRuntimeError("unexpected IllegalArgumentException: " + illegalArgumentException.getMessage());
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new TclRuntimeError("unexpected IllegalAccessException: " + illegalAccessException.getMessage());
        }
    }

    static TclObject getProperty(Interp interp, TclObject tclObject, TclObject tclObject2, boolean bl) throws TclException {
        Object object = ReflectObject.get(interp, tclObject);
        if (object == null) {
            throw new TclException(interp, "can't get property from null object");
        }
        Class clazz = ReflectObject.getClass(interp, tclObject);
        PropertySig propertySig = PropertySig.get(interp, clazz, tclObject2);
        Method method = propertySig.desc.getReadMethod();
        if (method == null) {
            throw new TclException(interp, "can't get write-only property \"" + tclObject2 + "\"");
        }
        try {
            return JavaInvoke.wrap(interp, method.getReturnType(), propertySig.pkgInvoker.invokeMethod(method, object, EMPTY_ARGS), bl);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new TclRuntimeError("unexpected inaccessible readMethod: " + illegalAccessException.getMessage());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new TclRuntimeError("unexpected IllegalArgumentException: " + illegalArgumentException.getMessage());
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new ReflectException(interp, (Throwable)invocationTargetException);
        }
    }

    static void setProperty(Interp interp, TclObject tclObject, TclObject tclObject2, TclObject tclObject3) throws TclException {
        Object object = ReflectObject.get(interp, tclObject);
        if (object == null) {
            throw new TclException(interp, "can't set property in null object");
        }
        Class clazz = ReflectObject.getClass(interp, tclObject);
        PropertySig propertySig = PropertySig.get(interp, clazz, tclObject2);
        Method method = propertySig.desc.getWriteMethod();
        Class<?> clazz2 = propertySig.desc.getPropertyType();
        if (method == null) {
            throw new TclException(interp, "can't set read-only property \"" + tclObject2 + "\"");
        }
        Object[] objectArray = new Object[]{JavaInvoke.convertTclObject(interp, clazz2, tclObject3)};
        try {
            propertySig.pkgInvoker.invokeMethod(method, object, objectArray);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new TclRuntimeError("unexpected inaccessible writeMethod: " + illegalAccessException.getMessage());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new TclRuntimeError("unexpected IllegalArgumentException: " + illegalArgumentException.getMessage());
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new ReflectException(interp, (Throwable)invocationTargetException);
        }
    }

    public static Class getClassByName(Interp interp, String string) throws TclException {
        int n;
        Class clazz = null;
        StringBuffer stringBuffer = new StringBuffer(64);
        StringBuffer stringBuffer2 = new StringBuffer(64);
        StringBuffer stringBuffer3 = new StringBuffer(string);
        int n2 = 0;
        while ((n = stringBuffer3.length()) > 2 && stringBuffer3.charAt(n - 2) == '[' && stringBuffer3.charAt(n - 1) == ']') {
            stringBuffer3.setLength(n - 2);
            stringBuffer.append('[');
            ++n2;
        }
        boolean bl = false;
        string = stringBuffer3.toString();
        if (string.indexOf(46) == -1) {
            String string2;
            if (n2 > 0) {
                boolean bl2 = true;
                if (string.equals("int")) {
                    stringBuffer.append('I');
                } else if (string.equals("boolean")) {
                    stringBuffer.append('Z');
                } else if (string.equals("long")) {
                    stringBuffer.append('J');
                } else if (string.equals("float")) {
                    stringBuffer.append('F');
                } else if (string.equals("double")) {
                    stringBuffer.append('D');
                } else if (string.equals("byte")) {
                    stringBuffer.append('B');
                } else if (string.equals("short")) {
                    stringBuffer.append('S');
                } else if (string.equals("char")) {
                    stringBuffer.append('C');
                } else {
                    bl2 = false;
                }
                if (bl2) {
                    try {
                        return Class.forName(stringBuffer.toString());
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new TclRuntimeError("unexpected ClassNotFoundException: " + classNotFoundException.getMessage());
                    }
                }
                stringBuffer.append('L');
                stringBuffer2.append(';');
            } else {
                if (string.equals("int")) {
                    return Integer.TYPE;
                }
                if (string.equals("boolean")) {
                    return Boolean.TYPE;
                }
                if (string.equals("long")) {
                    return Long.TYPE;
                }
                if (string.equals("float")) {
                    return Float.TYPE;
                }
                if (string.equals("double")) {
                    return Double.TYPE;
                }
                if (string.equals("byte")) {
                    return Byte.TYPE;
                }
                if (string.equals("short")) {
                    return Short.TYPE;
                }
                if (string.equals("char")) {
                    return Character.TYPE;
                }
            }
            TclClassLoader tclClassLoader = (TclClassLoader)interp.getClassLoader();
            try {
                string2 = stringBuffer + string + stringBuffer2;
                clazz = tclClassLoader.loadClass(string2);
            }
            catch (ClassNotFoundException classNotFoundException) {
                clazz = null;
            }
            catch (PackageNameException packageNameException) {
                throw new TclRuntimeError("unexpected PackageNameException :" + packageNameException.getMessage());
            }
            if (clazz == null) {
                boolean bl3 = false;
                String string3 = JavaImportCmd.getImport(interp, string);
                if (string3 == null) {
                    bl3 = true;
                    string3 = "java.lang." + string;
                }
                try {
                    string2 = stringBuffer + string3 + stringBuffer2;
                    clazz = tclClassLoader.loadClass(string2);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    clazz = null;
                }
                catch (PackageNameException packageNameException) {
                    if (!bl3) {
                        bl = true;
                    }
                    clazz = null;
                }
            }
        } else {
            String string4;
            TclClassLoader tclClassLoader = (TclClassLoader)interp.getClassLoader();
            if (n2 > 0) {
                stringBuffer.append("L");
                stringBuffer2.append(";");
            }
            try {
                string4 = stringBuffer + string + stringBuffer2;
                clazz = tclClassLoader.loadClass(string4);
            }
            catch (ClassNotFoundException classNotFoundException) {
                clazz = null;
            }
            catch (PackageNameException packageNameException) {
                bl = true;
                clazz = null;
            }
            if (clazz == null && string.indexOf(36) == -1) {
                ArrayList<String> arrayList = new ArrayList<String>(5);
                int n3 = 0;
                int n4 = string.length();
                for (int i = 0; i <= n4; ++i) {
                    if (i != n4 && string.charAt(i) != '.') continue;
                    arrayList.add(string.substring(n3, i));
                    n3 = i + 1;
                }
                String string5 = null;
                String string6 = null;
                boolean bl4 = false;
                for (int i = arrayList.size() - 1; i > 0; --i) {
                    int n5;
                    StringBuffer stringBuffer4 = new StringBuffer(64);
                    for (n5 = 0; n5 < i; ++n5) {
                        stringBuffer4.append(arrayList.get(n5));
                        stringBuffer4.append('.');
                    }
                    if (stringBuffer4.length() > 0 && stringBuffer4.charAt(stringBuffer4.length() - 1) == '.') {
                        stringBuffer4.setLength(stringBuffer4.length() - 1);
                    }
                    string5 = stringBuffer4.toString();
                    stringBuffer4 = new StringBuffer(64);
                    for (n5 = i; n5 < arrayList.size(); ++n5) {
                        stringBuffer4.append(arrayList.get(n5));
                        stringBuffer4.append('$');
                    }
                    if (stringBuffer4.length() > 0 && stringBuffer4.charAt(stringBuffer4.length() - 1) == '$') {
                        stringBuffer4.setLength(stringBuffer4.length() - 1);
                    }
                    string6 = stringBuffer4.toString();
                    try {
                        string4 = stringBuffer + string5 + stringBuffer2;
                        clazz = tclClassLoader.loadClass(string4);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        clazz = null;
                    }
                    catch (PackageNameException packageNameException) {
                        bl = true;
                        clazz = null;
                    }
                    if (clazz != null) {
                        bl4 = true;
                        break;
                    }
                    if (string5.indexOf(46) != -1) continue;
                    String string7 = JavaImportCmd.getImport(interp, string5);
                    if (string7 != null) {
                        bl4 = true;
                        string5 = string7;
                        break;
                    }
                    string7 = "java.lang." + string5;
                    try {
                        string4 = stringBuffer + string7 + stringBuffer2;
                        clazz = tclClassLoader.loadClass(string4);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        clazz = null;
                    }
                    catch (PackageNameException packageNameException) {
                        clazz = null;
                    }
                    if (clazz == null) continue;
                    bl4 = true;
                    string5 = string7;
                    break;
                }
                if (bl4) {
                    try {
                        string4 = stringBuffer + string5 + "$" + string6 + stringBuffer2;
                        clazz = tclClassLoader.loadClass(string4);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        clazz = null;
                    }
                    catch (PackageNameException packageNameException) {
                        bl = true;
                        clazz = null;
                    }
                }
            }
        }
        if (clazz == null && bl) {
            throw new TclException(interp, "cannot load new class into java or tcl package");
        }
        if (clazz == null) {
            throw new TclException(interp, "unknown class \"" + stringBuffer3 + "\"");
        }
        return clazz;
    }

    static TclObject convertJavaObject(Interp interp, Class clazz, Object object) throws TclException {
        if (object == null) {
            if (clazz == String.class) {
                return TclString.newInstance("");
            }
            return ReflectObject.newInstance(interp, clazz, object);
        }
        if (clazz == Integer.TYPE || clazz == Integer.class) {
            return TclInteger.newInstance(((Integer)object).intValue());
        }
        if (clazz == Long.TYPE || clazz == Long.class) {
            return TclInteger.newInstance((Long)object);
        }
        if (clazz == Short.TYPE || clazz == Short.class) {
            return TclInteger.newInstance(((Short)object).intValue());
        }
        if (clazz == Byte.TYPE || clazz == Byte.class) {
            return TclInteger.newInstance(((Byte)object).intValue());
        }
        if (clazz == Double.TYPE || clazz == Double.class) {
            return TclDouble.newInstance((Double)object);
        }
        if (clazz == Float.TYPE || clazz == Float.class) {
            return TclDouble.newInstance(((Float)object).doubleValue());
        }
        if (clazz == Boolean.TYPE || clazz == Boolean.class) {
            return TclBoolean.newInstance((Boolean)object);
        }
        if (clazz == Character.TYPE || clazz == Character.class) {
            return TclString.newInstance(((Character)object).toString());
        }
        if (clazz == String.class) {
            return TclString.newInstance((String)object);
        }
        return ReflectObject.newInstance(interp, clazz, object);
    }

    static final Object convertTclObject(Interp interp, Class clazz, TclObject tclObject) throws TclException {
        Object object = null;
        Class clazz2 = null;
        boolean bl = false;
        try {
            object = ReflectObject.get(interp, tclObject);
            clazz2 = ReflectObject.getClass(interp, tclObject);
            bl = true;
        }
        catch (TclException tclException) {
            interp.resetResult();
        }
        if (!bl) {
            if (clazz == String.class) {
                return tclObject.toString();
            }
            if (clazz == Object.class) {
                return tclObject.toString();
            }
            if (clazz == Integer.TYPE || clazz == Integer.class) {
                return new Integer(TclInteger.getInt(interp, tclObject));
            }
            if (clazz == Boolean.TYPE || clazz == Boolean.class) {
                return new Boolean(TclBoolean.get(interp, tclObject));
            }
            if (clazz == Long.TYPE || clazz == Long.class) {
                return new Long(TclInteger.getLong(interp, tclObject));
            }
            if (clazz == Float.TYPE || clazz == Float.class) {
                double d = TclDouble.get(interp, tclObject);
                float f = (float)d;
                if (!Double.isNaN(d) && d != Double.NEGATIVE_INFINITY && d != Double.POSITIVE_INFINITY && d != 0.0 && (Math.abs(d) > 3.4028234663852886E38 || Math.abs(d) < (double)1.4E-45f)) {
                    throw new TclException(interp, "double value too large to represent in a float");
                }
                return new Float(f);
            }
            if (clazz == Double.TYPE || clazz == Double.class) {
                return new Double(TclDouble.get(interp, tclObject));
            }
            if (clazz == Byte.TYPE || clazz == Byte.class) {
                int n = TclInteger.getInt(interp, tclObject);
                if (n < -128 || n > 127) {
                    throw new TclException(interp, "integer value too large to represent in a byte");
                }
                return new Byte((byte)n);
            }
            if (clazz == Short.TYPE || clazz == Short.class) {
                int n = TclInteger.getInt(interp, tclObject);
                if (n < Short.MIN_VALUE || n > Short.MAX_VALUE) {
                    throw new TclException(interp, "integer value too large to represent in a short");
                }
                return new Short((short)n);
            }
            if (clazz == Character.TYPE || clazz == Character.class) {
                String string = tclObject.toString();
                if (string.length() != 1) {
                    throw new TclException(interp, "expected character but got \"" + tclObject + "\"");
                }
                return new Character(string.charAt(0));
            }
            if (clazz == TclObject.class) {
                return tclObject;
            }
            throw new TclException(interp, "\"" + tclObject + "\" is not an object handle of class \"" + JavaInfoCmd.getNameFromClass(clazz) + "\"");
        }
        if (JavaInvoke.isAssignable(clazz, clazz2)) {
            return object;
        }
        if (clazz.isPrimitive()) {
            if (clazz == Boolean.TYPE) {
                if (object instanceof Boolean) {
                    return object;
                }
            } else if (clazz == Character.TYPE) {
                if (object instanceof Character) {
                    return object;
                }
            } else if (clazz == Byte.TYPE) {
                if (object instanceof Byte) {
                    return object;
                }
            } else if (clazz == Short.TYPE) {
                if (object instanceof Short) {
                    return object;
                }
            } else if (clazz == Integer.TYPE) {
                if (object instanceof Integer) {
                    return object;
                }
            } else if (clazz == Long.TYPE) {
                if (object instanceof Long) {
                    return object;
                }
            } else if (clazz == Float.TYPE) {
                if (object instanceof Float) {
                    return object;
                }
            } else if (clazz == Double.TYPE) {
                if (object instanceof Double) {
                    return object;
                }
            } else if (clazz == Void.TYPE) {
                // empty if block
            }
        }
        if (clazz == TclObject.class) {
            return tclObject;
        }
        throw new TclException(interp, "expected object of type " + JavaInfoCmd.getNameFromClass(clazz) + " but got \"" + tclObject + "\" (" + (clazz2 == null ? "null" : JavaInfoCmd.getNameFromClass(clazz2)) + ")");
    }

    private static final TclObject wrap(Interp interp, Class clazz, Object object, boolean bl) throws TclException {
        if (bl) {
            return JavaInvoke.convertJavaObject(interp, clazz, object);
        }
        return ReflectObject.newInstance(interp, clazz, object);
    }

    static final boolean isAssignable(Class clazz, Class clazz2) {
        if (clazz2 == null) {
            return !clazz.isPrimitive();
        }
        return clazz == clazz2 || clazz.isAssignableFrom(clazz2);
    }

    static void notAccessibleError(Interp interp, Class clazz) throws TclException {
        throw new TclException(interp, "Class \"" + JavaInfoCmd.getNameFromClass(clazz) + "\" is not accessible");
    }

    static boolean isInnerClass(Class clazz) throws TclException {
        String string = clazz.getName();
        return string.indexOf(36) != -1;
    }
}

