/*
 * Decompiled with CFR 0.152.
 */
package tcl.pkg.java;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Map;
import tcl.lang.Command;
import tcl.lang.CommandWithDispose;
import tcl.lang.InternalRep;
import tcl.lang.Interp;
import tcl.lang.TclException;
import tcl.lang.TclNumArgsException;
import tcl.lang.TclObject;
import tcl.lang.TclRuntimeError;
import tcl.pkg.java.ArrayObject;
import tcl.pkg.java.JavaInfoCmd;
import tcl.pkg.java.JavaInvoke;
import tcl.pkg.java.reflect.PkgInvoker;

public class ReflectObject
implements InternalRep,
CommandWithDispose {
    Object javaObj;
    Class javaClass;
    Interp ownerInterp;
    String refID;
    private int useCount;
    private boolean isValid;
    Hashtable bindings;
    private static final String NULL_REP = "java0x0";
    protected static final String NOCONVERT = "-noconvert";
    protected static final String CMD_PREFIX = "java0x";
    private static final boolean debug = false;
    private static final boolean dump = false;

    private static ReflectObject makeNullObject(Interp interp, Class clazz) {
        ReflectObject reflectObject = new ReflectObject();
        reflectObject.ownerInterp = interp;
        reflectObject.refID = NULL_REP;
        reflectObject.useCount = 1;
        reflectObject.isValid = true;
        reflectObject.javaObj = null;
        reflectObject.javaClass = clazz;
        return reflectObject;
    }

    private static String getHashString(Class clazz, Object object) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(JavaInfoCmd.getNameFromClass(clazz));
        stringBuffer.append('.');
        stringBuffer.append(System.identityHashCode(object));
        return stringBuffer.toString();
    }

    private static void addToReflectTable(ReflectObject reflectObject) {
        Interp interp = reflectObject.ownerInterp;
        Class clazz = reflectObject.javaClass;
        Object object = reflectObject.javaObj;
        String string = reflectObject.refID;
        String string2 = ReflectObject.getHashString(clazz, object);
        ReflectObject reflectObject2 = (ReflectObject)interp.reflectObjTable.get(string2);
        if (reflectObject2 == null) {
            interp.reflectObjTable.put(string2, reflectObject);
        } else {
            ArrayList<ReflectObject> arrayList = (ArrayList<ReflectObject>)interp.reflectConflictTable.get(string2);
            if (arrayList == null) {
                arrayList = new ArrayList<ReflectObject>();
                interp.reflectConflictTable.put(string2, arrayList);
            }
            arrayList.add(reflectObject);
        }
    }

    private static void removeFromReflectTable(ReflectObject reflectObject) {
        Interp interp = reflectObject.ownerInterp;
        Class clazz = reflectObject.javaClass;
        Object object = reflectObject.javaObj;
        String string = reflectObject.refID;
        String string2 = ReflectObject.getHashString(clazz, object);
        ReflectObject reflectObject2 = (ReflectObject)interp.reflectObjTable.get(string2);
        if (reflectObject2 == null) {
            throw new TclRuntimeError("reflect table returned null for " + string + " with hash \"" + string2 + "\"");
        }
        if (reflectObject2 == reflectObject) {
            interp.reflectObjTable.remove(string2);
            ArrayList arrayList = (ArrayList)interp.reflectConflictTable.get(string2);
            if (arrayList != null) {
                Object e = arrayList.remove(0);
                if (arrayList.isEmpty()) {
                    interp.reflectConflictTable.remove(string2);
                }
                interp.reflectObjTable.put(string2, e);
            }
        } else {
            ArrayList arrayList = (ArrayList)interp.reflectConflictTable.get(string2);
            if (arrayList == null) {
                throw new TclRuntimeError("conflict table mapped to null for " + string + " with hash \"" + string2 + "\"");
            }
            int n = arrayList.indexOf(reflectObject);
            if (n == -1) {
                throw new TclRuntimeError("no entry in conflict table for " + string + " with hash \"" + string2 + "\"");
            }
            arrayList.remove(n);
            if (arrayList.isEmpty()) {
                interp.reflectConflictTable.remove(string2);
            }
        }
    }

    private static ReflectObject findInConflictTable(Interp interp, Object object, String string) {
        ArrayList arrayList = (ArrayList)interp.reflectConflictTable.get(string);
        if (arrayList == null) {
            return null;
        }
        ListIterator listIterator = arrayList.listIterator();
        while (listIterator.hasNext()) {
            ReflectObject reflectObject = (ReflectObject)listIterator.next();
            if (reflectObject.javaObj != object) continue;
            return reflectObject;
        }
        return null;
    }

    private static ReflectObject findInReflectTable(Interp interp, Class clazz, Object object) {
        String string = ReflectObject.getHashString(clazz, object);
        ReflectObject reflectObject = (ReflectObject)interp.reflectObjTable.get(string);
        if (reflectObject == null) {
            return null;
        }
        if (reflectObject.javaObj == object) {
            return reflectObject;
        }
        return ReflectObject.findInConflictTable(interp, object, string);
    }

    public static void dump(Interp interp) {
        try {
            System.out.println("BEGIN DUMP -------------------------------");
            System.out.println("interp.reflectObjCount = " + interp.reflectObjCount);
            System.out.println("interp.reflectObjTable.size() = " + interp.reflectObjTable.size());
            System.out.println("interp.reflectConflictTable.size() = " + interp.reflectConflictTable.size());
            Iterator iterator = interp.reflectObjTable.entrySet().iterator();
            while (iterator.hasNext()) {
                String string;
                Map.Entry entry = iterator.next();
                System.out.println();
                String string2 = (String)entry.getKey();
                ReflectObject reflectObject = (ReflectObject)entry.getValue();
                if (reflectObject == null) {
                    throw new RuntimeException("Reflect table entry \"" + string2 + "\" hashed to null");
                }
                if (reflectObject.ownerInterp != interp) {
                    throw new RuntimeException("roRep.ownerInterp not the same as current interp");
                }
                if (interp.getCommand(reflectObject.refID) == null) {
                    System.out.println("could not find command named \"" + reflectObject.refID + "\"");
                }
                if (!string2.equals(string = ReflectObject.getHashString(reflectObject.javaClass, reflectObject.javaObj))) {
                    throw new RuntimeException("hash \"" + string2 + "\" is not equal to calculated hash \"" + string);
                }
                System.out.println("hash \"" + string2 + "\" corresponds to ReflectObject with refID \"" + reflectObject.refID + "\" useCount = \"" + reflectObject.useCount + "\" isValid = \"" + reflectObject.isValid + "\" javaClass = \"" + JavaInfoCmd.getNameFromClass(reflectObject.javaClass) + "\" System.identityHashCode(javaObj) = \"" + System.identityHashCode(reflectObject.javaObj) + "\"");
                ArrayList arrayList = (ArrayList)interp.reflectConflictTable.get(string2);
                if (arrayList == null) continue;
                System.out.println("Found conflict table for hash " + string2);
                ListIterator listIterator = arrayList.listIterator();
                while (iterator.hasNext()) {
                    ReflectObject reflectObject2 = (ReflectObject)listIterator.next();
                    System.out.println("hash conflict for \"" + string2 + "\" corresponds to ReflectObject with refID \"" + reflectObject2.refID + "\"");
                }
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace(System.out);
        }
    }

    private static ReflectObject makeReflectObject(Interp interp, Class clazz, Object object) throws TclException {
        if (clazz != null && !PkgInvoker.isAccessible(clazz)) {
            JavaInvoke.notAccessibleError(interp, clazz);
        }
        if (object == null) {
            return ReflectObject.makeNullObject(interp, clazz);
        }
        if (clazz == null) {
            throw new TclException(interp, "non null reflect object with null class is not valid");
        }
        if (clazz == Integer.TYPE) {
            clazz = Integer.class;
        } else if (clazz == Boolean.TYPE) {
            clazz = Boolean.class;
        } else if (clazz == Long.TYPE) {
            clazz = Long.class;
        } else if (clazz == Float.TYPE) {
            clazz = Float.class;
        } else if (clazz == Double.TYPE) {
            clazz = Double.class;
        } else if (clazz == Byte.TYPE) {
            clazz = Byte.class;
        } else if (clazz == Short.TYPE) {
            clazz = Short.class;
        } else if (clazz == Character.TYPE) {
            clazz = Character.class;
        } else if (clazz == Void.TYPE) {
            throw new TclException(interp, "void object type can not be reflected");
        }
        ReflectObject reflectObject = ReflectObject.findInReflectTable(interp, clazz, object);
        if (reflectObject != null && reflectObject.isValid) {
            ++reflectObject.useCount;
            return reflectObject;
        }
        reflectObject = clazz.isArray() ? new ArrayObject() : new ReflectObject();
        reflectObject.ownerInterp = interp;
        reflectObject.javaObj = object;
        reflectObject.javaClass = clazz;
        Class<?> clazz2 = reflectObject.javaObj.getClass();
        if (!reflectObject.javaClass.isAssignableFrom(clazz2)) {
            throw new TclException(interp, "object of type " + JavaInfoCmd.getNameFromClass(clazz2) + " can not be referenced as type " + JavaInfoCmd.getNameFromClass(reflectObject.javaClass));
        }
        ++interp.reflectObjCount;
        reflectObject.refID = CMD_PREFIX + Long.toHexString(interp.reflectObjCount);
        interp.createCommand(reflectObject.refID, reflectObject);
        ReflectObject.addToReflectTable(reflectObject);
        reflectObject.useCount = 1;
        reflectObject.isValid = true;
        return reflectObject;
    }

    @Override
    public void dispose() {
        --this.useCount;
        if (this.useCount == 0 && this.refID != NULL_REP) {
            if (this.isValid) {
                this.ownerInterp.deleteCommand(this.refID);
            }
            ReflectObject.removeFromReflectTable(this);
            this.ownerInterp = null;
            this.javaObj = null;
            this.javaClass = null;
            this.bindings = null;
            this.refID = NULL_REP;
        }
    }

    @Override
    public InternalRep duplicate() {
        ++this.useCount;
        return this;
    }

    private static void setReflectObjectFromAny(Interp interp, TclObject tclObject) throws TclException {
        String string;
        ReflectObject reflectObject;
        InternalRep internalRep = tclObject.getInternalRep();
        if (internalRep instanceof ReflectObject) {
            reflectObject = (ReflectObject)internalRep;
            if (reflectObject.isValid && reflectObject.ownerInterp == interp) {
                return;
            }
        }
        if ((string = tclObject.toString()).startsWith(CMD_PREFIX)) {
            if (string.equals(NULL_REP)) {
                tclObject.setInternalRep(ReflectObject.makeReflectObject(interp, null, null));
                return;
            }
            Command command = interp.getCommand(string);
            if (command != null && command instanceof ReflectObject && ((ReflectObject)command).isValid) {
                reflectObject = (ReflectObject)command;
                ++reflectObject.useCount;
                tclObject.setInternalRep(reflectObject);
                return;
            }
        }
        throw new TclException(interp, "unknown java object \"" + tclObject + "\"");
    }

    public static TclObject newInstance(Interp interp, Class clazz, Object object) throws TclException {
        return new TclObject(ReflectObject.makeReflectObject(interp, clazz, object));
    }

    public static Object get(Interp interp, TclObject tclObject) throws TclException {
        ReflectObject.setReflectObjectFromAny(interp, tclObject);
        ReflectObject reflectObject = (ReflectObject)tclObject.getInternalRep();
        return reflectObject.javaObj;
    }

    public static Class getClass(Interp interp, TclObject tclObject) throws TclException {
        ReflectObject.setReflectObjectFromAny(interp, tclObject);
        ReflectObject reflectObject = (ReflectObject)tclObject.getInternalRep();
        return reflectObject.javaClass;
    }

    static ReflectObject getReflectObject(Interp interp, TclObject tclObject) throws TclException {
        ReflectObject.setReflectObjectFromAny(interp, tclObject);
        return (ReflectObject)tclObject.getInternalRep();
    }

    @Override
    public void cmdProc(Interp interp, TclObject[] tclObjectArray) throws TclException {
        int n;
        boolean bl;
        if (!this.isValid) {
            throw new TclException(interp, "reflected object is no longer valid");
        }
        if (tclObjectArray.length < 2) {
            throw new TclNumArgsException(interp, 1, tclObjectArray, "?-noconvert? signature ?arg arg ...?");
        }
        String string = tclObjectArray[1].toString();
        if (string.length() >= 2 && NOCONVERT.startsWith(string)) {
            bl = false;
            n = 2;
        } else {
            bl = true;
            n = 1;
        }
        if (tclObjectArray.length < n + 1) {
            throw new TclNumArgsException(interp, 1, tclObjectArray, "?-noconvert? signature ?arg arg ...?");
        }
        int n2 = n + 1;
        int n3 = tclObjectArray.length - n2;
        TclObject tclObject = JavaInvoke.callMethod(interp, tclObjectArray[0], tclObjectArray[n], tclObjectArray, n2, n3, bl);
        if (tclObject == null) {
            interp.resetResult();
        } else {
            interp.setResult(tclObject);
        }
    }

    @Override
    public void disposeCmd() {
        this.isValid = false;
        this.dispose();
    }

    public String toString() {
        return this.refID;
    }
}

