/*
 * Decompiled with CFR 0.152.
 */
package tcl.pkg.tjc;

import java.util.HashMap;
import tcl.lang.CallFrame;
import tcl.lang.Command;
import tcl.lang.ExprValue;
import tcl.lang.Expression;
import tcl.lang.Interp;
import tcl.lang.Namespace;
import tcl.lang.Parser;
import tcl.lang.TclDouble;
import tcl.lang.TclException;
import tcl.lang.TclInteger;
import tcl.lang.TclList;
import tcl.lang.TclNumArgsException;
import tcl.lang.TclObject;
import tcl.lang.TclRuntimeError;
import tcl.lang.TclString;
import tcl.lang.Util;
import tcl.lang.Var;
import tcl.lang.WrappedCommand;
import tcl.lang.cmd.LappendCmd;
import tcl.lang.cmd.LindexCmd;
import tcl.lang.cmd.ProcCmd;
import tcl.lang.cmd.SwitchCmd;

public class TJC {
    public static final int SWITCH_MODE_EXACT = 0;
    public static final int SWITCH_MODE_GLOB = 1;
    public static final int SWITCH_MODE_REGEXP = 2;
    public static final int EXPR_OP_MULT = 8;
    public static final int EXPR_OP_DIVIDE = 9;
    public static final int EXPR_OP_MOD = 10;
    public static final int EXPR_OP_PLUS = 11;
    public static final int EXPR_OP_MINUS = 12;
    public static final int EXPR_OP_LEFT_SHIFT = 13;
    public static final int EXPR_OP_RIGHT_SHIFT = 14;
    public static final int EXPR_OP_LESS = 15;
    public static final int EXPR_OP_GREATER = 16;
    public static final int EXPR_OP_LEQ = 17;
    public static final int EXPR_OP_GEQ = 18;
    public static final int EXPR_OP_EQUAL = 19;
    public static final int EXPR_OP_NEQ = 20;
    public static final int EXPR_OP_BIT_AND = 21;
    public static final int EXPR_OP_BIT_XOR = 22;
    public static final int EXPR_OP_BIT_OR = 23;
    public static final int EXPR_OP_STREQ = 28;
    public static final int EXPR_OP_STRNEQ = 29;
    public static final int EXPR_OP_UNARY_MINUS = 30;
    public static final int EXPR_OP_UNARY_PLUS = 31;
    public static final int EXPR_OP_UNARY_NOT = 32;
    public static final int EXPR_OP_UNARY_BIT_NOT = 33;
    public static final WrappedCommand INVALID_COMMAND_CACHE = new WrappedCommand();
    private static final boolean USE_OBJV_CACHE = true;
    private static final boolean USE_EXPR_CACHE = true;

    public static CallFrame pushLocalCallFrame(Interp interp, Namespace namespace) {
        CallFrame callFrame = interp.newCallFrame();
        if (namespace != null) {
            callFrame.ns = namespace;
        }
        if (!callFrame.isProcCallFrame) {
            throw new TclRuntimeError("expected isProcCallFrame to be true");
        }
        callFrame.level = interp.varFrame == null ? 1 : interp.varFrame.level + 1;
        callFrame.caller = interp.frame;
        callFrame.callerVar = interp.varFrame;
        interp.frame = callFrame;
        interp.varFrame = callFrame;
        return callFrame;
    }

    public static void popLocalCallFrame(Interp interp, CallFrame callFrame) {
        if (interp.errInProgress) {
            callFrame.dispose();
            interp.errInProgress = true;
        } else {
            callFrame.dispose();
        }
    }

    public static Var[] initCompiledLocals(CallFrame callFrame, int n, String[] stringArray) {
        callFrame.compiledLocalsNames = stringArray;
        callFrame.compiledLocals = new Var[n];
        return callFrame.compiledLocals;
    }

    public static void evalProcBody(Interp interp, String string) throws TclException {
        interp.eval(string);
    }

    public static void checkTclException(Interp interp, TclException tclException, String string) throws TclException {
        int n = tclException.getCompletionCode();
        if (n == 2) {
            int n2 = interp.updateReturnInfo();
            if (n2 != 0) {
                tclException.setCompletionCode(n2);
                throw tclException;
            }
        } else {
            if (n == 1) {
                interp.addErrorInfo("\n    (procedure \"" + string + "\" line 1)");
                throw tclException;
            }
            if (n == 3) {
                throw new TclException(interp, "invoked \"break\" outside of a loop");
            }
            if (n == 4) {
                throw new TclException(interp, "invoked \"continue\" outside of a loop");
            }
            throw tclException;
        }
    }

    public static void createCommand(Interp interp, String string, CompiledCommand compiledCommand) throws TclException {
        ProcCmd.FindCommandNamespaceResult findCommandNamespaceResult = ProcCmd.FindCommandNamespace(interp, string);
        interp.createCommand(findCommandNamespaceResult.cmdFullName, compiledCommand);
        compiledCommand.wcmd = Namespace.findCommand(interp, findCommandNamespaceResult.cmdName, findCommandNamespaceResult.ns, 2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void sourceInitFile(Interp interp, String string, String[] stringArray, String string2) throws TclException {
        block5: {
            interp.eval("package require TJC");
            interp.eval("rename ::source ::TJC::source");
            interp.createCommand("::source", new InitSourceCmd(string, stringArray, string2));
            TclException tclException = null;
            try {
                interp.evalResource(string2 + string);
            }
            catch (TclException tclException2) {
                tclException = tclException2;
            }
            finally {
                interp.eval("rename ::source {}");
                interp.eval("rename ::TJC::source ::source");
                if (tclException == null) break block5;
                interp.setResult(tclException.getMessage());
                throw tclException;
            }
        }
    }

    public static WrappedCommand resolveCmd(Interp interp, String string) throws TclException {
        return Namespace.findCommand(interp, string, null, 0);
    }

    static final void setVarScalar(Var var, TclObject tclObject) {
        TclObject tclObject2 = var.getValue();
        if (tclObject2 != tclObject) {
            var.setValue(tclObject);
            tclObject.preserve();
            if (tclObject2 != null) {
                tclObject2.release();
            }
        }
    }

    public static final TclObject incrVar(Interp interp, String string, String string2, long l) throws TclException {
        return Var.incrVar(interp, string, string2, l, 512);
    }

    public static TclObject[] grabObjv(Interp interp, int n) {
        return Parser.grabObjv(interp, n);
    }

    public static void releaseObjv(Interp interp, TclObject[] tclObjectArray, int n) {
        Parser.releaseObjv(interp, tclObjectArray, n);
    }

    public static void releaseObjvElems(Interp interp, TclObject[] tclObjectArray, int n) {
        for (int i = 0; i < n; ++i) {
            TclObject tclObject = tclObjectArray[i];
            if (tclObject == null) continue;
            tclObject.release();
        }
        Parser.releaseObjv(interp, tclObjectArray, n);
    }

    public static void invoke(Interp interp, Command command, TclObject[] objectArray, int n) throws TclException {
        int n2;
        Object[] objectArray2;
        int n3;
        boolean bl = false;
        CallFrame callFrame = interp.varFrame;
        if (command == null) {
            String string;
            WrappedCommand wrappedCommand;
            int n4 = 0;
            if ((n & 0x20000) != 0) {
                n4 |= 1;
            }
            if ((wrappedCommand = Namespace.findCommand(interp, string = objectArray[0].toString(), null, n4)) != null) {
                command = wrappedCommand.cmd;
            }
            if (command == null) {
                wrappedCommand = Namespace.findCommand(interp, "unknown", null, 1);
                if (wrappedCommand != null) {
                    command = wrappedCommand.cmd;
                }
                if (command == null) {
                    throw new TclException(interp, "invalid command name \"" + string + "\"");
                }
                n3 = objectArray.length;
                if (n3 == 0) {
                    throw new TclRuntimeError("zero length objv array");
                }
                objectArray2 = TJC.grabObjv(interp, n3 + 1);
                objectArray2[0] = (char)TclString.newInstance("unknown");
                objectArray2[0].preserve();
                for (n2 = n3 - 1; n2 >= 0; --n2) {
                    objectArray2[n2 + 1] = (char)objectArray[n2];
                }
                objectArray = objectArray2;
                bl = true;
            }
        }
        try {
            interp.preserve();
            interp.allowExceptions();
            interp.ready();
            ++interp.nestLevel;
            ++interp.cmdCount;
            if ((n & 0x20000) != 0) {
                interp.varFrame = null;
            }
            command.cmdProc(interp, (TclObject[])objectArray);
        }
        catch (TclException tclException) {
            if (tclException.getCompletionCode() == 1 && !interp.errAlreadyLogged) {
                StringBuffer stringBuffer = new StringBuffer(64);
                int n5 = objectArray.length;
                if (n5 == 0) {
                    throw new TclRuntimeError("zero length objv array");
                }
                for (n3 = 0; n3 < n5; ++n3) {
                    Util.appendElement(interp, stringBuffer, objectArray[n3].toString());
                }
                String string = stringBuffer.toString();
                objectArray2 = string.toCharArray();
                n2 = 0;
                int n6 = 0;
                int n7 = string.length();
                Parser.logCommandInfo(interp, objectArray2, n2, n6, n7, tclException);
            }
            throw tclException;
        }
        finally {
            if (bl) {
                objectArray[0].release();
                TJC.releaseObjv(interp, objectArray, objectArray.length);
            }
            --interp.nestLevel;
            interp.varFrame = callFrame;
            interp.release();
            interp.checkInterrupted();
        }
    }

    public static boolean getBoolean(Interp interp, TclObject tclObject) throws TclException {
        if (tclObject.isIntType()) {
            return tclObject.ivalue != 0L;
        }
        if (tclObject.isDoubleType()) {
            return TJC.exprGetKnownDouble(tclObject) != 0.0;
        }
        ExprValue exprValue = interp.expr.grabExprValue();
        Expression.ExprParseString(interp, tclObject, exprValue);
        boolean bl = exprValue.getBooleanValue(interp);
        interp.expr.releaseExprValue(exprValue);
        return bl;
    }

    public static int invokeSwitch(Interp interp, TclObject[] tclObjectArray, int n, String string, int n2) throws TclException {
        int n3 = SwitchCmd.getBodyOffset(interp, tclObjectArray, n, string, n2);
        return n3;
    }

    public static void switchStringIsNotOption(Interp interp, String string) throws TclException {
        if (string.startsWith("-")) {
            TclObject[] tclObjectArray = new TclObject[]{TclString.newInstance("switch")};
            throw new TclNumArgsException(interp, 1, tclObjectArray, "?switches? string pattern body ... ?default body?");
        }
    }

    public static void catchVarErr(Interp interp) throws TclException {
        throw new TclException(interp, "couldn't save command result in variable");
    }

    public static void foreachVarErr(Interp interp, String string) throws TclException {
        throw new TclException(interp, "couldn't set loop variable: \"" + string + "\"");
    }

    public static void exprReleaseValue(Interp interp, ExprValue exprValue) {
        interp.expr.releaseExprValue(exprValue);
    }

    public static ExprValue exprGetValue(Interp interp, long l, String string) throws TclException {
        ExprValue exprValue = interp.expr.grabExprValue();
        exprValue.setIntValue(l, string);
        return exprValue;
    }

    public static ExprValue exprGetValue(Interp interp, double d, String string) throws TclException {
        ExprValue exprValue = interp.expr.grabExprValue();
        exprValue.setDoubleValue(d, string);
        return exprValue;
    }

    public static ExprValue exprGetValue(Interp interp, String string) throws TclException {
        ExprValue exprValue = interp.expr.grabExprValue();
        exprValue.setStringValue(string);
        return exprValue;
    }

    public static ExprValue exprGetValue(Interp interp, boolean bl) throws TclException {
        ExprValue exprValue = interp.expr.grabExprValue();
        exprValue.setIntValue(bl);
        return exprValue;
    }

    public static ExprValue exprGetValue(Interp interp, TclObject tclObject) throws TclException {
        ExprValue exprValue = interp.expr.grabExprValue();
        Expression.ExprParseObject(interp, tclObject, exprValue);
        return exprValue;
    }

    public static void exprInitValue(Interp interp, ExprValue exprValue, TclObject tclObject) throws TclException {
        Expression.ExprParseObject(interp, tclObject, exprValue);
    }

    public static ExprValue exprGetValue(Interp interp) {
        return interp.expr.grabExprValue();
    }

    public static long exprGetKnownInt(TclObject tclObject) {
        return tclObject.ivalue;
    }

    public static double exprGetKnownDouble(TclObject tclObject) {
        return ((TclDouble)tclObject.getInternalRep()).value;
    }

    public static void exprUnaryOperator(Interp interp, int n, ExprValue exprValue) throws TclException {
        Expression.evalUnaryOperator(interp, n, exprValue);
    }

    public static void exprBinaryOperator(Interp interp, int n, ExprValue exprValue, ExprValue exprValue2) throws TclException {
        Expression.evalBinaryOperator(interp, n, exprValue, exprValue2);
    }

    public static void exprMathFunction(Interp interp, String string, ExprValue[] exprValueArray, ExprValue exprValue) throws TclException {
        interp.expr.evalMathFunction(interp, string, exprValueArray, false, exprValue);
    }

    public static void exprSetResult(Interp interp, ExprValue exprValue) throws TclException {
        switch (exprValue.getType()) {
            case 0: {
                interp.setResult(exprValue.getIntValue());
                break;
            }
            case 1: {
                interp.setResult(exprValue.getDoubleValue());
                break;
            }
            case 2: {
                interp.setResult(exprValue.getStringValue());
                break;
            }
            default: {
                throw new TclRuntimeError("internal error: expression, unknown");
            }
        }
    }

    public static void exprEqualsEmptyString(ExprValue exprValue, TclObject tclObject, boolean bl) throws TclException {
        boolean bl2;
        if (tclObject.hasNoStringRep() && tclObject.isListType()) {
            bl2 = TclList.getLength(null, tclObject) == 0;
        } else {
            String string = tclObject.toString();
            boolean bl3 = bl2 = "".equals(string) || string.length() == 0;
        }
        if (bl) {
            bl2 = !bl2;
        }
        exprValue.setIntValue(bl2);
    }

    public static void exprIntMathFunction(Interp interp, ExprValue exprValue) throws TclException {
        switch (exprValue.getType()) {
            case 0: {
                break;
            }
            case 1: {
                double d = exprValue.getDoubleValue();
                if (d < 0.0 && d < -9.223372036854776E18 || d > 0.0 && d > 9.223372036854776E18) {
                    Expression.IntegerTooLarge(interp);
                }
                exprValue.setIntValue((long)d);
                break;
            }
            case 2: {
                throw new TclException(interp, "argument to math function didn't have numeric value");
            }
        }
    }

    public static void exprDoubleMathFunction(Interp interp, ExprValue exprValue) throws TclException {
        if (exprValue.isStringType()) {
            throw new TclException(interp, "argument to math function didn't have numeric value");
        }
        if (exprValue.isIntType()) {
            exprValue.setDoubleValue(exprValue.getIntValue());
        }
    }

    public static void exprUnaryNotOperator(Interp interp, ExprValue exprValue) throws TclException {
        if (exprValue.isDoubleType()) {
            exprValue.setIntValue(exprValue.getDoubleValue() == 0.0);
        } else {
            Expression.evalUnaryOperator(interp, 32, exprValue);
        }
    }

    public static void exprUnaryNotOperator(Interp interp, ExprValue exprValue, TclObject tclObject) throws TclException {
        if (tclObject.isDoubleType()) {
            exprValue.setIntValue(TJC.exprGetKnownDouble(tclObject) == 0.0);
            return;
        }
        Expression.ExprParseString(interp, tclObject, exprValue);
        if (exprValue.isIntType()) {
            exprValue.optIntUnaryNot();
        } else if (exprValue.isDoubleType()) {
            exprValue.setIntValue(exprValue.getDoubleValue() == 0.0);
        } else {
            Expression.evalUnaryOperator(interp, 32, exprValue);
        }
    }

    public static void exprUnaryNotOperatorKnownInt(ExprValue exprValue, TclObject tclObject) {
        exprValue.setIntValue(tclObject.ivalue == 0L);
    }

    public static int exprUnaryNotOperatorKnownInt(TclObject tclObject) {
        return tclObject.ivalue == 0L ? 1 : 0;
    }

    public static boolean exprUnaryNotOperatorKnownIntAsBoolean(TclObject tclObject) {
        return tclObject.ivalue == 0L;
    }

    public static final void makeGlobalLinkVar(Interp interp, String string, String string2, int n) throws TclException {
        Var.makeUpvar(interp, null, string, null, 1, string2, 0, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void lindexNonconst(Interp interp, TclObject tclObject, TclObject tclObject2) throws TclException {
        if (tclObject2.isIntType()) {
            TclObject tclObject3 = TclList.index(interp, tclObject, (int)tclObject2.ivalue);
            if (tclObject3 == null) {
                interp.resetResult();
            } else {
                interp.setResult(tclObject3);
            }
            return;
        }
        TclObject[] tclObjectArray = TJC.grabObjv(interp, 3);
        try {
            tclObjectArray[1] = tclObject;
            tclObjectArray[2] = tclObject2;
            tclObject2.preserve();
            TclObject tclObject4 = LindexCmd.TclLindexList(interp, tclObject, tclObjectArray, 2);
            interp.setResult(tclObject4);
            tclObject4.release();
        }
        finally {
            tclObjectArray[2].release();
            TJC.releaseObjv(interp, tclObjectArray, 3);
        }
    }

    public static final TclObject lappendVar(Interp interp, String string, String string2, TclObject[] tclObjectArray) throws TclException {
        if (string2 == null) {
            return LappendCmd.lappendVar(interp, string, tclObjectArray, 0);
        }
        String string3 = string + "(" + string2 + ")";
        return LappendCmd.lappendVar(interp, string3, tclObjectArray, 0);
    }

    public static final TclObject appendVar(Interp interp, String string, String string2, TclObject[] tclObjectArray) throws TclException {
        TclObject tclObject = null;
        int n = tclObjectArray.length;
        if (string2 != null) {
            string = string + "(" + string2 + ")";
        }
        for (int i = 0; i < n; ++i) {
            tclObject = interp.setVar(string, tclObjectArray[i], 4);
        }
        if (tclObject == null) {
            tclObject = interp.checkCommonString(null);
        }
        return tclObject;
    }

    public static final TclObject stringIndex(Interp interp, String string, TclObject tclObject) throws TclException {
        int n = string.length();
        int n2 = tclObject.isIntType() ? (int)tclObject.ivalue : Util.getIntForIndex(interp, tclObject, n - 1);
        if (n2 >= 0 && n2 < n) {
            TclObject tclObject2 = interp.checkCommonCharacter(string.charAt(n2));
            if (tclObject2 == null) {
                tclObject2 = TclString.newInstance(string.substring(n2, n2 + 1));
            }
            return tclObject2;
        }
        return interp.checkCommonString(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final TclObject stringRange(Interp interp, String string, TclObject tclObject, TclObject tclObject2) throws TclException {
        int n;
        int n2;
        int n3 = string.length();
        try {
            n2 = tclObject.isIntType() ? (int)tclObject.ivalue : Util.getIntForIndex(interp, tclObject, n3 - 1);
            if (n2 < 0) {
                n2 = 0;
            }
            if ((n = tclObject2.isIntType() ? (int)tclObject2.ivalue : Util.getIntForIndex(interp, tclObject2, n3 - 1)) >= n3) {
                n = n3 - 1;
            }
        }
        finally {
            tclObject.release();
        }
        if (n2 > n) {
            return interp.checkCommonString(null);
        }
        String string2 = string.substring(n2, n + 1);
        return TclString.newInstance(string2);
    }

    public static final TclObject stringFirst(Interp interp, String string, String string2, TclObject tclObject) throws TclException {
        int n;
        int n2;
        int n3 = string.length();
        int n4 = string2.length();
        if (tclObject == null) {
            n2 = 0;
        } else {
            n2 = Util.getIntForIndex(interp, tclObject, n4 - 1);
            if (n2 >= n4) {
                return interp.checkCommonInteger(-1L);
            }
        }
        if (n3 == 0) {
            n = -1;
        } else if (n3 == 1) {
            char c = string.charAt(0);
            n = string2.indexOf(c, n2);
        } else {
            n = string2.indexOf(string, n2);
        }
        return interp.checkCommonInteger(n);
    }

    public static final TclObject stringLast(Interp interp, String string, String string2, TclObject tclObject) throws TclException {
        int n;
        int n2 = string.length();
        int n3 = string2.length();
        if (tclObject == null) {
            boolean bl = false;
        } else {
            int n4 = Util.getIntForIndex(interp, tclObject, n3 - 1);
            if (n4 < 0) {
                return interp.checkCommonInteger(-1L);
            }
            if (n4 < n3) {
                string2 = string2.substring(0, n4 + 1);
            }
        }
        if (n2 == 0) {
            n = -1;
        } else if (n2 == 1) {
            char c = string.charAt(0);
            n = string2.lastIndexOf(c);
        } else {
            n = string2.lastIndexOf(string);
        }
        return interp.checkCommonInteger(n);
    }

    static {
        TJC.INVALID_COMMAND_CACHE.deleted = true;
        TJC.INVALID_COMMAND_CACHE.cmdEpoch = -1;
    }

    static class InitSourceCmd
    implements Command {
        String init_file;
        String[] files;
        String prefix;
        HashMap filesTable;

        InitSourceCmd(String string, String[] stringArray, String string2) {
            this.init_file = string;
            this.files = stringArray;
            this.prefix = string2;
            this.filesTable = new HashMap();
            for (int i = 0; i < stringArray.length; ++i) {
                this.filesTable.put(stringArray[i], "");
            }
        }

        @Override
        public void cmdProc(Interp interp, TclObject[] tclObjectArray) throws TclException {
            Object object;
            boolean bl = false;
            if (tclObjectArray.length == 2) {
                object = tclObjectArray[1].toString();
                interp.eval("file tail {" + (String)object + "}");
                String string = interp.getResult().toString();
                if (this.filesTable.containsKey(string)) {
                    bl = true;
                    interp.evalResource(this.prefix + string);
                }
            }
            if (!bl) {
                object = interp.getWrappedCommand("TJC::source");
                if (((WrappedCommand)object).mustCallInvoke(interp)) {
                    ((WrappedCommand)object).invoke(interp, tclObjectArray);
                } else {
                    ((WrappedCommand)object).cmd.cmdProc(interp, tclObjectArray);
                }
            }
        }
    }

    public static abstract class CompiledCommand
    implements Command {
        public WrappedCommand wcmd = null;
        protected boolean inlineCmds = false;
        protected boolean initCmd = false;

        protected void initCmd(Interp interp) throws TclException {
            if (this.initCmd) {
                throw new TclRuntimeError("initCmd already invoked");
            }
            this.builtinCommandsCheck(interp);
            this.initConstants(interp);
            this.initCmd = true;
        }

        protected void initConstants(Interp interp) throws TclException {
        }

        protected void builtinCommandsCheck(Interp interp) throws TclException {
            if (this.wcmd.ns.fullName.equals("::")) {
                return;
            }
            String[] stringArray = new String[]{"break", "catch", "continue", "expr", "for", "foreach", "if", "return", "switch", "while"};
            String[] stringArray2 = new String[]{"break", "catch", "continue", "expr", "for", "foreach", "global", "if", "list", "llength", "return", "set", "switch", "while"};
            String[] stringArray3 = this.inlineCmds ? stringArray2 : stringArray;
            for (int i = 0; i < stringArray3.length; ++i) {
                String string = stringArray3[i];
                WrappedCommand wrappedCommand = Namespace.findCommand(interp, string, this.wcmd.ns, 2);
                if (wrappedCommand == null) continue;
                throw new TclException(interp, "TJC compiled command can't be loaded into the namespace " + this.wcmd.ns.fullName + " as it defines the builtin Tcl command \"" + string + "\" (" + wrappedCommand.toString() + ")");
            }
        }

        protected final void initVarScoped(Interp interp, String string, Var[] varArray, int n) throws TclException {
            if (varArray[n] == null) {
                Var.makeUpvar(interp, null, string, null, 1, string, 4096, n);
            }
        }

        protected final TclObject getVarScalar(Interp interp, String string, Var[] varArray, int n) throws TclException {
            Var var = varArray[n];
            if (var == null || (var = Var.resolveScalar(var)) == null) {
                return Var.getVarCompiledLocalScalarInvalid(interp, string);
            }
            return var.getValue();
        }

        protected final TclObject getVarArray(Interp interp, String string, String string2, Var[] varArray, int n) throws TclException {
            Var var = varArray[n];
            if (var == null || (var = Var.resolveArray(var)) == null) {
                return Var.getVarCompiledLocalArrayInvalid(interp, string, string2);
            }
            return Var.getVarCompiledLocalArray(interp, string, string2, var, true);
        }

        protected final TclObject setVarScalar(Interp interp, String string, TclObject tclObject, Var[] varArray, int n) throws TclException {
            Var var = varArray[n];
            if (var == null) {
                return Var.initVarCompiledLocalScalar(interp, string, tclObject, varArray, n);
            }
            if ((var = Var.resolveScalar(var)) == null) {
                return Var.setVarCompiledLocalScalarInvalid(interp, string, tclObject);
            }
            TJC.setVarScalar(var, tclObject);
            return tclObject;
        }

        protected final TclObject setVarScalar(Interp interp, String string, String string2, Var[] varArray, int n) throws TclException {
            TclObject tclObject = interp.checkCommonString(string2);
            return this.setVarScalar(interp, string, tclObject, varArray, n);
        }

        protected final TclObject setVarArray(Interp interp, String string, String string2, TclObject tclObject, Var[] varArray, int n) throws TclException {
            Var var = varArray[n];
            if (var == null) {
                return Var.initVarCompiledLocalArray(interp, string, string2, tclObject, varArray, n);
            }
            if ((var = Var.resolveArray(var)) == null) {
                return Var.setVarCompiledLocalArrayInvalid(interp, string, string2, tclObject);
            }
            return Var.setVarCompiledLocalArray(interp, string, string2, tclObject, var);
        }

        protected final TclObject setVarArray(Interp interp, String string, String string2, String string3, Var[] varArray, int n) throws TclException {
            TclObject tclObject = interp.checkCommonString(string3);
            return this.setVarArray(interp, string, string2, tclObject, varArray, n);
        }

        protected final TclObject incrVarScalar(Interp interp, String string, long l, Var[] varArray, int n) throws TclException {
            Var var = varArray[n];
            if (var == null || (var = Var.resolveScalar(var)) == null) {
                return TJC.incrVar(interp, string, null, l);
            }
            TclObject tclObject = var.getValue();
            boolean bl = false;
            if (tclObject.isShared()) {
                tclObject = tclObject.duplicate();
                bl = true;
            }
            try {
                TclInteger.incr(interp, tclObject, l);
            }
            catch (TclException tclException) {
                if (bl) {
                    tclObject.release();
                }
                throw tclException;
            }
            if (bl) {
                TJC.setVarScalar(var, tclObject);
            }
            return tclObject;
        }

        protected final TclObject incrVarArray(Interp interp, String string, String string2, long l, Var[] varArray, int n) throws TclException {
            Var var = varArray[n];
            if (var == null || (var = Var.resolveArray(var)) == null) {
                return TJC.incrVar(interp, string, string2, l);
            }
            TclObject tclObject = Var.getVarCompiledLocalArray(interp, string, string2, var, true);
            boolean bl = false;
            if (tclObject.isShared()) {
                tclObject = tclObject.duplicate();
                bl = true;
            }
            try {
                TclInteger.incr(interp, tclObject, l);
            }
            catch (TclException tclException) {
                if (bl) {
                    tclObject.release();
                }
                throw tclException;
            }
            return Var.setVarCompiledLocalArray(interp, string, string2, tclObject, var);
        }

        protected final TclObject lappendVarScalar(Interp interp, String string, TclObject[] tclObjectArray, Var[] varArray, int n) throws TclException {
            int n2;
            Var var = varArray[n];
            if (var == null || (var = Var.resolveScalar(var)) == null) {
                return TJC.lappendVar(interp, string, null, tclObjectArray);
            }
            TclObject tclObject = var.getValue();
            boolean bl = false;
            if (tclObject.isShared()) {
                tclObject = tclObject.duplicate();
                bl = true;
            }
            if ((n2 = tclObjectArray.length) == 1) {
                TclList.append(interp, tclObject, tclObjectArray[0]);
            } else {
                TclList.append(interp, tclObject, tclObjectArray, 0, n2);
            }
            if (bl) {
                TJC.setVarScalar(var, tclObject);
            }
            return tclObject;
        }

        protected final TclObject lappendVarArray(Interp interp, String string, String string2, TclObject[] tclObjectArray, Var[] varArray, int n) throws TclException {
            Var var = varArray[n];
            if (var == null || (var = Var.resolveArray(var)) == null) {
                return TJC.lappendVar(interp, string, string2, tclObjectArray);
            }
            TclObject tclObject = Var.getVarCompiledLocalArray(interp, string, string2, var, false);
            if (tclObject == null) {
                tclObject = TclList.newInstance();
            } else if (tclObject.isShared()) {
                tclObject = tclObject.duplicate();
            }
            int n2 = tclObjectArray.length;
            if (n2 == 1) {
                TclList.append(interp, tclObject, tclObjectArray[0]);
            } else {
                TclList.append(interp, tclObject, tclObjectArray, 0, n2);
            }
            return Var.setVarCompiledLocalArray(interp, string, string2, tclObject, var);
        }

        protected final TclObject appendVarScalar(Interp interp, String string, TclObject[] tclObjectArray, Var[] varArray, int n) throws TclException {
            int n2;
            Var var = varArray[n];
            if (var == null || (var = Var.resolveScalar(var)) == null) {
                return TJC.appendVar(interp, string, null, tclObjectArray);
            }
            TclObject tclObject = var.getValue();
            boolean bl = false;
            if (tclObject.isShared()) {
                tclObject = TclString.newInstance(tclObject.toString());
                bl = true;
            }
            if ((n2 = tclObjectArray.length) == 1) {
                TclString.append(tclObject, tclObjectArray[0].toString());
            } else {
                TclString.append(tclObject, tclObjectArray, 0, n2);
            }
            if (bl) {
                TJC.setVarScalar(var, tclObject);
            }
            return tclObject;
        }

        protected final TclObject appendVarArray(Interp interp, String string, String string2, TclObject[] tclObjectArray, Var[] varArray, int n) throws TclException {
            return TJC.appendVar(interp, string, string2, tclObjectArray);
        }
    }
}

