/*
 * Decompiled with CFR 0.152.
 */
package com.github.trang.copiers.cglib;

import com.baidu.unbiz.easymapper.util.ReflectionUtil;
import com.github.trang.copiers.adapter.CopierAdapter;
import net.sf.cglib.beans.BeanCopier;
import net.sf.cglib.core.Converter;

public class CglibCopier<F, T>
extends CopierAdapter<BeanCopier, F, T> {
    private static final boolean USE_CONVERTER = false;
    private Converter converter;

    public CglibCopier(Class<F> sourceClass, Class<T> targetClass) {
        super(sourceClass, targetClass, BeanCopier.create(sourceClass, targetClass, (boolean)false));
    }

    @Override
    public T copy(F source) {
        this.checkNull(source, "source bean cannot be null!");
        try {
            Object target = ReflectionUtil.newInstance((Class)this.targetClass);
            ((BeanCopier)this.copier).copy(source, target, this.converter);
            return (T)target;
        }
        catch (Exception e) {
            throw new RuntimeException("create object fail, class: " + this.targetClass.getName(), e);
        }
    }

    @Override
    public void copy(F source, T target) {
        this.checkNull(source, "source bean cannot be null!");
        this.checkNull(target, "target bean cannot be null!");
        try {
            ((BeanCopier)this.copier).copy(source, target, this.converter);
        }
        catch (Exception e) {
            throw new RuntimeException("create object fail, class: " + this.targetClass.getName(), e);
        }
    }

    public Converter getConverter() {
        return this.converter;
    }

    static class CustomConvert
    implements Converter {
        CustomConvert() {
        }

        public Object convert(Object value, Class target, Object context) {
            return value;
        }
    }
}

