/*
 * Decompiled with CFR 0.152.
 */
package com.github.trang.copiers.cglib;

import com.baidu.unbiz.easymapper.util.ReflectionUtil;
import com.github.trang.copiers.adapter.CopierAdapter;
import java.util.Map;
import net.sf.cglib.beans.BeanMap;

public class MapToBeanCopier<T>
extends CopierAdapter<BeanMap, Map<String, Object>, T> {
    public MapToBeanCopier(Class<T> beanClass) {
        this.targetClass = beanClass;
    }

    @Override
    public T copy(Map<String, Object> map) {
        this.checkNull(map, "map cannot be null!");
        this.checkNull(this.targetClass, "target class cannot be null!");
        try {
            Object bean = ReflectionUtil.newInstance((Class)this.targetClass);
            BeanMap beanMap = BeanMap.create((Object)bean);
            beanMap.putAll(map);
            return (T)bean;
        }
        catch (Exception e) {
            throw new RuntimeException("create object fail, class: " + this.targetClass.getName(), e);
        }
    }

    @Override
    public void copy(Map<String, Object> map, T bean) {
        this.checkNull(map, "map cannot be null!");
        this.checkNull(this.targetClass, "target bean cannot be null!");
        try {
            BeanMap beanMap = BeanMap.create(bean);
            beanMap.putAll(map);
        }
        catch (Exception e) {
            throw new RuntimeException("create object fail, class: " + bean.getClass().getName(), e);
        }
    }
}

