/*
 * Decompiled with CFR 0.152.
 */
package com.github.trang.druid.autoconfigure;

import com.alibaba.druid.pool.DruidDataSource;
import com.github.trang.druid.autoconfigure.datasource.DruidDataSource2;
import com.github.trang.druid.autoconfigure.util.CharMatcher;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.boot.bind.PropertySourcesBinder;
import org.springframework.boot.bind.RelaxedPropertyResolver;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.context.annotation.ImportSelector;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertyResolver;
import org.springframework.core.type.AnnotationMetadata;

@Import(value={DataSourceImportSelector.class})
public class DruidDataSourceConfiguration {
    private static final Logger log = LoggerFactory.getLogger(DruidDataSourceConfiguration.class);

    static class DataSourceBeanPostProcessor
    implements BeanPostProcessor,
    EnvironmentAware {
        private ConfigurableEnvironment environment;

        DataSourceBeanPostProcessor() {
        }

        public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
            if (bean instanceof DruidDataSource) {
                PropertySourcesBinder binder = new PropertySourcesBinder(this.environment);
                binder.bindTo("spring.datasource.druid.data-sources." + beanName, bean);
            }
            return bean;
        }

        public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
            return bean;
        }

        public void setEnvironment(Environment environment) {
            this.environment = (ConfigurableEnvironment)environment;
        }
    }

    static class DataSourceImportSelector
    implements ImportSelector,
    EnvironmentAware {
        private ConfigurableEnvironment environment;

        DataSourceImportSelector() {
        }

        public String[] selectImports(AnnotationMetadata metadata) {
            RelaxedPropertyResolver resolver = new RelaxedPropertyResolver((PropertyResolver)this.environment, "spring.datasource.druid.");
            Map properties = resolver.getSubProperties("data-sources");
            if (properties.isEmpty()) {
                return new String[]{SingleDataSourceRegister.class.getName()};
            }
            return new String[]{DynamicDataSourceRegister.class.getName(), DataSourceBeanPostProcessor.class.getName()};
        }

        public void setEnvironment(Environment environment) {
            this.environment = (ConfigurableEnvironment)environment;
        }
    }

    static class DynamicDataSourceRegister
    implements ImportBeanDefinitionRegistrar,
    EnvironmentAware {
        private static final String BEAN_SUFFIX = "DataSource";
        private RelaxedPropertyResolver resolver;

        DynamicDataSourceRegister() {
        }

        public void registerBeanDefinitions(AnnotationMetadata metadata, BeanDefinitionRegistry registry) {
            this.resolver.getSubProperties("").keySet().stream().map(key -> key.substring(0, key.indexOf("."))).distinct().forEach(dataSourceName -> {
                AbstractBeanDefinition beanDefinition = BeanDefinitionBuilder.genericBeanDefinition(DruidDataSource2.class).setInitMethodName("init").setDestroyMethodName("close").getBeanDefinition();
                String camelName = CharMatcher.separatedToCamel().apply((String)dataSourceName);
                registry.registerBeanDefinition(camelName, (BeanDefinition)beanDefinition);
                if (camelName.toLowerCase().endsWith(BEAN_SUFFIX.toLowerCase())) {
                    if (!camelName.endsWith(BEAN_SUFFIX)) {
                        String otherAlias = camelName.substring(0, camelName.toLowerCase().indexOf(BEAN_SUFFIX.toLowerCase()));
                        otherAlias = otherAlias + BEAN_SUFFIX;
                        registry.registerAlias(camelName, otherAlias);
                    }
                } else {
                    String otherAlias = camelName + BEAN_SUFFIX;
                    registry.registerAlias(camelName, otherAlias);
                }
                log.debug("druid {}-data-source init...", dataSourceName);
            });
        }

        public void setEnvironment(Environment environment) {
            this.resolver = new RelaxedPropertyResolver((PropertyResolver)environment, "spring.datasource.druid.data-sources.");
        }
    }

    static class SingleDataSourceRegister
    implements ImportBeanDefinitionRegistrar {
        static final String BEAN_NAME = "dataSource";

        SingleDataSourceRegister() {
        }

        public void registerBeanDefinitions(AnnotationMetadata metadata, BeanDefinitionRegistry registry) {
            if (!registry.containsBeanDefinition(BEAN_NAME)) {
                AbstractBeanDefinition beanDefinition = BeanDefinitionBuilder.genericBeanDefinition(DruidDataSource2.class).setInitMethodName("init").setDestroyMethodName("close").getBeanDefinition();
                registry.registerBeanDefinition(BEAN_NAME, (BeanDefinition)beanDefinition);
                log.debug("druid data-source init...");
            }
        }
    }
}

