/*
 * Decompiled with CFR 0.152.
 */
package com.github.trang.druid.autoconfigure;

import com.alibaba.druid.support.http.StatViewServlet;
import com.github.trang.druid.autoconfigure.properties.DruidDataSourceProperties;
import javax.servlet.Servlet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.StringUtils;

@Configuration
@ConditionalOnWebApplication
@ConditionalOnClass(value={Servlet.class})
@ConditionalOnProperty(prefix="spring.datasource.druid.stat-view-servlet", name={"enabled"}, havingValue="true")
public class DruidServletConfiguration {
    private static final Logger log = LoggerFactory.getLogger(DruidServletConfiguration.class);

    @Bean
    public ServletRegistrationBean servletRegistrationBean(DruidDataSourceProperties druidProperties) {
        log.debug("druid stat-view-servlet init...");
        DruidDataSourceProperties.DruidStatViewServletProperties properties = druidProperties.getStatViewServlet();
        ServletRegistrationBean registration = new ServletRegistrationBean((Servlet)new StatViewServlet(), new String[0]);
        registration.addUrlMappings(new String[]{properties.getUrlMappings()});
        if (!StringUtils.isEmpty((Object)properties.getLoginUsername())) {
            registration.addInitParameter("loginUsername", properties.getLoginUsername());
        }
        if (!StringUtils.isEmpty((Object)properties.getLoginPassword())) {
            registration.addInitParameter("loginPassword", properties.getLoginPassword());
        }
        if (!StringUtils.isEmpty((Object)properties.getAllow())) {
            registration.addInitParameter("allow", properties.getAllow());
        }
        if (!StringUtils.isEmpty((Object)properties.getDeny())) {
            registration.addInitParameter("deny", properties.getDeny());
        }
        registration.addInitParameter("resetEnable", Boolean.toString(properties.isResetEnable()));
        return registration;
    }
}

